CREATE TABLE `access_info` (
  `user_id` int(10) unsigned NOT NULL,
  `login_period` datetime NOT NULL,
  `logout_period` datetime NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `ad_pay` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `emp_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `pay_amount` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `ad_salary` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `emp_id` int(10) NOT NULL,
  `date` date NOT NULL,
  `advance_amount` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `admissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `pid` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `guardian` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `seat` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `bill` int(11) NOT NULL COMMENT 'ID of bills table',
  `status` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'admitted' COMMENT 'admitted or released',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `admit_type` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `room_no` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cabin_no` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `seat_no` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `trash` int(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `advanced_payment` (
  `id` int(100) unsigned NOT NULL AUTO_INCREMENT,
  `created` date NOT NULL,
  `payment_date` date NOT NULL,
  `emp_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `trash` int(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `payment_date` (`payment_date`),
  KEY `emp_id` (`emp_id`(250))
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `altra_doctor_payment` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `doctor_id` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payment` decimal(8,2) NOT NULL,
  `trash` int(10) NOT NULL DEFAULT 0,
  UNIQUE KEY `id` (`id`),
  KEY `rf_pc_id` (`doctor_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `appointment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date` date NOT NULL,
  `patient_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `father_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `age` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `gender` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `religion` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `village` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_office` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `district` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `upazila` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `admission_date` date NOT NULL,
  `admission_time` time NOT NULL,
  `disease` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `doctor_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `clearance_date` date NOT NULL,
  `clearance_time` time NOT NULL,
  `bed_no` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone_no` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ref_doctor_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `op_relation` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `op_pa_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `op_age` int(7) NOT NULL,
  `op_village` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `op_post_office` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `op_district` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `op_upazila` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type_of_unconscious` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name_of_operation` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name_of_witness` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `father_name_of_witness` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `village_of_witness` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `witness_district` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `witness_upazila` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `witness_date` date NOT NULL,
  `name_of_consentant` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `father_name_of_consentant` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `village_of_consentant` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `consentant_district` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `consentant_upazila` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `consentant_date` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `bank` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `bank_name` varchar(252) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `bank_account` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `datetime` date NOT NULL,
  `bank_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `branch_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `holder_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `holder_contact` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_number` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `init_balance` decimal(10,2) NOT NULL,
  `pre_balance` int(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `bank_name` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `bank_name` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `barcode` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `img_height` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `img_width` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code_width` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code_height` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pos_x` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pos_y` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `bills` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date DEFAULT NULL,
  `time` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `voucher` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pid` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `details` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `subtotal` decimal(10,2) NOT NULL COMMENT 'Without  Vat amount',
  `vat` int(100) NOT NULL COMMENT 'Vat percentage',
  `vat_amount` decimal(10,2) NOT NULL,
  `total` decimal(10,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `less_type` varchar(200) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `grand_total` decimal(10,2) NOT NULL,
  `paid` decimal(10,2) NOT NULL,
  `service_charge` decimal(10,2) NOT NULL DEFAULT 0.00,
  `due` decimal(10,2) NOT NULL,
  `last_paid` decimal(10,2) NOT NULL,
  `last_payment_date` date NOT NULL,
  `payment_status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `refereed_doctor` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` int(11) NOT NULL,
  `other_rf_doctor` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `delivery_time` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `date` (`date`),
  KEY `voucher` (`voucher`),
  KEY `pid` (`pid`),
  KEY `title` (`title`)
) ENGINE=InnoDB AUTO_INCREMENT=4278 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `bonus` (
  `id` int(100) unsigned NOT NULL AUTO_INCREMENT,
  `created` date NOT NULL,
  `bonus_date` date NOT NULL,
  `emp_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `bonus` decimal(10,2) NOT NULL COMMENT 'Bonus  (%)',
  `trash` int(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `emp_id` (`emp_id`(250)),
  KEY `bonus_date` (`bonus_date`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `bonus_structure` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `eid` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fields` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `percentage` decimal(10,2) NOT NULL,
  `remarks` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `brand` (
  `id` int(45) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `name` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `trash` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `category` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `category` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `brand` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `trash` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `closing` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `opening` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `income` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cost` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `salary_cost` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `bank` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `hand_cash` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `opening_type` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'auto',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `commission_payment` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `payment_date` date NOT NULL,
  `type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `person_id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `balance` decimal(10,2) NOT NULL,
  `paid` decimal(10,2) NOT NULL,
  `due` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `commissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `ref` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'expression [ registration:10 or pathology:15 ]. registration -> ID = 10 and pathology -> ID = 15',
  `person` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `person_id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'doctors:ID or marketer:ID or pc:ID',
  `type` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `consultancies` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `pid` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `doctor` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'ID of doctors table',
  `reference_name` int(100) NOT NULL,
  `room` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `notes` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'any description for patient',
  `bill` int(11) NOT NULL COMMENT 'ID of bills table',
  `status` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending' COMMENT 'pending or complete',
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `cost` (
  `id` int(100) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `cost_field` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `spend_by` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `trash` tinyint(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `cost_bill` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `voucher` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `bill_by` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total_qty` decimal(10,2) NOT NULL,
  `grand_total` decimal(10,2) NOT NULL,
  `trash` int(1) NOT NULL DEFAULT 0,
  `date` date NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `cost_bill_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `voucher` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `item_id` int(11) NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `quantity` decimal(10,2) NOT NULL,
  `total` decimal(10,2) NOT NULL,
  `trash` int(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `cost_field` (
  `id` int(100) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cost_field` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `trash` int(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `create_reports` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `test_id` int(11) NOT NULL,
  `procedure_id` int(11) NOT NULL,
  `standard` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `condition` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `daily_wages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` date NOT NULL,
  `emp_id` int(11) NOT NULL,
  `attendance` decimal(10,2) NOT NULL,
  `salary` decimal(10,2) NOT NULL,
  `bonus` decimal(10,2) NOT NULL,
  `payment` decimal(10,2) NOT NULL,
  `trash` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `created_at` (`created_at`),
  KEY `emp_id` (`emp_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `deduction_structure` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `eid` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fields` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `remarks` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `designations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created_at` date NOT NULL,
  `designation_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `trash` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `diagnosis` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `delivery` date NOT NULL COMMENT 'Date value',
  `pid` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Test name',
  `group_id` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `test_id` int(11) NOT NULL,
  `gender` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `refereed_doctor` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `group` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Test group',
  `room` varchar(110) COLLATE utf8mb4_unicode_ci NOT NULL,
  `result` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alt_doctor_id` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alt_doctor_fee` decimal(8,2) NOT NULL,
  `remarks` text COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Normal, High, Low etc',
  `amount` decimal(10,2) NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `bill` int(11) NOT NULL,
  `user_id` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`),
  KEY `refereed_doctor` (`refereed_doctor`),
  KEY `alt_doctor_id` (`alt_doctor_id`),
  KEY `bill` (`bill`),
  KEY `group_id` (`group_id`),
  KEY `user_id` (`user_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=11196 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `doctor_payment` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `doctor_id` int(100) NOT NULL,
  `total_paid` decimal(8,2) NOT NULL,
  `payment` decimal(8,2) NOT NULL,
  `less` decimal(8,2) NOT NULL,
  `due` decimal(8,2) NOT NULL,
  `trash` int(10) NOT NULL DEFAULT 0,
  UNIQUE KEY `id` (`id`),
  KEY `rf_pc_id` (`doctor_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `doctors` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `fullName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `designation` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `degree` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `specialised` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `hospital` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mobile` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fee` decimal(8,2) NOT NULL DEFAULT 0.00,
  `commission` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `address` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `room_no` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` int(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=69 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `due_collection` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pid` int(11) NOT NULL,
  `admission_id` int(11) NOT NULL,
  `contact` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `previous_paid` decimal(10,2) NOT NULL,
  `due` decimal(10,2) NOT NULL,
  `paid` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `due_payment` (
  `id` int(45) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `time` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `voucher_number` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `total_amount` decimal(10,2) NOT NULL,
  `prev_paid` decimal(10,2) NOT NULL,
  `prev_due` decimal(10,2) NOT NULL,
  `paid` decimal(10,2) NOT NULL,
  `due` decimal(10,2) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `remission` decimal(10,2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=801 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `emergencies` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `pid` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `notes` longtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bill` int(11) NOT NULL COMMENT 'ID of bills table',
  `status` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `employee` (
  `id` int(20) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `emp_id` int(20) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `joining_date` date NOT NULL,
  `gender` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mobile` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `overtime` int(11) NOT NULL,
  `entry_time` time NOT NULL,
  `exit_time` time NOT NULL,
  `present_address` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `permanent_address` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `designation` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `employee_salary` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `path` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `emp_id` (`emp_id`),
  KEY `type` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `group_mapping` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `group_id` int(11) NOT NULL,
  `test_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `group_id` (`group_id`),
  KEY `test_id` (`test_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4748 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `group_name` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `position` int(11) DEFAULT NULL,
  `group_name` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `trash` int(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `incentive_structure` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `eid` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fields` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `percentage` decimal(10,2) NOT NULL,
  `remarks` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `income` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `income_field` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `income_by` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `trash` tinyint(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `income_field` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `income_field` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `trash` int(10) NOT NULL DEFAULT 0,
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `code` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `investigation` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `group` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `test_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `test_fee` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `room` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `unit` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_value` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `status` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'available',
  `trash` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `journal` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `ref` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'expression [ registration:10 or pathology:15 or pid:123456 ]. registration -> ID = 10 and pathology -> ID = 15 and pid = patient ID',
  `details` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `status` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'income or cost or liability or assets',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4278 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `marketer` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `create_at` date NOT NULL,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mobile` varchar(24) COLLATE utf8mb4_unicode_ci NOT NULL,
  `commission` decimal(10,2) NOT NULL,
  `address` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `trash` int(1) NOT NULL DEFAULT 0,
  `img_url` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`) USING HASH
) ENGINE=InnoDB AUTO_INCREMENT=113 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `medicine` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `product_name` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_code` varchar(252) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_cat` varchar(252) COLLATE utf8mb4_unicode_ci NOT NULL,
  `subcategory` varchar(252) COLLATE utf8mb4_unicode_ci NOT NULL,
  `purchase_price` decimal(10,2) NOT NULL,
  `sale_price` decimal(10,2) NOT NULL,
  `unit` varchar(252) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(252) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `messages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `messages_date` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `messages_name` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL,
  `messages_mobile` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `messages_text` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `messages_condition` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `meta_info` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_value` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_status` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `mixed_patient` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `age` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `refd_doctor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lab_no` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `examination` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `gender` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date` date NOT NULL,
  `comments` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `mixed_report` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `test_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `result` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `opening_balance` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `opening_amount` decimal(10,2) NOT NULL,
  `initial_invest` decimal(10,2) NOT NULL,
  `closing_amount` decimal(10,2) NOT NULL,
  `status` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '1st : opening balance always on top',
  `trash` tinyint(2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `outstock` (
  `id` int(200) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `voucher_no` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `stock_voucher_no` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reagent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `quantity` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `overtime` (
  `id` int(255) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `emp_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `start_time` datetime NOT NULL,
  `end_time` datetime NOT NULL,
  `hourly_rate` decimal(10,2) NOT NULL,
  `trash` int(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `emp_id` (`emp_id`(250))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `parameter` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `position` int(11) DEFAULT 0,
  `parameter_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ref_value` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `result` varchar(128) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `unit` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` date NOT NULL,
  `trash` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `trash` (`trash`)
) ENGINE=InnoDB AUTO_INCREMENT=855 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `patient_admission` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) DEFAULT NULL,
  `date` date NOT NULL,
  `admit_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `room_no` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `seat_no` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cabin_no` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `days` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `paid` decimal(10,2) DEFAULT NULL,
  `due` decimal(10,2) DEFAULT NULL,
  `pair` decimal(10,2) DEFAULT NULL,
  `patient_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `age` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `gender` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contact` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_report` int(1) NOT NULL DEFAULT 0,
  `trash` int(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `patient_barcode` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `img_height` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `img_width` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code_width` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code_height` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pos_x` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pos_y` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `patient_histories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `test_id` int(11) NOT NULL,
  `parameter_id` int(11) NOT NULL,
  `test_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parameter` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `standard` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `test_id` (`test_id`),
  KEY `parameter_id` (`parameter_id`)
) ENGINE=MyISAM AUTO_INCREMENT=23994 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `patient_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `patient_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `patient_pid` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `patients` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `pid` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `guardian` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON String. { ''relation'' : ''person name'' }',
  `gender` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `age` int(11) NOT NULL,
  `age_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'year',
  `address` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `contact` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_report` int(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4281 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `pc` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `fullName` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mobile` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `commission` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `address` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `prescription` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `prescription_id` varchar(11) COLLATE utf8mb4_unicode_ci NOT NULL,
  `date` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL,
  `symptoms` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `diagnosis` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `patient_name` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `medicine` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `test` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `privileges` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `privilege_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int(100) NOT NULL,
  `access` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `procedures` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `test_id` int(11) NOT NULL,
  `test_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parameter` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `referral_value` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'with Condition',
  `unit` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `products` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `brand` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `category` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `model` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `subcategory` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `purchase_price` decimal(10,2) NOT NULL,
  `sale_price` decimal(10,2) NOT NULL,
  `unit` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `remarks` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `trash` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `purchase` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `voucher_no` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `category` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `subcategory` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `brand` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `purchase_price` decimal(10,2) NOT NULL,
  `quantity` int(10) unsigned NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `subtotal` decimal(10,2) NOT NULL,
  `total` decimal(10,2) NOT NULL,
  `total_discount` decimal(10,2) NOT NULL,
  `transport_cost` decimal(10,2) NOT NULL,
  `grand_total` decimal(10,2) NOT NULL,
  `paid` decimal(10,2) NOT NULL,
  `due` decimal(10,2) NOT NULL,
  `final_due` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `reagent` (
  `id` int(200) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `reagent` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `reagent_stock` (
  `id` int(200) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `voucher_no` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reagent` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `quantity` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expire_date` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `recharge_sms` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `amount` varchar(192) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sms` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `registrations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `pid` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'ID of patients. Connect to patients table. ',
  `type` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'admission or, consultancy or, emergency or, pathology',
  `status` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending' COMMENT 'pending or admitted or released or consultancy or emergency',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `remark` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `remark` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `remark_id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `rf_pc_commission_payment` (
  `id` int(100) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `rf_pc_id` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payment` decimal(8,2) NOT NULL,
  `trash` int(10) NOT NULL DEFAULT 0,
  UNIQUE KEY `id` (`id`),
  KEY `rf_pc_id` (`rf_pc_id`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `salary` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` date NOT NULL,
  `payment_date` date NOT NULL,
  `emp_id` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `total_salary` decimal(10,2) NOT NULL,
  `adjust_amount` decimal(10,2) NOT NULL,
  `trash` int(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `payment_date` (`payment_date`),
  KEY `emp_id` (`emp_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `salary_records` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `created` date NOT NULL,
  `payment_date` date NOT NULL,
  `emp_id` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` decimal(10,2) NOT NULL,
  `remarks` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `trash` int(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `payment_date` (`payment_date`),
  KEY `emp_id` (`emp_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `salary_structure` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `eid` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `basic` decimal(10,2) NOT NULL,
  `incentive` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `deduction` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  `bonus` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'no',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `sale` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `time` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `voucher_number` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `category` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `model` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `product` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `quantity` int(10) unsigned NOT NULL,
  `subtotal` decimal(10,2) NOT NULL,
  `total` decimal(10,2) NOT NULL,
  `discount` decimal(10,2) NOT NULL,
  `grand_total` decimal(10,2) NOT NULL,
  `paid` decimal(10,2) NOT NULL,
  `due` decimal(10,2) NOT NULL,
  `remission` decimal(10,2) NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mobile` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `sessions` (
  `session_id` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `user_agent` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_activity` int(10) unsigned NOT NULL DEFAULT 0,
  `user_data` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`session_id`),
  KEY `last_activity_idx` (`last_activity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `sitemeta` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_value` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `sms_record` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `delivery_date` date NOT NULL,
  `delivery_time` time NOT NULL,
  `mobile` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `total_characters` varchar(4) COLLATE utf8mb4_unicode_ci NOT NULL,
  `total_messages` varchar(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  `delivery_report` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=45 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `stock` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `quantity` int(11) NOT NULL,
  `unit` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pcs',
  `purchase_price` decimal(10,2) NOT NULL,
  `sell_price` decimal(10,2) NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `test` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `position` int(11) DEFAULT NULL,
  `test_name` varchar(252) COLLATE utf8mb4_unicode_ci NOT NULL,
  `room` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fee` decimal(10,2) NOT NULL,
  `cost` decimal(10,2) NOT NULL,
  `rf_com` decimal(10,2) NOT NULL DEFAULT 0.00,
  `created_at` date NOT NULL,
  `trash` int(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=924 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `test_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `position` int(11) DEFAULT NULL,
  `group_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `remarks` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` date NOT NULL,
  `trash` int(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `trash` (`trash`)
) ENGINE=InnoDB AUTO_INCREMENT=145 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `test_histories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `test_id` int(11) NOT NULL,
  `procedure_id` int(11) NOT NULL,
  `patient_id` int(11) NOT NULL,
  `patient_voucher` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `standerd` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `condition` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  `report` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `remark` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `test_mapping` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `test_id` int(11) NOT NULL,
  `parameter_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `test_id` (`test_id`),
  KEY `parameter_id` (`parameter_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1004 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `test_name` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `group_name` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `test_name` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=139 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `theme_setting` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `theme_color` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `background_pattern` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `login_background` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `google_map` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `footer` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `header` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `logo` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `menu_icon` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `social_icon` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `language` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `signature` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `transaction` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transaction_date` date NOT NULL,
  `bank` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `account_number` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `transaction_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `source` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `amount` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `transaction_by` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `remarks` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `ultra_patient` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `patient_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` date NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `age` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `gender` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `specimen` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reff_doctor` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `ultra_patient_report` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `created_at` date NOT NULL,
  `patient_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `test_name` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `test_report` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `users` (
  `id` int(15) NOT NULL AUTO_INCREMENT,
  `opening` datetime NOT NULL,
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `l_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `gender` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `birthday` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `maritial_status` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `position` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `about` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `website` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `facecbook` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `twitter` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `username` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL,
  `privilege` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mobile` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  `branch` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 

CREATE TABLE `vat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `percentage` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `vat_id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci; 
 
INSERT INTO `access_info` ( `user_id`, `login_period`, `logout_period`) VALUES 
('13', '2021-04-05 10:50:09', '0000-00-00 00:00:00'), 
('13', '2021-04-05 11:20:59', '2021-04-05 11:30:25'), 
('13', '2021-04-05 11:32:24', '0000-00-00 00:00:00'), 
('13', '2021-04-17 11:15:44', '0000-00-00 00:00:00'), 
('13', '2021-04-18 10:50:22', '0000-00-00 00:00:00'), 
('13', '2021-04-18 10:57:49', '0000-00-00 00:00:00'), 
('13', '2021-04-20 14:57:39', '0000-00-00 00:00:00'), 
('13', '2021-04-20 15:49:14', '2021-04-20 16:11:52'), 
('13', '2021-04-20 16:12:02', '2021-04-20 16:13:12'), 
('13', '2021-04-20 16:13:40', '2021-04-20 16:14:03'), 
('13', '2021-04-20 16:15:12', '2021-04-20 16:40:32'), 
('13', '2021-04-20 16:40:44', '2021-04-20 16:45:16'), 
('14', '2021-04-20 16:45:29', '2021-04-20 16:55:37'), 
('13', '2021-04-20 17:37:32', '0000-00-00 00:00:00'), 
('13', '2021-04-20 18:12:10', '0000-00-00 00:00:00'), 
('13', '2021-04-20 18:15:02', '0000-00-00 00:00:00'), 
('13', '2021-04-20 18:41:03', '0000-00-00 00:00:00'), 
('13', '2021-04-20 19:12:07', '0000-00-00 00:00:00'), 
('13', '2021-04-21 00:12:17', '0000-00-00 00:00:00'), 
('13', '2021-04-21 11:49:23', '0000-00-00 00:00:00'), 
('13', '2021-04-21 13:50:02', '0000-00-00 00:00:00'), 
('13', '2021-04-21 13:55:20', '2021-04-21 14:50:40'), 
('13', '2021-04-21 13:56:26', '0000-00-00 00:00:00'), 
('13', '2021-04-21 14:01:34', '0000-00-00 00:00:00'), 
('15', '2021-04-21 14:50:45', '2021-04-22 15:47:47'), 
('13', '2021-04-21 16:32:53', '0000-00-00 00:00:00'), 
('13', '2021-04-22 04:20:48', '0000-00-00 00:00:00'), 
('13', '2021-04-22 04:21:52', '0000-00-00 00:00:00'), 
('13', '2021-04-22 13:50:56', '0000-00-00 00:00:00'), 
('13', '2021-04-22 13:51:08', '0000-00-00 00:00:00'), 
('13', '2021-04-22 14:06:15', '0000-00-00 00:00:00'), 
('13', '2021-04-22 14:06:21', '2021-04-22 14:34:03'), 
('13', '2021-04-22 14:09:06', '0000-00-00 00:00:00'), 
('13', '2021-04-22 14:10:51', '0000-00-00 00:00:00'), 
('13', '2021-04-22 14:31:59', '0000-00-00 00:00:00'), 
('13', '2021-04-22 14:34:08', '0000-00-00 00:00:00'), 
('13', '2021-04-22 14:34:49', '0000-00-00 00:00:00'), 
('13', '2021-04-22 14:37:03', '0000-00-00 00:00:00'), 
('13', '2021-04-22 14:47:27', '0000-00-00 00:00:00'), 
('13', '2021-04-22 14:51:12', '0000-00-00 00:00:00'), 
('13', '2021-04-22 14:57:54', '0000-00-00 00:00:00'), 
('13', '2021-04-22 15:00:26', '0000-00-00 00:00:00'), 
('13', '2021-04-22 15:03:19', '0000-00-00 00:00:00'), 
('15', '2021-04-22 15:03:58', '2021-04-22 15:17:56'), 
('13', '2021-04-22 15:18:02', '2021-04-22 15:22:35'), 
('13', '2021-04-22 15:19:55', '0000-00-00 00:00:00'), 
('13', '2021-04-22 15:29:47', '2021-04-22 16:23:46'), 
('15', '2021-04-22 15:47:54', '0000-00-00 00:00:00'), 
('15', '2021-04-22 15:48:07', '0000-00-00 00:00:00'), 
('15', '2021-04-22 16:24:01', '2021-04-22 16:28:31'), 
('16', '2021-04-22 16:28:39', '2021-04-22 16:28:44'), 
('15', '2021-04-22 16:28:52', '2021-04-22 16:30:55'), 
('16', '2021-04-22 16:31:02', '2021-04-22 16:33:18'), 
('17', '2021-04-22 16:33:04', '0000-00-00 00:00:00'), 
('15', '2021-04-22 16:33:26', '2021-04-22 16:35:01'), 
('16', '2021-04-22 16:35:07', '2021-04-22 16:35:17'), 
('13', '2021-04-22 16:35:21', '2021-04-22 16:35:26'), 
('17', '2021-04-22 16:38:25', '0000-00-00 00:00:00'), 
('17', '2021-04-22 16:38:59', '2021-04-22 16:41:50'), 
('15', '2021-04-22 16:42:02', '0000-00-00 00:00:00'), 
('13', '2021-04-22 17:12:15', '2021-04-22 17:12:29'), 
('17', '2021-04-22 17:12:50', '0000-00-00 00:00:00'), 
('17', '2021-04-22 17:14:17', '0000-00-00 00:00:00'), 
('18', '2021-04-22 17:59:34', '0000-00-00 00:00:00'), 
('17', '2021-04-22 18:00:20', '0000-00-00 00:00:00'), 
('17', '2021-04-22 18:01:20', '0000-00-00 00:00:00'), 
('15', '2021-04-24 10:48:02', '2021-04-24 14:41:44'), 
('18', '2021-04-24 13:48:51', '0000-00-00 00:00:00'), 
('18', '2021-04-24 13:50:45', '0000-00-00 00:00:00'), 
('17', '2021-04-24 13:51:28', '0000-00-00 00:00:00'), 
('17', '2021-04-24 13:51:28', '0000-00-00 00:00:00'), 
('17', '2021-04-24 13:56:52', '0000-00-00 00:00:00'), 
('17', '2021-04-24 13:58:17', '0000-00-00 00:00:00'), 
('15', '2021-04-24 14:41:50', '2021-04-24 16:01:41'), 
('17', '2021-04-24 15:15:57', '0000-00-00 00:00:00'), 
('15', '2021-04-24 15:22:48', '0000-00-00 00:00:00'), 
('17', '2021-04-24 15:57:02', '0000-00-00 00:00:00'), 
('18', '2021-04-24 16:12:21', '0000-00-00 00:00:00'), 
('17', '2021-04-24 16:14:03', '0000-00-00 00:00:00'), 
('17', '2021-04-24 16:17:23', '0000-00-00 00:00:00'), 
('15', '2021-04-24 16:29:33', '2021-04-24 16:31:01'), 
('18', '2021-04-24 16:31:09', '2021-04-24 16:31:19'), 
('15', '2021-04-24 16:31:23', '2021-04-24 16:32:10'), 
('17', '2021-04-24 16:32:15', '2021-04-24 16:32:22'), 
('15', '2021-04-24 16:32:26', '2021-04-24 16:36:04'), 
('15', '2021-04-24 16:42:10', '2021-04-24 16:50:29'), 
('3', '2021-04-24 16:50:35', '2021-04-24 16:56:16'), 
('4', '2021-04-24 17:27:03', '0000-00-00 00:00:00'), 
('3', '2021-04-24 17:36:24', '0000-00-00 00:00:00'), 
('3', '2021-04-24 17:51:04', '0000-00-00 00:00:00'), 
('1', '2021-04-24 18:04:09', '2021-04-24 18:08:43'), 
('2', '2021-04-24 18:08:59', '0000-00-00 00:00:00'), 
('3', '2021-04-24 19:44:02', '0000-00-00 00:00:00'), 
('2', '2021-04-24 21:51:52', '2021-04-24 23:31:43'), 
('3', '2021-04-24 22:09:37', '0000-00-00 00:00:00'), 
('3', '2021-04-24 22:10:10', '0000-00-00 00:00:00'), 
('1', '2021-04-24 23:31:55', '2021-04-24 23:32:03'), 
('2', '2021-04-24 23:32:11', '0000-00-00 00:00:00'), 
('2', '2021-04-25 03:07:02', '0000-00-00 00:00:00'), 
('2', '2021-04-25 09:30:23', '2021-04-25 11:23:24'), 
('4', '2021-04-25 11:13:51', '0000-00-00 00:00:00'), 
('3', '2021-04-25 11:14:21', '0000-00-00 00:00:00'), 
('3', '2021-04-25 11:15:20', '0000-00-00 00:00:00'), 
('3', '2021-04-25 11:15:25', '0000-00-00 00:00:00'), 
('3', '2021-04-25 11:23:29', '2021-04-25 11:23:40'), 
('4', '2021-04-25 11:23:47', '2021-04-25 11:23:59'), 
('1', '2021-04-25 11:24:04', '2021-04-25 11:24:11'), 
('3', '2021-04-25 11:24:16', '0000-00-00 00:00:00'), 
('2', '2021-04-25 11:24:19', '0000-00-00 00:00:00'), 
('3', '2021-04-25 11:24:59', '0000-00-00 00:00:00'), 
('4', '2021-04-25 11:24:59', '0000-00-00 00:00:00'), 
('1', '2021-04-25 11:25:25', '0000-00-00 00:00:00'), 
('4', '2021-04-25 11:25:51', '0000-00-00 00:00:00'), 
('3', '2021-04-25 12:09:52', '0000-00-00 00:00:00'), 
('4', '2021-04-25 12:13:27', '0000-00-00 00:00:00'), 
('3', '2021-04-25 12:18:19', '0000-00-00 00:00:00'), 
('2', '2021-04-25 12:31:06', '2021-04-25 13:43:48'), 
('3', '2021-04-25 12:57:04', '0000-00-00 00:00:00'), 
('4', '2021-04-25 13:45:21', '0000-00-00 00:00:00'), 
('1', '2021-04-25 13:48:25', '0000-00-00 00:00:00'), 
('2', '2021-04-25 14:15:54', '0000-00-00 00:00:00'), 
('1', '2021-04-25 16:08:31', '0000-00-00 00:00:00'), 
('4', '2021-04-25 16:12:35', '0000-00-00 00:00:00'), 
('1', '2021-04-25 16:27:02', '2021-04-25 17:27:22'), 
('1', '2021-04-25 17:27:29', '2021-04-25 17:47:52'), 
('4', '2021-04-25 17:33:07', '0000-00-00 00:00:00'), 
('4', '2021-04-25 17:48:16', '0000-00-00 00:00:00'), 
('4', '2021-04-25 19:01:15', '0000-00-00 00:00:00'), 
('4', '2021-04-25 19:14:28', '0000-00-00 00:00:00'), 
('4', '2021-04-25 19:37:52', '0000-00-00 00:00:00'), 
('4', '2021-04-25 19:41:36', '0000-00-00 00:00:00'), 
('4', '2021-04-25 20:17:43', '0000-00-00 00:00:00'), 
('4', '2021-04-26 11:35:30', '0000-00-00 00:00:00'), 
('5', '2021-04-26 11:46:18', '0000-00-00 00:00:00'), 
('4', '2021-04-26 11:54:11', '0000-00-00 00:00:00'), 
('4', '2021-04-26 11:59:48', '0000-00-00 00:00:00'), 
('4', '2021-04-26 12:02:03', '0000-00-00 00:00:00'), 
('2', '2021-04-26 12:19:35', '2021-04-26 14:15:16'), 
('1', '2021-04-26 12:29:10', '0000-00-00 00:00:00'), 
('1', '2021-04-26 13:05:20', '0000-00-00 00:00:00'), 
('4', '2021-04-26 13:52:23', '0000-00-00 00:00:00'), 
('4', '2021-04-26 13:55:00', '0000-00-00 00:00:00'), 
('4', '2021-04-26 13:55:36', '0000-00-00 00:00:00'), 
('2', '2021-04-26 13:59:33', '2021-04-26 13:59:47'), 
('1', '2021-04-26 13:59:50', '2021-04-28 14:08:14'), 
('2', '2021-04-26 14:02:06', '0000-00-00 00:00:00'), 
('1', '2021-04-26 14:16:24', '2021-04-26 16:27:01'), 
('6', '2021-04-26 16:03:07', '0000-00-00 00:00:00'), 
('4', '2021-04-26 19:03:39', '0000-00-00 00:00:00'), 
('6', '2021-04-26 19:31:28', '2021-04-26 19:33:09'), 
('1', '2021-04-26 19:33:38', '0000-00-00 00:00:00'), 
('1', '2021-04-27 12:56:33', '0000-00-00 00:00:00'), 
('4', '2021-04-27 14:22:03', '0000-00-00 00:00:00'), 
('4', '2021-04-27 16:33:55', '0000-00-00 00:00:00'), 
('2', '2021-04-27 17:08:40', '0000-00-00 00:00:00'), 
('4', '2021-04-27 17:12:05', '0000-00-00 00:00:00'), 
('1', '2021-04-27 19:01:43', '2021-04-27 19:11:00'), 
('6', '2021-04-27 19:11:09', '0000-00-00 00:00:00'), 
('1', '2021-04-27 19:48:36', '0000-00-00 00:00:00'), 
('1', '2021-04-27 19:59:28', '0000-00-00 00:00:00'), 
('1', '2021-04-27 20:14:44', '0000-00-00 00:00:00'), 
('1', '2021-04-28 10:24:28', '0000-00-00 00:00:00'), 
('1', '2021-04-28 10:24:28', '0000-00-00 00:00:00'), 
('4', '2021-04-28 13:46:58', '0000-00-00 00:00:00'), 
('2', '2021-04-28 14:07:53', '2021-04-28 14:08:30'), 
('2', '2021-04-28 14:08:22', '2021-04-28 14:12:45'), 
('1', '2021-04-28 14:08:57', '0000-00-00 00:00:00'), 
('1', '2021-04-28 14:09:50', '0000-00-00 00:00:00'), 
('4', '2021-04-28 14:12:27', '0000-00-00 00:00:00'), 
('1', '2021-04-28 14:12:48', '2021-04-28 14:24:42'), 
('1', '2021-04-28 14:25:00', '2021-04-28 14:25:18'), 
('1', '2021-04-28 14:25:21', '2021-04-28 14:49:48'), 
('1', '2021-04-28 14:45:30', '0000-00-00 00:00:00'), 
('4', '2021-04-28 14:48:27', '0000-00-00 00:00:00'), 
('2', '2021-04-28 14:50:09', '2021-04-28 14:51:57'), 
('1', '2021-04-28 14:52:00', '0000-00-00 00:00:00'), 
('1', '2021-04-28 15:54:15', '0000-00-00 00:00:00'), 
('1', '2021-04-28 17:35:26', '0000-00-00 00:00:00'), 
('1', '2021-04-28 18:51:01', '0000-00-00 00:00:00'), 
('1', '2021-04-28 18:52:30', '0000-00-00 00:00:00'), 
('1', '2021-04-28 18:56:34', '0000-00-00 00:00:00'), 
('4', '2021-04-28 18:58:33', '0000-00-00 00:00:00'), 
('1', '2021-04-29 10:14:12', '0000-00-00 00:00:00'), 
('1', '2021-04-29 10:30:05', '0000-00-00 00:00:00'), 
('1', '2021-04-29 13:36:09', '0000-00-00 00:00:00'), 
('4', '2021-04-29 13:50:17', '0000-00-00 00:00:00'), 
('4', '2021-04-29 15:20:22', '0000-00-00 00:00:00'), 
('4', '2021-04-29 16:05:32', '0000-00-00 00:00:00'), 
('4', '2021-04-29 18:31:51', '0000-00-00 00:00:00'), 
('1', '2021-04-30 12:41:05', '0000-00-00 00:00:00'), 
('1', '2021-05-01 09:54:23', '0000-00-00 00:00:00'), 
('1', '2021-05-01 14:03:20', '0000-00-00 00:00:00'), 
('4', '2021-05-01 14:06:55', '0000-00-00 00:00:00'), 
('1', '2021-05-01 15:07:05', '0000-00-00 00:00:00'), 
('4', '2021-05-01 15:08:29', '0000-00-00 00:00:00'), 
('1', '2021-05-01 15:09:35', '0000-00-00 00:00:00'), 
('4', '2021-05-01 15:24:00', '0000-00-00 00:00:00'), 
('1', '2021-05-01 19:33:56', '0000-00-00 00:00:00'), 
('4', '2021-05-01 19:35:28', '0000-00-00 00:00:00'), 
('1', '2021-05-01 19:52:47', '0000-00-00 00:00:00'), 
('1', '2021-05-01 20:00:31', '0000-00-00 00:00:00'), 
('1', '2021-05-02 09:50:27', '0000-00-00 00:00:00'), 
('1', '2021-05-02 11:14:09', '0000-00-00 00:00:00'), 
('1', '2021-05-02 12:46:12', '0000-00-00 00:00:00'), 
('2', '2021-05-02 14:01:21', '0000-00-00 00:00:00'), 
('1', '2021-05-02 14:13:27', '0000-00-00 00:00:00'), 
('1', '2021-05-02 14:24:38', '0000-00-00 00:00:00'), 
('4', '2021-05-02 14:31:39', '0000-00-00 00:00:00'), 
('4', '2021-05-02 14:46:05', '0000-00-00 00:00:00'), 
('6', '2021-05-02 14:50:57', '2021-05-02 14:51:56'), 
('6', '2021-05-02 14:54:31', '2021-05-02 14:55:13'), 
('6', '2021-05-02 14:56:07', '2021-05-02 14:57:22'), 
('4', '2021-05-02 14:56:39', '0000-00-00 00:00:00'), 
('6', '2021-05-02 15:00:29', '2021-05-02 15:43:41'), 
('6', '2021-05-02 15:43:57', '2021-05-02 15:55:07'), 
('6', '2021-05-02 16:00:53', '2021-05-02 16:11:19'), 
('7', '2021-05-02 16:11:32', '0000-00-00 00:00:00'), 
('4', '2021-05-02 16:12:27', '2021-05-02 16:12:42'), 
('7', '2021-05-02 16:13:13', '0000-00-00 00:00:00'), 
('6', '2021-05-02 16:13:36', '2021-05-02 16:14:26'), 
('4', '2021-05-02 16:13:55', '0000-00-00 00:00:00'), 
('8', '2021-05-02 16:14:37', '2021-05-02 16:14:58'), 
('6', '2021-05-02 16:15:08', '2021-05-02 16:15:52'), 
('6', '2021-05-02 16:16:21', '0000-00-00 00:00:00'), 
('4', '2021-05-02 18:03:48', '0000-00-00 00:00:00'), 
('4', '2021-05-02 18:50:40', '0000-00-00 00:00:00'), 
('6', '2021-05-03 00:41:22', '0000-00-00 00:00:00'), 
('6', '2021-05-03 00:53:39', '0000-00-00 00:00:00'), 
('6', '2021-05-03 00:59:38', '0000-00-00 00:00:00'), 
('6', '2021-05-03 01:05:02', '0000-00-00 00:00:00'), 
('6', '2021-05-03 01:07:22', '0000-00-00 00:00:00'), 
('8', '2021-05-03 09:58:07', '0000-00-00 00:00:00'), 
('8', '2021-05-03 11:38:16', '2021-05-03 11:38:45'), 
('8', '2021-05-03 11:39:04', '2021-05-03 11:39:28'), 
('6', '2021-05-03 11:39:57', '0000-00-00 00:00:00'), 
('2', '2021-05-03 11:53:51', '0000-00-00 00:00:00'), 
('2', '2021-05-03 13:37:50', '2021-05-05 15:41:43'), 
('2', '2021-05-03 13:52:23', '0000-00-00 00:00:00'), 
('4', '2021-05-03 14:52:58', '0000-00-00 00:00:00'), 
('2', '2021-05-03 15:12:11', '0000-00-00 00:00:00'), 
('2', '2021-05-03 15:53:18', '0000-00-00 00:00:00'), 
('9', '2021-05-03 16:54:59', '0000-00-00 00:00:00'), 
('4', '2021-05-03 17:11:18', '0000-00-00 00:00:00'), 
('4', '2021-05-03 18:20:56', '0000-00-00 00:00:00'), 
('6', '2021-05-04 10:09:27', '0000-00-00 00:00:00'), 
('6', '2021-05-04 12:24:16', '0000-00-00 00:00:00'), 
('4', '2021-05-04 14:21:21', '0000-00-00 00:00:00'), 
('4', '2021-05-04 17:19:42', '0000-00-00 00:00:00'), 
('8', '2021-05-05 10:02:34', '0000-00-00 00:00:00'), 
('8', '2021-05-05 11:23:56', '0000-00-00 00:00:00'), 
('8', '2021-05-05 13:25:58', '0000-00-00 00:00:00'), 
('8', '2021-05-05 13:27:49', '0000-00-00 00:00:00'), 
('8', '2021-05-05 13:46:44', '0000-00-00 00:00:00'), 
('9', '2021-05-05 14:01:20', '2021-05-05 14:02:28'), 
('4', '2021-05-05 14:01:41', '0000-00-00 00:00:00'), 
('9', '2021-05-05 14:02:31', '0000-00-00 00:00:00'), 
('9', '2021-05-05 15:41:51', '0000-00-00 00:00:00'), 
('9', '2021-05-05 15:46:43', '2021-05-05 16:24:49'), 
('9', '2021-05-05 15:48:06', '0000-00-00 00:00:00'), 
('9', '2021-05-05 16:00:23', '0000-00-00 00:00:00'), 
('4', '2021-05-05 16:27:42', '0000-00-00 00:00:00'), 
('8', '2021-05-06 09:44:12', '0000-00-00 00:00:00'), 
('8', '2021-05-06 13:56:29', '0000-00-00 00:00:00'), 
('8', '2021-05-06 14:01:21', '0000-00-00 00:00:00'), 
('4', '2021-05-06 15:13:22', '0000-00-00 00:00:00'), 
('4', '2021-05-06 15:25:39', '0000-00-00 00:00:00'), 
('4', '2021-05-06 15:40:14', '0000-00-00 00:00:00'), 
('4', '2021-05-07 14:23:34', '0000-00-00 00:00:00'), 
('4', '2021-05-07 15:28:00', '0000-00-00 00:00:00'), 
('8', '2021-05-08 14:26:04', '0000-00-00 00:00:00'), 
('4', '2021-05-08 14:29:21', '0000-00-00 00:00:00'), 
('4', '2021-05-08 14:47:41', '0000-00-00 00:00:00'), 
('8', '2021-05-08 14:53:53', '0000-00-00 00:00:00'), 
('8', '2021-05-08 15:11:02', '0000-00-00 00:00:00'), 
('4', '2021-05-08 16:01:51', '0000-00-00 00:00:00'), 
('8', '2021-05-08 19:14:52', '0000-00-00 00:00:00'), 
('8', '2021-05-08 20:18:23', '0000-00-00 00:00:00'), 
('4', '2021-05-09 10:17:54', '0000-00-00 00:00:00'), 
('4', '2021-05-09 11:52:09', '0000-00-00 00:00:00'), 
('8', '2021-05-09 14:15:09', '0000-00-00 00:00:00'), 
('8', '2021-05-09 15:43:04', '0000-00-00 00:00:00'), 
('8', '2021-05-09 16:04:07', '0000-00-00 00:00:00'), 
('8', '2021-05-09 17:16:07', '0000-00-00 00:00:00'), 
('8', '2021-05-09 18:22:42', '0000-00-00 00:00:00'), 
('8', '2021-05-10 15:42:01', '0000-00-00 00:00:00'), 
('8', '2021-05-10 17:31:08', '0000-00-00 00:00:00'), 
('8', '2021-05-10 17:55:30', '0000-00-00 00:00:00'), 
('4', '2021-05-11 10:08:25', '0000-00-00 00:00:00'), 
('8', '2021-05-11 14:35:45', '0000-00-00 00:00:00'), 
('8', '2021-05-11 15:00:10', '0000-00-00 00:00:00'), 
('8', '2021-05-11 17:19:17', '0000-00-00 00:00:00'), 
('8', '2021-05-11 19:07:34', '0000-00-00 00:00:00'), 
('4', '2021-05-12 10:24:45', '0000-00-00 00:00:00'), 
('4', '2021-05-12 12:57:41', '2021-05-12 15:41:06'), 
('8', '2021-05-12 15:41:17', '0000-00-00 00:00:00'), 
('8', '2021-05-12 19:24:32', '0000-00-00 00:00:00'), 
('8', '2021-05-12 19:25:01', '0000-00-00 00:00:00'), 
('8', '2021-05-12 19:33:23', '2021-05-12 20:13:51'), 
('8', '2021-05-16 14:20:42', '0000-00-00 00:00:00'), 
('8', '2021-05-16 16:15:31', '0000-00-00 00:00:00'), 
('8', '2021-05-16 17:24:03', '0000-00-00 00:00:00'), 
('8', '2021-05-17 10:24:46', '0000-00-00 00:00:00'), 
('8', '2021-05-17 11:31:51', '0000-00-00 00:00:00'), 
('6', '2021-05-17 13:10:48', '0000-00-00 00:00:00'), 
('8', '2021-05-17 14:16:04', '0000-00-00 00:00:00'), 
('8', '2021-05-17 19:42:22', '0000-00-00 00:00:00'), 
('8', '2021-05-17 19:43:57', '0000-00-00 00:00:00'), 
('8', '2021-05-18 10:36:06', '0000-00-00 00:00:00'), 
('8', '2021-05-18 11:52:29', '0000-00-00 00:00:00'), 
('8', '2021-05-18 12:46:53', '2021-05-18 12:49:00'), 
('8', '2021-05-18 12:49:16', '0000-00-00 00:00:00'), 
('8', '2021-05-18 13:28:40', '0000-00-00 00:00:00'), 
('4', '2021-05-18 14:51:43', '0000-00-00 00:00:00'), 
('4', '2021-05-18 17:31:09', '0000-00-00 00:00:00'), 
('8', '2021-05-19 09:25:06', '0000-00-00 00:00:00'), 
('4', '2021-05-19 14:17:49', '0000-00-00 00:00:00'), 
('4', '2021-05-19 14:36:26', '0000-00-00 00:00:00'), 
('4', '2021-05-19 14:45:00', '0000-00-00 00:00:00'), 
('4', '2021-05-19 14:56:59', '0000-00-00 00:00:00'), 
('4', '2021-05-19 15:36:55', '0000-00-00 00:00:00'), 
('10', '2021-05-19 15:37:11', '0000-00-00 00:00:00'), 
('4', '2021-05-19 17:35:01', '0000-00-00 00:00:00'), 
('4', '2021-05-19 17:50:10', '0000-00-00 00:00:00'), 
('4', '2021-05-19 18:22:05', '0000-00-00 00:00:00'), 
('4', '2021-05-19 18:40:18', '0000-00-00 00:00:00'), 
('4', '2021-05-19 18:40:58', '0000-00-00 00:00:00'), 
('4', '2021-05-19 18:48:05', '0000-00-00 00:00:00'), 
('4', '2021-05-19 21:03:46', '0000-00-00 00:00:00'), 
('8', '2021-05-20 09:16:07', '0000-00-00 00:00:00'), 
('8', '2021-05-20 12:49:26', '0000-00-00 00:00:00'), 
('8', '2021-05-20 12:54:53', '0000-00-00 00:00:00'), 
('8', '2021-05-20 13:06:03', '0000-00-00 00:00:00'), 
('4', '2021-05-20 14:18:21', '0000-00-00 00:00:00'), 
('4', '2021-05-20 18:41:11', '0000-00-00 00:00:00'), 
('4', '2021-05-20 22:05:39', '0000-00-00 00:00:00'), 
('4', '2021-05-21 11:32:08', '0000-00-00 00:00:00'), 
('4', '2021-05-21 12:45:48', '0000-00-00 00:00:00'), 
('4', '2021-05-21 13:18:27', '0000-00-00 00:00:00'), 
('4', '2021-05-21 15:38:15', '0000-00-00 00:00:00'), 
('8', '2021-05-22 09:57:56', '0000-00-00 00:00:00'), 
('8', '2021-05-22 11:04:54', '0000-00-00 00:00:00'), 
('4', '2021-05-22 14:59:52', '0000-00-00 00:00:00'), 
('4', '2021-05-22 15:28:22', '0000-00-00 00:00:00'), 
('4', '2021-05-22 16:43:14', '0000-00-00 00:00:00'), 
('4', '2021-05-22 16:49:43', '0000-00-00 00:00:00'), 
('4', '2021-05-22 17:55:45', '0000-00-00 00:00:00'), 
('8', '2021-05-23 09:33:35', '2021-05-23 13:55:19'), 
('8', '2021-05-23 10:47:10', '0000-00-00 00:00:00'), 
('4', '2021-05-23 11:37:45', '0000-00-00 00:00:00'), 
('8', '2021-05-23 13:04:34', '0000-00-00 00:00:00'), 
('8', '2021-05-23 13:57:28', '0000-00-00 00:00:00'), 
('4', '2021-05-23 14:15:09', '0000-00-00 00:00:00'), 
('4', '2021-05-23 14:24:26', '0000-00-00 00:00:00'), 
('4', '2021-05-23 17:34:26', '0000-00-00 00:00:00'), 
('8', '2021-05-24 09:35:40', '0000-00-00 00:00:00'), 
('8', '2021-05-24 14:17:55', '0000-00-00 00:00:00'), 
('4', '2021-05-24 15:56:24', '0000-00-00 00:00:00'), 
('4', '2021-05-24 17:44:33', '0000-00-00 00:00:00'), 
('4', '2021-05-24 19:33:47', '0000-00-00 00:00:00'), 
('4', '2021-05-24 21:23:36', '0000-00-00 00:00:00'), 
('8', '2021-05-25 09:19:28', '0000-00-00 00:00:00'), 
('4', '2021-05-25 14:58:12', '0000-00-00 00:00:00'), 
('4', '2021-05-25 17:22:37', '0000-00-00 00:00:00'), 
('4', '2021-05-25 19:35:44', '0000-00-00 00:00:00'), 
('4', '2021-05-25 20:34:00', '0000-00-00 00:00:00'), 
('8', '2021-05-26 10:05:52', '0000-00-00 00:00:00'), 
('4', '2021-05-26 14:17:53', '0000-00-00 00:00:00'), 
('4', '2021-05-26 14:49:06', '0000-00-00 00:00:00'), 
('4', '2021-05-26 14:50:02', '0000-00-00 00:00:00'), 
('6', '2021-05-26 16:03:52', '0000-00-00 00:00:00'), 
('6', '2021-05-26 16:48:59', '0000-00-00 00:00:00'), 
('8', '2021-05-26 21:29:40', '0000-00-00 00:00:00'), 
('8', '2021-05-27 09:13:08', '0000-00-00 00:00:00'), 
('8', '2021-05-27 09:46:32', '0000-00-00 00:00:00'), 
('8', '2021-05-27 10:19:22', '0000-00-00 00:00:00'), 
('8', '2021-05-27 12:35:50', '0000-00-00 00:00:00'), 
('8', '2021-05-27 13:31:17', '0000-00-00 00:00:00'), 
('8', '2021-05-27 13:32:57', '0000-00-00 00:00:00'), 
('4', '2021-05-27 14:25:42', '0000-00-00 00:00:00'), 
('4', '2021-05-27 15:33:30', '0000-00-00 00:00:00'), 
('4', '2021-05-27 17:41:54', '0000-00-00 00:00:00'), 
('4', '2021-05-27 18:02:11', '0000-00-00 00:00:00'), 
('4', '2021-05-27 19:11:55', '0000-00-00 00:00:00'), 
('8', '2021-05-28 12:41:23', '2021-05-28 15:12:14'), 
('8', '2021-05-28 15:12:48', '2021-05-28 15:14:17'), 
('8', '2021-05-28 15:36:06', '2021-05-28 18:50:56'), 
('8', '2021-05-28 19:37:53', '0000-00-00 00:00:00'), 
('8', '2021-05-28 20:16:33', '2021-05-28 20:31:25'), 
('8', '2021-05-28 21:01:56', '0000-00-00 00:00:00'), 
('8', '2021-05-29 10:04:21', '0000-00-00 00:00:00'), 
('8', '2021-05-29 11:44:36', '0000-00-00 00:00:00'), 
('4', '2021-05-29 14:16:45', '0000-00-00 00:00:00'), 
('8', '2021-05-30 09:14:30', '0000-00-00 00:00:00'), 
('8', '2021-05-30 10:12:25', '2021-05-30 14:03:40'), 
('4', '2021-05-30 14:04:13', '0000-00-00 00:00:00'), 
('8', '2021-05-30 14:08:47', '2021-05-30 15:13:41'), 
('4', '2021-05-30 15:14:20', '0000-00-00 00:00:00'), 
('4', '2021-05-30 17:12:36', '0000-00-00 00:00:00'), 
('4', '2021-05-30 21:22:17', '0000-00-00 00:00:00'), 
('8', '2021-05-31 09:16:12', '0000-00-00 00:00:00'), 
('8', '2021-05-31 13:18:54', '2021-05-31 13:58:56'), 
('4', '2021-05-31 14:00:46', '0000-00-00 00:00:00'), 
('4', '2021-05-31 16:19:38', '0000-00-00 00:00:00'), 
('4', '2021-05-31 18:28:01', '0000-00-00 00:00:00'), 
('8', '2021-06-01 09:26:32', '0000-00-00 00:00:00'), 
('8', '2021-06-01 13:52:18', '2021-06-01 13:59:13'), 
('4', '2021-06-01 14:00:07', '0000-00-00 00:00:00'), 
('4', '2021-06-01 14:07:58', '0000-00-00 00:00:00'), 
('8', '2021-06-02 09:21:44', '0000-00-00 00:00:00'), 
('8', '2021-06-02 12:04:22', '0000-00-00 00:00:00'), 
('8', '2021-06-02 13:34:26', '0000-00-00 00:00:00'), 
('4', '2021-06-02 14:03:59', '0000-00-00 00:00:00'), 
('4', '2021-06-02 14:18:14', '0000-00-00 00:00:00'), 
('4', '2021-06-02 14:23:20', '0000-00-00 00:00:00'), 
('4', '2021-06-02 19:15:35', '0000-00-00 00:00:00'), 
('8', '2021-06-03 09:44:08', '0000-00-00 00:00:00'), 
('8', '2021-06-03 09:45:02', '2021-06-03 16:29:55'), 
('11', '2021-06-03 15:40:02', '0000-00-00 00:00:00'), 
('4', '2021-06-03 16:12:23', '2021-06-03 16:15:36'), 
('13', '2021-06-03 16:15:51', '0000-00-00 00:00:00'), 
('13', '2021-06-03 16:25:22', '0000-00-00 00:00:00'), 
('4', '2021-06-03 16:30:29', '0000-00-00 00:00:00'), 
('13', '2021-06-03 17:05:09', '0000-00-00 00:00:00'), 
('4', '2021-06-04 11:04:39', '0000-00-00 00:00:00'), 
('13', '2021-06-04 13:48:48', '2021-06-04 13:54:44'), 
('4', '2021-06-04 18:58:31', '0000-00-00 00:00:00'), 
('4', '2021-06-05 10:30:33', '0000-00-00 00:00:00'), 
('4', '2021-06-05 18:02:06', '0000-00-00 00:00:00'), 
('6', '2021-06-05 18:56:37', '0000-00-00 00:00:00'), 
('8', '2021-06-06 09:39:04', '0000-00-00 00:00:00'), 
('8', '2021-06-06 11:19:41', '2021-06-06 13:53:04'), 
('4', '2021-06-06 13:54:05', '0000-00-00 00:00:00'), 
('4', '2021-06-06 15:09:02', '0000-00-00 00:00:00'), 
('8', '2021-06-07 09:32:07', '2021-06-07 14:12:43'), 
('8', '2021-06-07 11:14:00', '2021-06-07 11:18:03'), 
('6', '2021-06-07 11:49:41', '0000-00-00 00:00:00'), 
('8', '2021-06-07 12:12:09', '2021-06-07 12:17:25'), 
('4', '2021-06-07 13:36:39', '0000-00-00 00:00:00'), 
('4', '2021-06-07 15:01:32', '0000-00-00 00:00:00'), 
('8', '2021-06-08 09:39:17', '2021-06-08 13:51:28'), 
('4', '2021-06-08 14:07:54', '0000-00-00 00:00:00'), 
('8', '2021-06-09 09:44:32', '0000-00-00 00:00:00'), 
('4', '2021-06-09 13:41:22', '0000-00-00 00:00:00'), 
('8', '2021-06-09 13:53:20', '0000-00-00 00:00:00'), 
('4', '2021-06-09 19:55:59', '0000-00-00 00:00:00'), 
('4', '2021-06-09 22:32:23', '0000-00-00 00:00:00'), 
('8', '2021-06-10 09:21:30', '0000-00-00 00:00:00'), 
('14', '2021-06-10 13:32:18', '2021-06-10 13:33:51'), 
('14', '2021-06-10 13:34:12', '0000-00-00 00:00:00'), 
('14', '2021-06-10 13:58:19', '0000-00-00 00:00:00'), 
('14', '2021-06-10 14:07:56', '0000-00-00 00:00:00'), 
('14', '2021-06-10 14:44:06', '0000-00-00 00:00:00'), 
('10', '2021-06-15 15:15:25', '2021-06-15 15:16:08'), 
('10', '2021-06-15 15:16:35', '2021-06-15 15:16:53'), 
('14', '2021-06-15 15:17:19', '0000-00-00 00:00:00'), 
('14', '2021-06-15 16:25:17', '0000-00-00 00:00:00'), 
('14', '2021-06-16 09:18:40', '0000-00-00 00:00:00'), 
('14', '2021-06-17 18:36:46', '2021-06-17 18:43:55'), 
('14', '2021-06-18 18:00:23', '0000-00-00 00:00:00'), 
('14', '2021-06-19 10:38:58', '2021-06-19 14:43:47'), 
('14', '2021-06-19 11:23:47', '0000-00-00 00:00:00'), 
('14', '2021-06-19 11:44:27', '0000-00-00 00:00:00'), 
('14', '2021-06-19 14:43:52', '0000-00-00 00:00:00'), 
('14', '2021-06-19 16:47:13', '0000-00-00 00:00:00'), 
('14', '2021-06-19 16:48:50', '0000-00-00 00:00:00'), 
('14', '2021-06-20 12:01:08', '0000-00-00 00:00:00'), 
('14', '2021-06-20 18:10:12', '0000-00-00 00:00:00'), 
('14', '2021-06-20 19:45:38', '0000-00-00 00:00:00'), 
('14', '2021-06-21 11:04:39', '0000-00-00 00:00:00'), 
('14', '2021-06-21 11:07:34', '0000-00-00 00:00:00'), 
('14', '2021-06-21 12:31:38', '0000-00-00 00:00:00'), 
('14', '2021-06-21 14:17:03', '0000-00-00 00:00:00'), 
('14', '2021-06-21 15:25:01', '0000-00-00 00:00:00'), 
('10', '2021-06-22 11:05:29', '2021-06-22 11:05:52'), 
('14', '2021-06-22 11:05:55', '0000-00-00 00:00:00'), 
('14', '2021-06-22 11:32:54', '2021-06-22 15:53:45'), 
('14', '2021-06-22 12:25:25', '0000-00-00 00:00:00'), 
('14', '2021-06-23 11:13:46', '0000-00-00 00:00:00'), 
('14', '2021-06-23 11:36:47', '0000-00-00 00:00:00'), 
('14', '2021-06-23 11:52:31', '2021-06-23 11:54:37'), 
('14', '2021-06-23 15:03:49', '0000-00-00 00:00:00'), 
('14', '2021-06-23 15:36:16', '2021-06-23 15:49:11'), 
('14', '2021-06-23 17:13:45', '2021-06-23 18:36:14'), 
('14', '2021-06-23 17:48:37', '0000-00-00 00:00:00'), 
('14', '2021-06-23 20:37:28', '0000-00-00 00:00:00'), 
('14', '2021-06-23 23:04:11', '0000-00-00 00:00:00'), 
('14', '2021-06-24 00:36:08', '2021-06-24 00:42:34'), 
('14', '2021-06-24 11:52:18', '0000-00-00 00:00:00'), 
('14', '2021-06-24 18:00:15', '0000-00-00 00:00:00'), 
('14', '2021-06-24 18:33:22', '0000-00-00 00:00:00'), 
('14', '2021-06-24 18:42:01', '0000-00-00 00:00:00'), 
('14', '2021-06-25 11:02:00', '2021-06-26 17:01:43'), 
('14', '2021-06-26 11:41:45', '0000-00-00 00:00:00'), 
('14', '2021-06-26 18:00:55', '0000-00-00 00:00:00'), 
('14', '2021-06-27 10:48:50', '0000-00-00 00:00:00'), 
('14', '2021-06-27 14:15:17', '2021-06-27 18:54:27'), 
('14', '2021-06-27 16:11:27', '0000-00-00 00:00:00'), 
('14', '2021-06-27 19:31:54', '0000-00-00 00:00:00'), 
('14', '2021-06-27 20:15:32', '2021-06-27 20:40:13'), 
('14', '2021-06-27 20:50:46', '0000-00-00 00:00:00'), 
('14', '2021-06-28 11:57:52', '0000-00-00 00:00:00'), 
('14', '2021-06-28 12:12:18', '2021-06-28 12:59:50'), 
('14', '2021-06-28 13:10:17', '0000-00-00 00:00:00'), 
('14', '2021-06-28 13:55:10', '0000-00-00 00:00:00'), 
('14', '2021-06-28 17:18:10', '0000-00-00 00:00:00'), 
('14', '2021-06-29 09:33:25', '0000-00-00 00:00:00'), 
('14', '2021-06-29 19:25:02', '2021-06-29 19:26:28'), 
('14', '2021-06-30 12:11:07', '0000-00-00 00:00:00'), 
('14', '2021-06-30 15:37:11', '2021-06-30 15:41:27'), 
('14', '2021-07-01 13:17:20', '2021-07-01 13:20:16'), 
('14', '2021-07-02 11:41:21', '0000-00-00 00:00:00'), 
('14', '2021-07-03 12:05:47', '2021-07-03 15:34:27'), 
('10', '2021-07-03 14:26:05', '2021-07-03 14:26:18'), 
('14', '2021-07-03 14:26:45', '0000-00-00 00:00:00'), 
('14', '2021-07-04 16:07:01', '2021-07-04 16:09:31'), 
('14', '2021-07-06 13:05:34', '2021-07-06 13:06:40'), 
('14', '2021-07-07 14:06:34', '0000-00-00 00:00:00'), 
('14', '2021-07-07 16:03:38', '0000-00-00 00:00:00'), 
('14', '2021-07-08 16:23:53', '0000-00-00 00:00:00'), 
('14', '2021-07-09 13:20:40', '0000-00-00 00:00:00'), 
('14', '2021-07-11 18:11:39', '0000-00-00 00:00:00'), 
('14', '2021-07-15 13:12:35', '0000-00-00 00:00:00'), 
('14', '2021-07-16 17:37:22', '2021-07-16 17:41:35'), 
('14', '2021-07-20 11:40:57', '0000-00-00 00:00:00'), 
('14', '2021-07-24 18:49:43', '0000-00-00 00:00:00'), 
('14', '2021-07-24 19:18:07', '0000-00-00 00:00:00'), 
('14', '2021-07-24 19:18:27', '0000-00-00 00:00:00'), 
('14', '2021-07-26 13:09:00', '0000-00-00 00:00:00'), 
('14', '2021-07-27 12:12:49', '0000-00-00 00:00:00'), 
('14', '2021-07-30 13:04:41', '2021-07-30 13:52:51'), 
('15', '2021-08-03 15:52:32', '0000-00-00 00:00:00'), 
('15', '2021-08-03 16:05:03', '0000-00-00 00:00:00'), 
('15', '2021-08-03 16:20:49', '0000-00-00 00:00:00'), 
('15', '2021-08-03 16:25:36', '0000-00-00 00:00:00'), 
('15', '2021-08-03 17:20:49', '2021-08-03 18:36:02'), 
('15', '2021-08-04 11:16:29', '2021-08-04 11:25:03'), 
('16', '2021-08-04 11:26:30', '0000-00-00 00:00:00'), 
('15', '2021-08-04 11:41:50', '0000-00-00 00:00:00'), 
('15', '2021-08-04 12:10:51', '2021-08-04 14:04:42'), 
('15', '2021-08-04 12:15:21', '0000-00-00 00:00:00'), 
('15', '2021-08-04 14:04:14', '0000-00-00 00:00:00'), 
('15', '2021-08-04 14:05:02', '2021-08-04 14:12:50'), 
('15', '2021-08-04 14:06:34', '0000-00-00 00:00:00'), 
('15', '2021-08-04 14:13:02', '2021-08-04 14:14:23'), 
('17', '2021-08-04 14:14:32', '2021-08-04 14:14:41'), 
('17', '2021-08-04 14:15:06', '2021-08-04 14:17:51'), 
('15', '2021-08-04 14:18:02', '0000-00-00 00:00:00'), 
('15', '2021-08-04 14:27:02', '0000-00-00 00:00:00'), 
('15', '2021-08-04 14:41:23', '0000-00-00 00:00:00'), 
('15', '2021-08-04 14:52:45', '0000-00-00 00:00:00'), 
('15', '2021-08-04 14:57:05', '0000-00-00 00:00:00'), 
('15', '2021-08-04 15:01:31', '0000-00-00 00:00:00'), 
('15', '2021-08-04 15:04:08', '0000-00-00 00:00:00'), 
('15', '2021-08-04 15:46:43', '0000-00-00 00:00:00'), 
('15', '2021-08-04 17:51:48', '2021-08-04 19:40:26'), 
('15', '2021-08-04 18:56:53', '0000-00-00 00:00:00'), 
('15', '2021-08-04 20:01:11', '2021-08-04 20:02:08'), 
('15', '2021-08-04 20:35:17', '0000-00-00 00:00:00'), 
('15', '2021-08-05 10:57:23', '0000-00-00 00:00:00'), 
('17', '2021-08-05 12:03:28', '0000-00-00 00:00:00'), 
('15', '2021-08-05 14:05:47', '0000-00-00 00:00:00'), 
('15', '2021-08-06 10:57:46', '0000-00-00 00:00:00'), 
('15', '2021-08-08 11:51:22', '0000-00-00 00:00:00'), 
('15', '2021-08-09 12:08:23', '0000-00-00 00:00:00'), 
('15', '2021-08-10 13:58:54', '0000-00-00 00:00:00'), 
('15', '2021-08-10 17:38:38', '0000-00-00 00:00:00'), 
('15', '2021-08-10 17:58:13', '0000-00-00 00:00:00'), 
('15', '2021-08-10 18:38:57', '0000-00-00 00:00:00'), 
('15', '2021-08-10 19:06:02', '0000-00-00 00:00:00'), 
('15', '2021-08-10 19:46:43', '0000-00-00 00:00:00'), 
('15', '2021-08-10 20:06:21', '0000-00-00 00:00:00'), 
('15', '2021-08-10 20:09:15', '2021-08-10 20:13:22'), 
('15', '2021-08-11 10:01:49', '0000-00-00 00:00:00'), 
('15', '2021-08-11 10:12:54', '0000-00-00 00:00:00'), 
('15', '2021-08-11 11:10:38', '0000-00-00 00:00:00'), 
('15', '2021-08-11 11:14:21', '0000-00-00 00:00:00'), 
('15', '2021-08-11 11:16:51', '0000-00-00 00:00:00'), 
('15', '2021-08-11 11:30:28', '0000-00-00 00:00:00'), 
('15', '2021-08-11 11:30:35', '0000-00-00 00:00:00'), 
('15', '2021-08-11 11:50:07', '0000-00-00 00:00:00'), 
('15', '2021-08-11 11:54:03', '0000-00-00 00:00:00'), 
('15', '2021-08-11 12:21:32', '0000-00-00 00:00:00'), 
('15', '2021-08-11 12:56:26', '0000-00-00 00:00:00'), 
('15', '2021-08-11 13:03:43', '0000-00-00 00:00:00'), 
('15', '2021-08-11 13:10:40', '0000-00-00 00:00:00'), 
('15', '2021-08-11 13:29:04', '0000-00-00 00:00:00'), 
('15', '2021-08-11 14:25:19', '0000-00-00 00:00:00'), 
('15', '2021-08-11 14:39:49', '2021-08-11 14:41:34'), 
('15', '2021-08-11 14:41:37', '0000-00-00 00:00:00'), 
('15', '2021-08-11 14:50:10', '0000-00-00 00:00:00'), 
('15', '2021-08-11 15:06:21', '0000-00-00 00:00:00'), 
('18', '2021-08-11 15:57:07', '2021-08-11 16:01:56'), 
('15', '2021-08-11 16:02:51', '0000-00-00 00:00:00'), 
('18', '2021-08-11 16:03:54', '2021-08-11 16:04:23'), 
('18', '2021-08-11 16:12:35', '0000-00-00 00:00:00'), 
('15', '2021-08-11 16:25:44', '0000-00-00 00:00:00'), 
('15', '2021-08-11 16:26:44', '0000-00-00 00:00:00'), 
('15', '2021-08-11 16:35:25', '0000-00-00 00:00:00'), 
('15', '2021-08-11 17:52:38', '0000-00-00 00:00:00'), 
('15', '2021-08-11 17:54:10', '0000-00-00 00:00:00'), 
('15', '2021-08-11 19:35:14', '0000-00-00 00:00:00'), 
('15', '2021-08-12 10:10:24', '0000-00-00 00:00:00'), 
('15', '2021-08-12 10:56:09', '0000-00-00 00:00:00'), 
('15', '2021-08-12 11:24:57', '0000-00-00 00:00:00'), 
('15', '2021-08-12 12:01:25', '0000-00-00 00:00:00'), 
('15', '2021-08-12 12:20:52', '0000-00-00 00:00:00'), 
('15', '2021-08-12 14:09:25', '2021-08-12 14:10:21'), 
('15', '2021-08-12 16:06:46', '0000-00-00 00:00:00'), 
('15', '2021-08-12 17:33:16', '0000-00-00 00:00:00'), 
('15', '2021-08-13 10:27:45', '0000-00-00 00:00:00'), 
('15', '2021-08-13 10:55:30', '0000-00-00 00:00:00'), 
('15', '2021-08-13 11:23:51', '0000-00-00 00:00:00'), 
('15', '2021-08-13 11:35:38', '0000-00-00 00:00:00'), 
('15', '2021-08-13 11:47:44', '0000-00-00 00:00:00'), 
('15', '2021-08-13 11:51:18', '0000-00-00 00:00:00'), 
('15', '2021-08-13 12:46:29', '0000-00-00 00:00:00'), 
('15', '2021-08-13 12:59:11', '0000-00-00 00:00:00'), 
('15', '2021-08-13 14:32:26', '0000-00-00 00:00:00'), 
('15', '2021-08-13 14:43:28', '0000-00-00 00:00:00'), 
('15', '2021-08-13 15:11:12', '0000-00-00 00:00:00'), 
('15', '2021-08-13 16:10:48', '0000-00-00 00:00:00'), 
('15', '2021-08-13 16:42:02', '0000-00-00 00:00:00'), 
('15', '2021-08-13 19:28:53', '0000-00-00 00:00:00'), 
('15', '2021-08-14 09:58:37', '0000-00-00 00:00:00'), 
('15', '2021-08-14 10:53:28', '0000-00-00 00:00:00'), 
('15', '2021-08-14 12:09:20', '0000-00-00 00:00:00'), 
('15', '2021-08-14 13:01:29', '0000-00-00 00:00:00'), 
('15', '2021-08-14 13:27:59', '0000-00-00 00:00:00'), 
('15', '2021-08-14 13:35:07', '0000-00-00 00:00:00'), 
('15', '2021-08-14 13:52:08', '0000-00-00 00:00:00'), 
('15', '2021-08-14 14:28:56', '0000-00-00 00:00:00'), 
('15', '2021-08-14 14:43:33', '0000-00-00 00:00:00'), 
('15', '2021-08-14 14:45:48', '2021-08-14 15:27:10'), 
('15', '2021-08-14 14:51:32', '0000-00-00 00:00:00'), 
('15', '2021-08-14 15:16:23', '0000-00-00 00:00:00'), 
('15', '2021-08-14 15:27:15', '0000-00-00 00:00:00'), 
('15', '2021-08-14 15:33:33', '0000-00-00 00:00:00'), 
('15', '2021-08-14 17:09:59', '0000-00-00 00:00:00'), 
('15', '2021-08-14 17:10:59', '0000-00-00 00:00:00'), 
('15', '2021-08-14 18:20:15', '0000-00-00 00:00:00'), 
('15', '2021-08-14 18:35:59', '2021-08-14 18:37:13'), 
('15', '2021-08-15 10:38:32', '0000-00-00 00:00:00'), 
('15', '2021-08-15 11:04:14', '0000-00-00 00:00:00'), 
('15', '2021-08-15 11:33:14', '0000-00-00 00:00:00'), 
('15', '2021-08-15 12:19:48', '0000-00-00 00:00:00'), 
('15', '2021-08-15 14:07:57', '0000-00-00 00:00:00'), 
('15', '2021-08-15 14:46:19', '0000-00-00 00:00:00'), 
('15', '2021-08-16 09:52:33', '0000-00-00 00:00:00'), 
('15', '2021-08-16 09:59:20', '0000-00-00 00:00:00'), 
('15', '2021-08-16 11:16:58', '0000-00-00 00:00:00'), 
('15', '2021-08-16 13:07:54', '0000-00-00 00:00:00'), 
('15', '2021-08-16 15:58:39', '0000-00-00 00:00:00'), 
('15', '2021-08-17 09:57:13', '0000-00-00 00:00:00'), 
('15', '2021-08-17 10:37:12', '0000-00-00 00:00:00'), 
('15', '2021-08-17 10:43:27', '0000-00-00 00:00:00'), 
('15', '2021-08-17 12:25:54', '2021-08-17 14:13:42'), 
('15', '2021-08-17 12:42:07', '0000-00-00 00:00:00'), 
('15', '2021-08-17 12:52:13', '0000-00-00 00:00:00'), 
('15', '2021-08-17 13:14:40', '0000-00-00 00:00:00'), 
('15', '2021-08-17 14:00:17', '0000-00-00 00:00:00'), 
('15', '2021-08-17 14:39:29', '0000-00-00 00:00:00'), 
('15', '2021-08-17 16:26:16', '0000-00-00 00:00:00'), 
('15', '2021-08-17 17:08:19', '0000-00-00 00:00:00'), 
('15', '2021-08-17 17:32:16', '0000-00-00 00:00:00'), 
('15', '2021-08-17 17:36:13', '0000-00-00 00:00:00'), 
('15', '2021-08-17 19:52:11', '0000-00-00 00:00:00'), 
('15', '2021-08-18 09:50:33', '0000-00-00 00:00:00'), 
('15', '2021-08-18 10:53:20', '0000-00-00 00:00:00'), 
('15', '2021-08-18 11:22:13', '0000-00-00 00:00:00'), 
('15', '2021-08-18 12:36:27', '0000-00-00 00:00:00'), 
('15', '2021-08-18 12:53:24', '0000-00-00 00:00:00'), 
('15', '2021-08-18 15:32:56', '0000-00-00 00:00:00'), 
('15', '2021-08-18 17:06:38', '0000-00-00 00:00:00'), 
('15', '2021-08-18 17:34:39', '0000-00-00 00:00:00'), 
('15', '2021-08-18 18:34:18', '0000-00-00 00:00:00'), 
('15', '2021-08-18 20:01:39', '0000-00-00 00:00:00'), 
('15', '2021-08-18 20:04:03', '0000-00-00 00:00:00'), 
('15', '2021-08-19 10:10:12', '0000-00-00 00:00:00'), 
('15', '2021-08-19 10:16:41', '0000-00-00 00:00:00'), 
('15', '2021-08-19 10:41:12', '0000-00-00 00:00:00'), 
('15', '2021-08-19 11:04:10', '0000-00-00 00:00:00'), 
('15', '2021-08-19 12:48:13', '0000-00-00 00:00:00'), 
('15', '2021-08-19 13:17:47', '0000-00-00 00:00:00'), 
('15', '2021-08-19 14:21:43', '0000-00-00 00:00:00'), 
('15', '2021-08-19 14:23:38', '0000-00-00 00:00:00'), 
('15', '2021-08-20 09:59:21', '0000-00-00 00:00:00'), 
('15', '2021-08-20 10:53:30', '0000-00-00 00:00:00'), 
('15', '2021-08-20 11:46:47', '0000-00-00 00:00:00'), 
('15', '2021-08-20 12:21:50', '0000-00-00 00:00:00'), 
('15', '2021-08-20 13:27:20', '0000-00-00 00:00:00'), 
('15', '2021-08-20 16:38:22', '0000-00-00 00:00:00'), 
('15', '2021-08-21 10:06:01', '0000-00-00 00:00:00'), 
('15', '2021-08-21 10:16:56', '0000-00-00 00:00:00'), 
('15', '2021-08-21 15:06:23', '0000-00-00 00:00:00'), 
('15', '2021-08-21 16:09:40', '0000-00-00 00:00:00'), 
('15', '2021-08-21 17:49:06', '2021-08-21 19:04:50'), 
('15', '2021-08-21 19:08:34', '0000-00-00 00:00:00'), 
('15', '2021-08-21 19:17:27', '0000-00-00 00:00:00'), 
('15', '2021-08-21 19:29:03', '0000-00-00 00:00:00'), 
('15', '2021-08-22 10:01:22', '0000-00-00 00:00:00'), 
('15', '2021-08-22 10:23:51', '0000-00-00 00:00:00'), 
('15', '2021-08-22 10:32:56', '0000-00-00 00:00:00'), 
('15', '2021-08-22 10:57:41', '0000-00-00 00:00:00'), 
('15', '2021-08-22 12:00:46', '0000-00-00 00:00:00'), 
('15', '2021-08-22 14:05:50', '0000-00-00 00:00:00'), 
('15', '2021-08-22 16:54:32', '0000-00-00 00:00:00'), 
('15', '2021-08-22 16:55:16', '0000-00-00 00:00:00'), 
('15', '2021-08-22 16:55:22', '0000-00-00 00:00:00'), 
('15', '2021-08-22 18:41:45', '0000-00-00 00:00:00'), 
('15', '2021-08-22 18:49:16', '0000-00-00 00:00:00'), 
('15', '2021-08-22 19:00:28', '0000-00-00 00:00:00'), 
('15', '2021-08-22 19:19:10', '0000-00-00 00:00:00'), 
('15', '2021-08-22 19:24:06', '0000-00-00 00:00:00'), 
('15', '2021-08-23 10:04:04', '0000-00-00 00:00:00'), 
('15', '2021-08-23 10:42:52', '0000-00-00 00:00:00'), 
('15', '2021-08-23 10:53:34', '0000-00-00 00:00:00'), 
('15', '2021-08-23 13:19:21', '0000-00-00 00:00:00'), 
('15', '2021-08-23 15:19:30', '0000-00-00 00:00:00'), 
('15', '2021-08-23 16:59:37', '0000-00-00 00:00:00'), 
('15', '2021-08-23 17:22:29', '0000-00-00 00:00:00'), 
('15', '2021-08-23 17:30:13', '0000-00-00 00:00:00'), 
('15', '2021-08-23 18:32:36', '0000-00-00 00:00:00'), 
('15', '2021-08-24 10:18:55', '0000-00-00 00:00:00'), 
('15', '2021-08-24 10:56:05', '0000-00-00 00:00:00'), 
('15', '2021-08-24 10:58:17', '0000-00-00 00:00:00'), 
('15', '2021-08-24 13:04:41', '0000-00-00 00:00:00'), 
('15', '2021-08-24 13:21:50', '0000-00-00 00:00:00'), 
('15', '2021-08-24 13:27:29', '0000-00-00 00:00:00'), 
('15', '2021-08-24 13:28:14', '0000-00-00 00:00:00'), 
('15', '2021-08-24 15:26:54', '0000-00-00 00:00:00'), 
('15', '2021-08-24 15:38:02', '0000-00-00 00:00:00'), 
('15', '2021-08-24 15:40:09', '0000-00-00 00:00:00'), 
('15', '2021-08-24 16:38:10', '0000-00-00 00:00:00'), 
('15', '2021-08-24 18:18:38', '0000-00-00 00:00:00'), 
('15', '2021-08-24 19:54:15', '0000-00-00 00:00:00'), 
('15', '2021-08-25 09:55:40', '0000-00-00 00:00:00'), 
('15', '2021-08-25 10:01:19', '0000-00-00 00:00:00'), 
('15', '2021-08-25 10:25:03', '0000-00-00 00:00:00'), 
('15', '2021-08-26 09:54:41', '0000-00-00 00:00:00'), 
('15', '2021-08-26 10:20:24', '0000-00-00 00:00:00'), 
('15', '2021-08-26 10:29:55', '0000-00-00 00:00:00'), 
('15', '2021-08-26 12:30:28', '0000-00-00 00:00:00'), 
('15', '2021-08-26 12:55:53', '0000-00-00 00:00:00'), 
('15', '2021-08-26 13:41:59', '0000-00-00 00:00:00'), 
('15', '2021-08-26 15:03:43', '0000-00-00 00:00:00'), 
('15', '2021-08-26 15:04:54', '0000-00-00 00:00:00'), 
('15', '2021-08-26 15:48:33', '0000-00-00 00:00:00'), 
('15', '2021-08-26 15:59:09', '0000-00-00 00:00:00'), 
('15', '2021-08-26 17:15:08', '0000-00-00 00:00:00'), 
('15', '2021-08-27 10:15:00', '0000-00-00 00:00:00'), 
('15', '2021-08-27 11:20:02', '0000-00-00 00:00:00'), 
('15', '2021-08-27 18:57:08', '0000-00-00 00:00:00'), 
('15', '2021-08-27 19:00:39', '0000-00-00 00:00:00'), 
('15', '2021-08-27 19:17:53', '0000-00-00 00:00:00'), 
('15', '2021-08-28 10:33:13', '0000-00-00 00:00:00'), 
('15', '2021-08-28 10:37:44', '0000-00-00 00:00:00'), 
('15', '2021-08-28 10:50:02', '0000-00-00 00:00:00'), 
('15', '2021-08-28 12:45:33', '0000-00-00 00:00:00'), 
('15', '2021-08-28 13:01:03', '0000-00-00 00:00:00'), 
('15', '2021-08-28 13:15:54', '0000-00-00 00:00:00'), 
('15', '2021-08-28 13:37:50', '0000-00-00 00:00:00'), 
('15', '2021-08-28 15:14:21', '0000-00-00 00:00:00'), 
('15', '2021-08-28 17:57:18', '0000-00-00 00:00:00'), 
('15', '2021-08-28 19:01:21', '0000-00-00 00:00:00'), 
('15', '2021-08-28 19:51:14', '0000-00-00 00:00:00'), 
('15', '2021-08-29 09:57:41', '0000-00-00 00:00:00'), 
('15', '2021-08-29 10:58:08', '0000-00-00 00:00:00'), 
('15', '2021-08-29 11:10:14', '0000-00-00 00:00:00'), 
('15', '2021-08-29 11:41:33', '0000-00-00 00:00:00'), 
('15', '2021-08-29 12:59:39', '0000-00-00 00:00:00'), 
('15', '2021-08-29 15:46:47', '0000-00-00 00:00:00'), 
('15', '2021-08-29 18:01:07', '0000-00-00 00:00:00'), 
('15', '2021-08-29 18:49:12', '0000-00-00 00:00:00'), 
('15', '2021-08-29 18:50:20', '0000-00-00 00:00:00'), 
('15', '2021-08-29 18:57:45', '0000-00-00 00:00:00'), 
('15', '2021-08-29 19:23:42', '0000-00-00 00:00:00'), 
('15', '2021-08-30 10:28:28', '0000-00-00 00:00:00'), 
('15', '2021-08-30 10:44:31', '0000-00-00 00:00:00'), 
('15', '2021-08-30 10:47:29', '0000-00-00 00:00:00'), 
('15', '2021-08-30 11:16:30', '0000-00-00 00:00:00'), 
('15', '2021-08-30 13:00:51', '0000-00-00 00:00:00'), 
('15', '2021-08-30 15:41:57', '0000-00-00 00:00:00'), 
('15', '2021-08-30 16:07:51', '0000-00-00 00:00:00'), 
('15', '2021-08-30 16:28:24', '0000-00-00 00:00:00'), 
('15', '2021-08-31 09:48:53', '0000-00-00 00:00:00'), 
('15', '2021-08-31 10:42:43', '0000-00-00 00:00:00'), 
('15', '2021-08-31 13:03:30', '0000-00-00 00:00:00'), 
('15', '2021-08-31 14:08:41', '0000-00-00 00:00:00'), 
('15', '2021-08-31 15:47:40', '0000-00-00 00:00:00'), 
('15', '2021-08-31 15:54:52', '0000-00-00 00:00:00'), 
('15', '2021-08-31 16:17:38', '0000-00-00 00:00:00'), 
('15', '2021-08-31 18:11:10', '0000-00-00 00:00:00'), 
('15', '2021-08-31 19:30:37', '0000-00-00 00:00:00'), 
('15', '2021-09-01 09:53:20', '0000-00-00 00:00:00'), 
('15', '2021-09-01 12:40:12', '0000-00-00 00:00:00'), 
('15', '2021-09-01 13:03:44', '0000-00-00 00:00:00'), 
('15', '2021-09-01 13:30:14', '0000-00-00 00:00:00'), 
('15', '2021-09-01 13:50:35', '2021-09-01 13:52:14'), 
('15', '2021-09-01 13:52:30', '0000-00-00 00:00:00'), 
('15', '2021-09-01 15:17:42', '0000-00-00 00:00:00'), 
('15', '2021-09-01 15:54:20', '0000-00-00 00:00:00'), 
('15', '2021-09-01 17:51:44', '0000-00-00 00:00:00'), 
('15', '2021-09-01 18:24:18', '0000-00-00 00:00:00'), 
('15', '2021-09-02 09:53:08', '0000-00-00 00:00:00'), 
('15', '2021-09-02 13:07:42', '0000-00-00 00:00:00'), 
('15', '2021-09-02 13:19:07', '0000-00-00 00:00:00'), 
('15', '2021-09-02 13:20:16', '0000-00-00 00:00:00'), 
('15', '2021-09-02 14:56:44', '0000-00-00 00:00:00'), 
('15', '2021-09-02 16:52:37', '0000-00-00 00:00:00'), 
('15', '2021-09-02 18:35:38', '0000-00-00 00:00:00'), 
('15', '2021-09-02 18:48:32', '0000-00-00 00:00:00'), 
('15', '2021-09-02 19:14:02', '0000-00-00 00:00:00'), 
('15', '2021-09-03 09:34:42', '0000-00-00 00:00:00'), 
('15', '2021-09-03 10:10:19', '0000-00-00 00:00:00'), 
('15', '2021-09-03 10:33:55', '0000-00-00 00:00:00'), 
('15', '2021-09-03 12:30:03', '0000-00-00 00:00:00'), 
('15', '2021-09-03 12:48:54', '0000-00-00 00:00:00'), 
('15', '2021-09-03 14:15:13', '0000-00-00 00:00:00'), 
('15', '2021-09-03 14:44:43', '0000-00-00 00:00:00'), 
('15', '2021-09-03 16:05:26', '0000-00-00 00:00:00'), 
('15', '2021-09-03 16:31:16', '0000-00-00 00:00:00'), 
('15', '2021-09-03 17:35:28', '0000-00-00 00:00:00'), 
('15', '2021-09-04 10:11:27', '0000-00-00 00:00:00'), 
('15', '2021-09-04 11:07:37', '0000-00-00 00:00:00'), 
('15', '2021-09-04 13:21:31', '0000-00-00 00:00:00'), 
('15', '2021-09-04 15:02:51', '0000-00-00 00:00:00'), 
('15', '2021-09-04 16:26:18', '0000-00-00 00:00:00'), 
('15', '2021-09-05 11:04:53', '0000-00-00 00:00:00'), 
('15', '2021-09-05 14:17:41', '0000-00-00 00:00:00'), 
('15', '2021-09-05 15:26:29', '0000-00-00 00:00:00'), 
('15', '2021-09-05 16:01:02', '0000-00-00 00:00:00'), 
('15', '2021-09-05 16:39:08', '0000-00-00 00:00:00'), 
('15', '2021-09-05 16:49:40', '0000-00-00 00:00:00'), 
('15', '2021-09-05 19:20:15', '0000-00-00 00:00:00'), 
('15', '2021-09-05 20:05:59', '0000-00-00 00:00:00'), 
('15', '2021-09-05 20:11:22', '0000-00-00 00:00:00'), 
('15', '2021-09-06 09:57:15', '0000-00-00 00:00:00'), 
('15', '2021-09-06 10:50:53', '0000-00-00 00:00:00'), 
('15', '2021-09-06 12:30:33', '0000-00-00 00:00:00'), 
('15', '2021-09-06 15:55:18', '0000-00-00 00:00:00'), 
('15', '2021-09-06 16:22:43', '0000-00-00 00:00:00'), 
('15', '2021-09-06 18:46:21', '0000-00-00 00:00:00'), 
('15', '2021-09-06 19:03:27', '0000-00-00 00:00:00'), 
('15', '2021-09-06 19:16:09', '0000-00-00 00:00:00'), 
('15', '2021-09-07 10:11:21', '0000-00-00 00:00:00'), 
('15', '2021-09-07 10:30:26', '0000-00-00 00:00:00'), 
('15', '2021-09-07 11:09:50', '0000-00-00 00:00:00'), 
('15', '2021-09-07 11:10:52', '0000-00-00 00:00:00'), 
('15', '2021-09-07 11:29:12', '0000-00-00 00:00:00'), 
('15', '2021-09-07 14:53:33', '0000-00-00 00:00:00'), 
('15', '2021-09-07 16:45:00', '0000-00-00 00:00:00'), 
('15', '2021-09-07 19:01:33', '0000-00-00 00:00:00'), 
('15', '2021-09-08 10:10:18', '0000-00-00 00:00:00'), 
('15', '2021-09-08 11:57:11', '0000-00-00 00:00:00'), 
('15', '2021-09-08 13:09:34', '0000-00-00 00:00:00'), 
('15', '2021-09-08 14:38:30', '0000-00-00 00:00:00'), 
('15', '2021-09-08 16:13:55', '0000-00-00 00:00:00'), 
('15', '2021-09-08 16:14:27', '0000-00-00 00:00:00'), 
('15', '2021-09-08 19:27:41', '0000-00-00 00:00:00'), 
('15', '2021-09-09 10:02:33', '0000-00-00 00:00:00'), 
('15', '2021-09-09 11:40:41', '0000-00-00 00:00:00'), 
('15', '2021-09-09 12:38:03', '0000-00-00 00:00:00'), 
('15', '2021-09-09 13:22:02', '0000-00-00 00:00:00'), 
('15', '2021-09-09 15:56:46', '0000-00-00 00:00:00'), 
('15', '2021-09-09 18:40:38', '0000-00-00 00:00:00'), 
('15', '2021-09-10 10:22:43', '0000-00-00 00:00:00'), 
('15', '2021-09-10 11:20:46', '0000-00-00 00:00:00'), 
('15', '2021-09-10 11:44:35', '0000-00-00 00:00:00'), 
('15', '2021-09-10 13:40:29', '0000-00-00 00:00:00'), 
('15', '2021-09-10 13:46:53', '0000-00-00 00:00:00'), 
('15', '2021-09-10 14:04:49', '0000-00-00 00:00:00'), 
('15', '2021-09-10 14:04:56', '0000-00-00 00:00:00'), 
('15', '2021-09-10 18:42:35', '0000-00-00 00:00:00'), 
('15', '2021-09-11 10:28:25', '0000-00-00 00:00:00'), 
('15', '2021-09-11 10:42:05', '0000-00-00 00:00:00'), 
('15', '2021-09-11 11:22:52', '0000-00-00 00:00:00'), 
('15', '2021-09-11 12:42:17', '0000-00-00 00:00:00'), 
('15', '2021-09-11 12:54:23', '0000-00-00 00:00:00'), 
('15', '2021-09-11 14:47:38', '0000-00-00 00:00:00'), 
('15', '2021-09-11 16:05:23', '0000-00-00 00:00:00'), 
('15', '2021-09-11 16:07:31', '0000-00-00 00:00:00'), 
('15', '2021-09-11 17:14:41', '0000-00-00 00:00:00'), 
('15', '2021-09-11 18:41:38', '0000-00-00 00:00:00'), 
('15', '2021-09-12 10:01:23', '0000-00-00 00:00:00'), 
('15', '2021-09-12 17:50:11', '0000-00-00 00:00:00'), 
('15', '2021-09-12 17:56:31', '0000-00-00 00:00:00'), 
('15', '2021-09-12 18:43:01', '0000-00-00 00:00:00'), 
('15', '2021-09-12 19:08:47', '0000-00-00 00:00:00'), 
('15', '2021-09-12 19:52:57', '0000-00-00 00:00:00'), 
('15', '2021-09-13 10:21:29', '0000-00-00 00:00:00'), 
('15', '2021-09-13 11:06:18', '0000-00-00 00:00:00'), 
('15', '2021-09-13 11:48:19', '0000-00-00 00:00:00'), 
('15', '2021-09-13 12:41:01', '0000-00-00 00:00:00'), 
('15', '2021-09-13 15:47:58', '0000-00-00 00:00:00'), 
('15', '2021-09-13 18:42:11', '0000-00-00 00:00:00'), 
('15', '2021-09-13 18:50:37', '0000-00-00 00:00:00'), 
('15', '2021-09-14 10:17:52', '0000-00-00 00:00:00'), 
('15', '2021-09-14 10:37:05', '0000-00-00 00:00:00'), 
('15', '2021-09-14 10:54:52', '0000-00-00 00:00:00'), 
('15', '2021-09-14 11:14:06', '0000-00-00 00:00:00'), 
('15', '2021-09-14 13:48:08', '0000-00-00 00:00:00'), 
('15', '2021-09-14 14:47:28', '0000-00-00 00:00:00'), 
('15', '2021-09-14 15:06:38', '0000-00-00 00:00:00'), 
('15', '2021-09-14 15:15:47', '2021-09-14 16:13:50'), 
('15', '2021-09-14 16:14:03', '0000-00-00 00:00:00'), 
('15', '2021-09-14 17:43:16', '0000-00-00 00:00:00'), 
('15', '2021-09-14 18:56:03', '0000-00-00 00:00:00'), 
('15', '2021-09-14 19:40:54', '0000-00-00 00:00:00'), 
('15', '2021-09-15 09:49:04', '0000-00-00 00:00:00'), 
('15', '2021-09-15 10:55:01', '0000-00-00 00:00:00'), 
('15', '2021-09-15 11:13:40', '0000-00-00 00:00:00'), 
('15', '2021-09-15 14:50:47', '0000-00-00 00:00:00'), 
('15', '2021-09-15 18:56:40', '0000-00-00 00:00:00'), 
('15', '2021-09-15 19:45:32', '0000-00-00 00:00:00'), 
('15', '2021-09-15 19:45:52', '0000-00-00 00:00:00'), 
('15', '2021-09-16 11:03:57', '0000-00-00 00:00:00'), 
('15', '2021-09-16 13:45:00', '0000-00-00 00:00:00'), 
('15', '2021-09-16 14:26:39', '0000-00-00 00:00:00'), 
('15', '2021-09-16 15:30:06', '0000-00-00 00:00:00'), 
('15', '2021-09-16 16:54:00', '0000-00-00 00:00:00'), 
('15', '2021-09-17 10:02:56', '2021-09-17 14:42:21'), 
('15', '2021-09-17 10:23:08', '0000-00-00 00:00:00'), 
('15', '2021-09-17 12:27:57', '0000-00-00 00:00:00'), 
('15', '2021-09-17 12:48:32', '0000-00-00 00:00:00'), 
('15', '2021-09-17 12:53:57', '0000-00-00 00:00:00'), 
('15', '2021-09-17 14:01:48', '2021-09-17 15:53:49'), 
('15', '2021-09-17 14:42:26', '0000-00-00 00:00:00'), 
('15', '2021-09-17 15:53:53', '0000-00-00 00:00:00'), 
('15', '2021-09-17 18:17:32', '0000-00-00 00:00:00'), 
('15', '2021-09-17 18:54:19', '0000-00-00 00:00:00'), 
('15', '2021-09-17 19:42:27', '0000-00-00 00:00:00'), 
('15', '2021-09-18 09:46:19', '0000-00-00 00:00:00'), 
('15', '2021-09-18 10:48:41', '0000-00-00 00:00:00'), 
('15', '2021-09-18 11:30:05', '0000-00-00 00:00:00'), 
('15', '2021-09-18 12:00:39', '0000-00-00 00:00:00'), 
('15', '2021-09-18 12:15:15', '0000-00-00 00:00:00'), 
('15', '2021-09-18 13:31:33', '0000-00-00 00:00:00'), 
('15', '2021-09-18 13:38:56', '0000-00-00 00:00:00'), 
('15', '2021-09-18 14:00:16', '2021-09-18 15:01:17'), 
('15', '2021-09-18 14:19:57', '2021-09-18 18:08:38'), 
('19', '2021-09-18 15:01:24', '2021-09-18 15:01:56'), 
('15', '2021-09-18 15:01:59', '2021-09-18 15:03:25'), 
('19', '2021-09-18 15:03:51', '2021-09-18 15:12:09'), 
('20', '2021-09-18 15:12:17', '2021-09-18 15:13:24'), 
('15', '2021-09-18 15:13:28', '0000-00-00 00:00:00'), 
('19', '2021-09-18 17:52:34', '2021-09-18 17:53:15'), 
('19', '2021-09-18 17:53:49', '2021-09-18 17:56:13'), 
('19', '2021-09-18 17:57:46', '2021-09-18 17:59:42'), 
('19', '2021-09-18 18:01:17', '0000-00-00 00:00:00'), 
('19', '2021-09-18 18:03:44', '2021-09-18 18:05:03'), 
('20', '2021-09-18 18:09:41', '2021-09-18 18:10:57'), 
('10', '2021-09-18 18:11:05', '2021-09-18 18:11:23'), 
('20', '2021-09-18 18:11:31', '2021-09-18 18:14:04'), 
('10', '2021-09-18 18:17:11', '2021-09-18 18:17:27'), 
('10', '2021-09-18 18:36:05', '2021-09-18 18:38:13'), 
('10', '2021-09-18 18:38:27', '2021-09-18 18:40:19'), 
('10', '2021-09-18 18:40:28', '0000-00-00 00:00:00'), 
('10', '2021-09-18 18:55:32', '0000-00-00 00:00:00'), 
('10', '2021-09-18 19:06:10', '0000-00-00 00:00:00'), 
('10', '2021-09-18 19:46:44', '0000-00-00 00:00:00'), 
('10', '2021-09-19 09:42:32', '0000-00-00 00:00:00'), 
('10', '2021-09-19 11:00:16', '2021-09-19 11:23:25'), 
('10', '2021-09-19 11:24:01', '2021-09-19 11:26:33');  



 



 



 



INSERT INTO `admit_type` ( `id`, `type`, `room_no`, `cabin_no`, `seat_no`, `price`, `trash`) VALUES 
('11', 'cabin', '', '208', '', '5000.00', '0'), 
('10', 'cabin', '', '207', '', '0.00', '0'), 
('9', 'cabin', '', '206', '', '0.00', '0'), 
('8', 'cabin', '', '205', '', '0.00', '0'), 
('12', 'seat', '305', '', '1', '1000.00', '0'), 
('13', 'cabin', '', '10', '', '5000.00', '0'), 
('14', 'seat', '304', '', '12', '500.00', '0');  



INSERT INTO `advanced_payment` ( `id`, `created`, `payment_date`, `emp_id`, `amount`, `trash`) VALUES 
('5', '2021-06-10', '2021-06-30', '21001', '30000.00', '0');  



INSERT INTO `altra_doctor_payment` ( `id`, `date`, `doctor_id`, `payment`, `trash`) VALUES 
('1', '2021-06-10', '21', '500.00', '0'), 
('2', '2021-06-10', '27', '1200.00', '0'), 
('3', '2021-09-15', '62', '0.00', '0');  



 



INSERT INTO `bank` ( `id`, `date`, `bank_name`) VALUES 
('1', '2021-06-10', 'Datch Bangla Bank Ltd'), 
('2', '2021-06-10', 'Islami Bank');  



 



 



INSERT INTO `barcode` ( `id`, `img_height`, `img_width`, `code_width`, `code_height`, `pos_x`, `pos_y`, `code_type`) VALUES 
('1', '68', '209', '2', '40', '104', '23', 'code128'), 
('2', '68', '209', '2', '40', '104', '23', 'code128');  



INSERT INTO `bills` ( `id`, `date`, `time`, `voucher`, `pid`, `title`, `details`, `subtotal`, `vat`, `vat_amount`, `total`, `discount`, `less_type`, `grand_total`, `paid`, `service_charge`, `due`, `last_paid`, `last_payment_date`, `payment_status`, `refereed_doctor`, `user_id`, `other_rf_doctor`, `status`, `delivery_time`) VALUES 
('1108', '2021-08-10', '05:39:37 PM', '20210810001', '12761', 'diagnosis', 'diagnosis', '500.00', '0', '0.00', '500.00', '0.00', 'Flat', '500.00', '0.00', '0.00', '500.00', '0.00', '2021-08-10', 'pending', '', '15', '', 'diagnosis', '2021-08-10 08:00 PM'), 
('1109', '2021-08-10', '05:57:00 PM', '20210810002', '27939', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '0.00', 'Flat', '900.00', '0.00', '0.00', '900.00', '0.00', '2021-08-10', 'pending', '', '15', '', 'diagnosis', '2021-08-10 08:00 PM'), 
('1110', '2021-08-10', '05:57:48 PM', '20210810003', '51442', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-08-10', 'pending', '', '15', '', 'diagnosis', '2021-08-10 08:00 PM'), 
('1111', '2021-08-10', '06:10:55 PM', '20210810004', '23381', 'diagnosis', 'diagnosis', '450.00', '0', '0.00', '450.00', '0.00', 'Flat', '450.00', '0.00', '0.00', '450.00', '0.00', '2021-08-10', 'pending', '', '15', '', 'diagnosis', '2021-08-10 08:00 PM'), 
('1112', '2021-08-10', '06:14:32 PM', '20210810005', '73086', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-08-10', 'pending', '', '15', '', 'diagnosis', '2021-08-10 08:00 PM'), 
('1113', '2021-08-10', '06:32:36 PM', '20210810006', '80864', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '0.00', 'Flat', '650.00', '0.00', '0.00', '650.00', '0.00', '2021-08-10', 'pending', '', '15', '', 'diagnosis', '2021-08-10 08:00 PM'), 
('1114', '2021-08-10', '06:34:10 PM', '20210810007', '39375', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-08-10', 'pending', '', '15', '', 'diagnosis', '2021-08-10 08:00 PM'), 
('1115', '2021-08-10', '06:36:40 PM', '20210810008', '55727', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-08-10', 'pending', '', '15', '', 'diagnosis', '2021-08-10 08:00 PM'), 
('1116', '2021-08-10', '07:16:03 PM', '20210810009', '14027', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-08-10', 'pending', '', '15', '', 'diagnosis', '2021-08-10 08:00 PM'), 
('1117', '2021-08-10', '07:53:56 PM', '20210810010', '98622', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '700.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-10', 'pending', '', '15', '', 'diagnosis', '2021-08-10 08:00 PM'), 
('1118', '2021-08-10', '08:01:32 PM', '20210810011', '89487', 'diagnosis', 'diagnosis', '2750.00', '0', '0.00', '2750.00', '0.00', 'Flat', '2750.00', '0.00', '0.00', '2750.00', '0.00', '2021-08-10', 'pending', '', '15', '', 'diagnosis', '2021-08-10 08:00 PM'), 
('1119', '2021-08-11', '10:05:02 AM', '20210811001', '72160', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1122', '2021-08-11', '11:00:21 AM', '20210811004', '83705', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-11', 'pending', '', '15', 'self', 'diagnosis', '2021-08-11 08:00 PM'), 
('1123', '2021-08-11', '11:01:42 AM', '20210811005', '14836', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-11', 'pending', '', '15', 'self', 'diagnosis', '2021-08-11 08:00 PM'), 
('1124', '2021-08-11', '11:06:40 AM', '20210811006', '51413', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '0.00', '0.00', '400.00', '0.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1126', '2021-08-11', '11:19:26 AM', '20210811008', '12007', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1127', '2021-08-11', '11:26:20 AM', '20210811009', '33490', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '0.00', 'Flat', '550.00', '400.00', '0.00', '150.00', '400.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1128', '2021-08-11', '11:30:07 AM', '20210811010', '85397', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1129', '2021-08-11', '11:32:44 AM', '20210811011', '47245', 'diagnosis', 'diagnosis', '600.00', '0', '0.00', '600.00', '350.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1131', '2021-08-11', '11:56:26 AM', '20210811013', '56857', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '5.00', '0.00', '45.00', '5.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1133', '2021-08-11', '11:59:41 AM', '20210811015', '47331', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '200.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1135', '2021-08-11', '12:03:58 PM', '20210811017', '51117', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1136', '2021-08-11', '12:09:24 PM', '20210811018', '75723', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1137', '2021-08-11', '12:17:47 PM', '20210811019', '78898', 'diagnosis', 'diagnosis', '2200.00', '0', '0.00', '2200.00', '200.00', 'Flat', '2000.00', '2000.00', '0.00', '0.00', '2000.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1138', '2021-08-11', '12:29:20 PM', '20210811020', '01140', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '600.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1139', '2021-08-11', '12:31:52 PM', '20210811021', '01142', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '200.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1140', '2021-08-11', '12:34:27 PM', '20210811012', '01143', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1142', '2021-08-11', '12:35:54 PM', '20210811016', '01145', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1145', '2021-08-11', '12:37:53 PM', '20210811014', '01148', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '250.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1146', '2021-08-11', '12:42:09 PM', '20210811022', '01149', 'diagnosis', 'diagnosis', '1950.00', '0', '0.00', '1950.00', '450.00', 'Flat', '1500.00', '500.00', '0.00', '1000.00', '500.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1147', '2021-08-11', '12:46:15 PM', '20210811003', '01150', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '300.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1148', '2021-08-11', '12:48:15 PM', '20210811023', '01151', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1149', '2021-08-11', '12:52:03 PM', '20210811024', '01152', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '0.00', 'Flat', '0.00', '790.00', '0.00', '0.00', '790.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1150', '2021-08-11', '12:54:07 PM', '20210811025', '01153', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1151', '2021-08-11', '12:56:26 PM', '20210811026', '01154', 'diagnosis', 'diagnosis', '2250.00', '0', '0.00', '2250.00', '650.00', 'Flat', '1600.00', '1600.00', '0.00', '0.00', '1600.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1152', '2021-08-11', '12:57:23 PM', '20210811027', '01155', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1153', '2021-08-11', '01:57:52 PM', '20210811028', '01156', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '600.00', '0.00', '600.00', '600.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1154', '2021-08-11', '02:11:22 PM', '20210811029', '01157', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1155', '2021-08-11', '02:28:51 PM', '20210811030', '01158', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1156', '2021-08-11', '03:13:18 PM', '20210811031', '01159', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1157', '2021-08-11', '03:37:12 PM', '20210811032', '01160', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1158', '2021-08-11', '03:54:56 PM', '20210811033', '01161', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '0.00', '0.00', '50.00', '0.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1160', '2021-08-11', '03:58:55 PM', '20210811035', '01163', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1161', '2021-08-11', '04:04:03 PM', '20210811036', '01164', 'diagnosis', 'diagnosis', '350.00', '0', '0.00', '350.00', '20.00', 'Flat', '330.00', '0.00', '0.00', '330.00', '0.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1162', '2021-08-11', '04:08:14 PM', '20210811037', '01165', 'diagnosis', 'diagnosis', '350.00', '0', '0.00', '350.00', '200.00', 'Flat', '150.00', '150.00', '0.00', '0.00', '150.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1163', '2021-08-11', '04:15:49 PM', '20210811038', '01166', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1450.00', '250.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1164', '2021-08-11', '04:19:59 PM', '20210811039', '01167', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '0.00', 'Flat', '550.00', '0.00', '0.00', '550.00', '0.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1165', '2021-08-11', '04:23:59 PM', '20210811040', '01168', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '350.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1166', '2021-08-11', '04:28:10 PM', '20210811041', '01169', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '200.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1167', '2021-08-11', '04:30:54 PM', '20210811042', '01170', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '150.00', 'Flat', '150.00', '150.00', '0.00', '0.00', '150.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1168', '2021-08-11', '04:33:42 PM', '20210811043', '01171', 'diagnosis', 'diagnosis', '1100.00', '0', '0.00', '1100.00', '400.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1169', '2021-08-11', '04:41:36 PM', '20210811044', '01172', 'diagnosis', 'diagnosis', '1850.00', '0', '0.00', '1850.00', '550.00', 'Flat', '1300.00', '1300.00', '0.00', '0.00', '1300.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1170', '2021-08-11', '04:44:44 PM', '20210811045', '01173', 'diagnosis', 'diagnosis', '1950.00', '0', '0.00', '1950.00', '550.00', 'Flat', '1400.00', '1400.00', '0.00', '0.00', '1400.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1171', '2021-08-11', '04:46:22 PM', '20210811046', '01174', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '0.00', 'Flat', '1300.00', '0.00', '0.00', '1300.00', '0.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1172', '2021-08-11', '04:56:03 PM', '20210811047', '01175', 'diagnosis', 'diagnosis', '2250.00', '0', '0.00', '2250.00', '550.00', 'Flat', '1700.00', '1700.00', '0.00', '0.00', '1700.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1173', '2021-08-11', '04:59:03 PM', '20210811048', '01176', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '100.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1174', '2021-08-11', '05:02:37 PM', '20210811049', '01177', 'diagnosis', 'diagnosis', '1650.00', '0', '0.00', '1650.00', '250.00', 'Flat', '1400.00', '1400.00', '0.00', '0.00', '1400.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1175', '2021-08-11', '05:05:47 PM', '20210811050', '01178', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '0.00', 'Flat', '1300.00', '500.00', '0.00', '800.00', '500.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1176', '2021-08-11', '05:09:44 PM', '20210811051', '01179', 'diagnosis', 'diagnosis', '1150.00', '0', '0.00', '1150.00', '350.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1177', '2021-08-11', '05:11:35 PM', '20210811052', '01180', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '0.00', 'Flat', '550.00', '0.00', '0.00', '550.00', '0.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1178', '2021-08-11', '05:14:53 PM', '20210811053', '01181', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1179', '2021-08-11', '05:19:24 PM', '20210811054', '01182', 'diagnosis', 'diagnosis', '2250.00', '0', '0.00', '2250.00', '0.00', 'Flat', '2250.00', '500.00', '0.00', '1750.00', '500.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1180', '2021-08-11', '05:23:23 PM', '20210811055', '01183', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '50.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1181', '2021-08-11', '05:26:34 PM', '20210811056', '01184', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '300.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-11', 'pending', '', '15', 'UHC,MO', 'diagnosis', '2021-08-11 08:00 PM'), 
('1182', '2021-08-11', '05:28:49 PM', '20210811057', '01185', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '0.00', 'Flat', '700.00', '0.00', '0.00', '700.00', '0.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1183', '2021-08-11', '05:31:05 PM', '20210811058', '01186', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '0.00', 'Flat', '800.00', '0.00', '0.00', '800.00', '0.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1184', '2021-08-11', '05:32:39 PM', '20210811059', '01187', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1185', '2021-08-11', '05:35:47 PM', '20210811060', '01188', 'diagnosis', 'diagnosis', '2600.00', '0', '0.00', '2600.00', '1100.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1500.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1186', '2021-08-11', '05:56:00 PM', '20210811061', '01189', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '400.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1187', '2021-08-11', '06:00:14 PM', '20210811062', '01190', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1188', '2021-08-11', '06:02:24 PM', '20210811063', '01191', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '0.00', '150.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1189', '2021-08-11', '06:10:24 PM', '20210811064', '01192', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1190', '2021-08-11', '06:14:19 PM', '20210811065', '01193', 'diagnosis', 'diagnosis', '1250.00', '0', '0.00', '1250.00', '450.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1191', '2021-08-11', '06:26:11 PM', '20210811066', '01194', 'diagnosis', 'diagnosis', '1750.00', '0', '0.00', '1750.00', '550.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1192', '2021-08-11', '06:39:06 PM', '20210811067', '01195', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '300.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1193', '2021-08-11', '06:56:19 PM', '20210811068', '01196', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1194', '2021-08-11', '07:03:58 PM', '20210811002', '01197', 'diagnosis', 'diagnosis', '500.00', '0', '0.00', '500.00', '50.00', 'Flat', '450.00', '450.00', '0.00', '0.00', '450.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1195', '2021-08-11', '07:12:05 PM', '20210811007', '01198', 'diagnosis', 'diagnosis', '350.00', '0', '0.00', '350.00', '0.00', 'Flat', '350.00', '0.00', '0.00', '350.00', '0.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1196', '2021-08-11', '07:17:11 PM', '20210811034', '01199', 'diagnosis', 'diagnosis', '1400.00', '0', '0.00', '1400.00', '0.00', 'Flat', '1400.00', '500.00', '0.00', '900.00', '500.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1197', '2021-08-11', '08:09:02 PM', '20210811069', '01200', 'diagnosis', 'diagnosis', '500.00', '0', '0.00', '500.00', '200.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-11', 'pending', '', '15', '', 'diagnosis', '2021-08-11 08:00 PM'), 
('1198', '2021-08-12', '11:00:36 AM', '20210812001', '01201', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1199', '2021-08-12', '11:02:50 AM', '20210812002', '01202', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1200', '2021-08-12', '11:04:30 AM', '20210812003', '01203', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '50.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1201', '2021-08-12', '11:07:04 AM', '20210812004', '01204', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '200.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1202', '2021-08-12', '11:07:58 AM', '20210812005', '01205', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1203', '2021-08-12', '11:21:17 AM', '20210812006', '01206', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '300.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1204', '2021-08-12', '11:27:00 AM', '20210812007', '01207', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1205', '2021-08-12', '11:29:19 AM', '20210812008', '01208', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '300.00', '0.00', '100.00', '300.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1206', '2021-08-12', '11:31:07 AM', '20210812009', '01209', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1207', '2021-08-12', '11:33:17 AM', '20210812010', '01210', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1208', '2021-08-12', '11:39:01 AM', '20210812011', '01211', 'diagnosis', 'diagnosis', '2200.00', '0', '0.00', '2200.00', '600.00', 'Flat', '1600.00', '1600.00', '0.00', '0.00', '1600.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1209', '2021-08-12', '11:41:52 AM', '20210812012', '01212', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1210', '2021-08-12', '11:45:45 AM', '20210812013', '01213', 'diagnosis', 'diagnosis', '2250.00', '0', '0.00', '2250.00', '950.00', 'Flat', '1300.00', '1300.00', '0.00', '0.00', '1300.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1211', '2021-08-12', '11:47:03 AM', '20210812014', '01214', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1212', '2021-08-12', '11:48:36 AM', '20210812015', '01215', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '355.00', 'Flat', '295.00', '295.00', '0.00', '0.00', '295.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1213', '2021-08-12', '11:51:45 AM', '20210812016', '01216', 'diagnosis', 'diagnosis', '1550.00', '0', '0.00', '1550.00', '750.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1214', '2021-08-12', '11:54:10 AM', '20210812017', '01217', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1215', '2021-08-12', '11:56:19 AM', '20210812018', '01218', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '250.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1216', '2021-08-12', '11:58:26 AM', '20210812019', '01219', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '450.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1217', '2021-08-12', '12:01:20 PM', '20210812020', '01220', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '450.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1218', '2021-08-12', '12:05:12 PM', '20210812021', '01221', 'diagnosis', 'diagnosis', '1700.00', '0', '0.00', '1700.00', '0.00', 'Flat', '1700.00', '1000.00', '0.00', '700.00', '1000.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1219', '2021-08-12', '12:09:21 PM', '20210812022', '01222', 'diagnosis', 'diagnosis', '1950.00', '0', '0.00', '1950.00', '550.00', 'Flat', '1400.00', '1400.00', '0.00', '0.00', '1400.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1220', '2021-08-12', '12:11:11 PM', '20210812023', '01223', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1221', '2021-08-12', '12:54:27 PM', '20210812024', '01224', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '350.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1222', '2021-08-12', '12:57:30 PM', '20210812025', '01225', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '500.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1223', '2021-08-12', '01:01:55 PM', '20210812026', '01226', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '0.00', 'Flat', '1350.00', '500.00', '0.00', '850.00', '500.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1224', '2021-08-12', '01:03:41 PM', '20210812027', '01227', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '0.00', 'Flat', '1350.00', '500.00', '0.00', '850.00', '500.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1225', '2021-08-12', '01:09:08 PM', '20210812028', '01228', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1226', '2021-08-12', '01:13:16 PM', '20210812029', '01229', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '0.00', 'Flat', '1300.00', '500.00', '0.00', '800.00', '500.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1227', '2021-08-12', '01:15:49 PM', '20210812030', '01230', 'diagnosis', 'diagnosis', '2000.00', '0', '0.00', '2000.00', '0.00', 'Flat', '2000.00', '0.00', '0.00', '2000.00', '0.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1228', '2021-08-12', '01:35:49 PM', '20210812031', '01231', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1229', '2021-08-12', '01:39:15 PM', '20210812032', '01232', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '300.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1230', '2021-08-12', '01:42:59 PM', '20210812033', '01233', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1231', '2021-08-12', '01:44:34 PM', '20210812034', '01234', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '300.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1232', '2021-08-12', '01:46:09 PM', '20210812035', '01235', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '0.00', 'Flat', '650.00', '400.00', '0.00', '250.00', '400.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1233', '2021-08-12', '01:51:11 PM', '20210812036', '01236', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '300.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1234', '2021-08-12', '01:56:45 PM', '20210812037', '01237', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '400.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1235', '2021-08-12', '02:31:02 PM', '20210812038', '01238', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '150.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1236', '2021-08-12', '02:32:27 PM', '20210812039', '01239', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '150.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1237', '2021-08-12', '02:40:02 PM', '20210812040', '01240', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1238', '2021-08-12', '02:52:09 PM', '20210812041', '01241', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '100.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1239', '2021-08-12', '02:55:12 PM', '20210812042', '01242', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '300.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1240', '2021-08-12', '03:04:47 PM', '20210812043', '01243', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '300.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1241', '2021-08-12', '03:06:48 PM', '20210812044', '01244', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '0.00', 'Flat', '800.00', '0.00', '0.00', '800.00', '0.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1242', '2021-08-12', '03:23:40 PM', '20210812045', '01245', 'diagnosis', 'diagnosis', '1550.00', '0', '0.00', '1550.00', '450.00', 'Flat', '1100.00', '1100.00', '0.00', '0.00', '1100.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1243', '2021-08-12', '03:26:30 PM', '20210812046', '01246', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '500.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1244', '2021-08-12', '03:28:57 PM', '20210812047', '01247', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '300.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1245', '2021-08-12', '03:35:26 PM', '20210812048', '01248', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-12', 'pending', '', '15', 'Abdul Aziz L M f', 'diagnosis', '2021-08-12 08:00 PM'), 
('1246', '2021-08-12', '03:37:56 PM', '20210812049', '01249', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1247', '2021-08-12', '03:51:03 PM', '20210812050', '01250', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1248', '2021-08-12', '03:59:06 PM', '20210812051', '01251', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '0.00', 'Flat', '550.00', '0.00', '0.00', '550.00', '0.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1249', '2021-08-12', '04:06:54 PM', '20210812052', '01252', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '100.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1250', '2021-08-12', '04:08:48 PM', '20210812053', '01253', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1251', '2021-08-12', '04:09:52 PM', '20210812054', '01254', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '0.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1252', '2021-08-12', '04:16:14 PM', '20210812055', '01255', 'diagnosis', 'diagnosis', '1600.00', '0', '0.00', '1600.00', '800.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1253', '2021-08-12', '04:19:26 PM', '20210812056', '01256', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '400.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1254', '2021-08-12', '04:23:04 PM', '20210812057', '01257', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '250.00', 'Flat', '450.00', '450.00', '0.00', '0.00', '450.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1255', '2021-08-12', '04:27:59 PM', '20210812058', '01258', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '80.00', '0.00', '70.00', '80.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1256', '2021-08-12', '04:31:25 PM', '20210812059', '01259', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '350.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1257', '2021-08-12', '04:39:08 PM', '20210812060', '01260', 'diagnosis', 'diagnosis', '1600.00', '0', '0.00', '1600.00', '0.00', 'Flat', '1600.00', '200.00', '0.00', '1400.00', '200.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1258', '2021-08-12', '04:43:56 PM', '20210812061', '01261', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '0.00', 'Flat', '1500.00', '500.00', '0.00', '1000.00', '500.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1259', '2021-08-12', '04:51:00 PM', '20210812062', '01262', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '300.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1260', '2021-08-12', '04:56:23 PM', '20210812063', '01263', 'diagnosis', 'diagnosis', '1600.00', '0', '0.00', '1600.00', '300.00', 'Flat', '1300.00', '1300.00', '0.00', '0.00', '1300.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1261', '2021-08-12', '04:58:49 PM', '20210812064', '01264', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '400.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1262', '2021-08-12', '05:02:49 PM', '20210812065', '01265', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '0.00', 'Flat', '1300.00', '500.00', '0.00', '800.00', '500.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1263', '2021-08-12', '05:05:26 PM', '20210812066', '01266', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1264', '2021-08-12', '05:08:11 PM', '20210812067', '01267', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '150.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1265', '2021-08-12', '05:11:49 PM', '20210812068', '01268', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '200.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1266', '2021-08-12', '05:13:50 PM', '20210812069', '01269', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1267', '2021-08-12', '05:29:28 PM', '20210812070', '01270', 'diagnosis', 'diagnosis', '1250.00', '0', '0.00', '1250.00', '450.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1268', '2021-08-12', '05:31:55 PM', '20210812071', '01271', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '100.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1269', '2021-08-12', '05:35:14 PM', '20210812072', '01272', 'diagnosis', 'diagnosis', '1550.00', '0', '0.00', '1550.00', '0.00', 'Flat', '1550.00', '500.00', '0.00', '1050.00', '500.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1270', '2021-08-12', '05:37:59 PM', '20210812073', '01273', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1271', '2021-08-12', '05:58:09 PM', '20210812074', '01274', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-12', 'pending', '', '15', '', 'diagnosis', '2021-08-12 08:00 PM'), 
('1272', '2021-08-13', '10:31:00 AM', '20210813001', '01275', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1273', '2021-08-13', '10:57:57 AM', '20210813002', '01276', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1274', '2021-08-13', '11:04:36 AM', '20210813003', '01277', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1275', '2021-08-13', '11:23:09 AM', '20210813004', '01278', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '150.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1276', '2021-08-13', '11:24:32 AM', '20210813005', '01279', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '0.00', 'Flat', '650.00', '0.00', '0.00', '650.00', '0.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1277', '2021-08-13', '11:29:14 AM', '20210813006', '01280', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1278', '2021-08-13', '11:32:58 AM', '20210813007', '01281', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '0.00', '0.00', '400.00', '0.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1279', '2021-08-13', '11:38:46 AM', '20210813008', '01282', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '0.00', 'Flat', '950.00', '500.00', '0.00', '450.00', '500.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1280', '2021-08-13', '11:40:58 AM', '20210813009', '01283', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '0.00', '0.00', '400.00', '0.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1281', '2021-08-13', '11:45:47 AM', '20210813010', '01284', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1282', '2021-08-13', '11:52:32 AM', '20210813011', '01285', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1283', '2021-08-13', '11:53:52 AM', '20210813012', '01286', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1284', '2021-08-13', '11:55:34 AM', '20210813013', '01287', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1285', '2021-08-13', '12:00:09 PM', '20210813014', '01288', 'diagnosis', 'diagnosis', '1700.00', '0', '0.00', '1700.00', '0.00', 'Flat', '1700.00', '500.00', '0.00', '1200.00', '500.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1286', '2021-08-13', '12:04:54 PM', '20210813015', '01289', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '0.00', '0.00', '400.00', '0.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1287', '2021-08-13', '12:09:15 PM', '20210813016', '01290', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '0.00', 'Flat', '1300.00', '800.00', '0.00', '500.00', '800.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1288', '2021-08-13', '12:15:13 PM', '20210813017', '01291', 'diagnosis', 'diagnosis', '3400.00', '0', '0.00', '3400.00', '600.00', 'Flat', '2800.00', '2800.00', '0.00', '0.00', '2800.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1289', '2021-08-13', '12:16:40 PM', '20210813018', '01292', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '0.00', 'Flat', '650.00', '300.00', '0.00', '350.00', '300.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1290', '2021-08-13', '12:21:17 PM', '20210813019', '01293', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '0.00', '150.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1291', '2021-08-13', '12:24:41 PM', '20210813020', '01294', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1292', '2021-08-13', '12:28:01 PM', '20210813021', '01295', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '200.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1293', '2021-08-13', '12:31:32 PM', '20210813022', '01296', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '450.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1294', '2021-08-13', '12:34:18 PM', '20210813023', '01297', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1295', '2021-08-13', '12:43:44 PM', '20210813024', '01298', 'diagnosis', 'diagnosis', '2400.00', '0', '0.00', '2400.00', '400.00', 'Flat', '2000.00', '2000.00', '0.00', '0.00', '2000.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1296', '2021-08-13', '12:45:13 PM', '20210813025', '01299', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1297', '2021-08-13', '12:51:24 PM', '20210813026', '01300', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '200.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1298', '2021-08-13', '12:54:07 PM', '20210813027', '01301', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '200.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1299', '2021-08-13', '12:55:35 PM', '20210813028', '01302', 'diagnosis', 'diagnosis', '200.00', '0', '0.00', '200.00', '0.00', 'Flat', '200.00', '50.00', '0.00', '150.00', '50.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1300', '2021-08-13', '12:58:42 PM', '20210813029', '01303', 'diagnosis', 'diagnosis', '1100.00', '0', '0.00', '1100.00', '0.00', 'Flat', '1100.00', '900.00', '0.00', '200.00', '900.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1301', '2021-08-13', '01:00:34 PM', '20210813030', '01304', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '450.00', 'Flat', '550.00', '550.00', '0.00', '0.00', '550.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1302', '2021-08-13', '01:02:01 PM', '20210813031', '01305', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1304', '2021-08-13', '01:06:52 PM', '20210813033', '01307', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '100.00', 'Flat', '750.00', '750.00', '0.00', '0.00', '750.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1305', '2021-08-13', '01:07:47 PM', '20210813032', '01308', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '0.00', '0.00', '400.00', '0.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1306', '2021-08-13', '01:10:04 PM', '20210813034', '01309', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1307', '2021-08-13', '01:12:51 PM', '20210813035', '01310', 'diagnosis', 'diagnosis', '1100.00', '0', '0.00', '1100.00', '200.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1308', '2021-08-13', '01:14:49 PM', '20210813036', '01311', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '400.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1309', '2021-08-13', '01:17:23 PM', '20210813037', '01312', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1310', '2021-08-13', '01:19:19 PM', '20210813038', '01313', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '0.00', 'Flat', '550.00', '400.00', '0.00', '150.00', '400.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1311', '2021-08-13', '01:23:41 PM', '20210813039', '01314', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1312', '2021-08-13', '01:27:27 PM', '20210813040', '01315', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '300.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1313', '2021-08-13', '01:30:28 PM', '20210813041', '01316', 'diagnosis', 'diagnosis', '1850.00', '0', '0.00', '1850.00', '450.00', 'Flat', '1400.00', '1400.00', '0.00', '0.00', '1400.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1314', '2021-08-13', '01:32:57 PM', '20210813042', '01317', 'diagnosis', 'diagnosis', '1150.00', '0', '0.00', '1150.00', '50.00', 'Flat', '1100.00', '1100.00', '0.00', '0.00', '1100.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1315', '2021-08-13', '01:34:53 PM', '20210813043', '01318', 'diagnosis', 'diagnosis', '750.00', '0', '0.00', '750.00', '400.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1316', '2021-08-13', '01:52:41 PM', '20210813044', '01319', 'diagnosis', 'diagnosis', '1400.00', '0', '0.00', '1400.00', '200.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1317', '2021-08-13', '01:56:21 PM', '20210813045', '01320', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '0.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1318', '2021-08-13', '01:57:53 PM', '20210813046', '01321', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '0.00', 'Flat', '900.00', '0.00', '0.00', '900.00', '0.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1319', '2021-08-13', '02:00:46 PM', '20210813047', '01322', 'diagnosis', 'diagnosis', '1400.00', '0', '0.00', '1400.00', '200.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1320', '2021-08-13', '02:04:14 PM', '20210813048', '01323', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '0.00', '0.00', '400.00', '0.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1321', '2021-08-13', '02:07:41 PM', '20210813049', '01324', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '100.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1322', '2021-08-13', '02:09:08 PM', '20210813050', '01325', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '300.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1323', '2021-08-13', '02:11:29 PM', '20210813051', '01326', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1324', '2021-08-13', '02:15:54 PM', '20210813052', '01327', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '0.00', 'Flat', '800.00', '200.00', '0.00', '600.00', '200.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1325', '2021-08-13', '02:17:54 PM', '20210813053', '01328', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1326', '2021-08-13', '02:23:12 PM', '20210813054', '01329', 'diagnosis', 'diagnosis', '1250.00', '0', '0.00', '1250.00', '250.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-13', 'pending', '', '15', 'Dr.Rahat Khan.MBBS.', 'diagnosis', '2021-08-13 08:00 PM'), 
('1327', '2021-08-13', '02:24:34 PM', '20210813055', '01330', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1328', '2021-08-13', '02:30:35 PM', '20210813056', '01331', 'diagnosis', 'diagnosis', '1400.00', '0', '0.00', '1400.00', '600.00', 'Flat', '800.00', '700.00', '0.00', '100.00', '700.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1329', '2021-08-13', '02:35:48 PM', '20210813057', '01332', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '300.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1330', '2021-08-13', '02:38:51 PM', '20210813058', '01333', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1331', '2021-08-13', '02:40:38 PM', '20210813059', '01334', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '0.00', 'Flat', '900.00', '0.00', '0.00', '900.00', '0.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1332', '2021-08-13', '02:42:06 PM', '20210813060', '01335', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '150.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1333', '2021-08-13', '02:43:33 PM', '20210813061', '01336', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '200.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1334', '2021-08-13', '02:48:03 PM', '20210813062', '01337', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1335', '2021-08-13', '02:51:16 PM', '20210813063', '01338', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1450.00', '750.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1336', '2021-08-13', '02:52:40 PM', '20210813064', '01339', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '0.00', 'Flat', '650.00', '0.00', '0.00', '650.00', '0.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1337', '2021-08-13', '02:56:01 PM', '20210813065', '01340', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1338', '2021-08-13', '03:00:44 PM', '20210813066', '01341', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '200.00', 'Flat', '1100.00', '1100.00', '0.00', '0.00', '1100.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1339', '2021-08-13', '03:07:51 PM', '20210813067', '01342', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '0.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1340', '2021-08-13', '03:12:52 PM', '20210813068', '01343', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '0.00', 'Flat', '1350.00', '500.00', '0.00', '850.00', '500.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1341', '2021-08-13', '03:14:52 PM', '20210813069', '01344', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '450.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1342', '2021-08-13', '03:31:05 PM', '20210813070', '01345', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1343', '2021-08-13', '03:34:54 PM', '20210813071', '01346', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1344', '2021-08-13', '03:37:30 PM', '20210813072', '01347', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '0.00', 'Flat', '800.00', '600.00', '0.00', '200.00', '600.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1345', '2021-08-13', '03:43:52 PM', '20210813073', '01348', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '300.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1346', '2021-08-13', '03:45:31 PM', '20210813074', '01349', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1347', '2021-08-13', '03:52:34 PM', '20210813075', '01350', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '100.00', 'Flat', '800.00', '700.00', '0.00', '100.00', '700.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1348', '2021-08-13', '03:59:42 PM', '20210813076', '01351', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '500.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1349', '2021-08-13', '04:02:45 PM', '20210813077', '01352', 'diagnosis', 'diagnosis', '2850.00', '0', '0.00', '2850.00', '850.00', 'Flat', '2000.00', '2000.00', '0.00', '0.00', '2000.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1350', '2021-08-13', '04:28:34 PM', '20210813078', '01353', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1351', '2021-08-13', '04:32:43 PM', '20210813079', '01354', 'diagnosis', 'diagnosis', '3050.00', '0', '0.00', '3050.00', '1050.00', 'Flat', '2000.00', '2000.00', '0.00', '0.00', '2000.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1352', '2021-08-13', '04:34:14 PM', '20210813080', '01355', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1353', '2021-08-13', '04:37:40 PM', '20210813081', '01356', 'diagnosis', 'diagnosis', '1750.00', '0', '0.00', '1750.00', '1250.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1354', '2021-08-13', '04:39:44 PM', '20210813082', '01357', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1355', '2021-08-13', '04:40:32 PM', '20210813083', '01358', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1356', '2021-08-13', '04:41:05 PM', '20210813084', '01359', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '0.00', 'Flat', '1300.00', '0.00', '0.00', '1300.00', '0.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1357', '2021-08-13', '04:41:32 PM', '20210813085', '01360', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '300.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1358', '2021-08-13', '04:42:00 PM', '20210813086', '01361', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1359', '2021-08-13', '04:42:30 PM', '20210813087', '01362', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1360', '2021-08-13', '04:43:13 PM', '20210813088', '01363', 'diagnosis', 'diagnosis', '2100.00', '0', '0.00', '2100.00', '600.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1500.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1361', '2021-08-13', '04:45:12 PM', '20210813089', '01364', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '0.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1362', '2021-08-13', '04:47:54 PM', '20210813090', '01365', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '1100.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1363', '2021-08-13', '04:49:52 PM', '20210813091', '01366', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '250.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1364', '2021-08-13', '05:02:24 PM', '20210813092', '01367', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1365', '2021-08-13', '05:05:32 PM', '20210813093', '01368', 'diagnosis', 'diagnosis', '750.00', '0', '0.00', '750.00', '50.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1366', '2021-08-13', '05:13:34 PM', '20210813094', '01369', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '400.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1367', '2021-08-13', '05:18:49 PM', '20210813095', '01370', 'diagnosis', 'diagnosis', '1850.00', '0', '0.00', '1850.00', '0.00', 'Flat', '1850.00', '1000.00', '0.00', '850.00', '1000.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1368', '2021-08-13', '05:19:55 PM', '20210813096', '01371', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '350.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1369', '2021-08-13', '05:21:23 PM', '20210813097', '01372', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '700.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1370', '2021-08-13', '05:24:42 PM', '20210813098', '01373', 'diagnosis', 'diagnosis', '1800.00', '0', '0.00', '1800.00', '0.00', 'Flat', '1800.00', '1000.00', '0.00', '800.00', '1000.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1371', '2021-08-13', '05:25:57 PM', '20210813099', '01374', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1372', '2021-08-13', '05:27:26 PM', '20210813100', '01375', 'diagnosis', 'diagnosis', '1250.00', '0', '0.00', '1250.00', '0.00', 'Flat', '1250.00', '300.00', '0.00', '950.00', '300.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1373', '2021-08-13', '05:28:34 PM', '20210813101', '01376', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1374', '2021-08-13', '05:29:47 PM', '20210813102', '01377', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '200.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1375', '2021-08-13', '05:32:14 PM', '20210813103', '01378', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '800.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1376', '2021-08-13', '05:33:51 PM', '20210813104', '01379', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '0.00', 'Flat', '550.00', '0.00', '0.00', '550.00', '0.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1377', '2021-08-13', '05:36:21 PM', '20210813105', '01380', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '800.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1378', '2021-08-13', '05:39:07 PM', '20210813106', '01381', 'diagnosis', 'diagnosis', '1400.00', '0', '0.00', '1400.00', '0.00', 'Flat', '1400.00', '1000.00', '0.00', '400.00', '1000.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1379', '2021-08-13', '05:43:53 PM', '20210813107', '01382', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '0.00', 'Flat', '900.00', '0.00', '0.00', '900.00', '0.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1380', '2021-08-13', '05:46:33 PM', '20210813108', '01383', 'diagnosis', 'diagnosis', '1750.00', '0', '0.00', '1750.00', '550.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1381', '2021-08-13', '05:50:38 PM', '20210813109', '01384', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '300.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1382', '2021-08-13', '05:54:19 PM', '20210813110', '01385', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '0.00', 'Flat', '1300.00', '500.00', '0.00', '800.00', '500.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1383', '2021-08-13', '05:55:44 PM', '20210813111', '01386', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1384', '2021-08-13', '06:01:51 PM', '20210813112', '01387', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '250.00', 'Flat', '150.00', '150.00', '0.00', '0.00', '150.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1385', '2021-08-13', '06:06:27 PM', '20210813113', '01388', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '300.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1386', '2021-08-13', '06:14:30 PM', '20210813114', '01389', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1387', '2021-08-13', '06:32:04 PM', '20210813115', '01390', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '0.00', '0.00', '400.00', '0.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1388', '2021-08-13', '06:36:43 PM', '20210813116', '01391', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '50.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1389', '2021-08-13', '06:39:29 PM', '20210813117', '01392', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '100.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1390', '2021-08-13', '06:42:42 PM', '20210813118', '01393', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '0.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1391', '2021-08-13', '07:05:28 PM', '20210813119', '01394', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '300.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1392', '2021-08-13', '07:10:40 PM', '20210813120', '01395', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '900.00', '0.00', 'Flat', '1000.00', '1000.00', '100.00', '0.00', '1000.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1393', '2021-08-13', '07:18:15 PM', '20210813121', '01396', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1394', '2021-08-13', '07:36:45 PM', '20210813122', '01397', 'diagnosis', 'diagnosis', '1650.00', '0', '0.00', '1650.00', '0.00', 'Flat', '1650.00', '500.00', '0.00', '1150.00', '500.00', '2021-08-13', 'pending', '', '15', '', 'diagnosis', '2021-08-13 08:00 PM'), 
('1395', '2021-08-14', '10:00:25 AM', '20210814001', '01398', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1396', '2021-08-14', '10:15:28 AM', '20210814002', '01399', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1397', '2021-08-14', '10:23:19 AM', '20210814003', '01400', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1398', '2021-08-14', '10:56:06 AM', '20210814004', '01401', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1399', '2021-08-14', '10:58:29 AM', '20210814005', '01402', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1400', '2021-08-14', '11:03:31 AM', '20210814006', '01403', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1401', '2021-08-14', '11:06:33 AM', '20210814007', '01404', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1402', '2021-08-14', '11:09:01 AM', '20210814008', '01405', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1403', '2021-08-14', '11:11:50 AM', '20210814009', '01406', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1404', '2021-08-14', '11:15:30 AM', '20210814010', '01407', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '70.00', 'Flat', '80.00', '80.00', '0.00', '0.00', '80.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1405', '2021-08-14', '11:25:14 AM', '20210814011', '01408', 'diagnosis', 'diagnosis', '1150.00', '0', '0.00', '1150.00', '350.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1406', '2021-08-14', '11:30:12 AM', '20210814012', '01409', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '300.00', 'Flat', '500.00', '0.00', '0.00', '500.00', '0.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1407', '2021-08-14', '11:33:17 AM', '20210814013', '01410', 'diagnosis', 'diagnosis', '1900.00', '0', '0.00', '1900.00', '0.00', 'Flat', '1900.00', '1000.00', '0.00', '900.00', '1000.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1408', '2021-08-14', '11:36:13 AM', '20210814014', '01411', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '550.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1409', '2021-08-14', '11:37:47 AM', '20210814015', '01412', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '550.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1410', '2021-08-14', '11:40:48 AM', '20210814016', '01413', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1411', '2021-08-14', '11:43:05 AM', '20210814017', '01414', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1412', '2021-08-14', '12:06:30 PM', '20210814018', '01415', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '200.00', '0.00', '200.00', '200.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1413', '2021-08-14', '12:15:12 PM', '20210814019', '01416', 'diagnosis', 'diagnosis', '1250.00', '0', '0.00', '1250.00', '350.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1414', '2021-08-14', '12:20:53 PM', '20210814020', '01417', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '300.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1415', '2021-08-14', '12:24:42 PM', '20210814021', '01418', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1416', '2021-08-14', '12:30:55 PM', '20210814022', '01419', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '350.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1417', '2021-08-14', '12:32:31 PM', '20210814023', '01420', 'diagnosis', 'diagnosis', '1800.00', '0', '0.00', '1800.00', '600.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1418', '2021-08-14', '12:34:19 PM', '20210814024', '01421', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1419', '2021-08-14', '12:37:58 PM', '20210814025', '01422', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1420', '2021-08-14', '12:39:40 PM', '20210814026', '01423', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '400.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1421', '2021-08-14', '12:49:35 PM', '20210814027', '01424', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '250.00', 'Flat', '550.00', '550.00', '0.00', '0.00', '550.00', '2021-08-14', 'pending', '', '15', 'Dr.Muhammad Anwarul Islam', 'diagnosis', '2021-08-14 08:00 PM'), 
('1422', '2021-08-14', '12:51:45 PM', '20210814028', '01425', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '300.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1423', '2021-08-14', '01:08:56 PM', '20210814029', '01426', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '200.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1424', '2021-08-14', '01:10:41 PM', '20210814030', '01427', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '0.00', 'Flat', '550.00', '400.00', '0.00', '150.00', '400.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1425', '2021-08-14', '01:12:27 PM', '20210814031', '01428', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '300.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1426', '2021-08-14', '01:13:52 PM', '20210814032', '01429', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '300.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1427', '2021-08-14', '01:16:09 PM', '20210814033', '01430', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1428', '2021-08-14', '01:22:50 PM', '20210814034', '01431', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '100.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1429', '2021-08-14', '01:25:20 PM', '20210814035', '01432', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '200.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1430', '2021-08-14', '01:36:43 PM', '20210814036', '01433', 'diagnosis', 'diagnosis', '600.00', '0', '0.00', '600.00', '0.00', 'Flat', '600.00', '0.00', '0.00', '600.00', '0.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1431', '2021-08-14', '01:38:11 PM', '20210814037', '01434', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1432', '2021-08-14', '01:40:07 PM', '20210814038', '01435', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '300.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1433', '2021-08-14', '01:41:53 PM', '20210814039', '01436', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '50.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1434', '2021-08-14', '01:43:42 PM', '20210814040', '01437', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1435', '2021-08-14', '01:54:15 PM', '20210814041', '01438', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '0.00', 'Flat', '900.00', '200.00', '0.00', '700.00', '200.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1436', '2021-08-14', '01:55:55 PM', '20210814042', '01439', 'diagnosis', 'diagnosis', '1250.00', '0', '0.00', '1250.00', '250.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1437', '2021-08-14', '01:57:06 PM', '20210814043', '01440', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '200.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1438', '2021-08-14', '01:58:19 PM', '20210814044', '01441', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '150.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1439', '2021-08-14', '02:00:12 PM', '20210814045', '01442', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '350.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1440', '2021-08-14', '02:03:51 PM', '20210814046', '01443', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '0.00', 'Flat', '950.00', '0.00', '0.00', '950.00', '0.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1441', '2021-08-14', '02:07:14 PM', '20210814047', '01444', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '100.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1442', '2021-08-14', '02:09:15 PM', '20210814048', '01445', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '300.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1443', '2021-08-14', '02:10:17 PM', '20210814049', '01446', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '450.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1444', '2021-08-14', '02:11:29 PM', '20210814050', '01447', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '400.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1445', '2021-08-14', '02:12:35 PM', '20210814051', '01448', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '400.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1446', '2021-08-14', '03:35:19 PM', '20210814052', '01449', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '100.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1447', '2021-08-14', '03:35:49 PM', '20210814053', '01450', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1448', '2021-08-14', '03:36:29 PM', '20210814054', '01451', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '200.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1449', '2021-08-14', '03:37:07 PM', '20210814055', '01452', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1450', '2021-08-14', '03:37:32 PM', '20210814056', '01453', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '0.00', 'Flat', '550.00', '0.00', '0.00', '550.00', '0.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1451', '2021-08-14', '03:38:28 PM', '20210814057', '01454', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1452', '2021-08-14', '03:38:59 PM', '20210814058', '01455', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '250.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1453', '2021-08-14', '03:39:38 PM', '20210814059', '01456', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1454', '2021-08-14', '03:40:03 PM', '20210814060', '01457', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1455', '2021-08-14', '03:40:27 PM', '20210814061', '01458', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1456', '2021-08-14', '03:49:01 PM', '20210814062', '01459', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '500.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1457', '2021-08-14', '03:53:00 PM', '20210814063', '01460', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '0.00', 'Flat', '1300.00', '500.00', '0.00', '800.00', '500.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1458', '2021-08-14', '03:59:56 PM', '20210814064', '01461', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1459', '2021-08-14', '04:09:38 PM', '20210814065', '01462', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '0.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1460', '2021-08-14', '04:14:01 PM', '20210814066', '01463', 'diagnosis', 'diagnosis', '1650.00', '0', '0.00', '1650.00', '250.00', 'Flat', '1400.00', '1400.00', '0.00', '0.00', '1400.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1461', '2021-08-14', '04:17:35 PM', '20210814067', '01464', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '300.00', 'Flat', '550.00', '550.00', '0.00', '0.00', '550.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1462', '2021-08-14', '04:54:09 PM', '20210814068', '01465', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '150.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1463', '2021-08-14', '05:04:49 PM', '20210814069', '01466', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '400.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1464', '2021-08-14', '05:19:26 PM', '20210814070', '01467', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '50.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1465', '2021-08-14', '05:28:07 PM', '20210814071', '01468', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '150.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1466', '2021-08-14', '05:33:43 PM', '20210814072', '01469', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1467', '2021-08-14', '05:42:10 PM', '20210814073', '01470', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '150.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1468', '2021-08-14', '05:48:58 PM', '20210814074', '01471', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1469', '2021-08-14', '06:29:26 PM', '20210814075', '01472', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-14', 'pending', '', '15', '', 'diagnosis', '2021-08-14 08:00 PM'), 
('1470', '2021-08-15', '10:40:20 AM', '20210815001', '01473', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1471', '2021-08-15', '10:42:16 AM', '20210815002', '01474', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '200.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1472', '2021-08-15', '10:51:19 AM', '20210815003', '01475', 'diagnosis', 'diagnosis', '3050.00', '0', '0.00', '3050.00', '50.00', 'Flat', '3000.00', '3000.00', '0.00', '0.00', '3000.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1473', '2021-08-15', '10:54:02 AM', '20210815004', '01476', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1474', '2021-08-15', '11:02:38 AM', '20210815005', '01477', 'diagnosis', 'diagnosis', '1850.00', '0', '0.00', '1850.00', '850.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1475', '2021-08-15', '11:06:12 AM', '20210815006', '01478', 'diagnosis', 'diagnosis', '2400.00', '0', '0.00', '2400.00', '600.00', 'Flat', '1800.00', '1800.00', '0.00', '0.00', '1800.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1476', '2021-08-15', '11:11:05 AM', '20210815007', '01479', 'diagnosis', 'diagnosis', '1150.00', '0', '0.00', '1150.00', '0.00', 'Flat', '1150.00', '0.00', '0.00', '1150.00', '0.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1477', '2021-08-15', '11:14:25 AM', '20210815008', '01480', 'diagnosis', 'diagnosis', '1700.00', '0', '0.00', '1700.00', '500.00', 'Flat', '1200.00', '1000.00', '0.00', '200.00', '1000.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1478', '2021-08-15', '11:16:38 AM', '20210815009', '01481', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1479', '2021-08-15', '11:22:45 AM', '20210815010', '01482', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '0.00', '0.00', '400.00', '0.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1480', '2021-08-15', '11:31:38 AM', '20210815011', '01483', 'diagnosis', 'diagnosis', '750.00', '0', '0.00', '550.00', '250.00', 'Flat', '500.00', '500.00', '200.00', '0.00', '300.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1481', '2021-08-15', '11:42:15 AM', '20210815012', '01484', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1482', '2021-08-15', '11:49:47 AM', '20210815013', '01485', 'diagnosis', 'diagnosis', '1700.00', '0', '0.00', '1700.00', '0.00', 'Flat', '1700.00', '500.00', '0.00', '1200.00', '500.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1483', '2021-08-15', '11:59:49 AM', '20210815014', '01486', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '450.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1484', '2021-08-15', '12:03:36 PM', '20210815015', '01487', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '500.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1485', '2021-08-15', '12:09:19 PM', '20210815016', '01488', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1486', '2021-08-15', '12:13:17 PM', '20210815017', '01489', 'diagnosis', 'diagnosis', '1550.00', '0', '0.00', '1550.00', '250.00', 'Flat', '1300.00', '1300.00', '0.00', '0.00', '1300.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1487', '2021-08-15', '12:21:52 PM', '20210815018', '01490', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '600.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1488', '2021-08-15', '12:24:23 PM', '20210815019', '01491', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1489', '2021-08-15', '12:26:12 PM', '20210815020', '01492', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1490', '2021-08-15', '12:28:08 PM', '20210815021', '01493', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '0.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1491', '2021-08-15', '12:29:55 PM', '20210815022', '01494', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '200.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1492', '2021-08-15', '12:33:41 PM', '20210815023', '01495', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1493', '2021-08-15', '12:46:39 PM', '20210815024', '01496', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '400.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1494', '2021-08-15', '12:57:16 PM', '20210815025', '01497', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1495', '2021-08-15', '01:00:22 PM', '20210815026', '01498', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '450.00', 'Flat', '900.00', '500.00', '0.00', '400.00', '500.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1496', '2021-08-15', '01:01:43 PM', '20210815027', '01499', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1497', '2021-08-15', '01:22:12 PM', '20210815028', '01500', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1498', '2021-08-15', '01:24:21 PM', '20210815029', '01501', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1499', '2021-08-15', '01:25:42 PM', '20210815030', '01502', 'diagnosis', 'diagnosis', '450.00', '0', '0.00', '450.00', '0.00', 'Flat', '450.00', '0.00', '0.00', '450.00', '0.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1500', '2021-08-15', '01:28:00 PM', '20210815031', '01503', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1501', '2021-08-15', '01:50:16 PM', '20210815032', '01504', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '300.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1502', '2021-08-15', '01:52:34 PM', '20210815033', '01505', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1503', '2021-08-15', '01:57:26 PM', '20210815034', '01506', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '350.00', 'Flat', '700.00', '600.00', '0.00', '100.00', '600.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1504', '2021-08-15', '02:15:13 PM', '20210815035', '01507', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '150.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1505', '2021-08-15', '02:18:42 PM', '20210815036', '01508', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '250.00', 'Flat', '550.00', '550.00', '0.00', '0.00', '550.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1506', '2021-08-15', '02:52:55 PM', '20210815037', '01509', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '950.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1507', '2021-08-15', '03:09:45 PM', '20210815038', '01510', 'diagnosis', 'diagnosis', '2950.00', '0', '0.00', '2950.00', '0.00', 'Flat', '2950.00', '500.00', '0.00', '2450.00', '500.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1508', '2021-08-15', '03:19:04 PM', '20210815039', '01511', 'diagnosis', 'diagnosis', '1250.00', '0', '0.00', '1250.00', '250.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1509', '2021-08-15', '03:25:15 PM', '20210815040', '01512', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '400.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1510', '2021-08-15', '03:29:20 PM', '20210815041', '01513', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '650.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1511', '2021-08-15', '03:46:25 PM', '20210815042', '01514', 'diagnosis', 'diagnosis', '1750.00', '0', '0.00', '1750.00', '550.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1512', '2021-08-15', '03:48:40 PM', '20210815043', '01515', 'diagnosis', 'diagnosis', '2000.00', '0', '0.00', '2000.00', '0.00', 'Flat', '2000.00', '500.00', '0.00', '1500.00', '500.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1513', '2021-08-15', '03:55:47 PM', '20210815044', '01516', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '150.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1514', '2021-08-15', '03:57:16 PM', '20210815045', '01517', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '650.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1515', '2021-08-15', '03:58:42 PM', '20210815046', '01518', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1450.00', '450.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1516', '2021-08-15', '04:00:25 PM', '20210815047', '01519', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1517', '2021-08-15', '04:01:25 PM', '20210815048', '01520', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1518', '2021-08-15', '04:03:28 PM', '20210815049', '01521', 'diagnosis', 'diagnosis', '3250.00', '0', '0.00', '3250.00', '850.00', 'Flat', '2400.00', '1500.00', '0.00', '900.00', '1500.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1519', '2021-08-15', '04:04:28 PM', '20210815050', '01522', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1520', '2021-08-15', '04:05:56 PM', '20210815051', '01523', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '350.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1521', '2021-08-15', '04:08:51 PM', '20210815052', '01524', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1450.00', '750.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1522', '2021-08-15', '04:10:36 PM', '20210815053', '01525', 'diagnosis', 'diagnosis', '1850.00', '0', '0.00', '1850.00', '0.00', 'Flat', '1850.00', '1000.00', '0.00', '850.00', '1000.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1523', '2021-08-15', '04:20:30 PM', '20210815054', '01526', 'diagnosis', 'diagnosis', '1400.00', '0', '0.00', '1400.00', '100.00', 'Flat', '1300.00', '1300.00', '0.00', '0.00', '1300.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1524', '2021-08-15', '04:25:04 PM', '20210815055', '01527', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '400.00', 'Flat', '150.00', '150.00', '0.00', '0.00', '150.00', '2021-08-15', 'pending', '', '15', 'self', 'diagnosis', '2021-08-15 08:00 PM'), 
('1525', '2021-08-15', '04:26:12 PM', '20210815056', '01528', 'diagnosis', 'diagnosis', '1850.00', '0', '0.00', '1850.00', '0.00', 'Flat', '1850.00', '0.00', '0.00', '1850.00', '0.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1526', '2021-08-15', '04:29:05 PM', '20210815057', '01529', 'diagnosis', 'diagnosis', '1700.00', '0', '0.00', '1700.00', '0.00', 'Flat', '1700.00', '800.00', '0.00', '900.00', '800.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1527', '2021-08-15', '04:30:07 PM', '20210815058', '01530', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1528', '2021-08-15', '04:35:18 PM', '20210815059', '01531', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '100.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1529', '2021-08-15', '04:37:22 PM', '20210815060', '01532', 'diagnosis', 'diagnosis', '1700.00', '0', '0.00', '1700.00', '500.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1530', '2021-08-15', '04:39:37 PM', '20210815061', '01533', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '450.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1531', '2021-08-15', '04:43:52 PM', '20210815062', '01534', 'diagnosis', 'diagnosis', '2350.00', '0', '0.00', '2350.00', '350.00', 'Flat', '2000.00', '2000.00', '0.00', '0.00', '2000.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1532', '2021-08-15', '04:44:59 PM', '20210815063', '01535', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1533', '2021-08-15', '04:52:31 PM', '20210815064', '01536', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1450.00', '250.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1534', '2021-08-15', '04:54:52 PM', '20210815065', '01537', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '0.00', 'Flat', '1500.00', '200.00', '0.00', '1300.00', '200.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1535', '2021-08-15', '05:03:26 PM', '20210815066', '01538', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '150.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1536', '2021-08-15', '05:07:20 PM', '20210815067', '01539', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1450.00', '0.00', 'Flat', '1450.00', '500.00', '0.00', '950.00', '500.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1537', '2021-08-15', '05:13:56 PM', '20210815068', '01540', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '0.00', '0.00', '400.00', '0.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1538', '2021-08-15', '05:16:47 PM', '20210815069', '01541', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1450.00', '0.00', 'Flat', '1450.00', '0.00', '0.00', '1450.00', '0.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1539', '2021-08-15', '05:22:20 PM', '20210815070', '01542', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1540', '2021-08-15', '05:25:00 PM', '20210815071', '01543', 'diagnosis', 'diagnosis', '2050.00', '0', '0.00', '2050.00', '950.00', 'Flat', '1100.00', '1100.00', '0.00', '0.00', '1100.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1541', '2021-08-15', '05:27:53 PM', '20210815072', '01544', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1542', '2021-08-15', '05:29:23 PM', '20210815073', '01545', 'diagnosis', 'diagnosis', '500.00', '0', '0.00', '500.00', '200.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1543', '2021-08-15', '05:41:55 PM', '20210815074', '01546', 'diagnosis', 'diagnosis', '1950.00', '0', '0.00', '1950.00', '0.00', 'Flat', '1950.00', '1000.00', '0.00', '950.00', '1000.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1544', '2021-08-15', '05:48:06 PM', '20210815075', '01547', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '0.00', 'Flat', '800.00', '500.00', '0.00', '300.00', '500.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1545', '2021-08-15', '05:49:46 PM', '20210815076', '01548', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1546', '2021-08-15', '05:51:15 PM', '20210815077', '01549', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '300.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1547', '2021-08-15', '05:54:07 PM', '20210815078', '01550', 'diagnosis', 'diagnosis', '2000.00', '0', '0.00', '1950.00', '0.00', 'Flat', '2000.00', '2000.00', '50.00', '0.00', '2000.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1548', '2021-08-15', '06:01:39 PM', '20210815079', '01551', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '200.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1549', '2021-08-15', '06:21:13 PM', '20210815080', '01552', 'diagnosis', 'diagnosis', '1900.00', '0', '0.00', '1900.00', '0.00', 'Flat', '1900.00', '1000.00', '0.00', '900.00', '1000.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1550', '2021-08-15', '06:45:41 PM', '20210815081', '01553', 'diagnosis', 'diagnosis', '350.00', '0', '0.00', '350.00', '150.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1551', '2021-08-15', '06:50:00 PM', '20210815082', '01554', 'diagnosis', 'diagnosis', '1250.00', '0', '0.00', '1250.00', '450.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-15', 'pending', '', '15', '', 'diagnosis', '2021-08-15 08:00 PM'), 
('1552', '2021-08-16', '09:55:29 AM', '20210816001', '01555', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '200.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1553', '2021-08-16', '10:25:16 AM', '20210816002', '01556', 'diagnosis', 'diagnosis', '450.00', '0', '0.00', '450.00', '300.00', 'Flat', '150.00', '150.00', '0.00', '0.00', '150.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1554', '2021-08-16', '10:58:35 AM', '20210816003', '01557', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '0.00', '0.00', '400.00', '0.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1555', '2021-08-16', '11:00:19 AM', '20210816004', '01558', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1556', '2021-08-16', '11:09:28 AM', '20210816005', '01559', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1557', '2021-08-16', '11:11:14 AM', '20210816006', '01560', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1558', '2021-08-16', '11:26:49 AM', '20210816007', '01561', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '350.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1559', '2021-08-16', '11:43:50 AM', '20210816008', '01562', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1560', '2021-08-16', '11:46:24 AM', '20210816009', '01563', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '600.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1561', '2021-08-16', '11:47:32 AM', '20210816010', '01564', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1562', '2021-08-16', '11:49:01 AM', '20210816011', '01565', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '350.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1563', '2021-08-16', '11:50:12 AM', '20210816012', '01566', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '500.00', '0.00', '700.00', '500.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1564', '2021-08-16', '11:51:51 AM', '20210816013', '01567', 'diagnosis', 'diagnosis', '1250.00', '0', '0.00', '1250.00', '750.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1565', '2021-08-16', '11:52:55 AM', '20210816014', '01568', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '200.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1566', '2021-08-16', '11:54:41 AM', '20210816015', '01569', 'diagnosis', 'diagnosis', '450.00', '0', '0.00', '450.00', '250.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1567', '2021-08-16', '11:56:20 AM', '20210816016', '01570', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '170.00', 'Flat', '380.00', '380.00', '0.00', '0.00', '380.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1568', '2021-08-16', '12:04:28 PM', '20210816017', '01571', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1569', '2021-08-16', '12:07:59 PM', '20210816018', '01572', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1570', '2021-08-16', '12:13:53 PM', '20210816019', '01573', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '0.00', 'Flat', '1350.00', '0.00', '0.00', '1350.00', '0.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1571', '2021-08-16', '12:21:15 PM', '20210816020', '01574', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '250.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1572', '2021-08-16', '12:30:39 PM', '20210816021', '01575', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1573', '2021-08-16', '12:33:31 PM', '20210816022', '01576', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1574', '2021-08-16', '12:35:33 PM', '20210816023', '01577', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1575', '2021-08-16', '12:45:46 PM', '20210816024', '01578', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1576', '2021-08-16', '12:50:54 PM', '20210816025', '01579', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '300.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1577', '2021-08-16', '01:04:05 PM', '20210816026', '01580', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '400.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1578', '2021-08-16', '01:11:01 PM', '20210816027', '01581', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '0.00', 'Flat', '650.00', '0.00', '0.00', '650.00', '0.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1579', '2021-08-16', '01:14:22 PM', '20210816028', '01582', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1580', '2021-08-16', '01:17:05 PM', '20210816029', '01583', 'diagnosis', 'diagnosis', '3650.00', '0', '0.00', '3650.00', '1150.00', 'Flat', '2500.00', '2500.00', '0.00', '0.00', '2500.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1581', '2021-08-16', '01:20:11 PM', '20210816030', '01584', 'diagnosis', 'diagnosis', '2200.00', '0', '0.00', '2200.00', '200.00', 'Flat', '2000.00', '2000.00', '0.00', '0.00', '2000.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1582', '2021-08-16', '01:21:50 PM', '20210816031', '01585', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '500.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1583', '2021-08-16', '01:25:16 PM', '20210816032', '01586', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '400.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1584', '2021-08-16', '01:26:23 PM', '20210816033', '01587', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '400.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1585', '2021-08-16', '01:27:37 PM', '20210816034', '01588', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '200.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1586', '2021-08-16', '01:29:28 PM', '20210816035', '01589', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '50.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1587', '2021-08-16', '01:37:24 PM', '20210816036', '01590', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1588', '2021-08-16', '01:52:43 PM', '20210816037', '01591', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '100.00', 'Flat', '450.00', '450.00', '0.00', '0.00', '450.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1589', '2021-08-16', '01:55:32 PM', '20210816038', '01592', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '400.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1590', '2021-08-16', '01:58:13 PM', '20210816039', '01593', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1591', '2021-08-16', '01:59:46 PM', '20210816040', '01594', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '200.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1592', '2021-08-16', '02:02:34 PM', '20210816041', '01595', 'diagnosis', 'diagnosis', '1800.00', '0', '0.00', '1800.00', '100.00', 'Flat', '1700.00', '1700.00', '0.00', '0.00', '1700.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1593', '2021-08-16', '02:16:29 PM', '20210816042', '01596', 'diagnosis', 'diagnosis', '2000.00', '0', '0.00', '2000.00', '400.00', 'Flat', '1600.00', '1600.00', '0.00', '0.00', '1600.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1594', '2021-08-16', '02:42:14 PM', '20210816043', '01597', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '250.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1595', '2021-08-16', '02:43:38 PM', '20210816044', '01598', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1596', '2021-08-16', '02:46:49 PM', '20210816045', '01599', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '600.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1597', '2021-08-16', '02:51:57 PM', '20210816046', '01600', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '200.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1598', '2021-08-16', '02:55:15 PM', '20210816047', '01601', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '200.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1599', '2021-08-16', '03:05:31 PM', '20210816048', '01602', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1600', '2021-08-16', '03:17:27 PM', '20210816049', '01603', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1601', '2021-08-16', '03:26:01 PM', '20210816050', '01604', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '100.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1602', '2021-08-16', '03:29:25 PM', '20210816051', '01605', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1603', '2021-08-16', '03:37:49 PM', '20210816052', '01606', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1604', '2021-08-16', '03:39:16 PM', '20210816053', '01607', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1605', '2021-08-16', '03:42:29 PM', '20210816054', '01608', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1606', '2021-08-16', '03:49:18 PM', '20210816055', '01609', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '550.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1607', '2021-08-16', '03:59:31 PM', '20210816056', '01610', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '500.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1608', '2021-08-16', '04:01:13 PM', '20210816057', '01611', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '800.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1609', '2021-08-16', '04:10:35 PM', '20210816058', '01612', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1610', '2021-08-16', '04:11:36 PM', '20210816059', '01613', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '0.00', 'Flat', '800.00', '0.00', '0.00', '800.00', '0.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1611', '2021-08-16', '04:20:32 PM', '20210816060', '01614', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1612', '2021-08-16', '04:22:44 PM', '20210816061', '01615', 'diagnosis', 'diagnosis', '750.00', '0', '0.00', '750.00', '0.00', 'Flat', '750.00', '200.00', '0.00', '550.00', '200.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1613', '2021-08-16', '04:25:27 PM', '20210816062', '01616', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '400.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '200.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1614', '2021-08-16', '04:26:45 PM', '20210816063', '01617', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '0.00', 'Flat', '800.00', '600.00', '0.00', '200.00', '600.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1615', '2021-08-16', '04:28:52 PM', '20210816064', '01618', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '0.00', 'Flat', '900.00', '0.00', '0.00', '900.00', '0.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1616', '2021-08-16', '04:49:18 PM', '20210816065', '01619', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1617', '2021-08-16', '04:54:06 PM', '20210816066', '01620', 'diagnosis', 'diagnosis', '1800.00', '0', '0.00', '1800.00', '500.00', 'Flat', '1300.00', '1000.00', '0.00', '300.00', '1000.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1618', '2021-08-16', '04:57:19 PM', '20210816067', '01621', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1619', '2021-08-16', '05:01:43 PM', '20210816068', '01622', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1620', '2021-08-16', '05:03:30 PM', '20210816069', '01623', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1621', '2021-08-16', '05:05:06 PM', '20210816070', '01624', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1622', '2021-08-16', '05:11:49 PM', '20210816071', '01625', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1623', '2021-08-16', '05:13:53 PM', '20210816072', '01626', 'diagnosis', 'diagnosis', '2000.00', '0', '0.00', '2000.00', '700.00', 'Flat', '1300.00', '1300.00', '0.00', '0.00', '1300.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1624', '2021-08-16', '05:18:36 PM', '20210816073', '01627', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '300.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1625', '2021-08-16', '05:26:43 PM', '20210816074', '01628', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1626', '2021-08-16', '05:36:06 PM', '20210816075', '01629', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1450.00', '450.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1627', '2021-08-16', '05:59:52 PM', '20210816076', '01630', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '350.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1628', '2021-08-16', '06:04:35 PM', '20210816077', '01631', 'diagnosis', 'diagnosis', '2400.00', '0', '0.00', '2400.00', '2400.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1629', '2021-08-16', '06:21:26 PM', '20210816078', '01632', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '150.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-16', 'pending', '', '15', '', 'diagnosis', '2021-08-16 08:00 PM'), 
('1630', '2021-08-17', '10:20:06 AM', '20210817001', '01633', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '200.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1631', '2021-08-17', '10:21:45 AM', '20210817002', '01634', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1632', '2021-08-17', '10:29:00 AM', '20210817003', '01635', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '100.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1633', '2021-08-17', '10:31:11 AM', '20210817004', '01636', 'diagnosis', 'diagnosis', '350.00', '0', '0.00', '350.00', '150.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1634', '2021-08-17', '10:39:52 AM', '20210817005', '01637', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '0.00', 'Flat', '550.00', '0.00', '0.00', '550.00', '0.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1635', '2021-08-17', '11:00:55 AM', '20210817006', '01638', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '300.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1636', '2021-08-17', '11:03:21 AM', '20210817007', '01639', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1637', '2021-08-17', '11:05:53 AM', '20210817008', '01640', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1638', '2021-08-17', '11:09:27 AM', '20210817009', '01641', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1639', '2021-08-17', '11:13:16 AM', '20210817010', '01642', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '100.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1640', '2021-08-17', '11:14:08 AM', '20210817011', '01643', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '0.00', 'Flat', '550.00', '0.00', '0.00', '550.00', '0.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1641', '2021-08-17', '11:17:34 AM', '20210817012', '01644', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1642', '2021-08-17', '11:21:08 AM', '20210817013', '01645', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1643', '2021-08-17', '11:23:21 AM', '20210817014', '01646', 'diagnosis', 'diagnosis', '2250.00', '0', '0.00', '2250.00', '1050.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1644', '2021-08-17', '11:25:11 AM', '20210817015', '01647', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1645', '2021-08-17', '11:26:16 AM', '20210817016', '01648', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1646', '2021-08-17', '11:31:29 AM', '20210817017', '01649', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1647', '2021-08-17', '11:35:34 AM', '20210817018', '01650', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '350.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1648', '2021-08-17', '11:39:38 AM', '20210817019', '01651', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '0.00', 'Flat', '650.00', '300.00', '0.00', '350.00', '300.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1649', '2021-08-17', '11:40:59 AM', '20210817020', '01652', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1650', '2021-08-17', '11:43:24 AM', '20210817021', '01653', 'diagnosis', 'diagnosis', '2400.00', '0', '0.00', '2400.00', '900.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1500.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1651', '2021-08-17', '11:45:51 AM', '20210817022', '01654', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1652', '2021-08-17', '11:47:36 AM', '20210817023', '01655', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1653', '2021-08-17', '11:49:18 AM', '20210817024', '01656', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '150.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1654', '2021-08-17', '11:50:28 AM', '20210817025', '01657', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1655', '2021-08-17', '11:53:33 AM', '20210817026', '01658', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1656', '2021-08-17', '11:59:30 AM', '20210817027', '01659', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1657', '2021-08-17', '12:01:30 PM', '20210817028', '01660', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '600.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1658', '2021-08-17', '12:05:37 PM', '20210817029', '01661', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1659', '2021-08-17', '12:06:39 PM', '20210817030', '01662', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1660', '2021-08-17', '12:13:04 PM', '20210817031', '01663', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '50.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1661', '2021-08-17', '12:21:23 PM', '20210817032', '01664', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1662', '2021-08-17', '12:23:57 PM', '20210817033', '01665', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '700.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1663', '2021-08-17', '12:27:14 PM', '20210817034', '01666', 'diagnosis', 'diagnosis', '1900.00', '0', '0.00', '1900.00', '300.00', 'Flat', '1600.00', '1600.00', '0.00', '0.00', '1600.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1664', '2021-08-17', '12:30:07 PM', '20210817035', '01667', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '550.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1665', '2021-08-17', '12:40:11 PM', '20210817036', '01668', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '200.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1666', '2021-08-17', '12:42:33 PM', '20210817037', '01669', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '400.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1667', '2021-08-17', '01:10:47 PM', '20210817038', '01670', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1668', '2021-08-17', '01:13:30 PM', '20210817039', '01671', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '350.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1669', '2021-08-17', '01:46:44 PM', '20210817040', '01672', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '350.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1670', '2021-08-17', '01:58:32 PM', '20210817041', '01673', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1671', '2021-08-17', '02:02:24 PM', '20210817042', '01674', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '400.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1672', '2021-08-17', '02:04:26 PM', '20210817043', '01675', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1673', '2021-08-17', '02:05:34 PM', '20210817044', '01676', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '200.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1674', '2021-08-17', '02:24:22 PM', '20210817045', '01677', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '600.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1675', '2021-08-17', '02:37:58 PM', '20210817046', '01678', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '200.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1676', '2021-08-17', '02:42:07 PM', '20210817047', '01679', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '200.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1677', '2021-08-17', '02:46:24 PM', '20210817048', '01680', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '50.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1678', '2021-08-17', '02:47:43 PM', '20210817049', '01681', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '500.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1679', '2021-08-17', '02:50:30 PM', '20210817050', '01682', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '550.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1680', '2021-08-17', '02:52:03 PM', '20210817051', '01683', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1681', '2021-08-17', '02:57:55 PM', '20210817052', '01684', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '0.00', '0.00', '400.00', '0.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1682', '2021-08-17', '03:15:19 PM', '20210817053', '01685', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1683', '2021-08-17', '03:21:17 PM', '20210817054', '01686', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '200.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1684', '2021-08-17', '03:34:59 PM', '20210817055', '01687', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1685', '2021-08-17', '03:42:33 PM', '20210817056', '01688', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1686', '2021-08-17', '03:47:45 PM', '20210817057', '01689', 'diagnosis', 'diagnosis', '2000.00', '0', '0.00', '2000.00', '0.00', 'Flat', '2000.00', '1000.00', '0.00', '1000.00', '1000.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1687', '2021-08-17', '03:49:19 PM', '20210817058', '01690', 'diagnosis', 'diagnosis', '2900.00', '0', '0.00', '2900.00', '0.00', 'Flat', '2900.00', '1000.00', '0.00', '1900.00', '1000.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1688', '2021-08-17', '03:51:31 PM', '20210817059', '01691', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '0.00', 'Flat', '550.00', '0.00', '0.00', '550.00', '0.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1689', '2021-08-17', '03:53:04 PM', '20210817060', '01692', 'diagnosis', 'diagnosis', '1650.00', '0', '0.00', '1650.00', '0.00', 'Flat', '1650.00', '1000.00', '0.00', '650.00', '1000.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1690', '2021-08-17', '03:54:08 PM', '20210817061', '01693', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1450.00', '450.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1691', '2021-08-17', '03:55:46 PM', '20210817062', '01694', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1692', '2021-08-17', '03:58:16 PM', '20210817063', '01695', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '150.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1693', '2021-08-17', '04:06:27 PM', '20210817064', '01696', 'diagnosis', 'diagnosis', '2400.00', '0', '0.00', '2400.00', '0.00', 'Flat', '2400.00', '500.00', '0.00', '1900.00', '500.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1694', '2021-08-17', '04:14:21 PM', '20210817065', '01697', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '300.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1695', '2021-08-17', '04:20:01 PM', '20210817066', '01698', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1696', '2021-08-17', '04:24:01 PM', '20210817067', '01699', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '150.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1697', '2021-08-17', '04:25:10 PM', '20210817068', '01700', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1698', '2021-08-17', '04:26:49 PM', '20210817069', '01701', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1699', '2021-08-17', '04:30:16 PM', '20210817070', '01702', 'diagnosis', 'diagnosis', '2500.00', '0', '0.00', '2500.00', '0.00', 'Flat', '2500.00', '1000.00', '0.00', '1500.00', '1000.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1700', '2021-08-17', '04:32:56 PM', '20210817071', '01703', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1701', '2021-08-17', '04:34:18 PM', '20210817072', '01704', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1702', '2021-08-17', '04:37:39 PM', '20210817073', '01705', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '530.00', 'Flat', '120.00', '120.00', '0.00', '0.00', '120.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1703', '2021-08-17', '04:38:09 PM', '20210817074', '01706', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '0.00', 'Flat', '950.00', '0.00', '0.00', '950.00', '0.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1704', '2021-08-17', '04:39:29 PM', '20210817075', '01707', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1705', '2021-08-17', '04:41:49 PM', '20210817076', '01708', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1706', '2021-08-17', '04:43:57 PM', '20210817077', '01709', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1707', '2021-08-17', '04:57:54 PM', '20210817078', '01710', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1708', '2021-08-17', '05:00:06 PM', '20210817079', '01711', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1709', '2021-08-17', '05:08:48 PM', '20210817080', '01712', 'diagnosis', 'diagnosis', '1850.00', '0', '0.00', '1850.00', '0.00', 'Flat', '1850.00', '0.00', '0.00', '1850.00', '0.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1710', '2021-08-17', '05:09:27 PM', '20210817081', '01713', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1711', '2021-08-17', '05:12:23 PM', '20210817082', '01714', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1712', '2021-08-17', '05:53:23 PM', '20210817083', '01715', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1713', '2021-08-17', '06:10:15 PM', '20210817084', '01716', 'diagnosis', 'diagnosis', '200.00', '0', '0.00', '200.00', '100.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1714', '2021-08-17', '06:23:03 PM', '20210817085', '01717', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1715', '2021-08-17', '06:30:12 PM', '20210817086', '01718', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1716', '2021-08-17', '06:30:57 PM', '20210817087', '01719', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1717', '2021-08-17', '06:32:14 PM', '20210817088', '01720', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1718', '2021-08-17', '06:39:48 PM', '20210817089', '01721', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1719', '2021-08-17', '06:52:15 PM', '20210817090', '01722', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1720', '2021-08-17', '06:53:21 PM', '20210817091', '01723', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1721', '2021-08-17', '07:01:09 PM', '20210817092', '01724', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1722', '2021-08-17', '07:22:26 PM', '20210817093', '01725', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1723', '2021-08-17', '07:49:52 PM', '20210817094', '01726', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1724', '2021-08-17', '07:55:38 PM', '20210817095', '01727', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-08-17', 'pending', '', '15', '', 'diagnosis', '2021-08-17 08:00 PM'), 
('1725', '2021-08-18', '09:52:03 AM', '20210818001', '01728', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1726', '2021-08-18', '09:53:00 AM', '20210818002', '01729', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1727', '2021-08-18', '09:57:16 AM', '20210818003', '01730', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1728', '2021-08-18', '10:18:57 AM', '20210818004', '01731', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1729', '2021-08-18', '10:25:55 AM', '20210818005', '01732', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '100.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1730', '2021-08-18', '10:57:22 AM', '20210818006', '01733', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1731', '2021-08-18', '11:02:49 AM', '20210818007', '01734', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1732', '2021-08-18', '11:10:19 AM', '20210818008', '01735', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1733', '2021-08-18', '11:16:19 AM', '20210818009', '01736', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1734', '2021-08-18', '11:25:42 AM', '20210818010', '01737', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1735', '2021-08-18', '11:36:31 AM', '20210818011', '01738', 'diagnosis', 'diagnosis', '1600.00', '0', '0.00', '1600.00', '800.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1736', '2021-08-18', '11:42:03 AM', '20210818012', '01739', 'diagnosis', 'diagnosis', '1800.00', '0', '0.00', '1800.00', '500.00', 'Flat', '1300.00', '1300.00', '0.00', '0.00', '1300.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1737', '2021-08-18', '11:44:54 AM', '20210818013', '01740', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1738', '2021-08-18', '11:46:44 AM', '20210818014', '01741', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '450.00', 'Flat', '900.00', '500.00', '0.00', '400.00', '500.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1739', '2021-08-18', '11:49:46 AM', '20210818015', '01742', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '650.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1740', '2021-08-18', '12:13:26 PM', '20210818016', '01743', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1741', '2021-08-18', '12:22:16 PM', '20210818017', '01744', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1742', '2021-08-18', '12:24:22 PM', '20210818018', '01745', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '250.00', 'Flat', '1100.00', '1100.00', '0.00', '0.00', '1100.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1743', '2021-08-18', '12:33:25 PM', '20210818019', '01746', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1744', '2021-08-18', '12:54:59 PM', '20210818020', '01747', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '500.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1745', '2021-08-18', '12:56:17 PM', '20210818021', '01748', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1746', '2021-08-18', '01:04:34 PM', '20210818022', '01749', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1747', '2021-08-18', '01:30:52 PM', '20210818023', '01750', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '0.00', 'Flat', '950.00', '500.00', '0.00', '450.00', '500.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1748', '2021-08-18', '02:05:38 PM', '20210818024', '01751', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1749', '2021-08-18', '02:10:05 PM', '20210818025', '01752', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1750', '2021-08-18', '02:28:00 PM', '20210818026', '01753', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1751', '2021-08-18', '02:32:30 PM', '20210818027', '01754', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1752', '2021-08-18', '02:49:06 PM', '20210818028', '01755', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1753', '2021-08-18', '02:53:44 PM', '20210818029', '01756', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '600.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1754', '2021-08-18', '02:55:33 PM', '20210818030', '01757', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1755', '2021-08-18', '03:07:04 PM', '20210818031', '01758', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1756', '2021-08-18', '03:10:17 PM', '20210818032', '01759', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1757', '2021-08-18', '03:28:55 PM', '20210818033', '01760', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1758', '2021-08-18', '03:31:58 PM', '20210818034', '01761', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '50.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1759', '2021-08-18', '03:57:50 PM', '20210818035', '01762', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1760', '2021-08-18', '04:03:30 PM', '20210818036', '01763', 'diagnosis', 'diagnosis', '2050.00', '0', '0.00', '2050.00', '550.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1500.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1761', '2021-08-18', '04:04:24 PM', '20210818037', '01764', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1762', '2021-08-18', '04:11:26 PM', '20210818038', '01765', 'diagnosis', 'diagnosis', '1100.00', '0', '0.00', '1100.00', '500.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1763', '2021-08-18', '04:20:12 PM', '20210818039', '01766', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '150.00', 'Flat', '150.00', '150.00', '0.00', '0.00', '150.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1764', '2021-08-18', '04:21:45 PM', '20210818040', '01767', 'diagnosis', 'diagnosis', '1750.00', '0', '0.00', '1750.00', '450.00', 'Flat', '1300.00', '1000.00', '0.00', '300.00', '1000.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1765', '2021-08-18', '04:23:58 PM', '20210818041', '01768', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1450.00', '0.00', 'Flat', '1450.00', '0.00', '0.00', '1450.00', '0.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1766', '2021-08-18', '04:31:16 PM', '20210818042', '01769', 'diagnosis', 'diagnosis', '2600.00', '0', '0.00', '2600.00', '0.00', 'Flat', '2600.00', '1500.00', '0.00', '1100.00', '1500.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1767', '2021-08-18', '04:32:54 PM', '20210818043', '01770', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '450.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1768', '2021-08-18', '04:34:37 PM', '20210818044', '01771', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '0.00', 'Flat', '300.00', '0.00', '0.00', '300.00', '0.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1769', '2021-08-18', '04:37:03 PM', '20210818045', '01772', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '250.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1770', '2021-08-18', '04:39:19 PM', '20210818046', '01773', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '200.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1771', '2021-08-18', '04:40:54 PM', '20210818047', '01774', 'diagnosis', 'diagnosis', '350.00', '0', '0.00', '350.00', '0.00', 'Flat', '350.00', '0.00', '0.00', '350.00', '0.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1772', '2021-08-18', '04:48:47 PM', '20210818048', '01775', 'diagnosis', 'diagnosis', '2000.00', '0', '0.00', '2000.00', '300.00', 'Flat', '1700.00', '1700.00', '0.00', '0.00', '1700.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1773', '2021-08-18', '04:50:17 PM', '20210818049', '01776', 'diagnosis', 'diagnosis', '3200.00', '0', '0.00', '3200.00', '1700.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1500.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1774', '2021-08-18', '04:52:12 PM', '20210818050', '01777', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1775', '2021-08-18', '04:56:37 PM', '20210818051', '01778', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '250.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1776', '2021-08-18', '05:02:39 PM', '20210818052', '01779', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1777', '2021-08-18', '05:07:53 PM', '20210818053', '01780', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '200.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1778', '2021-08-18', '05:21:42 PM', '20210818054', '01781', 'diagnosis', 'diagnosis', '2700.00', '0', '0.00', '2700.00', '1100.00', 'Flat', '1600.00', '1600.00', '0.00', '0.00', '1600.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1779', '2021-08-18', '05:25:19 PM', '20210818055', '01782', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '1200.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1780', '2021-08-18', '05:29:06 PM', '20210818056', '01783', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1781', '2021-08-18', '05:39:17 PM', '20210818057', '01784', 'diagnosis', 'diagnosis', '2000.00', '0', '0.00', '2000.00', '0.00', 'Flat', '2000.00', '0.00', '0.00', '2000.00', '0.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1782', '2021-08-18', '05:41:01 PM', '20210818058', '01785', 'diagnosis', 'diagnosis', '2400.00', '0', '0.00', '2400.00', '2400.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1783', '2021-08-18', '05:47:50 PM', '20210818059', '01786', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1784', '2021-08-18', '05:48:32 PM', '20210818060', '01787', 'diagnosis', 'diagnosis', '2750.00', '0', '0.00', '2750.00', '1250.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1500.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1785', '2021-08-18', '05:53:49 PM', '20210818061', '01788', 'diagnosis', 'diagnosis', '1750.00', '0', '0.00', '1750.00', '450.00', 'Flat', '1300.00', '1000.00', '0.00', '300.00', '1000.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1786', '2021-08-18', '06:06:29 PM', '20210818062', '01789', 'diagnosis', 'diagnosis', '500.00', '0', '0.00', '500.00', '200.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1787', '2021-08-18', '06:09:27 PM', '20210818063', '01790', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '600.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1788', '2021-08-18', '06:14:45 PM', '20210818064', '01791', 'diagnosis', 'diagnosis', '200.00', '0', '0.00', '200.00', '150.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1789', '2021-08-18', '06:18:05 PM', '20210818065', '01792', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '350.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1790', '2021-08-18', '06:22:25 PM', '20210818066', '01793', 'diagnosis', 'diagnosis', '1950.00', '0', '0.00', '1950.00', '450.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1500.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1791', '2021-08-18', '06:23:48 PM', '20210818067', '01794', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1792', '2021-08-18', '06:25:16 PM', '20210818068', '01795', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1793', '2021-08-18', '06:52:53 PM', '20210818069', '01796', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1794', '2021-08-18', '07:26:27 PM', '20210818070', '01797', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '100.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-08-18', 'pending', '', '15', '', 'diagnosis', '2021-08-18 08:00 PM'), 
('1795', '2021-08-19', '10:15:20 AM', '20210819001', '01798', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '80.00', 'Flat', '70.00', '70.00', '0.00', '0.00', '70.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1796', '2021-08-19', '10:47:47 AM', '20210819002', '01799', 'diagnosis', 'diagnosis', '450.00', '0', '0.00', '450.00', '250.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1797', '2021-08-19', '11:01:29 AM', '20210819003', '01800', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1798', '2021-08-19', '11:09:56 AM', '20210819004', '01801', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '250.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1799', '2021-08-19', '11:16:16 AM', '20210819005', '01802', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1800', '2021-08-19', '11:19:36 AM', '20210819006', '01803', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '170.00', 'Flat', '380.00', '380.00', '0.00', '0.00', '380.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1801', '2021-08-19', '11:21:15 AM', '20210819007', '01804', 'diagnosis', 'diagnosis', '750.00', '0', '0.00', '750.00', '350.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1802', '2021-08-19', '11:23:23 AM', '20210819008', '01805', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '350.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1803', '2021-08-19', '11:44:10 AM', '20210819009', '01806', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1804', '2021-08-19', '11:46:55 AM', '20210819010', '01807', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1805', '2021-08-19', '11:54:40 AM', '20210819011', '01808', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '250.00', 'Flat', '1100.00', '1100.00', '0.00', '0.00', '1100.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1806', '2021-08-19', '11:57:19 AM', '20210819012', '01809', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '300.00', 'Flat', '750.00', '750.00', '0.00', '0.00', '750.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1807', '2021-08-19', '12:00:25 PM', '20210819013', '01810', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '450.00', 'Flat', '450.00', '450.00', '0.00', '0.00', '450.00', '2021-08-19', 'pending', '', '15', 'Sakawat Hosen ', 'diagnosis', '2021-08-19 08:00 PM'), 
('1808', '2021-08-19', '12:02:22 PM', '20210819014', '01811', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '0.00', 'Flat', '650.00', '0.00', '0.00', '650.00', '0.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1809', '2021-08-19', '12:03:45 PM', '20210819015', '01812', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '0.00', 'Flat', '1350.00', '500.00', '0.00', '850.00', '500.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1810', '2021-08-19', '12:06:29 PM', '20210819016', '01813', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1811', '2021-08-19', '12:08:00 PM', '20210819017', '01814', 'diagnosis', 'diagnosis', '350.00', '0', '0.00', '350.00', '200.00', 'Flat', '150.00', '150.00', '0.00', '0.00', '150.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1812', '2021-08-19', '12:10:14 PM', '20210819018', '01815', 'diagnosis', 'diagnosis', '1950.00', '0', '0.00', '1950.00', '650.00', 'Flat', '1300.00', '1300.00', '0.00', '0.00', '1300.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1813', '2021-08-19', '12:12:02 PM', '20210819019', '01816', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '450.00', 'Flat', '750.00', '750.00', '0.00', '0.00', '750.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1814', '2021-08-19', '12:14:28 PM', '20210819020', '01817', 'diagnosis', 'diagnosis', '450.00', '0', '0.00', '450.00', '450.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1815', '2021-08-19', '12:51:18 PM', '20210819021', '01818', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1816', '2021-08-19', '12:58:39 PM', '20210819022', '01819', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1817', '2021-08-19', '01:03:22 PM', '20210819023', '01820', 'diagnosis', 'diagnosis', '0.00', '0', '0.00', '0.00', '0.00', '0', '0.00', '0.00', '0.00', '0.00', '0.00', '0000-00-00', 'pending', '', '15', '0', 'diagnosis', '0'), 
('1818', '2021-08-19', '01:07:28 PM', '20210819024', '01821', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1819', '2021-08-19', '01:09:45 PM', '20210819025', '01822', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '550.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1820', '2021-08-19', '01:19:05 PM', '20210819026', '01823', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '300.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1821', '2021-08-19', '01:23:25 PM', '20210819027', '01824', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1822', '2021-08-19', '02:24:22 PM', '20210819028', '01825', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1823', '2021-08-19', '02:26:11 PM', '20210819029', '01826', 'diagnosis', 'diagnosis', '1750.00', '0', '0.00', '1750.00', '950.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '200.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1824', '2021-08-19', '03:02:21 PM', '20210819030', '01827', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1825', '2021-08-19', '03:43:16 PM', '20210819031', '01828', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1826', '2021-08-19', '03:58:19 PM', '20210819032', '01829', 'diagnosis', 'diagnosis', '1900.00', '0', '0.00', '1900.00', '300.00', 'Flat', '1600.00', '1600.00', '0.00', '0.00', '1600.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1827', '2021-08-19', '03:58:44 PM', '20210819033', '01830', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '30.00', 'Percentage', '1050.00', '500.00', '0.00', '550.00', '500.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1828', '2021-08-19', '04:01:56 PM', '20210819034', '01831', 'diagnosis', 'diagnosis', '1250.00', '0', '0.00', '1250.00', '50.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1829', '2021-08-19', '04:03:01 PM', '20210819035', '01832', 'diagnosis', 'diagnosis', '1150.00', '0', '0.00', '1150.00', '650.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1830', '2021-08-19', '04:05:25 PM', '20210819036', '01833', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1831', '2021-08-19', '04:06:34 PM', '20210819037', '01834', 'diagnosis', 'diagnosis', '1400.00', '0', '0.00', '1400.00', '200.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1832', '2021-08-19', '04:16:19 PM', '20210819038', '01835', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '400.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1833', '2021-08-19', '04:17:33 PM', '20210819039', '01836', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '0.00', 'Flat', '550.00', '400.00', '0.00', '150.00', '400.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1834', '2021-08-19', '04:24:59 PM', '20210819040', '01837', 'diagnosis', 'diagnosis', '2000.00', '0', '0.00', '2000.00', '0.00', 'Flat', '2000.00', '1000.00', '0.00', '1000.00', '1000.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1835', '2021-08-19', '04:29:20 PM', '20210819041', '01838', 'diagnosis', 'diagnosis', '2150.00', '0', '0.00', '2150.00', '0.00', 'Flat', '2150.00', '300.00', '0.00', '1850.00', '300.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1836', '2021-08-19', '04:31:41 PM', '20210819042', '01839', 'diagnosis', 'diagnosis', '350.00', '0', '0.00', '350.00', '30.00', 'Percentage', '245.00', '240.00', '0.00', '5.00', '240.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1837', '2021-08-19', '04:39:35 PM', '20210819043', '01840', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1838', '2021-08-19', '04:43:14 PM', '20210819044', '01841', 'diagnosis', 'diagnosis', '1850.00', '0', '0.00', '1850.00', '350.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1500.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1839', '2021-08-19', '04:44:16 PM', '20210819045', '01842', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1840', '2021-08-19', '04:50:06 PM', '20210819046', '01843', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '700.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1841', '2021-08-19', '04:59:05 PM', '20210819047', '01844', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '450.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1842', '2021-08-19', '05:03:46 PM', '20210819048', '01845', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1843', '2021-08-19', '05:07:18 PM', '20210819049', '01846', 'diagnosis', 'diagnosis', '600.00', '0', '0.00', '600.00', '50.00', 'Flat', '550.00', '550.00', '0.00', '0.00', '550.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1844', '2021-08-19', '05:08:35 PM', '20210819050', '01847', 'diagnosis', 'diagnosis', '1650.00', '0', '0.00', '1650.00', '0.00', 'Flat', '1650.00', '0.00', '0.00', '1650.00', '0.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1845', '2021-08-19', '05:11:44 PM', '20210819051', '01848', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1846', '2021-08-19', '05:26:05 PM', '20210819052', '01849', 'diagnosis', 'diagnosis', '2500.00', '0', '0.00', '2300.00', '0.00', 'Flat', '2500.00', '0.00', '200.00', '2500.00', '0.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1847', '2021-08-19', '05:35:01 PM', '20210819053', '01850', 'diagnosis', 'diagnosis', '2300.00', '0', '0.00', '2300.00', '500.00', 'Flat', '1800.00', '1200.00', '0.00', '600.00', '1200.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1848', '2021-08-19', '05:40:19 PM', '20210819054', '01851', 'diagnosis', 'diagnosis', '1400.00', '0', '0.00', '1400.00', '400.00', 'Flat', '1000.00', '800.00', '0.00', '200.00', '800.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1849', '2021-08-19', '05:44:26 PM', '20210819055', '01852', 'diagnosis', 'diagnosis', '2150.00', '0', '0.00', '2150.00', '550.00', 'Flat', '1600.00', '1600.00', '0.00', '0.00', '1600.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1850', '2021-08-19', '05:47:55 PM', '20210819056', '01853', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '0.00', '0.00', '50.00', '0.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1851', '2021-08-19', '06:14:54 PM', '20210819057', '01854', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '250.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1852', '2021-08-19', '06:23:45 PM', '20210819058', '01855', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1853', '2021-08-19', '06:44:58 PM', '20210819059', '01856', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '150.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1854', '2021-08-19', '06:47:30 PM', '20210819060', '01857', 'diagnosis', 'diagnosis', '1150.00', '0', '0.00', '1150.00', '350.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1855', '2021-08-19', '06:48:50 PM', '20210819061', '01858', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '0.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1500.00', '2021-08-19', 'pending', '', '15', '', 'diagnosis', '2021-08-19 08:00 PM'), 
('1856', '2021-08-20', '10:03:05 AM', '20210820001', '01859', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1857', '2021-08-20', '10:04:10 AM', '20210820002', '01860', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1858', '2021-08-20', '10:16:28 AM', '20210820003', '01861', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1859', '2021-08-20', '10:44:11 AM', '20210820004', '01862', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1860', '2021-08-20', '10:58:35 AM', '20210820005', '01863', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1861', '2021-08-20', '11:12:50 AM', '20210820006', '01864', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '0.00', 'Flat', '1500.00', '500.00', '0.00', '1000.00', '500.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1862', '2021-08-20', '11:17:15 AM', '20210820007', '01865', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '200.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1863', '2021-08-20', '11:19:02 AM', '20210820008', '01866', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '0.00', 'Flat', '650.00', '400.00', '0.00', '250.00', '400.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1864', '2021-08-20', '11:26:03 AM', '20210820009', '01867', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '150.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1865', '2021-08-20', '11:30:21 AM', '20210820010', '01868', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1866', '2021-08-20', '11:32:45 AM', '20210820011', '01869', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1867', '2021-08-20', '11:34:05 AM', '20210820012', '01870', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1868', '2021-08-20', '11:40:21 AM', '20210820013', '01871', 'diagnosis', 'diagnosis', '3000.00', '0', '0.00', '3000.00', '0.00', 'Flat', '3000.00', '2000.00', '0.00', '1000.00', '2000.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1869', '2021-08-20', '11:45:04 AM', '20210820014', '01872', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '100.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1870', '2021-08-20', '11:48:18 AM', '20210820015', '01873', 'diagnosis', 'diagnosis', '2650.00', '0', '0.00', '2650.00', '850.00', 'Flat', '1800.00', '1800.00', '0.00', '0.00', '1800.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1871', '2021-08-20', '11:51:44 AM', '20210820016', '01874', 'diagnosis', 'diagnosis', '1600.00', '0', '0.00', '1600.00', '0.00', 'Flat', '1600.00', '500.00', '0.00', '1100.00', '500.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1872', '2021-08-20', '11:53:03 AM', '20210820017', '01875', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '0.00', 'Flat', '950.00', '0.00', '0.00', '950.00', '0.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1873', '2021-08-20', '11:54:17 AM', '20210820018', '01876', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1874', '2021-08-20', '11:56:49 AM', '20210820019', '01877', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '400.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1875', '2021-08-20', '11:58:04 AM', '20210820020', '01878', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1876', '2021-08-20', '12:00:34 PM', '20210820021', '01879', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1877', '2021-08-20', '12:05:35 PM', '20210820022', '01880', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '700.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1878', '2021-08-20', '12:06:40 PM', '20210820023', '01881', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1879', '2021-08-20', '12:09:33 PM', '20210820024', '01882', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '300.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1880', '2021-08-20', '12:14:13 PM', '20210820025', '01883', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '350.00', 'Flat', '450.00', '450.00', '0.00', '0.00', '450.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1881', '2021-08-20', '12:16:21 PM', '20210820026', '01884', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '0.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1882', '2021-08-20', '12:22:51 PM', '20210820027', '01885', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '400.00', 'Flat', '800.00', '500.00', '0.00', '300.00', '500.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1883', '2021-08-20', '12:26:34 PM', '20210820028', '01886', 'diagnosis', 'diagnosis', '4150.00', '0', '0.00', '4150.00', '1150.00', 'Flat', '3000.00', '1000.00', '0.00', '2000.00', '1000.00', '2021-08-20', 'pending', '', '15', 'Sultan Ahamed', 'diagnosis', '2021-08-20 08:00 PM'), 
('1884', '2021-08-20', '12:32:44 PM', '20210820029', '01887', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '200.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1885', '2021-08-20', '12:35:56 PM', '20210820030', '01888', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1886', '2021-08-20', '12:36:36 PM', '20210820031', '01889', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '350.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1887', '2021-08-20', '12:40:13 PM', '20210820032', '01890', 'diagnosis', 'diagnosis', '2900.00', '0', '0.00', '2900.00', '900.00', 'Flat', '2000.00', '2000.00', '0.00', '0.00', '2000.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1888', '2021-08-20', '12:42:04 PM', '20210820033', '01891', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '200.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1889', '2021-08-20', '12:43:55 PM', '20210820034', '01892', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '0.00', 'Flat', '900.00', '500.00', '0.00', '400.00', '500.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1890', '2021-08-20', '12:51:11 PM', '20210820035', '01893', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '200.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1891', '2021-08-20', '12:55:48 PM', '20210820036', '01894', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '300.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1892', '2021-08-20', '01:01:46 PM', '20210820037', '01895', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '0.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1893', '2021-08-20', '01:07:15 PM', '20210820038', '01896', 'diagnosis', 'diagnosis', '2250.00', '0', '0.00', '2250.00', '450.00', 'Flat', '1800.00', '1800.00', '0.00', '0.00', '1800.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1894', '2021-08-20', '01:09:07 PM', '20210820039', '01897', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '450.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1895', '2021-08-20', '01:10:30 PM', '20210820040', '01898', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '200.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1896', '2021-08-20', '01:12:28 PM', '20210820041', '01899', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1897', '2021-08-20', '01:14:44 PM', '20210820042', '01900', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '0.00', 'Flat', '900.00', '500.00', '0.00', '400.00', '500.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1898', '2021-08-20', '01:23:55 PM', '20210820043', '01901', 'diagnosis', 'diagnosis', '1650.00', '0', '0.00', '1650.00', '150.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1500.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1899', '2021-08-20', '01:25:11 PM', '20210820044', '01902', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '200.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1900', '2021-08-20', '01:29:30 PM', '20210820045', '01903', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '0.00', 'Flat', '900.00', '200.00', '0.00', '700.00', '200.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1901', '2021-08-20', '01:34:00 PM', '20210820046', '01904', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '300.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1902', '2021-08-20', '01:41:36 PM', '20210820047', '01905', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '100.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1903', '2021-08-20', '01:47:37 PM', '20210820048', '01906', 'diagnosis', 'diagnosis', '1750.00', '0', '0.00', '1750.00', '350.00', 'Flat', '1400.00', '1400.00', '0.00', '0.00', '1400.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1904', '2021-08-20', '01:51:13 PM', '20210820049', '01907', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '200.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1905', '2021-08-20', '01:54:44 PM', '20210820050', '01908', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '100.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1906', '2021-08-20', '01:59:15 PM', '20210820051', '01909', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '50.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1907', '2021-08-20', '02:00:50 PM', '20210820052', '01910', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1908', '2021-08-20', '02:03:06 PM', '20210820053', '01911', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '0.00', 'Flat', '1050.00', '500.00', '0.00', '550.00', '500.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1909', '2021-08-20', '02:11:22 PM', '20210820054', '01912', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '50.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1910', '2021-08-20', '02:20:29 PM', '20210820055', '01913', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '200.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1911', '2021-08-20', '02:31:59 PM', '20210820056', '01914', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '300.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1912', '2021-08-20', '02:34:14 PM', '20210820057', '01915', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '0.00', 'Flat', '1300.00', '0.00', '0.00', '1300.00', '0.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1913', '2021-08-20', '02:35:56 PM', '20210820058', '01916', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1914', '2021-08-20', '02:44:23 PM', '20210820059', '01917', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1915', '2021-08-20', '02:47:47 PM', '20210820060', '01918', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '150.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1916', '2021-08-20', '03:02:18 PM', '20210820061', '01919', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '0.00', 'Flat', '1350.00', '1350.00', '0.00', '0.00', '1350.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1917', '2021-08-20', '03:03:14 PM', '20210820062', '01920', 'diagnosis', 'diagnosis', '450.00', '0', '0.00', '450.00', '200.00', 'Flat', '250.00', '200.00', '0.00', '50.00', '200.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1918', '2021-08-20', '03:15:53 PM', '20210820063', '01921', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '550.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1919', '2021-08-20', '03:22:05 PM', '20210820064', '01922', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '150.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1920', '2021-08-20', '03:40:20 PM', '20210820065', '01923', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '0.00', 'Flat', '950.00', '0.00', '0.00', '950.00', '0.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1921', '2021-08-20', '03:42:06 PM', '20210820066', '01924', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1922', '2021-08-20', '03:43:47 PM', '20210820067', '01925', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '850.00', '0.00', 'Flat', '900.00', '900.00', '50.00', '0.00', '900.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1923', '2021-08-20', '03:49:26 PM', '20210820068', '01926', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '0.00', '0.00', '400.00', '0.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1924', '2021-08-20', '03:54:41 PM', '20210820069', '01927', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '0.00', 'Flat', '900.00', '200.00', '0.00', '700.00', '200.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1925', '2021-08-20', '03:58:30 PM', '20210820070', '01928', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1450.00', '0.00', 'Flat', '1450.00', '400.00', '0.00', '1050.00', '400.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1926', '2021-08-20', '04:12:13 PM', '20210820071', '01929', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1927', '2021-08-20', '04:13:34 PM', '20210820072', '01930', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1928', '2021-08-20', '04:15:31 PM', '20210820073', '01931', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1929', '2021-08-20', '04:16:27 PM', '20210820074', '01932', 'diagnosis', 'diagnosis', '450.00', '0', '0.00', '450.00', '0.00', 'Flat', '450.00', '0.00', '0.00', '450.00', '0.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1930', '2021-08-20', '04:24:14 PM', '20210820075', '01933', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '50.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1931', '2021-08-20', '04:41:18 PM', '20210820076', '01934', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1932', '2021-08-20', '04:45:22 PM', '20210820077', '01935', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1933', '2021-08-20', '04:49:19 PM', '20210820078', '01936', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1934', '2021-08-20', '04:51:48 PM', '20210820079', '01937', 'diagnosis', 'diagnosis', '1600.00', '0', '0.00', '1600.00', '600.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1935', '2021-08-20', '04:53:41 PM', '20210820080', '01938', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '250.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1936', '2021-08-20', '04:53:50 PM', '20210820081', '01939', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '300.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1937', '2021-08-20', '04:55:58 PM', '20210820082', '01940', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '0.00', 'Flat', '800.00', '500.00', '0.00', '300.00', '500.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1938', '2021-08-20', '05:08:24 PM', '20210820083', '01941', 'diagnosis', 'diagnosis', '500.00', '0', '0.00', '500.00', '200.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1939', '2021-08-20', '05:17:27 PM', '20210820084', '01942', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '300.00', 'Flat', '600.00', '500.00', '0.00', '100.00', '500.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1940', '2021-08-20', '05:23:36 PM', '20210820085', '01943', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '400.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1941', '2021-08-20', '05:36:52 PM', '20210820086', '01944', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '500.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1942', '2021-08-20', '05:41:58 PM', '20210820087', '01945', 'diagnosis', 'diagnosis', '1900.00', '0', '0.00', '1900.00', '700.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1943', '2021-08-20', '05:51:07 PM', '20210820088', '01946', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '30.00', 'Percentage', '630.00', '630.00', '0.00', '0.00', '630.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1944', '2021-08-20', '06:03:12 PM', '20210820089', '01947', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '0.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1945', '2021-08-20', '06:07:21 PM', '20210820090', '01948', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '0.00', 'Flat', '550.00', '250.00', '0.00', '300.00', '250.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1946', '2021-08-20', '06:34:04 PM', '20210820091', '01949', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '0.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-20', 'pending', '', '15', '', 'diagnosis', '2021-08-20 08:00 PM'), 
('1947', '2021-08-21', '10:08:20 AM', '20210821001', '01950', 'diagnosis', 'diagnosis', '2250.00', '0', '0.00', '2250.00', '0.00', 'Flat', '2250.00', '1000.00', '0.00', '1250.00', '1000.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('1948', '2021-08-21', '10:11:53 AM', '20210821002', '01951', 'diagnosis', 'diagnosis', '350.00', '0', '0.00', '350.00', '0.00', 'Flat', '350.00', '0.00', '0.00', '350.00', '0.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('1949', '2021-08-21', '10:18:00 AM', '20210821003', '01952', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('1950', '2021-08-21', '10:19:31 AM', '20210821004', '01953', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('1951', '2021-08-21', '10:21:12 AM', '20210821005', '01954', 'diagnosis', 'diagnosis', '600.00', '0', '0.00', '600.00', '400.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('1952', '2021-08-21', '10:23:49 AM', '20210821006', '01955', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('1953', '2021-08-21', '10:26:45 AM', '20210821007', '01956', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('1954', '2021-08-21', '10:45:32 AM', '20210821008', '01957', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('1955', '2021-08-21', '10:47:25 AM', '20210821009', '01958', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('1956', '2021-08-21', '10:49:28 AM', '20210821010', '01959', 'diagnosis', 'diagnosis', '350.00', '0', '0.00', '350.00', '200.00', 'Flat', '150.00', '150.00', '0.00', '0.00', '150.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('1957', '2021-08-21', '10:51:17 AM', '20210821011', '01960', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '200.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('1958', '2021-08-21', '11:21:48 AM', '20210821012', '01961', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('1959', '2021-08-21', '11:24:16 AM', '20210821013', '01962', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '200.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('1960', '2021-08-21', '11:31:20 AM', '20210821014', '01963', 'diagnosis', 'diagnosis', '1550.00', '0', '0.00', '1550.00', '350.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('1961', '2021-08-21', '11:32:08 AM', '20210821015', '01964', 'diagnosis', 'diagnosis', '2250.00', '0', '0.00', '2250.00', '450.00', 'Flat', '1800.00', '1800.00', '0.00', '0.00', '1800.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('1962', '2021-08-21', '11:34:34 AM', '20210821016', '01965', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('1963', '2021-08-21', '11:36:33 AM', '20210821017', '01966', 'diagnosis', 'diagnosis', '1250.00', '0', '0.00', '1250.00', '0.00', 'Flat', '1250.00', '0.00', '0.00', '1250.00', '0.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('1964', '2021-08-21', '11:38:04 AM', '20210821018', '01967', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('1965', '2021-08-21', '11:42:17 AM', '20210821019', '01968', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '0.00', 'Flat', '1350.00', '0.00', '0.00', '1350.00', '0.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('1966', '2021-08-21', '11:55:50 AM', '20210821020', '01969', 'diagnosis', 'diagnosis', '450.00', '0', '0.00', '450.00', '0.00', 'Flat', '450.00', '0.00', '0.00', '450.00', '0.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('1967', '2021-08-21', '11:58:55 AM', '20210821021', '01970', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('1968', '2021-08-21', '12:01:52 PM', '20210821022', '01971', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('1969', '2021-08-21', '12:09:25 PM', '20210821023', '01972', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('1970', '2021-08-21', '12:10:32 PM', '20210821024', '01973', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('1971', '2021-08-21', '12:40:20 PM', '20210821025', '01974', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '0.00', '0.00', '400.00', '0.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('1972', '2021-08-21', '12:44:59 PM', '20210821026', '01975', 'diagnosis', 'diagnosis', '1250.00', '0', '0.00', '1250.00', '250.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('1973', '2021-08-21', '12:46:52 PM', '20210821027', '01976', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '950.00', '0.00', 'Flat', '1000.00', '1000.00', '50.00', '0.00', '1000.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('1974', '2021-08-21', '12:50:29 PM', '20210821028', '01977', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '250.00', 'Flat', '800.00', '400.00', '0.00', '400.00', '400.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('1975', '2021-08-21', '12:57:13 PM', '20210821029', '01978', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '400.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('1976', '2021-08-21', '12:58:46 PM', '20210821030', '01979', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '0.00', '0.00', '400.00', '0.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('1977', '2021-08-21', '01:01:10 PM', '20210821031', '01980', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '350.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('1978', '2021-08-21', '01:05:45 PM', '20210821032', '01981', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '0.00', '150.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('1979', '2021-08-21', '01:36:18 PM', '20210821033', '01982', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '300.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('1980', '2021-08-21', '01:37:43 PM', '20210821034', '01983', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '700.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('1981', '2021-08-21', '01:42:21 PM', '20210821035', '01984', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('1982', '2021-08-21', '01:44:56 PM', '20210821036', '01985', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '450.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('1983', '2021-08-21', '01:47:04 PM', '20210821037', '01986', 'diagnosis', 'diagnosis', '1150.00', '0', '0.00', '1150.00', '450.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('1984', '2021-08-21', '01:54:40 PM', '20210821038', '01987', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '150.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('1985', '2021-08-21', '01:56:47 PM', '20210821039', '01988', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '550.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('1986', '2021-08-21', '01:57:32 PM', '20210821040', '01989', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '0.00', 'Flat', '900.00', '500.00', '0.00', '400.00', '500.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('1987', '2021-08-21', '01:58:31 PM', '20210821041', '01990', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '0.00', 'Flat', '650.00', '0.00', '0.00', '650.00', '0.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('1988', '2021-08-21', '01:59:59 PM', '20210821042', '01991', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '0.00', 'Flat', '650.00', '0.00', '0.00', '650.00', '0.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('1989', '2021-08-21', '02:02:45 PM', '20210821043', '01992', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '200.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('1990', '2021-08-21', '02:09:18 PM', '20210821044', '01993', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('1991', '2021-08-21', '02:13:20 PM', '20210821045', '01994', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '400.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('1992', '2021-08-21', '02:17:38 PM', '20210821046', '01995', 'diagnosis', 'diagnosis', '1800.00', '0', '0.00', '1800.00', '500.00', 'Flat', '1300.00', '1300.00', '0.00', '0.00', '1300.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('1993', '2021-08-21', '02:39:18 PM', '20210821047', '01996', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '0.00', 'Flat', '800.00', '0.00', '0.00', '800.00', '0.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('1994', '2021-08-21', '02:54:53 PM', '20210821048', '01997', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('1995', '2021-08-21', '02:58:17 PM', '20210821049', '01998', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '100.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('1996', '2021-08-21', '03:01:35 PM', '20210821050', '01999', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '0.00', 'Flat', '900.00', '0.00', '0.00', '900.00', '0.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('1997', '2021-08-21', '03:11:33 PM', '20210821051', '02000', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('1998', '2021-08-21', '03:21:59 PM', '20210821052', '02001', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '300.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('1999', '2021-08-21', '03:27:51 PM', '20210821053', '02002', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('2000', '2021-08-21', '03:30:49 PM', '20210821054', '02003', 'diagnosis', 'diagnosis', '1700.00', '0', '0.00', '1700.00', '700.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('2001', '2021-08-21', '03:32:39 PM', '20210821055', '02004', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '350.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('2002', '2021-08-21', '03:34:57 PM', '20210821056', '02005', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '300.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('2003', '2021-08-21', '03:41:13 PM', '20210821057', '02006', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '0.00', 'Flat', '900.00', '200.00', '0.00', '700.00', '200.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('2004', '2021-08-21', '03:43:22 PM', '20210821058', '02007', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('2005', '2021-08-21', '03:45:44 PM', '20210821059', '02008', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '300.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('2006', '2021-08-21', '03:52:31 PM', '20210821060', '02009', 'diagnosis', 'diagnosis', '1400.00', '0', '0.00', '1400.00', '400.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('2007', '2021-08-21', '03:54:16 PM', '20210821061', '02010', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('2008', '2021-08-21', '03:55:38 PM', '20210821062', '02011', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '150.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('2009', '2021-08-21', '03:57:43 PM', '20210821063', '02012', 'diagnosis', 'diagnosis', '1400.00', '0', '0.00', '1400.00', '600.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('2010', '2021-08-21', '04:00:55 PM', '20210821064', '02013', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('2011', '2021-08-21', '04:02:58 PM', '20210821065', '02014', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('2012', '2021-08-21', '04:10:57 PM', '20210821066', '02015', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('2013', '2021-08-21', '04:15:40 PM', '20210821067', '02016', 'diagnosis', 'diagnosis', '1250.00', '0', '0.00', '1250.00', '450.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('2014', '2021-08-21', '04:17:11 PM', '20210821068', '02017', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '200.00', 'Flat', '450.00', '450.00', '0.00', '0.00', '450.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('2015', '2021-08-21', '04:18:42 PM', '20210821069', '02018', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '350.00', 'Flat', '450.00', '450.00', '0.00', '0.00', '450.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('2016', '2021-08-21', '04:34:31 PM', '20210821070', '02019', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '250.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('2017', '2021-08-21', '04:36:34 PM', '20210821071', '02020', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '50.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('2018', '2021-08-21', '04:39:39 PM', '20210821072', '02021', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '50.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('2019', '2021-08-21', '04:50:22 PM', '20210821073', '02022', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '300.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('2020', '2021-08-21', '04:52:08 PM', '20210821074', '02023', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '200.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('2021', '2021-08-21', '04:57:09 PM', '20210821075', '02024', 'diagnosis', 'diagnosis', '1800.00', '0', '0.00', '1800.00', '450.00', 'Flat', '1350.00', '1350.00', '0.00', '0.00', '1350.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('2022', '2021-08-21', '04:58:33 PM', '20210821076', '02025', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '150.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('2023', '2021-08-21', '05:00:01 PM', '20210821077', '02026', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('2024', '2021-08-21', '05:06:19 PM', '20210821078', '02027', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '100.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('2025', '2021-08-21', '05:18:36 PM', '20210821079', '02028', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '300.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('2026', '2021-08-21', '05:21:47 PM', '20210821080', '02029', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '150.00', 'Flat', '250.00', '300.00', '0.00', '-50.00', '300.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('2027', '2021-08-21', '05:23:52 PM', '20210821081', '02030', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('2028', '2021-08-21', '05:30:38 PM', '20210821082', '02031', 'diagnosis', 'diagnosis', '2100.00', '0', '0.00', '2100.00', '600.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1500.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('2029', '2021-08-21', '05:40:24 PM', '20210821083', '02032', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '0.00', '400.00', '0.00', '0.00', '400.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('2030', '2021-08-21', '05:58:10 PM', '20210821084', '02033', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('2031', '2021-08-21', '06:13:17 PM', '20210821085', '02034', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('2032', '2021-08-21', '06:33:59 PM', '20210821086', '02035', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('2033', '2021-08-21', '06:45:13 PM', '20210821087', '02036', 'diagnosis', 'diagnosis', '200.00', '0', '0.00', '200.00', '100.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('2034', '2021-08-21', '07:18:37 PM', '20210821088', '02037', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-21', 'pending', '', '15', '', 'diagnosis', '2021-08-21 08:00 PM'), 
('2035', '2021-08-22', '10:03:14 AM', '20210822001', '02038', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2036', '2021-08-22', '10:05:04 AM', '20210822002', '02039', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2037', '2021-08-22', '10:05:50 AM', '20210822003', '02040', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2038', '2021-08-22', '10:07:37 AM', '20210822004', '02041', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '50.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2039', '2021-08-22', '10:10:01 AM', '20210822005', '02042', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '150.00', 'Flat', '150.00', '150.00', '0.00', '0.00', '150.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2040', '2021-08-22', '10:20:44 AM', '20210822006', '02043', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '150.00', 'Flat', '150.00', '150.00', '0.00', '0.00', '150.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2041', '2021-08-22', '10:23:59 AM', '20210822007', '02044', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '200.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2042', '2021-08-22', '10:33:59 AM', '20210822008', '02045', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2043', '2021-08-22', '10:49:24 AM', '20210822009', '02046', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2044', '2021-08-22', '10:58:59 AM', '20210822010', '02047', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '0.00', '150.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2045', '2021-08-22', '11:00:49 AM', '20210822011', '02048', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2046', '2021-08-22', '11:01:38 AM', '20210822012', '02049', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '170.00', 'Flat', '380.00', '380.00', '0.00', '0.00', '380.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2047', '2021-08-22', '11:04:14 AM', '20210822013', '02050', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2048', '2021-08-22', '11:07:08 AM', '20210822014', '02051', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2049', '2021-08-22', '11:12:44 AM', '20210822015', '02052', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '400.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2050', '2021-08-22', '11:16:09 AM', '20210822016', '02053', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2051', '2021-08-22', '11:17:26 AM', '20210822017', '02054', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '0.00', 'Flat', '650.00', '0.00', '0.00', '650.00', '0.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2052', '2021-08-22', '11:19:18 AM', '20210822018', '02055', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2053', '2021-08-22', '11:21:09 AM', '20210822019', '02056', 'diagnosis', 'diagnosis', '1100.00', '0', '0.00', '1100.00', '600.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2054', '2021-08-22', '11:23:47 AM', '20210822020', '02057', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2055', '2021-08-22', '11:24:24 AM', '20210822021', '02058', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '350.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2056', '2021-08-22', '11:25:57 AM', '20210822022', '02059', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2057', '2021-08-22', '11:27:46 AM', '20210822023', '02060', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '250.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2058', '2021-08-22', '11:31:24 AM', '20210822024', '02061', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '50.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2059', '2021-08-22', '11:32:34 AM', '20210822025', '02062', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2060', '2021-08-22', '11:33:47 AM', '20210822026', '02063', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '350.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2061', '2021-08-22', '11:35:45 AM', '20210822027', '02064', 'diagnosis', 'diagnosis', '1900.00', '0', '0.00', '1900.00', '200.00', 'Flat', '1700.00', '1700.00', '0.00', '0.00', '1700.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2062', '2021-08-22', '11:40:29 AM', '20210822028', '02065', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '150.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2063', '2021-08-22', '11:41:38 AM', '20210822029', '02066', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '150.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2064', '2021-08-22', '11:43:26 AM', '20210822030', '02067', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '200.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2065', '2021-08-22', '11:45:18 AM', '20210822031', '02068', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2066', '2021-08-22', '11:48:39 AM', '20210822032', '02069', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2067', '2021-08-22', '11:52:58 AM', '20210822033', '02070', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '300.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2068', '2021-08-22', '12:09:15 PM', '20210822034', '02071', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '50.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2069', '2021-08-22', '12:27:18 PM', '20210822035', '02072', 'diagnosis', 'diagnosis', '600.00', '0', '0.00', '600.00', '0.00', 'Flat', '600.00', '0.00', '0.00', '600.00', '0.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2070', '2021-08-22', '12:30:49 PM', '20210822036', '02073', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2071', '2021-08-22', '12:32:11 PM', '20210822037', '02074', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2072', '2021-08-22', '12:45:16 PM', '20210822038', '02075', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2073', '2021-08-22', '12:47:16 PM', '20210822039', '02076', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2074', '2021-08-22', '12:49:10 PM', '20210822040', '02077', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2075', '2021-08-22', '12:58:25 PM', '20210822041', '02078', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '350.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2076', '2021-08-22', '12:59:52 PM', '20210822042', '02079', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '550.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2077', '2021-08-22', '01:06:28 PM', '20210822043', '02080', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '0.00', 'Flat', '650.00', '0.00', '0.00', '650.00', '0.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2078', '2021-08-22', '01:09:24 PM', '20210822044', '02081', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2079', '2021-08-22', '01:11:44 PM', '20210822045', '02082', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '200.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2080', '2021-08-22', '01:13:14 PM', '20210822046', '02083', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2081', '2021-08-22', '01:18:25 PM', '20210822047', '02084', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2082', '2021-08-22', '01:22:13 PM', '20210822048', '02085', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2083', '2021-08-22', '02:01:31 PM', '20210822049', '02086', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '150.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2084', '2021-08-22', '02:04:55 PM', '20210822050', '02087', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2085', '2021-08-22', '03:08:22 PM', '20210822051', '02088', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2086', '2021-08-22', '03:10:55 PM', '20210822052', '02089', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '500.00', '0.00', '700.00', '500.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2087', '2021-08-22', '03:14:20 PM', '20210822053', '02090', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '200.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2088', '2021-08-22', '03:22:08 PM', '20210822054', '02091', 'diagnosis', 'diagnosis', '1150.00', '0', '0.00', '1150.00', '350.00', 'Flat', '800.00', '400.00', '0.00', '400.00', '400.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2089', '2021-08-22', '03:30:10 PM', '20210822055', '02092', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2090', '2021-08-22', '03:31:57 PM', '20210822056', '02093', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2091', '2021-08-22', '03:35:18 PM', '20210822057', '02094', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '200.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2092', '2021-08-22', '03:42:25 PM', '20210822058', '02095', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2093', '2021-08-22', '03:49:34 PM', '20210822059', '02096', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2094', '2021-08-22', '03:54:48 PM', '20210822060', '02097', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '500.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2095', '2021-08-22', '04:00:02 PM', '20210822061', '02098', 'diagnosis', 'diagnosis', '1700.00', '0', '0.00', '1700.00', '200.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1500.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2096', '2021-08-22', '04:02:03 PM', '20210822062', '02099', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '30.00', 'Flat', '120.00', '120.00', '0.00', '0.00', '120.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2097', '2021-08-22', '04:10:16 PM', '20210822063', '02100', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '0.00', 'Flat', '1500.00', '700.00', '0.00', '800.00', '700.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2098', '2021-08-22', '04:13:35 PM', '20210822064', '02101', 'diagnosis', 'diagnosis', '4250.00', '0', '0.00', '4250.00', '750.00', 'Flat', '3500.00', '1500.00', '0.00', '2000.00', '1500.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2099', '2021-08-22', '04:15:57 PM', '20210822065', '02102', 'diagnosis', 'diagnosis', '600.00', '0', '0.00', '600.00', '0.00', 'Flat', '600.00', '0.00', '0.00', '600.00', '0.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2100', '2021-08-22', '04:20:27 PM', '20210822066', '02103', 'diagnosis', 'diagnosis', '2450.00', '0', '0.00', '2450.00', '450.00', 'Flat', '2000.00', '2000.00', '0.00', '0.00', '2000.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2101', '2021-08-22', '04:24:28 PM', '20210822067', '02104', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '0.00', 'Flat', '950.00', '600.00', '0.00', '350.00', '600.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2102', '2021-08-22', '04:25:13 PM', '20210822068', '02105', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2103', '2021-08-22', '04:28:16 PM', '20210822069', '02106', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '0.00', '150.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2104', '2021-08-22', '04:31:26 PM', '20210822070', '02107', 'diagnosis', 'diagnosis', '1150.00', '0', '0.00', '1150.00', '350.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2105', '2021-08-22', '04:34:17 PM', '20210822071', '02108', 'diagnosis', 'diagnosis', '2450.00', '0', '0.00', '2450.00', '450.00', 'Flat', '2000.00', '2200.00', '0.00', '-200.00', '2200.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2106', '2021-08-22', '04:36:38 PM', '20210822072', '02109', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '150.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2107', '2021-08-22', '04:38:35 PM', '20210822073', '02110', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '500.00', 'Flat', '150.00', '500.00', '0.00', '-350.00', '500.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2108', '2021-08-22', '04:42:14 PM', '20210822074', '02111', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '150.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2109', '2021-08-22', '04:44:33 PM', '20210822075', '02112', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1450.00', '350.00', 'Flat', '1100.00', '1100.00', '0.00', '0.00', '1100.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2110', '2021-08-22', '04:45:55 PM', '20210822076', '02113', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '300.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2111', '2021-08-22', '04:47:46 PM', '20210822077', '02114', 'diagnosis', 'diagnosis', '1750.00', '0', '0.00', '1750.00', '550.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2112', '2021-08-22', '04:49:27 PM', '20210822078', '02115', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2113', '2021-08-22', '04:50:38 PM', '20210822079', '02116', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '300.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2114', '2021-08-22', '04:51:28 PM', '20210822080', '02117', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '300.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2115', '2021-08-22', '04:56:29 PM', '20210822081', '02118', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '250.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2116', '2021-08-22', '05:04:32 PM', '20210822082', '02119', 'diagnosis', 'diagnosis', '1850.00', '0', '0.00', '1850.00', '1500.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2117', '2021-08-22', '05:06:40 PM', '20210822083', '02120', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '150.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2118', '2021-08-22', '05:08:59 PM', '20210822084', '02121', 'diagnosis', 'diagnosis', '1550.00', '0', '0.00', '1550.00', '1550.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2119', '2021-08-22', '05:13:03 PM', '20210822085', '02122', 'diagnosis', 'diagnosis', '1800.00', '0', '0.00', '1800.00', '300.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1500.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2121', '2021-08-22', '05:47:55 PM', '20210822086', '02124', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1450.00', '550.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2122', '2021-08-22', '05:50:25 PM', '20210822087', '02125', 'diagnosis', 'diagnosis', '2250.00', '0', '0.00', '2250.00', '650.00', 'Flat', '1600.00', '1600.00', '0.00', '0.00', '1600.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2123', '2021-08-22', '05:53:31 PM', '20210822088', '02126', 'diagnosis', 'diagnosis', '500.00', '0', '0.00', '500.00', '200.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2124', '2021-08-22', '05:58:04 PM', '20210822089', '02127', 'diagnosis', 'diagnosis', '1900.00', '0', '0.00', '1900.00', '400.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1500.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2125', '2021-08-22', '06:02:49 PM', '20210822090', '02128', 'diagnosis', 'diagnosis', '1700.00', '0', '0.00', '1700.00', '300.00', 'Flat', '1400.00', '1400.00', '0.00', '0.00', '1400.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2126', '2021-08-22', '06:04:18 PM', '20210822091', '02129', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '250.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2127', '2021-08-22', '06:07:07 PM', '20210822092', '02130', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2128', '2021-08-22', '06:19:25 PM', '20210822093', '02131', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '400.00', 'Flat', '1100.00', '1100.00', '0.00', '0.00', '1100.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2129', '2021-08-22', '06:25:42 PM', '20210822094', '02132', 'diagnosis', 'diagnosis', '1550.00', '0', '0.00', '1550.00', '550.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2130', '2021-08-22', '07:17:01 PM', '20210822095', '02133', 'diagnosis', 'diagnosis', '600.00', '0', '0.00', '600.00', '600.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-08-22', 'pending', '', '15', '', 'diagnosis', '2021-08-22 08:00 PM'), 
('2131', '2021-08-23', '10:21:58 AM', '20210823001', '02134', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '70.00', 'Flat', '80.00', '80.00', '0.00', '0.00', '80.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2132', '2021-08-23', '10:22:51 AM', '20210823002', '02135', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '100.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2133', '2021-08-23', '10:25:21 AM', '20210823003', '02136', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '0.00', '0.00', '400.00', '0.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2134', '2021-08-23', '10:55:17 AM', '20210823004', '02137', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2135', '2021-08-23', '11:01:30 AM', '20210823005', '02138', 'diagnosis', 'diagnosis', '350.00', '0', '0.00', '350.00', '350.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2136', '2021-08-23', '11:17:07 AM', '20210823006', '02139', 'diagnosis', 'diagnosis', '1700.00', '0', '0.00', '1700.00', '500.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2137', '2021-08-23', '11:22:50 AM', '20210823007', '02140', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '400.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2138', '2021-08-23', '11:25:23 AM', '20210823008', '02141', 'diagnosis', 'diagnosis', '1600.00', '0', '0.00', '1600.00', '100.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1500.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2139', '2021-08-23', '11:27:45 AM', '20210823009', '02142', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2140', '2021-08-23', '11:31:43 AM', '20210823010', '02143', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '450.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2141', '2021-08-23', '11:33:34 AM', '20210823011', '02144', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '350.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2142', '2021-08-23', '11:34:25 AM', '20210823012', '02145', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2143', '2021-08-23', '11:40:42 AM', '20210823013', '02146', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2144', '2021-08-23', '11:43:21 AM', '20210823014', '02147', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2145', '2021-08-23', '11:45:44 AM', '20210823015', '02148', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '150.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2146', '2021-08-23', '11:47:11 AM', '20210823016', '02149', 'diagnosis', 'diagnosis', '450.00', '0', '0.00', '450.00', '200.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2147', '2021-08-23', '11:50:17 AM', '20210823017', '02150', 'diagnosis', 'diagnosis', '600.00', '0', '0.00', '600.00', '400.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2148', '2021-08-23', '11:52:53 AM', '20210823018', '02151', 'diagnosis', 'diagnosis', '1150.00', '0', '0.00', '1150.00', '150.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2149', '2021-08-23', '11:55:04 AM', '20210823019', '02152', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2150', '2021-08-23', '12:06:22 PM', '20210823020', '02153', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '600.00', 'Flat', '900.00', '400.00', '0.00', '500.00', '400.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2151', '2021-08-23', '12:09:23 PM', '20210823021', '02154', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2152', '2021-08-23', '12:10:53 PM', '20210823022', '02155', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2153', '2021-08-23', '12:24:13 PM', '20210823023', '02156', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '150.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2154', '2021-08-23', '12:25:45 PM', '20210823024', '02157', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2155', '2021-08-23', '12:35:19 PM', '20210823025', '02158', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2156', '2021-08-23', '12:40:21 PM', '20210823026', '02159', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2157', '2021-08-23', '01:04:40 PM', '20210823027', '02160', 'diagnosis', 'diagnosis', '600.00', '0', '0.00', '600.00', '0.00', 'Flat', '600.00', '0.00', '0.00', '600.00', '0.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2158', '2021-08-23', '01:21:59 PM', '20210823028', '02161', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2159', '2021-08-23', '01:33:06 PM', '20210823029', '02162', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2160', '2021-08-23', '01:35:47 PM', '20210823030', '02163', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2161', '2021-08-23', '01:38:56 PM', '20210823031', '02164', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2162', '2021-08-23', '01:53:48 PM', '20210823032', '02165', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '150.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2163', '2021-08-23', '01:55:58 PM', '20210823033', '02166', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '200.00', 'Flat', '1300.00', '1300.00', '0.00', '0.00', '1300.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2164', '2021-08-23', '02:01:31 PM', '20210823034', '02167', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '250.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2165', '2021-08-23', '02:03:39 PM', '20210823035', '02168', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2166', '2021-08-23', '02:12:53 PM', '20210823036', '02169', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '350.00', 'Flat', '650.00', '650.00', '0.00', '0.00', '650.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2167', '2021-08-23', '02:14:58 PM', '20210823037', '02170', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2168', '2021-08-23', '02:27:08 PM', '20210823038', '02171', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '150.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2169', '2021-08-23', '02:28:42 PM', '20210823039', '02172', 'diagnosis', 'diagnosis', '1100.00', '0', '0.00', '1100.00', '800.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2170', '2021-08-23', '02:34:40 PM', '20210823040', '02173', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '150.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2171', '2021-08-23', '02:36:41 PM', '20210823041', '02174', 'diagnosis', 'diagnosis', '600.00', '0', '0.00', '600.00', '0.00', 'Flat', '600.00', '0.00', '0.00', '600.00', '0.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2172', '2021-08-23', '02:57:35 PM', '20210823042', '02175', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '350.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2173', '2021-08-23', '02:58:30 PM', '20210823043', '02176', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2174', '2021-08-23', '03:18:08 PM', '20210823044', '02177', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '50.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2175', '2021-08-23', '03:23:06 PM', '20210823045', '02178', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2176', '2021-08-23', '03:28:58 PM', '20210823046', '02179', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2177', '2021-08-23', '03:41:21 PM', '20210823047', '02180', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '600.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2178', '2021-08-23', '03:51:49 PM', '20210823048', '02181', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2179', '2021-08-23', '03:57:41 PM', '20210823049', '02182', 'diagnosis', 'diagnosis', '1600.00', '0', '0.00', '1600.00', '500.00', 'Flat', '1100.00', '1100.00', '0.00', '0.00', '1100.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2180', '2021-08-23', '04:00:20 PM', '20210823050', '02183', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1450.00', '650.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2181', '2021-08-23', '04:04:13 PM', '20210823051', '02184', 'diagnosis', 'diagnosis', '1100.00', '0', '0.00', '1100.00', '0.00', 'Flat', '1100.00', '0.00', '0.00', '1100.00', '0.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2182', '2021-08-23', '04:12:27 PM', '20210823052', '02185', 'diagnosis', 'diagnosis', '1800.00', '0', '0.00', '1800.00', '300.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1500.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2183', '2021-08-23', '04:16:01 PM', '20210823053', '02186', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2184', '2021-08-23', '04:19:18 PM', '20210823054', '02187', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '300.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2185', '2021-08-23', '04:22:41 PM', '20210823055', '02188', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2186', '2021-08-23', '04:25:32 PM', '20210823056', '02189', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '700.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2187', '2021-08-23', '04:45:17 PM', '20210823057', '02190', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2188', '2021-08-23', '04:48:44 PM', '20210823058', '02191', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1450.00', '250.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2189', '2021-08-23', '05:24:01 PM', '20210823059', '02192', 'diagnosis', 'diagnosis', '1650.00', '0', '0.00', '1650.00', '350.00', 'Flat', '1300.00', '1300.00', '0.00', '0.00', '1300.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2190', '2021-08-23', '05:24:36 PM', '20210823060', '02193', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2191', '2021-08-23', '05:37:25 PM', '20210823061', '02194', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '450.00', 'Flat', '750.00', '750.00', '0.00', '0.00', '750.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2192', '2021-08-23', '05:38:51 PM', '20210823062', '02195', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '300.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2193', '2021-08-23', '05:39:25 PM', '20210823063', '02196', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '350.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2194', '2021-08-23', '05:40:22 PM', '20210823064', '02197', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '150.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2195', '2021-08-23', '05:46:01 PM', '20210823065', '02198', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-23', 'pending', '', '15', 'self', 'diagnosis', '2021-08-23 08:00 PM'), 
('2196', '2021-08-23', '06:06:50 PM', '20210823066', '02199', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '0.00', 'Flat', '550.00', '0.00', '0.00', '550.00', '0.00', '2021-08-23', 'pending', '', '15', '', 'diagnosis', '2021-08-23 08:00 PM'), 
('2197', '2021-08-24', '10:59:34 AM', '20210824001', '02200', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '0.00', 'Flat', '550.00', '0.00', '0.00', '550.00', '0.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2198', '2021-08-24', '11:00:53 AM', '20210824002', '02201', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2199', '2021-08-24', '11:01:44 AM', '20210824003', '02202', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2200', '2021-08-24', '11:02:52 AM', '20210824004', '02203', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '150.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2201', '2021-08-24', '11:21:00 AM', '20210824005', '02204', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2202', '2021-08-24', '11:29:06 AM', '20210824006', '02205', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '300.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2203', '2021-08-24', '11:33:27 AM', '20210824007', '02206', 'diagnosis', 'diagnosis', '1250.00', '0', '0.00', '1250.00', '550.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2204', '2021-08-24', '11:37:07 AM', '20210824008', '02207', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '250.00', 'Flat', '1100.00', '1100.00', '0.00', '0.00', '1100.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2205', '2021-08-24', '11:40:57 AM', '20210824009', '02208', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '250.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2206', '2021-08-24', '11:48:47 AM', '20210824010', '02209', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2207', '2021-08-24', '11:51:07 AM', '20210824011', '02210', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '250.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2208', '2021-08-24', '11:52:29 AM', '20210824012', '02211', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2209', '2021-08-24', '12:01:18 PM', '20210824013', '02212', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2210', '2021-08-24', '12:05:49 PM', '20210824014', '02213', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '0.00', 'Flat', '650.00', '0.00', '0.00', '650.00', '0.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2211', '2021-08-24', '12:15:35 PM', '20210824015', '02214', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '450.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2212', '2021-08-24', '12:22:44 PM', '20210824016', '02215', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '250.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2213', '2021-08-24', '12:25:13 PM', '20210824017', '02216', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2214', '2021-08-24', '12:27:23 PM', '20210824018', '02217', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2215', '2021-08-24', '12:37:37 PM', '20210824019', '02218', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '200.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2216', '2021-08-24', '12:41:49 PM', '20210824020', '02219', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2217', '2021-08-24', '12:55:53 PM', '20210824021', '02220', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2218', '2021-08-24', '12:57:03 PM', '20210824022', '02221', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2219', '2021-08-24', '01:09:43 PM', '20210824023', '02222', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '150.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2220', '2021-08-24', '01:12:05 PM', '20210824024', '02223', 'diagnosis', 'diagnosis', '1250.00', '0', '0.00', '1250.00', '0.00', 'Flat', '1250.00', '0.00', '0.00', '1250.00', '0.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2221', '2021-08-24', '01:29:56 PM', '20210824025', '02224', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '0.00', 'Flat', '1350.00', '0.00', '0.00', '1350.00', '0.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2222', '2021-08-24', '01:42:45 PM', '20210824026', '02225', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2223', '2021-08-24', '01:49:03 PM', '20210824027', '02226', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2224', '2021-08-24', '01:52:55 PM', '20210824028', '02227', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2225', '2021-08-24', '02:11:46 PM', '20210824029', '02228', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '400.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2226', '2021-08-24', '02:22:51 PM', '20210824030', '02229', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '400.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2227', '2021-08-24', '02:24:36 PM', '20210824031', '02230', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '300.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2228', '2021-08-24', '02:25:49 PM', '20210824032', '02231', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '0.00', 'Flat', '650.00', '0.00', '0.00', '650.00', '0.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2229', '2021-08-24', '02:27:57 PM', '20210824033', '02232', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2230', '2021-08-24', '02:28:33 PM', '20210824034', '02233', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2231', '2021-08-24', '02:29:55 PM', '20210824035', '02234', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2232', '2021-08-24', '02:32:48 PM', '20210824036', '02235', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '300.00', 'Flat', '900.00', '500.00', '0.00', '400.00', '500.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2233', '2021-08-24', '02:34:01 PM', '20210824037', '02236', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2234', '2021-08-24', '02:34:51 PM', '20210824038', '02237', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2235', '2021-08-24', '02:37:21 PM', '20210824039', '02238', 'diagnosis', 'diagnosis', '2750.00', '0', '0.00', '2750.00', '0.00', 'Flat', '2750.00', '1000.00', '0.00', '1750.00', '1000.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2236', '2021-08-24', '02:52:29 PM', '20210824040', '02239', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2237', '2021-08-24', '02:53:37 PM', '20210824041', '02240', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2238', '2021-08-24', '02:59:04 PM', '20210824042', '02241', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2239', '2021-08-24', '03:04:14 PM', '20210824043', '02242', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2240', '2021-08-24', '03:32:52 PM', '20210824044', '02243', 'diagnosis', 'diagnosis', '2050.00', '0', '0.00', '2050.00', '850.00', 'Flat', '1200.00', '500.00', '0.00', '700.00', '500.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2241', '2021-08-24', '03:36:46 PM', '20210824045', '02244', 'diagnosis', 'diagnosis', '2850.00', '0', '0.00', '2850.00', '0.00', 'Flat', '2850.00', '2200.00', '0.00', '650.00', '2200.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2242', '2021-08-24', '03:40:56 PM', '20210824046', '02245', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '150.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2243', '2021-08-24', '03:44:54 PM', '20210824047', '02246', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '100.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2244', '2021-08-24', '03:49:56 PM', '20210824048', '02247', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2245', '2021-08-24', '03:53:59 PM', '20210824049', '02248', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '150.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2246', '2021-08-24', '04:04:04 PM', '20210824050', '02249', 'diagnosis', 'diagnosis', '2100.00', '0', '0.00', '2100.00', '200.00', 'Flat', '1900.00', '1900.00', '0.00', '0.00', '1900.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2247', '2021-08-24', '04:05:23 PM', '20210824051', '02250', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '0.00', 'Flat', '650.00', '0.00', '0.00', '650.00', '0.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2248', '2021-08-24', '04:07:52 PM', '20210824052', '02251', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '200.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2249', '2021-08-24', '04:09:59 PM', '20210824053', '02252', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '10.00', 'Flat', '140.00', '140.00', '0.00', '0.00', '140.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2250', '2021-08-24', '04:18:08 PM', '20210824054', '02253', 'diagnosis', 'diagnosis', '1950.00', '0', '0.00', '1950.00', '450.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1500.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2251', '2021-08-24', '04:23:57 PM', '20210824055', '02254', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '0.00', 'Flat', '550.00', '0.00', '0.00', '550.00', '0.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2252', '2021-08-24', '04:25:32 PM', '20210824056', '02255', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2253', '2021-08-24', '04:33:18 PM', '20210824057', '02256', 'diagnosis', 'diagnosis', '2150.00', '0', '0.00', '2150.00', '0.00', 'Flat', '2150.00', '1000.00', '0.00', '1150.00', '1000.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2254', '2021-08-24', '04:36:33 PM', '20210824058', '02257', 'diagnosis', 'diagnosis', '1900.00', '0', '0.00', '1900.00', '0.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2255', '2021-08-24', '04:39:38 PM', '20210824059', '02258', 'diagnosis', 'diagnosis', '1900.00', '0', '0.00', '1900.00', '570.00', 'Flat', '1330.00', '1330.00', '0.00', '0.00', '1330.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2256', '2021-08-24', '04:47:32 PM', '20210824060', '02259', 'diagnosis', 'diagnosis', '3150.00', '0', '0.00', '3150.00', '350.00', 'Flat', '2800.00', '2800.00', '0.00', '0.00', '2800.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2257', '2021-08-24', '04:49:09 PM', '20210824061', '02260', 'diagnosis', 'diagnosis', '1700.00', '0', '0.00', '1700.00', '200.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1500.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2258', '2021-08-24', '04:50:59 PM', '20210824062', '02261', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '200.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2259', '2021-08-24', '04:59:51 PM', '20210824063', '02262', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '100.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2260', '2021-08-24', '05:04:22 PM', '20210824064', '02263', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '0.00', 'Flat', '650.00', '0.00', '0.00', '650.00', '0.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2261', '2021-08-24', '05:23:03 PM', '20210824065', '02264', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2262', '2021-08-24', '05:26:24 PM', '20210824066', '02265', 'diagnosis', 'diagnosis', '2000.00', '0', '0.00', '2000.00', '500.00', 'Flat', '1500.00', '1400.00', '0.00', '100.00', '1400.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2263', '2021-08-24', '05:36:44 PM', '20210824067', '02266', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2264', '2021-08-24', '05:43:16 PM', '20210824068', '02267', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '500.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2265', '2021-08-24', '06:27:35 PM', '20210824069', '02268', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2266', '2021-08-24', '07:16:42 PM', '20210824070', '02269', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2267', '2021-08-24', '07:17:34 PM', '20210824071', '02270', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-08-24', 'pending', '', '15', '', 'diagnosis', '2021-08-24 08:00 PM'), 
('2268', '2021-08-25', '09:57:47 AM', '20210825001', '02271', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '200.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2269', '2021-08-25', '10:00:21 AM', '20210825002', '02272', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '100.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2270', '2021-08-25', '10:03:19 AM', '20210825003', '02273', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '100.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2271', '2021-08-25', '10:04:53 AM', '20210825004', '02274', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2272', '2021-08-25', '10:16:44 AM', '20210825005', '02275', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2273', '2021-08-25', '10:20:46 AM', '20210825006', '02276', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '200.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2274', '2021-08-25', '10:39:42 AM', '20210825007', '02277', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2275', '2021-08-25', '10:44:44 AM', '20210825008', '02278', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '350.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2276', '2021-08-25', '11:02:53 AM', '20210825009', '02279', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2277', '2021-08-25', '11:06:35 AM', '20210825010', '02280', 'diagnosis', 'diagnosis', '1750.00', '0', '0.00', '1750.00', '350.00', 'Flat', '1400.00', '1400.00', '0.00', '0.00', '1400.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2278', '2021-08-25', '11:07:50 AM', '20210825011', '02281', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '150.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2279', '2021-08-25', '11:08:55 AM', '20210825012', '02282', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2280', '2021-08-25', '11:11:53 AM', '20210825013', '02283', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2281', '2021-08-25', '11:22:54 AM', '20210825014', '02284', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '150.00', 'Flat', '150.00', '150.00', '0.00', '0.00', '150.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2282', '2021-08-25', '11:31:09 AM', '20210825015', '02285', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2283', '2021-08-25', '11:31:49 AM', '20210825016', '02286', 'diagnosis', 'diagnosis', '1700.00', '0', '0.00', '1700.00', '700.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2284', '2021-08-25', '11:37:03 AM', '20210825017', '02287', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2285', '2021-08-25', '11:46:16 AM', '20210825018', '02288', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2286', '2021-08-25', '11:49:27 AM', '20210825019', '02289', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2287', '2021-08-25', '11:53:37 AM', '20210825020', '02290', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2288', '2021-08-25', '12:06:56 PM', '20210825021', '02291', 'diagnosis', 'diagnosis', '0.00', '0', '0.00', '0.00', '0.00', '0', '0.00', '0.00', '0.00', '0.00', '0.00', '0000-00-00', 'pending', '', '15', '0', 'diagnosis', '0'), 
('2289', '2021-08-25', '12:09:33 PM', '20210825022', '02292', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2290', '2021-08-25', '12:11:48 PM', '20210825023', '02293', 'diagnosis', 'diagnosis', '2200.00', '0', '0.00', '2200.00', '400.00', 'Flat', '1800.00', '1800.00', '0.00', '0.00', '1800.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2291', '2021-08-25', '12:13:02 PM', '20210825024', '02294', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '300.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2292', '2021-08-25', '12:14:37 PM', '20210825025', '02295', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '300.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2293', '2021-08-25', '12:17:46 PM', '20210825026', '02296', 'diagnosis', 'diagnosis', '350.00', '0', '0.00', '350.00', '50.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2294', '2021-08-25', '12:19:32 PM', '20210825027', '02297', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '150.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2295', '2021-08-25', '12:27:56 PM', '20210825028', '02298', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2296', '2021-08-25', '12:31:08 PM', '20210825029', '02299', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2297', '2021-08-25', '12:34:43 PM', '20210825030', '02300', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '600.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2298', '2021-08-25', '12:37:18 PM', '20210825031', '02301', 'diagnosis', 'diagnosis', '1750.00', '0', '0.00', '1750.00', '250.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1500.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2299', '2021-08-25', '12:38:56 PM', '20210825032', '02302', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2300', '2021-08-25', '12:40:23 PM', '20210825033', '02303', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2301', '2021-08-25', '12:46:07 PM', '20210825034', '02304', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '350.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2302', '2021-08-25', '12:57:06 PM', '20210825035', '02305', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2303', '2021-08-25', '01:03:09 PM', '20210825036', '02306', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '150.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2304', '2021-08-25', '01:09:32 PM', '20210825037', '02307', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2305', '2021-08-25', '01:11:17 PM', '20210825038', '02308', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2306', '2021-08-25', '01:13:09 PM', '20210825039', '02309', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '200.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2307', '2021-08-25', '01:15:56 PM', '20210825040', '02310', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '500.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1400.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2308', '2021-08-25', '01:17:54 PM', '20210825041', '02311', 'diagnosis', 'diagnosis', '1600.00', '0', '0.00', '1600.00', '400.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2309', '2021-08-25', '01:20:32 PM', '20210825042', '02312', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2310', '2021-08-25', '01:22:16 PM', '20210825043', '02313', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2311', '2021-08-25', '01:23:47 PM', '20210825044', '02314', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2312', '2021-08-25', '01:32:35 PM', '20210825045', '02315', 'diagnosis', 'diagnosis', '2450.00', '0', '0.00', '2450.00', '450.00', 'Flat', '2000.00', '1500.00', '0.00', '500.00', '1500.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2313', '2021-08-25', '01:50:54 PM', '20210825046', '02316', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '200.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2314', '2021-08-25', '01:52:10 PM', '20210825047', '02317', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '200.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2315', '2021-08-25', '02:00:05 PM', '20210825048', '02318', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2316', '2021-08-25', '02:02:23 PM', '20210825049', '02319', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '300.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2317', '2021-08-25', '02:04:04 PM', '20210825050', '02320', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2318', '2021-08-25', '02:05:58 PM', '20210825051', '02321', 'diagnosis', 'diagnosis', '1250.00', '0', '0.00', '1250.00', '450.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2319', '2021-08-25', '02:06:51 PM', '20210825052', '02322', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2320', '2021-08-25', '02:12:00 PM', '20210825053', '02323', 'diagnosis', 'diagnosis', '1900.00', '0', '0.00', '1900.00', '100.00', 'Flat', '1800.00', '1000.00', '0.00', '800.00', '1000.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2321', '2021-08-25', '02:14:20 PM', '20210825054', '02324', 'diagnosis', 'diagnosis', '2200.00', '0', '0.00', '2200.00', '0.00', 'Flat', '2200.00', '2200.00', '0.00', '0.00', '2200.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2322', '2021-08-25', '02:17:59 PM', '20210825055', '02325', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '150.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2323', '2021-08-25', '02:20:48 PM', '20210825056', '02326', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2324', '2021-08-25', '02:23:16 PM', '20210825057', '02327', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '500.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2325', '2021-08-25', '02:31:48 PM', '20210825058', '02328', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2326', '2021-08-25', '02:37:45 PM', '20210825059', '02329', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2327', '2021-08-25', '02:54:38 PM', '20210825060', '02330', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2328', '2021-08-25', '03:12:54 PM', '20210825061', '02331', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2329', '2021-08-25', '03:18:45 PM', '20210825062', '02332', 'diagnosis', 'diagnosis', '1850.00', '0', '0.00', '1850.00', '0.00', 'Flat', '1850.00', '500.00', '0.00', '1350.00', '500.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2330', '2021-08-25', '03:21:48 PM', '20210825063', '02333', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2331', '2021-08-25', '03:23:32 PM', '20210825064', '02334', 'diagnosis', 'diagnosis', '1550.00', '0', '0.00', '1550.00', '0.00', 'Flat', '1550.00', '0.00', '0.00', '1550.00', '0.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2332', '2021-08-25', '03:43:13 PM', '20210825065', '02335', 'diagnosis', 'diagnosis', '2450.00', '0', '0.00', '2450.00', '950.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1500.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2333', '2021-08-25', '03:57:35 PM', '20210825066', '02336', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '0.00', 'Flat', '650.00', '0.00', '0.00', '650.00', '0.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2334', '2021-08-25', '04:00:57 PM', '20210825067', '02337', 'diagnosis', 'diagnosis', '1700.00', '0', '0.00', '1700.00', '400.00', 'Flat', '1300.00', '1300.00', '0.00', '0.00', '1300.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2335', '2021-08-25', '04:08:57 PM', '20210825068', '02338', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1450.00', '50.00', 'Flat', '1400.00', '1400.00', '0.00', '0.00', '1400.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2336', '2021-08-25', '04:10:51 PM', '20210825069', '02339', 'diagnosis', 'diagnosis', '2150.00', '0', '0.00', '2150.00', '650.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1500.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2337', '2021-08-25', '04:12:33 PM', '20210825070', '02340', 'diagnosis', 'diagnosis', '1600.00', '0', '0.00', '1600.00', '0.00', 'Flat', '1600.00', '500.00', '0.00', '1100.00', '500.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2338', '2021-08-25', '04:22:23 PM', '20210825071', '02341', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2339', '2021-08-25', '04:26:07 PM', '20210825072', '02342', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '450.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2340', '2021-08-25', '04:28:50 PM', '20210825073', '02343', 'diagnosis', 'diagnosis', '1600.00', '0', '0.00', '1600.00', '600.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2341', '2021-08-25', '04:29:42 PM', '20210825074', '02344', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2342', '2021-08-25', '04:31:28 PM', '20210825075', '02345', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '300.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2343', '2021-08-25', '04:35:43 PM', '20210825076', '02346', 'diagnosis', 'diagnosis', '3800.00', '0', '0.00', '3800.00', '0.00', 'Flat', '3800.00', '1000.00', '0.00', '2800.00', '1000.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2344', '2021-08-25', '04:38:00 PM', '20210825077', '02347', 'diagnosis', 'diagnosis', '1900.00', '0', '0.00', '1900.00', '0.00', 'Flat', '1900.00', '500.00', '0.00', '1400.00', '500.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2345', '2021-08-25', '04:41:59 PM', '20210825078', '02348', 'diagnosis', 'diagnosis', '1600.00', '0', '0.00', '1600.00', '0.00', 'Flat', '1600.00', '200.00', '0.00', '1400.00', '200.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2346', '2021-08-25', '04:43:26 PM', '20210825079', '02349', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '100.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2347', '2021-08-25', '04:44:18 PM', '20210825080', '02350', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2348', '2021-08-25', '04:46:18 PM', '20210825081', '02351', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2349', '2021-08-25', '04:49:28 PM', '20210825082', '02352', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2350', '2021-08-25', '04:52:42 PM', '20210825083', '02353', 'diagnosis', 'diagnosis', '2050.00', '0', '0.00', '2050.00', '0.00', 'Flat', '2050.00', '500.00', '0.00', '1550.00', '500.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2351', '2021-08-25', '04:53:51 PM', '20210825084', '02354', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2352', '2021-08-25', '04:56:22 PM', '20210825085', '02355', 'diagnosis', 'diagnosis', '350.00', '0', '0.00', '350.00', '150.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2353', '2021-08-25', '04:57:35 PM', '20210825086', '02356', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2354', '2021-08-25', '05:02:17 PM', '20210825087', '02357', 'diagnosis', 'diagnosis', '1750.00', '0', '0.00', '1750.00', '0.00', 'Flat', '1750.00', '300.00', '0.00', '1450.00', '300.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2355', '2021-08-25', '05:05:59 PM', '20210825088', '02358', 'diagnosis', 'diagnosis', '1650.00', '0', '0.00', '1650.00', '850.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2356', '2021-08-25', '05:12:58 PM', '20210825089', '02359', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '0.00', 'Flat', '1300.00', '200.00', '0.00', '1100.00', '200.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2357', '2021-08-25', '05:21:09 PM', '20210825090', '02360', 'diagnosis', 'diagnosis', '1550.00', '0', '0.00', '1550.00', '0.00', 'Flat', '1550.00', '0.00', '0.00', '1550.00', '0.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2358', '2021-08-25', '05:24:30 PM', '20210825091', '02361', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '0.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2359', '2021-08-25', '05:37:41 PM', '20210825092', '02362', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2360', '2021-08-25', '05:41:40 PM', '20210825093', '02363', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '400.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2361', '2021-08-25', '05:44:58 PM', '20210825094', '02364', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '150.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2362', '2021-08-25', '05:50:06 PM', '20210825095', '02365', 'diagnosis', 'diagnosis', '1600.00', '0', '0.00', '1600.00', '300.00', 'Flat', '1300.00', '1300.00', '0.00', '0.00', '1300.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2363', '2021-08-25', '06:28:02 PM', '20210825096', '02366', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2364', '2021-08-25', '06:34:07 PM', '20210825097', '02367', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2365', '2021-08-25', '06:46:04 PM', '20210825098', '02368', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '200.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2366', '2021-08-25', '07:10:56 PM', '20210825099', '02369', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2367', '2021-08-25', '07:31:48 PM', '20210825100', '02370', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-25', 'pending', '', '15', '', 'diagnosis', '2021-08-25 08:00 PM'), 
('2368', '2021-08-26', '09:55:47 AM', '20210826001', '02371', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-26', 'pending', '', '15', '', 'diagnosis', '2021-08-26 08:00 PM'), 
('2369', '2021-08-26', '10:17:22 AM', '20210826002', '02372', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-26', 'pending', '', '15', '', 'diagnosis', '2021-08-26 08:00 PM'), 
('2370', '2021-08-26', '10:41:19 AM', '20210826003', '02373', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '0.00', 'Flat', '300.00', '0.00', '0.00', '300.00', '0.00', '2021-08-26', 'pending', '', '15', '', 'diagnosis', '2021-08-26 08:00 PM'), 
('2371', '2021-08-26', '10:50:44 AM', '20210826004', '02374', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-26', 'pending', '', '15', '', 'diagnosis', '2021-08-26 08:00 PM'), 
('2372', '2021-08-26', '11:07:42 AM', '20210826005', '02375', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '0.00', 'Flat', '300.00', '0.00', '0.00', '300.00', '0.00', '2021-08-26', 'pending', '', '15', '', 'diagnosis', '2021-08-26 08:00 PM'), 
('2373', '2021-08-26', '11:22:16 AM', '20210826006', '02376', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '700.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-08-26', 'pending', '', '15', '', 'diagnosis', '2021-08-26 08:00 PM'), 
('2374', '2021-08-26', '11:26:33 AM', '20210826007', '02377', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-26', 'pending', '', '15', '', 'diagnosis', '2021-08-26 08:00 PM'), 
('2375', '2021-08-26', '11:30:47 AM', '20210826008', '02378', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-26', 'pending', '', '15', '', 'diagnosis', '2021-08-26 08:00 PM'), 
('2376', '2021-08-26', '11:35:24 AM', '20210826009', '02379', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '450.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-26', 'pending', '', '15', '', 'diagnosis', '2021-08-26 08:00 PM'), 
('2377', '2021-08-26', '11:45:15 AM', '20210826010', '02380', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-26', 'pending', '', '15', '', 'diagnosis', '2021-08-26 08:00 PM'), 
('2378', '2021-08-26', '11:47:51 AM', '20210826011', '02381', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '450.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-08-26', 'pending', '', '15', '', 'diagnosis', '2021-08-26 08:00 PM'), 
('2379', '2021-08-26', '11:54:53 AM', '20210826012', '02382', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-26', 'pending', '', '15', '', 'diagnosis', '2021-08-26 08:00 PM'), 
('2380', '2021-08-26', '12:09:55 PM', '20210826013', '02383', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '200.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-26', 'pending', '', '15', '', 'diagnosis', '2021-08-26 08:00 PM'), 
('2381', '2021-08-26', '12:11:49 PM', '20210826014', '02384', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '900.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-26', 'pending', '', '15', '', 'diagnosis', '2021-08-26 08:00 PM'), 
('2382', '2021-08-26', '12:58:21 PM', '20210826015', '02385', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-26', 'pending', '', '15', '', 'diagnosis', '2021-08-26 08:00 PM'), 
('2383', '2021-08-26', '01:01:27 PM', '20210826016', '02386', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '550.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-26', 'pending', '', '15', '', 'diagnosis', '2021-08-26 08:00 PM'), 
('2384', '2021-08-26', '01:02:12 PM', '20210826017', '02387', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-26', 'pending', '', '15', '', 'diagnosis', '2021-08-26 08:00 PM'), 
('2385', '2021-08-26', '01:03:12 PM', '20210826018', '02388', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-26', 'pending', '', '15', '', 'diagnosis', '2021-08-26 08:00 PM'), 
('2386', '2021-08-26', '01:04:00 PM', '20210826019', '02389', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-26', 'pending', '', '15', '', 'diagnosis', '2021-08-26 08:00 PM'), 
('2387', '2021-08-26', '01:04:59 PM', '20210826020', '02390', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-26', 'pending', '', '15', '', 'diagnosis', '2021-08-26 08:00 PM'), 
('2388', '2021-08-26', '01:05:47 PM', '20210826021', '02391', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '190.00', 'Flat', '360.00', '360.00', '0.00', '0.00', '360.00', '2021-08-26', 'pending', '', '15', '', 'diagnosis', '2021-08-26 08:00 PM'), 
('2389', '2021-08-26', '01:06:31 PM', '20210826022', '02392', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-26', 'pending', '', '15', '', 'diagnosis', '2021-08-26 08:00 PM'), 
('2390', '2021-08-26', '01:07:55 PM', '20210826023', '02393', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '500.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-26', 'pending', '', '15', '', 'diagnosis', '2021-08-26 08:00 PM'), 
('2391', '2021-08-26', '01:10:12 PM', '20210826024', '02394', 'diagnosis', 'diagnosis', '2250.00', '0', '0.00', '2250.00', '0.00', 'Flat', '2250.00', '1000.00', '0.00', '1250.00', '1000.00', '2021-08-26', 'pending', '', '15', '', 'diagnosis', '2021-08-26 08:00 PM'), 
('2392', '2021-08-26', '01:49:41 PM', '20210826025', '02395', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '200.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-26', 'pending', '', '15', '', 'diagnosis', '2021-08-26 08:00 PM'), 
('2393', '2021-08-26', '01:55:27 PM', '20210826026', '02396', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '150.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-08-26', 'pending', '', '15', '', 'diagnosis', '2021-08-26 08:00 PM'), 
('2394', '2021-08-26', '01:57:19 PM', '20210826027', '02397', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '500.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-26', 'pending', '', '15', '', 'diagnosis', '2021-08-26 08:00 PM'), 
('2395', '2021-08-26', '01:58:31 PM', '20210826028', '02398', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '200.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-08-26', 'pending', '', '15', '', 'diagnosis', '2021-08-26 08:00 PM'), 
('2396', '2021-08-26', '03:05:32 PM', '20210826029', '02399', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-26', 'pending', '', '15', '', 'diagnosis', '2021-08-26 08:00 PM'), 
('2397', '2021-08-26', '03:06:59 PM', '20210826030', '02400', 'diagnosis', 'diagnosis', '1250.00', '0', '0.00', '1250.00', '450.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-26', 'pending', '', '15', '', 'diagnosis', '2021-08-26 08:00 PM'), 
('2398', '2021-08-26', '03:08:48 PM', '20210826031', '02401', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-26', 'pending', '', '15', '', 'diagnosis', '2021-08-26 08:00 PM'), 
('2399', '2021-08-26', '03:16:00 PM', '20210826032', '02402', 'diagnosis', 'diagnosis', '450.00', '0', '0.00', '450.00', '450.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-08-26', 'pending', '', '15', '', 'diagnosis', '2021-08-26 08:00 PM'), 
('2400', '2021-08-26', '03:17:28 PM', '20210826033', '02403', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-26', 'pending', '', '15', '', 'diagnosis', '2021-08-26 08:00 PM'), 
('2401', '2021-08-26', '03:30:48 PM', '20210826034', '02404', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-26', 'pending', '', '15', '', 'diagnosis', '2021-08-26 08:00 PM'), 
('2402', '2021-08-26', '03:47:11 PM', '20210826035', '02405', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-26', 'pending', '', '15', '', 'diagnosis', '2021-08-26 08:00 PM'), 
('2403', '2021-08-26', '03:58:49 PM', '20210826036', '02406', 'diagnosis', 'diagnosis', '1100.00', '0', '0.00', '1100.00', '0.00', 'Flat', '1100.00', '0.00', '0.00', '1100.00', '0.00', '2021-08-26', 'pending', '', '15', '', 'diagnosis', '2021-08-26 08:00 PM'), 
('2404', '2021-08-26', '04:12:22 PM', '20210826037', '02407', 'diagnosis', 'diagnosis', '1600.00', '0', '0.00', '1600.00', '0.00', 'Flat', '1600.00', '800.00', '0.00', '800.00', '800.00', '2021-08-26', 'pending', '', '15', '', 'diagnosis', '2021-08-26 08:00 PM'), 
('2405', '2021-08-26', '04:14:37 PM', '20210826038', '02408', 'diagnosis', 'diagnosis', '1750.00', '0', '0.00', '1750.00', '0.00', 'Flat', '1750.00', '500.00', '0.00', '1250.00', '500.00', '2021-08-26', 'pending', '', '15', '', 'diagnosis', '2021-08-26 08:00 PM'), 
('2406', '2021-08-26', '04:16:44 PM', '20210826039', '02409', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '0.00', '150.00', '2021-08-26', 'pending', '', '15', '', 'diagnosis', '2021-08-26 08:00 PM'), 
('2407', '2021-08-26', '04:28:29 PM', '20210826040', '02410', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-26', 'pending', '', '15', '', 'diagnosis', '2021-08-26 08:00 PM'), 
('2408', '2021-08-26', '04:41:20 PM', '20210826041', '02411', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '350.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-26', 'pending', '', '15', '', 'diagnosis', '2021-08-26 08:00 PM'), 
('2409', '2021-08-26', '04:42:10 PM', '20210826042', '02412', 'diagnosis', 'diagnosis', '750.00', '0', '0.00', '750.00', '30.00', 'Percentage', '525.00', '500.00', '0.00', '25.00', '500.00', '2021-08-26', 'pending', '', '15', '', 'diagnosis', '2021-08-26 08:00 PM'), 
('2410', '2021-08-26', '04:45:56 PM', '20210826043', '02413', 'diagnosis', 'diagnosis', '1100.00', '0', '0.00', '1100.00', '200.00', 'Flat', '900.00', '500.00', '0.00', '400.00', '500.00', '2021-08-26', 'pending', '', '15', '', 'diagnosis', '2021-08-26 08:00 PM'), 
('2411', '2021-08-26', '04:53:54 PM', '20210826044', '02414', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '200.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-26', 'pending', '', '15', '', 'diagnosis', '2021-08-26 08:00 PM'), 
('2412', '2021-08-26', '05:19:29 PM', '20210826045', '02415', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '0.00', '150.00', '2021-08-26', 'pending', '', '15', '', 'diagnosis', '2021-08-26 08:00 PM'), 
('2413', '2021-08-26', '05:35:49 PM', '20210826046', '02416', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-26', 'pending', '', '15', '', 'diagnosis', '2021-08-26 08:00 PM'), 
('2414', '2021-08-26', '05:37:50 PM', '20210826047', '02417', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '0.00', 'Flat', '550.00', '0.00', '0.00', '550.00', '0.00', '2021-08-26', 'pending', '', '15', '', 'diagnosis', '2021-08-26 08:00 PM'), 
('2415', '2021-08-26', '05:39:10 PM', '20210826048', '02418', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '0.00', 'Flat', '650.00', '0.00', '0.00', '650.00', '0.00', '2021-08-26', 'pending', '', '15', '', 'diagnosis', '2021-08-26 08:00 PM'), 
('2416', '2021-08-26', '05:41:13 PM', '20210826049', '02419', 'diagnosis', 'diagnosis', '1150.00', '0', '0.00', '1150.00', '250.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-08-26', 'pending', '', '15', '', 'diagnosis', '2021-08-26 08:00 PM'), 
('2417', '2021-08-27', '10:32:39 AM', '20210827001', '02420', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '100.00', 'Flat', '450.00', '450.00', '0.00', '0.00', '450.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2418', '2021-08-27', '10:47:07 AM', '20210827002', '02421', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '0.00', '150.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2419', '2021-08-27', '10:57:02 AM', '20210827003', '02422', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2420', '2021-08-27', '11:22:10 AM', '20210827004', '02423', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '0.00', '150.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2421', '2021-08-27', '11:26:52 AM', '20210827005', '02424', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '350.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2422', '2021-08-27', '11:33:04 AM', '20210827006', '02425', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '400.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2423', '2021-08-27', '11:34:47 AM', '20210827007', '02426', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '0.00', '0.00', '400.00', '0.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2424', '2021-08-27', '11:39:47 AM', '20210827008', '02427', 'diagnosis', 'diagnosis', '450.00', '0', '0.00', '450.00', '250.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2425', '2021-08-27', '11:42:44 AM', '20210827009', '02428', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2426', '2021-08-27', '11:43:44 AM', '20210827010', '02429', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2427', '2021-08-27', '11:47:45 AM', '20210827011', '02430', 'diagnosis', 'diagnosis', '2500.00', '0', '0.00', '2500.00', '500.00', 'Flat', '2000.00', '2000.00', '0.00', '0.00', '2000.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2428', '2021-08-27', '11:51:32 AM', '20210827012', '02431', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '0.00', 'Flat', '800.00', '0.00', '0.00', '800.00', '0.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2429', '2021-08-27', '11:54:24 AM', '20210827013', '02432', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2430', '2021-08-27', '11:56:21 AM', '20210827014', '02433', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2431', '2021-08-27', '11:57:43 AM', '20210827015', '02434', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2432', '2021-08-27', '12:00:38 PM', '20210827016', '02435', 'diagnosis', 'diagnosis', '1750.00', '0', '0.00', '1750.00', '0.00', 'Flat', '1750.00', '500.00', '0.00', '1250.00', '500.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2433', '2021-08-27', '12:06:17 PM', '20210827017', '02436', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2434', '2021-08-27', '12:09:47 PM', '20210827018', '02437', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '600.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2435', '2021-08-27', '12:11:21 PM', '20210827019', '02438', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '300.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2436', '2021-08-27', '12:13:36 PM', '20210827020', '02439', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '200.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2437', '2021-08-27', '12:15:12 PM', '20210827021', '02440', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '0.00', 'Flat', '950.00', '400.00', '0.00', '550.00', '400.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2438', '2021-08-27', '12:17:06 PM', '20210827022', '02441', 'diagnosis', 'diagnosis', '1600.00', '0', '0.00', '1600.00', '500.00', 'Flat', '1100.00', '1100.00', '0.00', '0.00', '1100.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2439', '2021-08-27', '12:21:31 PM', '20210827023', '02442', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '0.00', 'Flat', '800.00', '200.00', '0.00', '600.00', '200.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2440', '2021-08-27', '12:24:33 PM', '20210827024', '02443', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '800.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2441', '2021-08-27', '12:26:08 PM', '20210827025', '02444', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2442', '2021-08-27', '12:28:08 PM', '20210827026', '02445', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-27', 'pending', '', '15', 'Dr Rasel', 'diagnosis', '2021-08-27 08:00 PM'), 
('2443', '2021-08-27', '12:31:06 PM', '20210827027', '02446', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2444', '2021-08-27', '12:34:53 PM', '20210827028', '02447', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '300.00', '0.00', '100.00', '300.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2445', '2021-08-27', '12:37:38 PM', '20210827029', '02448', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '10.00', 'Flat', '140.00', '140.00', '0.00', '0.00', '140.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2446', '2021-08-27', '12:38:34 PM', '20210827030', '02449', 'diagnosis', 'diagnosis', '750.00', '0', '0.00', '750.00', '200.00', 'Flat', '550.00', '550.00', '0.00', '0.00', '550.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2447', '2021-08-27', '12:47:01 PM', '20210827031', '02450', 'diagnosis', 'diagnosis', '1750.00', '0', '0.00', '1750.00', '250.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1500.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2448', '2021-08-27', '01:00:38 PM', '20210827032', '02451', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '350.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2449', '2021-08-27', '01:06:42 PM', '20210827033', '02452', 'diagnosis', 'diagnosis', '1900.00', '0', '0.00', '1900.00', '0.00', 'Flat', '1900.00', '1000.00', '0.00', '900.00', '1000.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2450', '2021-08-27', '01:09:15 PM', '20210827034', '02453', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '200.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2451', '2021-08-27', '01:13:45 PM', '20210827035', '02454', 'diagnosis', 'diagnosis', '1400.00', '0', '0.00', '1400.00', '0.00', 'Flat', '1400.00', '500.00', '0.00', '900.00', '500.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2452', '2021-08-27', '01:14:57 PM', '20210827036', '02455', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2453', '2021-08-27', '01:26:10 PM', '20210827037', '02456', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '0.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2454', '2021-08-27', '01:31:07 PM', '20210827038', '02457', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '200.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2455', '2021-08-27', '01:38:55 PM', '20210827039', '02458', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '400.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2456', '2021-08-27', '01:42:53 PM', '20210827040', '02459', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '50.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2457', '2021-08-27', '01:45:47 PM', '20210827041', '02460', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '350.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2458', '2021-08-27', '01:47:50 PM', '20210827042', '02461', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '200.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2459', '2021-08-27', '01:49:48 PM', '20210827043', '02462', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2460', '2021-08-27', '02:00:01 PM', '20210827044', '02463', 'diagnosis', 'diagnosis', '1750.00', '0', '0.00', '1750.00', '650.00', 'Flat', '1100.00', '1100.00', '0.00', '0.00', '1100.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2461', '2021-08-27', '02:02:55 PM', '20210827045', '02464', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '0.00', 'Flat', '1300.00', '0.00', '0.00', '1300.00', '0.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2462', '2021-08-27', '02:03:48 PM', '20210827046', '02465', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2463', '2021-08-27', '02:07:01 PM', '20210827047', '02466', 'diagnosis', 'diagnosis', '2500.00', '0', '0.00', '2300.00', '0.00', 'Flat', '2500.00', '1500.00', '200.00', '1000.00', '1500.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2464', '2021-08-27', '02:09:58 PM', '20210827048', '02467', 'diagnosis', 'diagnosis', '2200.00', '0', '0.00', '2200.00', '400.00', 'Flat', '1800.00', '1800.00', '0.00', '0.00', '1800.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2465', '2021-08-27', '02:14:47 PM', '20210827049', '02468', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '50.00', 'Flat', '1300.00', '1300.00', '0.00', '0.00', '1300.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2466', '2021-08-27', '02:18:56 PM', '20210827050', '02469', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '500.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2467', '2021-08-27', '02:22:29 PM', '20210827051', '02470', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2468', '2021-08-27', '02:27:16 PM', '20210827052', '02471', 'diagnosis', 'diagnosis', '2150.00', '0', '0.00', '2150.00', '250.00', 'Flat', '1900.00', '1900.00', '0.00', '0.00', '1900.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2469', '2021-08-27', '02:30:08 PM', '20210827053', '02472', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '300.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2470', '2021-08-27', '02:32:00 PM', '20210827054', '02473', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2471', '2021-08-27', '02:36:05 PM', '20210827055', '02474', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2472', '2021-08-27', '02:40:49 PM', '20210827056', '02475', 'diagnosis', 'diagnosis', '1900.00', '0', '0.00', '1900.00', '300.00', 'Flat', '1600.00', '1600.00', '0.00', '0.00', '1600.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2473', '2021-08-27', '02:42:22 PM', '20210827057', '02476', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '0.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2474', '2021-08-27', '02:47:02 PM', '20210827058', '02477', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '100.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2475', '2021-08-27', '02:56:34 PM', '20210827059', '02478', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '200.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2476', '2021-08-27', '03:03:10 PM', '20210827060', '02479', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '300.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2477', '2021-08-27', '03:05:25 PM', '20210827061', '02480', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2478', '2021-08-27', '03:10:05 PM', '20210827062', '02481', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '350.00', 'Flat', '550.00', '550.00', '0.00', '0.00', '550.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2479', '2021-08-27', '03:11:53 PM', '20210827063', '02482', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '0.00', '0.00', '400.00', '0.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2480', '2021-08-27', '03:13:02 PM', '20210827064', '02483', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '0.00', 'Flat', '900.00', '0.00', '0.00', '900.00', '0.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2481', '2021-08-27', '03:29:09 PM', '20210827065', '02484', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2482', '2021-08-27', '03:30:24 PM', '20210827066', '02485', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2483', '2021-08-27', '03:32:54 PM', '20210827067', '02486', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2484', '2021-08-27', '03:36:56 PM', '20210827068', '02487', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '150.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2485', '2021-08-27', '03:40:56 PM', '20210827069', '02488', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '300.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2486', '2021-08-27', '03:45:09 PM', '20210827070', '02489', 'diagnosis', 'diagnosis', '2650.00', '0', '0.00', '2650.00', '650.00', 'Flat', '2000.00', '2000.00', '0.00', '0.00', '2000.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2487', '2021-08-27', '03:46:52 PM', '20210827071', '02490', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '250.00', 'Flat', '700.00', '600.00', '0.00', '100.00', '600.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2488', '2021-08-27', '03:49:47 PM', '20210827072', '02491', 'diagnosis', 'diagnosis', '1600.00', '0', '0.00', '1600.00', '800.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2489', '2021-08-27', '03:52:12 PM', '20210827073', '02492', 'diagnosis', 'diagnosis', '1250.00', '0', '0.00', '1250.00', '0.00', 'Flat', '1250.00', '0.00', '0.00', '1250.00', '0.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2490', '2021-08-27', '03:54:52 PM', '20210827074', '02493', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '0.00', 'Flat', '900.00', '0.00', '0.00', '900.00', '0.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2491', '2021-08-27', '03:55:44 PM', '20210827075', '02494', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2492', '2021-08-27', '03:58:50 PM', '20210827076', '02495', 'diagnosis', 'diagnosis', '1550.00', '0', '0.00', '1550.00', '750.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2493', '2021-08-27', '04:00:49 PM', '20210827077', '02496', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2494', '2021-08-27', '04:05:57 PM', '20210827078', '02497', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '0.00', 'Flat', '900.00', '500.00', '0.00', '400.00', '500.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2495', '2021-08-27', '04:10:54 PM', '20210827079', '02498', 'diagnosis', 'diagnosis', '2150.00', '0', '0.00', '1750.00', '150.00', 'Flat', '2000.00', '2000.00', '400.00', '0.00', '2000.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2496', '2021-08-27', '04:13:02 PM', '20210827080', '02499', 'diagnosis', 'diagnosis', '3000.00', '0', '0.00', '3000.00', '800.00', 'Flat', '2200.00', '2200.00', '0.00', '0.00', '2200.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2497', '2021-08-27', '04:15:19 PM', '20210827081', '02500', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '30.00', 'Flat', '120.00', '120.00', '0.00', '0.00', '120.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2498', '2021-08-27', '04:23:47 PM', '20210827082', '02501', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '300.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2499', '2021-08-27', '04:42:36 PM', '20210827083', '02502', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '300.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2500', '2021-08-27', '04:55:08 PM', '20210827084', '02503', 'diagnosis', 'diagnosis', '2050.00', '0', '0.00', '2050.00', '750.00', 'Flat', '1300.00', '1300.00', '0.00', '0.00', '1300.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2501', '2021-08-27', '04:56:46 PM', '20210827085', '02504', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '50.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2502', '2021-08-27', '05:08:23 PM', '20210827086', '02505', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2503', '2021-08-27', '05:14:40 PM', '20210827087', '02506', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '200.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2504', '2021-08-27', '05:16:17 PM', '20210827088', '02507', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '0.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2505', '2021-08-27', '05:22:41 PM', '20210827089', '02508', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1450.00', '450.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2506', '2021-08-27', '05:33:41 PM', '20210827090', '02509', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2507', '2021-08-27', '05:58:25 PM', '20210827091', '02510', 'diagnosis', 'diagnosis', '1950.00', '0', '0.00', '1950.00', '1950.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2508', '2021-08-27', '06:02:36 PM', '20210827092', '02511', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '0.00', 'Flat', '850.00', '300.00', '0.00', '550.00', '300.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2509', '2021-08-27', '06:11:39 PM', '20210827093', '02512', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2510', '2021-08-27', '06:24:06 PM', '20210827094', '02513', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '0.00', 'Flat', '1300.00', '500.00', '0.00', '800.00', '500.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2511', '2021-08-27', '06:24:06 PM', '20210827094', '02513', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '0.00', 'Flat', '1300.00', '500.00', '0.00', '800.00', '500.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2512', '2021-08-27', '06:24:07 PM', '20210827095', '02515', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '0.00', 'Flat', '1300.00', '500.00', '0.00', '800.00', '500.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2513', '2021-08-27', '06:26:03 PM', '20210827096', '02516', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '100.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2514', '2021-08-27', '07:01:35 PM', '20210827097', '02517', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '550.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-27', 'pending', '', '15', '', 'diagnosis', '2021-08-27 08:00 PM'), 
('2515', '2021-08-28', '10:35:19 AM', '20210828001', '02518', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '200.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2516', '2021-08-28', '10:36:05 AM', '20210828002', '02519', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '200.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2517', '2021-08-28', '10:36:36 AM', '20210828003', '02520', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2518', '2021-08-28', '10:40:22 AM', '20210828004', '02521', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2519', '2021-08-28', '10:46:17 AM', '20210828005', '02522', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '200.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2520', '2021-08-28', '10:48:34 AM', '20210828006', '02523', 'diagnosis', 'diagnosis', '1850.00', '0', '0.00', '1850.00', '0.00', 'Flat', '1850.00', '0.00', '0.00', '1850.00', '0.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2521', '2021-08-28', '10:59:21 AM', '20210828007', '02524', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2522', '2021-08-28', '11:18:17 AM', '20210828008', '02525', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '200.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2523', '2021-08-28', '11:20:23 AM', '20210828009', '02526', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '300.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2524', '2021-08-28', '11:23:39 AM', '20210828010', '02527', 'diagnosis', 'diagnosis', '1650.00', '0', '0.00', '1650.00', '650.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2525', '2021-08-28', '11:27:03 AM', '20210828011', '02528', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '300.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2526', '2021-08-28', '11:29:18 AM', '20210828012', '02529', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '150.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2527', '2021-08-28', '11:32:30 AM', '20210828013', '02530', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2528', '2021-08-28', '11:37:32 AM', '20210828014', '02531', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '0.00', 'Flat', '650.00', '0.00', '0.00', '650.00', '0.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2529', '2021-08-28', '11:41:18 AM', '20210828015', '02532', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '300.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2530', '2021-08-28', '11:43:43 AM', '20210828016', '02533', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '200.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2531', '2021-08-28', '12:09:53 PM', '20210828017', '02534', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2532', '2021-08-28', '12:23:24 PM', '20210828018', '02535', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '150.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2533', '2021-08-28', '12:27:21 PM', '20210828019', '02536', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2534', '2021-08-28', '12:38:34 PM', '20210828020', '02537', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2535', '2021-08-28', '12:45:06 PM', '20210828021', '02538', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '150.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2536', '2021-08-28', '12:55:08 PM', '20210828022', '02539', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '200.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2537', '2021-08-28', '12:57:12 PM', '20210828023', '02540', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '450.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2538', '2021-08-28', '12:58:31 PM', '20210828024', '02541', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '500.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2539', '2021-08-28', '12:59:45 PM', '20210828025', '02542', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2540', '2021-08-28', '01:01:47 PM', '20210828026', '02543', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '100.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2541', '2021-08-28', '01:07:37 PM', '20210828027', '02544', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '0.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2542', '2021-08-28', '01:12:07 PM', '20210828028', '02545', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '350.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2543', '2021-08-28', '01:14:44 PM', '20210828029', '02546', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '350.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2544', '2021-08-28', '01:16:30 PM', '20210828030', '02547', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2545', '2021-08-28', '01:18:20 PM', '20210828031', '02548', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '0.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2546', '2021-08-28', '01:27:02 PM', '20210828032', '02549', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2547', '2021-08-28', '01:30:13 PM', '20210828033', '02550', 'diagnosis', 'diagnosis', '2100.00', '0', '0.00', '2100.00', '0.00', 'Flat', '2100.00', '500.00', '0.00', '1600.00', '500.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2548', '2021-08-28', '01:31:26 PM', '20210828034', '02551', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '0.00', 'Flat', '900.00', '500.00', '0.00', '400.00', '500.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2549', '2021-08-28', '01:34:40 PM', '20210828035', '02552', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '400.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2550', '2021-08-28', '01:36:19 PM', '20210828036', '02553', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2551', '2021-08-28', '01:39:15 PM', '20210828037', '02554', 'diagnosis', 'diagnosis', '1850.00', '0', '0.00', '1850.00', '450.00', 'Flat', '1400.00', '1400.00', '0.00', '0.00', '1400.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2552', '2021-08-28', '01:41:56 PM', '20210828038', '02555', 'diagnosis', 'diagnosis', '1250.00', '0', '0.00', '1250.00', '0.00', 'Flat', '1250.00', '0.00', '0.00', '1250.00', '0.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2553', '2021-08-28', '01:43:40 PM', '20210828039', '02556', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '200.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2554', '2021-08-28', '01:45:40 PM', '20210828040', '02557', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2555', '2021-08-28', '01:47:24 PM', '20210828041', '02558', 'diagnosis', 'diagnosis', '1100.00', '0', '0.00', '1100.00', '300.00', 'Flat', '800.00', '500.00', '0.00', '300.00', '500.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2556', '2021-08-28', '01:50:07 PM', '20210828042', '02559', 'diagnosis', 'diagnosis', '450.00', '0', '0.00', '450.00', '250.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2557', '2021-08-28', '01:51:14 PM', '20210828043', '02560', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '300.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2558', '2021-08-28', '01:52:29 PM', '20210828044', '02561', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '450.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2559', '2021-08-28', '02:00:23 PM', '20210828045', '02562', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '0.00', 'Flat', '900.00', '500.00', '0.00', '400.00', '500.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2560', '2021-08-28', '02:10:00 PM', '20210828046', '02563', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2561', '2021-08-28', '02:13:42 PM', '20210828047', '02564', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2562', '2021-08-28', '02:30:50 PM', '20210828048', '02565', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '400.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2563', '2021-08-28', '02:33:58 PM', '20210828049', '02566', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '600.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2564', '2021-08-28', '02:35:31 PM', '20210828050', '02567', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2565', '2021-08-28', '02:36:23 PM', '20210828051', '02568', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2566', '2021-08-28', '02:41:52 PM', '20210828052', '02569', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '400.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2567', '2021-08-28', '02:48:47 PM', '20210828053', '02570', 'diagnosis', 'diagnosis', '1100.00', '0', '0.00', '1100.00', '0.00', 'Flat', '1100.00', '400.00', '0.00', '700.00', '400.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2568', '2021-08-28', '02:50:23 PM', '20210828054', '02571', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '700.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2569', '2021-08-28', '02:52:02 PM', '20210828055', '02572', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2570', '2021-08-28', '02:58:19 PM', '20210828056', '02573', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '400.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2571', '2021-08-28', '03:00:01 PM', '20210828057', '02574', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '0.00', 'Flat', '800.00', '0.00', '0.00', '800.00', '0.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2572', '2021-08-28', '03:42:19 PM', '20210828058', '02575', 'diagnosis', 'diagnosis', '450.00', '0', '0.00', '450.00', '150.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2573', '2021-08-28', '03:46:14 PM', '20210828059', '02576', 'diagnosis', 'diagnosis', '2200.00', '0', '0.00', '2200.00', '800.00', 'Flat', '1400.00', '1400.00', '0.00', '0.00', '1400.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2574', '2021-08-28', '03:48:47 PM', '20210828060', '02577', 'diagnosis', 'diagnosis', '1250.00', '0', '0.00', '1250.00', '250.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2575', '2021-08-28', '03:55:16 PM', '20210828061', '02578', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2576', '2021-08-28', '03:56:04 PM', '20210828062', '02579', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1450.00', '0.00', 'Flat', '1450.00', '700.00', '0.00', '750.00', '700.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2577', '2021-08-28', '04:07:44 PM', '20210828063', '02580', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2578', '2021-08-28', '04:11:11 PM', '20210828064', '02581', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2579', '2021-08-28', '04:13:15 PM', '20210828065', '02582', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2580', '2021-08-28', '04:15:21 PM', '20210828066', '02583', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '800.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2581', '2021-08-28', '04:17:11 PM', '20210828067', '02584', 'diagnosis', 'diagnosis', '1900.00', '0', '0.00', '1900.00', '1000.00', 'Flat', '900.00', '500.00', '0.00', '400.00', '500.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2582', '2021-08-28', '04:23:15 PM', '20210828068', '02585', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2583', '2021-08-28', '04:29:18 PM', '20210828069', '02586', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '200.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2584', '2021-08-28', '04:32:08 PM', '20210828070', '02587', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2585', '2021-08-28', '04:36:29 PM', '20210828071', '02588', 'diagnosis', 'diagnosis', '1400.00', '0', '0.00', '1400.00', '700.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2586', '2021-08-28', '04:42:19 PM', '20210828072', '02589', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2587', '2021-08-28', '04:44:12 PM', '20210828073', '02590', 'diagnosis', 'diagnosis', '2050.00', '0', '0.00', '2050.00', '0.00', 'Flat', '2050.00', '400.00', '0.00', '1650.00', '400.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2588', '2021-08-28', '04:52:45 PM', '20210828074', '02591', 'diagnosis', 'diagnosis', '200.00', '0', '0.00', '200.00', '200.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2589', '2021-08-28', '04:57:47 PM', '20210828075', '02592', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '150.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2590', '2021-08-28', '05:02:18 PM', '20210828076', '02593', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '200.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2591', '2021-08-28', '05:05:55 PM', '20210828077', '02594', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '150.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2592', '2021-08-28', '05:07:27 PM', '20210828078', '02595', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '200.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2593', '2021-08-28', '05:24:42 PM', '20210828079', '02596', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '400.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2594', '2021-08-28', '05:58:03 PM', '20210828080', '02597', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '300.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2595', '2021-08-28', '05:59:40 PM', '20210828081', '02598', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '0.00', '150.00', '2021-08-28', 'pending', '', '15', '', 'diagnosis', '2021-08-28 08:00 PM'), 
('2596', '2021-08-29', '09:58:38 AM', '20210829001', '02599', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2597', '2021-08-29', '10:12:11 AM', '20210829002', '02600', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '50.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2598', '2021-08-29', '10:46:20 AM', '20210829003', '02601', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2599', '2021-08-29', '10:52:55 AM', '20210829004', '02602', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '0.00', 'Flat', '550.00', '200.00', '0.00', '350.00', '200.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2600', '2021-08-29', '10:56:45 AM', '20210829005', '02603', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '200.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2601', '2021-08-29', '11:11:40 AM', '20210829006', '02604', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2602', '2021-08-29', '11:22:08 AM', '20210829007', '02605', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2603', '2021-08-29', '11:27:52 AM', '20210829008', '02606', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '50.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2604', '2021-08-29', '11:30:26 AM', '20210829009', '02607', 'diagnosis', 'diagnosis', '1650.00', '0', '0.00', '1650.00', '50.00', 'Flat', '1600.00', '1600.00', '0.00', '0.00', '1600.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2605', '2021-08-29', '11:31:55 AM', '20210829010', '02608', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '0.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1500.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2606', '2021-08-29', '11:33:32 AM', '20210829011', '02609', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '100.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2607', '2021-08-29', '11:36:42 AM', '20210829012', '02610', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '400.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2608', '2021-08-29', '11:39:43 AM', '20210829013', '02611', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '100.00', 'Flat', '850.00', '850.00', '0.00', '0.00', '850.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2609', '2021-08-29', '11:43:43 AM', '20210829014', '02612', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '150.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2610', '2021-08-29', '11:45:32 AM', '20210829015', '02613', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2611', '2021-08-29', '11:47:12 AM', '20210829016', '02614', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '500.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2612', '2021-08-29', '11:51:23 AM', '20210829017', '02615', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2613', '2021-08-29', '11:52:37 AM', '20210829018', '02616', 'diagnosis', 'diagnosis', '1850.00', '0', '0.00', '1850.00', '450.00', 'Flat', '1400.00', '1400.00', '0.00', '0.00', '1400.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2614', '2021-08-29', '11:54:10 AM', '20210829019', '02617', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2615', '2021-08-29', '11:56:19 AM', '20210829020', '02618', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '200.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2616', '2021-08-29', '11:59:07 AM', '20210829021', '02619', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1450.00', '250.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2617', '2021-08-29', '12:00:30 PM', '20210829022', '02620', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2618', '2021-08-29', '12:02:05 PM', '20210829023', '02621', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '400.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2619', '2021-08-29', '12:03:58 PM', '20210829024', '02622', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2620', '2021-08-29', '12:05:41 PM', '20210829025', '02623', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '500.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2621', '2021-08-29', '12:08:13 PM', '20210829026', '02624', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2622', '2021-08-29', '12:17:37 PM', '20210829027', '02625', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '450.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2623', '2021-08-29', '12:19:28 PM', '20210829028', '02626', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2624', '2021-08-29', '12:21:42 PM', '20210829029', '02627', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2625', '2021-08-29', '12:31:17 PM', '20210829030', '02628', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2626', '2021-08-29', '12:46:07 PM', '20210829031', '02629', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '250.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2627', '2021-08-29', '12:48:00 PM', '20210829032', '02630', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2628', '2021-08-29', '01:02:35 PM', '20210829033', '02631', 'diagnosis', 'diagnosis', '3850.00', '0', '0.00', '3850.00', '0.00', 'Flat', '3850.00', '0.00', '0.00', '3850.00', '0.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2629', '2021-08-29', '01:05:04 PM', '20210829034', '02632', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2630', '2021-08-29', '01:07:20 PM', '20210829035', '02633', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '250.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2631', '2021-08-29', '01:11:32 PM', '20210829036', '02634', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2632', '2021-08-29', '01:12:27 PM', '20210829037', '02635', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2633', '2021-08-29', '01:13:33 PM', '20210829038', '02636', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '50.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2634', '2021-08-29', '01:15:51 PM', '20210829039', '02637', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '400.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2635', '2021-08-29', '01:20:17 PM', '20210829040', '02638', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2636', '2021-08-29', '01:57:59 PM', '20210829041', '02639', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2637', '2021-08-29', '02:49:55 PM', '20210829042', '02640', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2638', '2021-08-29', '02:51:42 PM', '20210829043', '02641', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '600.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2639', '2021-08-29', '03:20:54 PM', '20210829044', '02642', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2640', '2021-08-29', '03:43:36 PM', '20210829045', '02643', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2641', '2021-08-29', '03:46:20 PM', '20210829046', '02644', 'diagnosis', 'diagnosis', '2200.00', '0', '0.00', '2200.00', '500.00', 'Flat', '1700.00', '1700.00', '0.00', '0.00', '1700.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2642', '2021-08-29', '03:48:22 PM', '20210829047', '02645', 'diagnosis', 'diagnosis', '1650.00', '0', '0.00', '1650.00', '150.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1500.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2643', '2021-08-29', '03:49:42 PM', '20210829048', '02646', 'diagnosis', 'diagnosis', '1800.00', '0', '0.00', '1800.00', '0.00', 'Flat', '1800.00', '500.00', '0.00', '1300.00', '500.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2644', '2021-08-29', '03:51:58 PM', '20210829049', '02647', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '600.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2645', '2021-08-29', '03:53:47 PM', '20210829050', '02648', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '0.00', 'Flat', '1050.00', '300.00', '0.00', '750.00', '300.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2646', '2021-08-29', '03:57:01 PM', '20210829051', '02649', 'diagnosis', 'diagnosis', '1750.00', '0', '0.00', '1750.00', '350.00', 'Flat', '1400.00', '1400.00', '0.00', '0.00', '1400.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2647', '2021-08-29', '03:58:45 PM', '20210829052', '02650', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '0.00', 'Flat', '1300.00', '1000.00', '0.00', '300.00', '1000.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2648', '2021-08-29', '04:03:45 PM', '20210829053', '02651', 'diagnosis', 'diagnosis', '1650.00', '0', '0.00', '1650.00', '150.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1500.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2649', '2021-08-29', '04:04:37 PM', '20210829054', '02652', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2650', '2021-08-29', '04:05:42 PM', '20210829055', '02653', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '300.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2651', '2021-08-29', '04:07:03 PM', '20210829056', '02654', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2652', '2021-08-29', '04:09:09 PM', '20210829057', '02655', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '470.00', 'Flat', '180.00', '180.00', '0.00', '0.00', '180.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2653', '2021-08-29', '04:11:44 PM', '20210829058', '02656', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2654', '2021-08-29', '04:13:24 PM', '20210829059', '02657', 'diagnosis', 'diagnosis', '2250.00', '0', '0.00', '2250.00', '750.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1500.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2655', '2021-08-29', '04:16:34 PM', '20210829060', '02658', 'diagnosis', 'diagnosis', '2000.00', '0', '0.00', '2000.00', '500.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1500.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2656', '2021-08-29', '04:18:39 PM', '20210829061', '02659', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '350.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2657', '2021-08-29', '04:22:06 PM', '20210829062', '02660', 'diagnosis', 'diagnosis', '750.00', '0', '0.00', '750.00', '0.00', 'Flat', '750.00', '0.00', '0.00', '750.00', '0.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2658', '2021-08-29', '04:29:50 PM', '20210829063', '02661', 'diagnosis', 'diagnosis', '1800.00', '0', '0.00', '1800.00', '300.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1500.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2659', '2021-08-29', '04:32:32 PM', '20210829064', '02662', 'diagnosis', 'diagnosis', '2250.00', '0', '0.00', '2250.00', '350.00', 'Flat', '1900.00', '1900.00', '0.00', '0.00', '1900.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2660', '2021-08-29', '04:33:29 PM', '20210829065', '02663', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '300.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2661', '2021-08-29', '04:35:08 PM', '20210829066', '02664', 'diagnosis', 'diagnosis', '1400.00', '0', '0.00', '1400.00', '200.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2662', '2021-08-29', '04:37:14 PM', '20210829067', '02665', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2663', '2021-08-29', '04:38:52 PM', '20210829068', '02666', 'diagnosis', 'diagnosis', '2250.00', '0', '0.00', '2250.00', '0.00', 'Flat', '2250.00', '1000.00', '0.00', '1250.00', '1000.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2664', '2021-08-29', '04:47:43 PM', '20210829069', '02667', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '0.00', '150.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2665', '2021-08-29', '04:59:15 PM', '20210829070', '02668', 'diagnosis', 'diagnosis', '2550.00', '0', '0.00', '2550.00', '0.00', 'Flat', '2550.00', '2100.00', '0.00', '450.00', '2100.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2666', '2021-08-29', '05:03:04 PM', '20210829071', '02669', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '150.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2667', '2021-08-29', '05:04:53 PM', '20210829072', '02670', 'diagnosis', 'diagnosis', '600.00', '0', '0.00', '600.00', '0.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2668', '2021-08-29', '05:08:40 PM', '20210829073', '02671', 'diagnosis', 'diagnosis', '750.00', '0', '0.00', '600.00', '100.00', 'Flat', '650.00', '650.00', '150.00', '0.00', '650.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2669', '2021-08-29', '05:15:37 PM', '20210829074', '02672', 'diagnosis', 'diagnosis', '600.00', '0', '0.00', '600.00', '100.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2670', '2021-08-29', '05:18:50 PM', '20210829075', '02673', 'diagnosis', 'diagnosis', '2850.00', '0', '0.00', '2650.00', '1000.00', 'Flat', '1850.00', '0.00', '200.00', '1850.00', '0.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2671', '2021-08-29', '05:21:36 PM', '20210829076', '02674', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '0.00', 'Flat', '900.00', '0.00', '0.00', '900.00', '0.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2672', '2021-08-29', '05:23:21 PM', '20210829077', '02675', 'diagnosis', 'diagnosis', '1400.00', '0', '0.00', '1400.00', '0.00', 'Flat', '1400.00', '0.00', '0.00', '1400.00', '0.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2673', '2021-08-29', '05:25:56 PM', '20210829078', '02676', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '0.00', '0.00', '400.00', '0.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2674', '2021-08-29', '05:27:50 PM', '20210829079', '02677', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '200.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2675', '2021-08-29', '05:29:59 PM', '20210829080', '02678', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1450.00', '250.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2676', '2021-08-29', '05:32:13 PM', '20210829081', '02679', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '300.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2677', '2021-08-29', '05:36:37 PM', '20210829082', '02680', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1450.00', '250.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2678', '2021-08-29', '05:38:59 PM', '20210829083', '02681', 'diagnosis', 'diagnosis', '2700.00', '0', '0.00', '2700.00', '0.00', 'Flat', '2700.00', '500.00', '0.00', '2200.00', '500.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2679', '2021-08-29', '05:38:59 PM', '20210829084', '02682', 'diagnosis', 'diagnosis', '2700.00', '0', '0.00', '2700.00', '0.00', 'Flat', '2700.00', '500.00', '0.00', '2200.00', '500.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2680', '2021-08-29', '05:41:46 PM', '20210829085', '02683', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '600.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2681', '2021-08-29', '05:46:11 PM', '20210829086', '02684', 'diagnosis', 'diagnosis', '2250.00', '0', '0.00', '2250.00', '0.00', 'Flat', '2250.00', '1500.00', '0.00', '750.00', '1500.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2682', '2021-08-29', '05:49:21 PM', '20210829087', '02685', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '50.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2683', '2021-08-29', '05:50:39 PM', '20210829088', '02686', 'diagnosis', 'diagnosis', '750.00', '0', '0.00', '750.00', '0.00', 'Flat', '750.00', '0.00', '0.00', '750.00', '0.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2684', '2021-08-29', '05:58:42 PM', '20210829089', '02687', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '200.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2685', '2021-08-29', '06:11:27 PM', '20210829090', '02688', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '0.00', 'Flat', '1350.00', '500.00', '0.00', '850.00', '500.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2686', '2021-08-29', '06:15:30 PM', '20210829091', '02689', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '0.00', 'Flat', '900.00', '500.00', '0.00', '400.00', '500.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2687', '2021-08-29', '06:37:54 PM', '20210829092', '02690', 'diagnosis', 'diagnosis', '350.00', '0', '0.00', '350.00', '250.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2688', '2021-08-29', '06:41:31 PM', '20210829093', '02691', 'diagnosis', 'diagnosis', '350.00', '0', '0.00', '350.00', '100.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2689', '2021-08-29', '06:51:50 PM', '20210829094', '02692', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '200.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2690', '2021-08-29', '07:07:36 PM', '20210829095', '02693', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '150.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2691', '2021-08-29', '07:08:24 PM', '20210829096', '02694', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '150.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2692', '2021-08-29', '07:25:57 PM', '20210829097', '02695', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '600.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-08-29', 'pending', '', '15', '', 'diagnosis', '2021-08-29 08:00 PM'), 
('2693', '2021-08-30', '10:31:29 AM', '20210830001', '02696', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-30', 'pending', '', '15', '', 'diagnosis', '2021-08-30 08:00 PM'), 
('2694', '2021-08-30', '10:45:24 AM', '20210830002', '02697', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-30', 'pending', '', '15', '', 'diagnosis', '2021-08-30 08:00 PM'), 
('2695', '2021-08-30', '11:05:22 AM', '20210830003', '02698', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-30', 'pending', '', '15', '', 'diagnosis', '2021-08-30 08:00 PM'), 
('2696', '2021-08-30', '11:06:44 AM', '20210830004', '02699', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '550.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-30', 'pending', '', '15', '', 'diagnosis', '2021-08-30 08:00 PM'), 
('2697', '2021-08-30', '11:11:29 AM', '20210830005', '02700', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '250.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-30', 'pending', '', '15', '', 'diagnosis', '2021-08-30 08:00 PM'), 
('2698', '2021-08-30', '11:17:12 AM', '20210830006', '02701', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '350.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-30', 'pending', '', '15', '', 'diagnosis', '2021-08-30 08:00 PM'), 
('2699', '2021-08-30', '11:18:31 AM', '20210830007', '02702', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '0.00', 'Flat', '1500.00', '500.00', '0.00', '1000.00', '500.00', '2021-08-30', 'pending', '', '15', '', 'diagnosis', '2021-08-30 08:00 PM'), 
('2700', '2021-08-30', '11:23:14 AM', '20210830008', '02703', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-30', 'pending', '', '15', '', 'diagnosis', '2021-08-30 08:00 PM'), 
('2701', '2021-08-30', '11:26:26 AM', '20210830009', '02704', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '0.00', 'Flat', '550.00', '0.00', '0.00', '550.00', '0.00', '2021-08-30', 'pending', '', '15', '', 'diagnosis', '2021-08-30 08:00 PM'), 
('2702', '2021-08-30', '11:29:48 AM', '20210830010', '02705', 'diagnosis', 'diagnosis', '1600.00', '0', '0.00', '1600.00', '200.00', 'Flat', '1400.00', '1300.00', '0.00', '100.00', '1300.00', '2021-08-30', 'pending', '', '15', '', 'diagnosis', '2021-08-30 08:00 PM'), 
('2703', '2021-08-30', '11:35:49 AM', '20210830011', '02706', 'diagnosis', 'diagnosis', '1400.00', '0', '0.00', '1400.00', '300.00', 'Flat', '1100.00', '1100.00', '0.00', '0.00', '1100.00', '2021-08-30', 'pending', '', '15', '', 'diagnosis', '2021-08-30 08:00 PM'), 
('2704', '2021-08-30', '11:52:14 AM', '20210830012', '02707', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-30', 'pending', '', '15', '', 'diagnosis', '2021-08-30 08:00 PM'), 
('2705', '2021-08-30', '11:52:58 AM', '20210830013', '02708', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-30', 'pending', '', '15', '', 'diagnosis', '2021-08-30 08:00 PM'), 
('2706', '2021-08-30', '11:54:03 AM', '20210830014', '02709', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-30', 'pending', '', '15', '', 'diagnosis', '2021-08-30 08:00 PM'), 
('2707', '2021-08-30', '11:55:34 AM', '20210830015', '02710', 'diagnosis', 'diagnosis', '1850.00', '0', '0.00', '1850.00', '450.00', 'Flat', '1400.00', '1400.00', '0.00', '0.00', '1400.00', '2021-08-30', 'pending', '', '15', '', 'diagnosis', '2021-08-30 08:00 PM'), 
('2708', '2021-08-30', '11:56:39 AM', '20210830016', '02711', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '250.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-30', 'pending', '', '15', '', 'diagnosis', '2021-08-30 08:00 PM'), 
('2709', '2021-08-30', '12:02:07 PM', '20210830017', '02712', 'diagnosis', 'diagnosis', '1850.00', '0', '0.00', '1850.00', '450.00', 'Flat', '1400.00', '1300.00', '0.00', '100.00', '1300.00', '2021-08-30', 'pending', '', '15', 'Dr. Farhana Yaemin MBBS,FCPS,CMU', 'diagnosis', '2021-08-30 08:00 PM'), 
('2710', '2021-08-30', '12:27:38 PM', '20210830018', '02713', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-30', 'pending', '', '15', '', 'diagnosis', '2021-08-30 08:00 PM'), 
('2711', '2021-08-30', '12:48:51 PM', '20210830019', '02714', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '200.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-08-30', 'pending', '', '15', '', 'diagnosis', '2021-08-30 08:00 PM'), 
('2712', '2021-08-30', '12:57:22 PM', '20210830020', '02715', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-30', 'pending', '', '15', '', 'diagnosis', '2021-08-30 08:00 PM'), 
('2713', '2021-08-30', '01:01:50 PM', '20210830021', '02716', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-30', 'pending', '', '15', '', 'diagnosis', '2021-08-30 08:00 PM'), 
('2714', '2021-08-30', '01:03:37 PM', '20210830022', '02717', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '0.00', 'Flat', '700.00', '0.00', '0.00', '700.00', '0.00', '2021-08-30', 'pending', '', '15', '', 'diagnosis', '2021-08-30 08:00 PM'), 
('2715', '2021-08-30', '01:05:19 PM', '20210830023', '02718', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '200.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-30', 'pending', '', '15', '', 'diagnosis', '2021-08-30 08:00 PM'), 
('2716', '2021-08-30', '01:09:27 PM', '20210830024', '02719', 'diagnosis', 'diagnosis', '1550.00', '0', '0.00', '1550.00', '350.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-08-30', 'pending', '', '15', '', 'diagnosis', '2021-08-30 08:00 PM'), 
('2717', '2021-08-30', '01:12:30 PM', '20210830025', '02720', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '250.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-30', 'pending', '', '15', '', 'diagnosis', '2021-08-30 08:00 PM'), 
('2718', '2021-08-30', '01:18:27 PM', '20210830026', '02721', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '350.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-08-30', 'pending', '', '15', '', 'diagnosis', '2021-08-30 08:00 PM'), 
('2719', '2021-08-30', '01:20:24 PM', '20210830027', '02722', 'diagnosis', 'diagnosis', '1100.00', '0', '0.00', '1100.00', '700.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-30', 'pending', '', '15', '', 'diagnosis', '2021-08-30 08:00 PM'), 
('2720', '2021-08-30', '01:22:17 PM', '20210830028', '02723', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-30', 'pending', '', '15', '', 'diagnosis', '2021-08-30 08:00 PM'), 
('2721', '2021-08-30', '01:35:13 PM', '20210830029', '02724', 'diagnosis', 'diagnosis', '1800.00', '0', '0.00', '1800.00', '300.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1500.00', '2021-08-30', 'pending', '', '15', '', 'diagnosis', '2021-08-30 08:00 PM'), 
('2722', '2021-08-30', '01:43:57 PM', '20210830030', '02725', 'diagnosis', 'diagnosis', '1100.00', '0', '0.00', '1100.00', '600.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-30', 'pending', '', '15', '', 'diagnosis', '2021-08-30 08:00 PM'), 
('2723', '2021-08-30', '01:52:59 PM', '20210830031', '02726', 'diagnosis', 'diagnosis', '1750.00', '0', '0.00', '1750.00', '550.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-08-30', 'pending', '', '15', '', 'diagnosis', '2021-08-30 08:00 PM'), 
('2724', '2021-08-30', '01:55:48 PM', '20210830032', '02727', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-30', 'pending', '', '15', '', 'diagnosis', '2021-08-30 08:00 PM'), 
('2725', '2021-08-30', '02:20:37 PM', '20210830033', '02728', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-30', 'pending', '', '15', '', 'diagnosis', '2021-08-30 08:00 PM'), 
('2726', '2021-08-30', '02:32:54 PM', '20210830034', '02729', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '350.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-08-30', 'pending', '', '15', '', 'diagnosis', '2021-08-30 08:00 PM'), 
('2727', '2021-08-30', '02:56:58 PM', '20210830035', '02730', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '0.00', '150.00', '2021-08-30', 'pending', '', '15', '', 'diagnosis', '2021-08-30 08:00 PM'), 
('2728', '2021-08-30', '03:35:08 PM', '20210830036', '02731', 'diagnosis', 'diagnosis', '1150.00', '0', '0.00', '1150.00', '300.00', 'Flat', '850.00', '850.00', '0.00', '0.00', '850.00', '2021-08-30', 'pending', '', '15', '', 'diagnosis', '2021-08-30 08:00 PM'), 
('2729', '2021-08-30', '03:37:06 PM', '20210830037', '02732', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-30', 'pending', '', '15', '', 'diagnosis', '2021-08-30 08:00 PM'), 
('2730', '2021-08-30', '03:43:44 PM', '20210830038', '02733', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '300.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-30', 'pending', '', '15', '', 'diagnosis', '2021-08-30 08:00 PM'), 
('2731', '2021-08-30', '04:00:35 PM', '20210830039', '02734', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1450.00', '450.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-08-30', 'pending', '', '15', '', 'diagnosis', '2021-08-30 08:00 PM'), 
('2732', '2021-08-30', '04:10:30 PM', '20210830040', '02735', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '100.00', '0.00', '300.00', '100.00', '2021-08-30', 'pending', '', '15', '', 'diagnosis', '2021-08-30 08:00 PM'), 
('2733', '2021-08-30', '04:35:27 PM', '20210830041', '02736', 'diagnosis', 'diagnosis', '1400.00', '0', '0.00', '1400.00', '700.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-30', 'pending', '', '15', '', 'diagnosis', '2021-08-30 08:00 PM'), 
('2734', '2021-08-30', '04:43:07 PM', '20210830042', '02737', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '0.00', 'Flat', '650.00', '0.00', '0.00', '650.00', '0.00', '2021-08-30', 'pending', '', '15', '', 'diagnosis', '2021-08-30 08:00 PM'), 
('2735', '2021-08-30', '05:20:44 PM', '20210830043', '02738', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '200.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-30', 'pending', '', '15', '', 'diagnosis', '2021-08-30 08:00 PM'), 
('2736', '2021-08-30', '06:17:58 PM', '20210830044', '02739', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-30', 'pending', '', '15', '', 'diagnosis', '2021-08-30 08:00 PM'), 
('2737', '2021-08-31', '09:53:23 AM', '20210831001', '02740', 'diagnosis', 'diagnosis', '500.00', '0', '0.00', '500.00', '200.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2738', '2021-08-31', '09:56:43 AM', '20210831002', '02741', 'diagnosis', 'diagnosis', '1400.00', '0', '0.00', '1400.00', '600.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2739', '2021-08-31', '09:58:07 AM', '20210831003', '02742', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '200.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2740', '2021-08-31', '10:15:16 AM', '20210831004', '02743', 'diagnosis', 'diagnosis', '450.00', '0', '0.00', '450.00', '250.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2741', '2021-08-31', '10:19:01 AM', '20210831005', '02744', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2742', '2021-08-31', '10:22:08 AM', '20210831006', '02745', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2743', '2021-08-31', '10:27:04 AM', '20210831007', '02746', 'diagnosis', 'diagnosis', '2750.00', '0', '0.00', '2750.00', '0.00', 'Flat', '2750.00', '1000.00', '0.00', '1750.00', '1000.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2744', '2021-08-31', '10:30:43 AM', '20210831008', '02747', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2745', '2021-08-31', '10:38:27 AM', '20210831009', '02748', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2746', '2021-08-31', '11:06:25 AM', '20210831010', '02749', 'diagnosis', 'diagnosis', '3100.00', '0', '0.00', '3100.00', '0.00', 'Flat', '3100.00', '0.00', '0.00', '3100.00', '0.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2747', '2021-08-31', '11:09:00 AM', '20210831011', '02750', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '50.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2748', '2021-08-31', '11:13:49 AM', '20210831012', '02751', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2749', '2021-08-31', '11:15:28 AM', '20210831013', '02752', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2750', '2021-08-31', '11:16:32 AM', '20210831014', '02753', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '0.00', 'Flat', '650.00', '0.00', '0.00', '650.00', '0.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2751', '2021-08-31', '11:23:09 AM', '20210831015', '02754', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2752', '2021-08-31', '11:28:58 AM', '20210831016', '02755', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2753', '2021-08-31', '11:30:45 AM', '20210831017', '02756', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2754', '2021-08-31', '11:59:20 AM', '20210831018', '02757', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2755', '2021-08-31', '12:03:09 PM', '20210831019', '02758', 'diagnosis', 'diagnosis', '1700.00', '0', '0.00', '1700.00', '200.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1500.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2756', '2021-08-31', '12:05:52 PM', '20210831020', '02759', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2757', '2021-08-31', '12:09:03 PM', '20210831021', '02760', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '350.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2758', '2021-08-31', '12:10:26 PM', '20210831022', '02761', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '200.00', 'Flat', '1300.00', '1300.00', '0.00', '0.00', '1300.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2759', '2021-08-31', '12:16:26 PM', '20210831023', '02762', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '0.00', 'Flat', '1350.00', '500.00', '0.00', '850.00', '500.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2760', '2021-08-31', '12:18:54 PM', '20210831024', '02763', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '300.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2761', '2021-08-31', '12:21:09 PM', '20210831025', '02764', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '700.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2762', '2021-08-31', '12:23:17 PM', '20210831026', '02765', 'diagnosis', 'diagnosis', '2250.00', '0', '0.00', '2250.00', '250.00', 'Flat', '2000.00', '500.00', '0.00', '1500.00', '500.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2763', '2021-08-31', '12:26:42 PM', '20210831027', '02766', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '200.00', 'Flat', '1300.00', '1300.00', '0.00', '0.00', '1300.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2764', '2021-08-31', '12:28:17 PM', '20210831028', '02767', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2765', '2021-08-31', '12:41:58 PM', '20210831029', '02768', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2766', '2021-08-31', '01:35:11 PM', '20210831030', '02769', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '0.00', 'Flat', '650.00', '300.00', '0.00', '350.00', '300.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2767', '2021-08-31', '01:55:34 PM', '20210831031', '02770', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '600.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2768', '2021-08-31', '01:58:30 PM', '20210831032', '02771', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '100.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2770', '2021-08-31', '02:03:14 PM', '20210831033', '02773', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2771', '2021-08-31', '02:13:05 PM', '20210831034', '02774', 'diagnosis', 'diagnosis', '1650.00', '0', '0.00', '1650.00', '0.00', 'Flat', '1650.00', '1200.00', '0.00', '450.00', '1200.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2772', '2021-08-31', '02:54:40 PM', '20210831035', '02775', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '1000.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2773', '2021-08-31', '03:03:21 PM', '20210831036', '02776', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '150.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2774', '2021-08-31', '03:05:28 PM', '20210831037', '02777', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '300.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2776', '2021-08-31', '03:58:41 PM', '20210831039', '02779', 'diagnosis', 'diagnosis', '2400.00', '0', '0.00', '2400.00', '400.00', 'Flat', '2000.00', '2000.00', '0.00', '0.00', '2000.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2777', '2021-08-31', '04:00:30 PM', '20210831040', '02780', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '300.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2778', '2021-08-31', '04:05:57 PM', '20210831038', '02781', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2779', '2021-08-31', '04:13:54 PM', '20210831041', '02782', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2780', '2021-08-31', '04:19:31 PM', '20210831042', '02783', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '100.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2781', '2021-08-31', '04:21:15 PM', '20210831043', '02784', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2782', '2021-08-31', '04:23:09 PM', '20210831044', '02785', 'diagnosis', 'diagnosis', '2550.00', '0', '0.00', '2550.00', '550.00', 'Flat', '2000.00', '2000.00', '0.00', '0.00', '2000.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2783', '2021-08-31', '04:24:17 PM', '20210831045', '02786', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2784', '2021-08-31', '04:33:01 PM', '20210831046', '02787', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '400.00', '0.00', 'Flat', '800.00', '800.00', '400.00', '0.00', '800.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2785', '2021-08-31', '04:33:38 PM', '20210831047', '02788', 'diagnosis', 'diagnosis', '2800.00', '0', '0.00', '2800.00', '600.00', 'Flat', '2200.00', '2200.00', '0.00', '0.00', '2200.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2786', '2021-08-31', '04:37:27 PM', '20210831048', '02789', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2787', '2021-08-31', '04:39:04 PM', '20210831049', '02790', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1450.00', '250.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2788', '2021-08-31', '04:40:06 PM', '20210831050', '02791', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2789', '2021-08-31', '04:40:49 PM', '20210831051', '02792', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2790', '2021-08-31', '04:41:28 PM', '20210831052', '02793', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2792', '2021-08-31', '04:47:12 PM', '20210831053', '02795', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2793', '2021-08-31', '04:48:01 PM', '20210831054', '02796', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '200.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2794', '2021-08-31', '05:01:32 PM', '20210831055', '02797', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2795', '2021-08-31', '05:10:32 PM', '20210831056', '02798', 'diagnosis', 'diagnosis', '500.00', '0', '0.00', '500.00', '200.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2796', '2021-08-31', '05:14:47 PM', '20210831057', '02799', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2797', '2021-08-31', '05:22:30 PM', '20210831058', '02800', 'diagnosis', 'diagnosis', '2000.00', '0', '0.00', '2000.00', '0.00', 'Flat', '2000.00', '400.00', '0.00', '1600.00', '400.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2798', '2021-08-31', '05:27:00 PM', '20210831059', '02801', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2799', '2021-08-31', '05:29:55 PM', '20210831060', '02802', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2800', '2021-08-31', '05:40:03 PM', '20210831061', '02803', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2801', '2021-08-31', '05:43:20 PM', '20210831062', '02804', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '400.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2802', '2021-08-31', '05:45:25 PM', '20210831063', '02805', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '300.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2803', '2021-08-31', '06:06:47 PM', '20210831064', '02806', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '400.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2804', '2021-08-31', '06:09:01 PM', '20210831065', '02807', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2805', '2021-08-31', '06:27:41 PM', '20210831066', '02808', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '300.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2806', '2021-08-31', '06:29:35 PM', '20210831067', '02809', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '300.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2807', '2021-08-31', '06:51:34 PM', '20210831068', '02810', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '400.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2808', '2021-08-31', '07:04:18 PM', '20210831069', '02811', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '300.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2809', '2021-08-31', '07:18:15 PM', '20210831070', '02812', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '0.00', 'Flat', '1000.00', '0.00', '0.00', '1000.00', '0.00', '2021-08-31', 'pending', '', '15', '', 'diagnosis', '2021-08-31 08:00 PM'), 
('2810', '2021-09-01', '09:55:26 AM', '20210901001', '02813', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2811', '2021-09-01', '10:27:53 AM', '20210901002', '02814', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '0.00', 'Flat', '300.00', '0.00', '0.00', '300.00', '0.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2812', '2021-09-01', '10:37:58 AM', '20210901003', '02815', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2813', '2021-09-01', '10:40:14 AM', '20210901004', '02816', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2814', '2021-09-01', '10:45:50 AM', '20210901005', '02817', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2815', '2021-09-01', '10:56:10 AM', '20210901006', '02818', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2816', '2021-09-01', '10:57:57 AM', '20210901007', '02819', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2817', '2021-09-01', '11:00:45 AM', '20210901008', '02820', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '50.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2818', '2021-09-01', '11:05:58 AM', '20210901009', '02821', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '50.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2819', '2021-09-01', '11:21:56 AM', '20210901010', '02822', 'diagnosis', 'diagnosis', '1900.00', '0', '0.00', '1900.00', '0.00', 'Flat', '1900.00', '1000.00', '0.00', '900.00', '1000.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2820', '2021-09-01', '11:24:37 AM', '20210901011', '02823', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2821', '2021-09-01', '11:37:44 AM', '20210901012', '02824', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2822', '2021-09-01', '11:41:59 AM', '20210901013', '02825', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '0.00', 'Flat', '1050.00', '0.00', '0.00', '1050.00', '0.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2823', '2021-09-01', '11:44:29 AM', '20210901014', '02826', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2824', '2021-09-01', '11:45:27 AM', '20210901015', '02827', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2825', '2021-09-01', '11:46:36 AM', '20210901016', '02828', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '300.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2826', '2021-09-01', '11:47:47 AM', '20210901017', '02829', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '300.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2827', '2021-09-01', '11:50:47 AM', '20210901018', '02830', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '350.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2828', '2021-09-01', '11:52:16 AM', '20210901019', '02831', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '400.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2829', '2021-09-01', '11:53:24 AM', '20210901020', '02832', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '600.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2830', '2021-09-01', '11:54:34 AM', '20210901021', '02833', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '30.00', 'Flat', '120.00', '120.00', '0.00', '0.00', '120.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2831', '2021-09-01', '11:56:40 AM', '20210901022', '02834', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '0.00', 'Flat', '650.00', '0.00', '0.00', '650.00', '0.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2832', '2021-09-01', '12:17:31 PM', '20210901023', '02835', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2833', '2021-09-01', '12:22:41 PM', '20210901024', '02836', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2834', '2021-09-01', '12:25:02 PM', '20210901025', '02837', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '450.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2835', '2021-09-01', '12:30:06 PM', '20210901026', '02838', 'diagnosis', 'diagnosis', '2620.00', '0', '0.00', '2600.00', '120.00', 'Flat', '2500.00', '2000.00', '20.00', '500.00', '2000.00', '2021-09-01', 'pending', '', '1001', 'tyuhtuyi', 'diagnosis', '2021-09-01 02:00 PM'), 
('2836', '2021-09-01', '12:56:48 PM', '20210901027', '02839', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '200.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2837', '2021-09-01', '12:59:27 PM', '20210901028', '02840', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2838', '2021-09-01', '01:17:12 PM', '20210901029', '02841', 'diagnosis', 'diagnosis', '600.00', '0', '0.00', '600.00', '300.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2839', '2021-09-01', '01:18:17 PM', '20210901030', '02842', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2840', '2021-09-01', '01:18:57 PM', '20210901031', '02843', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2841', '2021-09-01', '01:21:27 PM', '20210901032', '02844', 'diagnosis', 'diagnosis', '1800.00', '0', '0.00', '1800.00', '600.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2842', '2021-09-01', '01:40:01 PM', '20210901033', '02845', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2843', '2021-09-01', '01:57:06 PM', '20210901034', '02846', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '300.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2844', '2021-09-01', '01:59:27 PM', '20210901035', '02847', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2845', '2021-09-01', '02:07:14 PM', '20210901036', '02848', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '300.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2846', '2021-09-01', '02:09:40 PM', '20210901037', '02849', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '50.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2847', '2021-09-01', '02:30:37 PM', '20210901038', '02850', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2848', '2021-09-01', '02:33:24 PM', '20210901039', '02851', 'diagnosis', 'diagnosis', '450.00', '0', '0.00', '450.00', '350.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2849', '2021-09-01', '02:46:42 PM', '20210901040', '02852', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2850', '2021-09-01', '02:51:41 PM', '20210901041', '02853', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2851', '2021-09-01', '03:33:46 PM', '20210901042', '02854', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '0.00', 'Flat', '550.00', '0.00', '0.00', '550.00', '0.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2852', '2021-09-01', '03:52:20 PM', '20210901043', '02855', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1450.00', '250.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2853', '2021-09-01', '03:57:29 PM', '20210901044', '02856', 'diagnosis', 'diagnosis', '1550.00', '0', '0.00', '1550.00', '750.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2854', '2021-09-01', '03:58:51 PM', '20210901045', '02857', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '0.00', 'Flat', '1300.00', '0.00', '0.00', '1300.00', '0.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2855', '2021-09-01', '04:00:27 PM', '20210901046', '02858', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2856', '2021-09-01', '04:10:55 PM', '20210901047', '02859', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2857', '2021-09-01', '04:12:14 PM', '20210901048', '02860', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2858', '2021-09-01', '04:14:25 PM', '20210901049', '02861', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2859', '2021-09-01', '04:22:11 PM', '20210901050', '02862', 'diagnosis', 'diagnosis', '1150.00', '0', '0.00', '1150.00', '250.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2860', '2021-09-01', '04:28:08 PM', '20210901051', '02863', 'diagnosis', 'diagnosis', '2100.00', '0', '0.00', '2100.00', '300.00', 'Flat', '1800.00', '1800.00', '0.00', '0.00', '1800.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2861', '2021-09-01', '04:29:23 PM', '20210901052', '02864', 'diagnosis', 'diagnosis', '750.00', '0', '0.00', '750.00', '250.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2862', '2021-09-01', '04:32:07 PM', '20210901053', '02865', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '300.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2863', '2021-09-01', '04:33:18 PM', '20210901054', '02866', 'diagnosis', 'diagnosis', '2400.00', '0', '0.00', '2400.00', '400.00', 'Flat', '2000.00', '2000.00', '0.00', '0.00', '2000.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2864', '2021-09-01', '04:39:28 PM', '20210901055', '02867', 'diagnosis', 'diagnosis', '1700.00', '0', '0.00', '1700.00', '900.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2865', '2021-09-01', '04:48:56 PM', '20210901056', '02868', 'diagnosis', 'diagnosis', '1700.00', '0', '0.00', '1700.00', '400.00', 'Flat', '1300.00', '1300.00', '0.00', '0.00', '1300.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2866', '2021-09-01', '05:07:09 PM', '20210901057', '02869', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2867', '2021-09-01', '05:11:06 PM', '20210901058', '02870', 'diagnosis', 'diagnosis', '4500.00', '0', '0.00', '4500.00', '200.00', 'Flat', '4300.00', '4300.00', '0.00', '0.00', '4300.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2868', '2021-09-01', '05:15:23 PM', '20210901059', '02871', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2869', '2021-09-01', '05:25:13 PM', '20210901060', '02872', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2870', '2021-09-01', '05:48:35 PM', '20210901061', '02873', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '300.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2871', '2021-09-01', '06:06:04 PM', '20210901062', '02874', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2872', '2021-09-01', '06:09:13 PM', '20210901063', '02875', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '500.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2873', '2021-09-01', '06:11:11 PM', '20210901064', '02876', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2874', '2021-09-01', '06:38:25 PM', '20210901065', '02877', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-01', 'pending', '', '15', '', 'diagnosis', '2021-09-01 08:00 PM'), 
('2875', '2021-09-02', '10:10:02 AM', '20210902001', '02878', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2876', '2021-09-02', '11:00:17 AM', '20210902002', '02879', 'diagnosis', 'diagnosis', '1100.00', '0', '0.00', '1100.00', '1100.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2877', '2021-09-02', '11:10:31 AM', '20210902003', '02880', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2878', '2021-09-02', '11:22:43 AM', '20210902004', '02881', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '0.00', 'Flat', '800.00', '500.00', '0.00', '300.00', '500.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2879', '2021-09-02', '11:26:10 AM', '20210902005', '02882', 'diagnosis', 'diagnosis', '1250.00', '0', '0.00', '1250.00', '350.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2880', '2021-09-02', '11:27:24 AM', '20210902006', '02883', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '150.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2881', '2021-09-02', '11:33:33 AM', '20210902007', '02884', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '200.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2882', '2021-09-02', '11:34:42 AM', '20210902008', '02885', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '350.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2883', '2021-09-02', '11:36:02 AM', '20210902009', '02886', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '200.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2884', '2021-09-02', '11:37:14 AM', '20210902010', '02887', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '0.00', 'Flat', '650.00', '0.00', '0.00', '650.00', '0.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2885', '2021-09-02', '11:39:02 AM', '20210902011', '02888', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2886', '2021-09-02', '11:41:23 AM', '20210902012', '02889', 'diagnosis', 'diagnosis', '1900.00', '0', '0.00', '1900.00', '400.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1500.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2887', '2021-09-02', '11:42:49 AM', '20210902013', '02890', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '0.00', 'Flat', '300.00', '0.00', '0.00', '300.00', '0.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2888', '2021-09-02', '11:47:21 AM', '20210902014', '02891', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2889', '2021-09-02', '11:48:41 AM', '20210902015', '02892', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2890', '2021-09-02', '11:49:58 AM', '20210902016', '02893', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2891', '2021-09-02', '11:54:07 AM', '20210902017', '02894', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '0.00', 'Flat', '700.00', '0.00', '0.00', '700.00', '0.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2892', '2021-09-02', '11:56:31 AM', '20210902018', '02895', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '350.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2893', '2021-09-02', '12:02:53 PM', '20210902019', '02896', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2894', '2021-09-02', '12:03:41 PM', '20210902020', '02897', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2895', '2021-09-02', '12:06:00 PM', '20210902021', '02898', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2896', '2021-09-02', '12:22:42 PM', '20210902022', '02899', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2897', '2021-09-02', '12:52:23 PM', '20210902023', '02900', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2898', '2021-09-02', '01:26:51 PM', '20210902024', '02901', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '0.00', '150.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2899', '2021-09-02', '01:29:48 PM', '20210902025', '02902', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2900', '2021-09-02', '01:34:09 PM', '20210902026', '02903', 'diagnosis', 'diagnosis', '450.00', '0', '0.00', '150.00', '50.00', 'Flat', '400.00', '400.00', '300.00', '0.00', '400.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2901', '2021-09-02', '01:35:42 PM', '20210902027', '02904', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2902', '2021-09-02', '01:36:39 PM', '20210902028', '02905', 'diagnosis', 'diagnosis', '1150.00', '0', '0.00', '1150.00', '0.00', 'Flat', '1150.00', '500.00', '0.00', '650.00', '500.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2903', '2021-09-02', '01:50:05 PM', '20210902029', '02906', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '100.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2904', '2021-09-02', '01:59:14 PM', '20210902030', '02907', 'diagnosis', 'diagnosis', '1400.00', '0', '0.00', '1400.00', '700.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2905', '2021-09-02', '02:02:33 PM', '20210902031', '02908', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '300.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2906', '2021-09-02', '02:04:41 PM', '20210902032', '02909', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '400.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2907', '2021-09-02', '02:06:34 PM', '20210902033', '02910', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2908', '2021-09-02', '02:08:57 PM', '20210902034', '02911', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '500.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2909', '2021-09-02', '02:36:31 PM', '20210902035', '02912', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2910', '2021-09-02', '02:38:51 PM', '20210902036', '02913', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '250.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2911', '2021-09-02', '02:47:21 PM', '20210902037', '02914', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '250.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2912', '2021-09-02', '02:58:00 PM', '20210902038', '02915', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '300.00', 'Flat', '1200.00', '1000.00', '0.00', '200.00', '1000.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2913', '2021-09-02', '03:19:49 PM', '20210902039', '02916', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2914', '2021-09-02', '03:20:56 PM', '20210902040', '02917', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2915', '2021-09-02', '03:30:55 PM', '20210902041', '02918', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '150.00', 'Flat', '650.00', '650.00', '0.00', '0.00', '650.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2916', '2021-09-02', '03:32:44 PM', '20210902042', '02919', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '350.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2917', '2021-09-02', '03:38:52 PM', '20210902043', '02920', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '300.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2918', '2021-09-02', '03:39:30 PM', '20210902044', '02921', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '300.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2919', '2021-09-02', '03:41:32 PM', '20210902045', '02922', 'diagnosis', 'diagnosis', '2000.00', '0', '0.00', '2000.00', '500.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1500.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2920', '2021-09-02', '03:46:33 PM', '20210902046', '02923', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '450.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2921', '2021-09-02', '03:49:25 PM', '20210902047', '02924', 'diagnosis', 'diagnosis', '1600.00', '0', '0.00', '1600.00', '400.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2922', '2021-09-02', '03:51:57 PM', '20210902048', '02925', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2923', '2021-09-02', '03:58:09 PM', '20210902049', '02926', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '0.00', '0.00', '400.00', '0.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2924', '2021-09-02', '04:09:30 PM', '20210902050', '02927', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '250.00', 'Flat', '750.00', '750.00', '0.00', '0.00', '750.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2925', '2021-09-02', '04:16:33 PM', '20210902051', '02928', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '150.00', '100.00', 'Flat', '200.00', '200.00', '150.00', '0.00', '200.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2926', '2021-09-02', '04:19:59 PM', '20210902052', '02929', 'diagnosis', 'diagnosis', '1800.00', '0', '0.00', '1800.00', '600.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2927', '2021-09-02', '04:24:43 PM', '20210902053', '02930', 'diagnosis', 'diagnosis', '350.00', '0', '0.00', '350.00', '150.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2928', '2021-09-02', '04:26:53 PM', '20210902054', '02931', 'diagnosis', 'diagnosis', '1950.00', '0', '0.00', '1950.00', '0.00', 'Flat', '1950.00', '100.00', '0.00', '1850.00', '100.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2929', '2021-09-02', '04:30:58 PM', '20210902055', '02932', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2930', '2021-09-02', '04:44:59 PM', '20210902056', '02933', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2931', '2021-09-02', '04:47:14 PM', '20210902057', '02934', 'diagnosis', 'diagnosis', '1700.00', '0', '0.00', '1700.00', '500.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2932', '2021-09-02', '04:48:57 PM', '20210902058', '02935', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '30.00', 'Flat', '120.00', '120.00', '0.00', '0.00', '120.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2933', '2021-09-02', '04:55:54 PM', '20210902059', '02936', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '300.00', 'Flat', '700.00', '500.00', '0.00', '200.00', '500.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2934', '2021-09-02', '05:07:21 PM', '20210902060', '02937', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1000.00', '0.00', 'Flat', '1500.00', '0.00', '500.00', '1500.00', '0.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2935', '2021-09-02', '05:11:24 PM', '20210902061', '02938', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2936', '2021-09-02', '05:15:20 PM', '20210902062', '02939', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '150.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2937', '2021-09-02', '05:19:52 PM', '20210902063', '02940', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '30.00', 'Percentage', '630.00', '630.00', '0.00', '0.00', '630.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2938', '2021-09-02', '05:24:25 PM', '20210902064', '02941', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2939', '2021-09-02', '05:28:34 PM', '20210902065', '02942', 'diagnosis', 'diagnosis', '1550.00', '0', '0.00', '1550.00', '0.00', 'Percentage', '1550.00', '700.00', '0.00', '850.00', '700.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2940', '2021-09-02', '05:31:08 PM', '20210902066', '02943', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2941', '2021-09-02', '06:01:41 PM', '20210902067', '02944', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '500.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2942', '2021-09-02', '06:25:50 PM', '20210902068', '02945', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '950.00', '0.00', 'Flat', '1000.00', '700.00', '50.00', '300.00', '700.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2943', '2021-09-02', '06:32:41 PM', '20210902069', '02946', 'diagnosis', 'diagnosis', '2600.00', '0', '0.00', '2600.00', '0.00', 'Flat', '2600.00', '1000.00', '0.00', '1600.00', '1000.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2944', '2021-09-02', '06:56:10 PM', '20210902070', '02947', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '300.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2945', '2021-09-02', '07:09:12 PM', '20210902071', '02948', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-02', 'pending', '', '15', '', 'diagnosis', '2021-09-02 08:00 PM'), 
('2946', '2021-09-03', '09:36:29 AM', '20210903001', '02949', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('2947', '2021-09-03', '09:37:30 AM', '20210903002', '02950', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '200.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('2948', '2021-09-03', '09:38:21 AM', '20210903003', '02951', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('2949', '2021-09-03', '10:03:25 AM', '20210903004', '02952', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('2950', '2021-09-03', '10:04:25 AM', '20210903005', '02953', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('2951', '2021-09-03', '10:12:59 AM', '20210903006', '02954', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('2952', '2021-09-03', '10:13:54 AM', '20210903007', '02955', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('2953', '2021-09-03', '10:16:13 AM', '20210903008', '02956', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '0.00', '0.00', '400.00', '0.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('2954', '2021-09-03', '10:18:22 AM', '20210903009', '02957', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('2955', '2021-09-03', '10:26:16 AM', '20210903010', '02958', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '0.00', 'Flat', '550.00', '300.00', '0.00', '250.00', '300.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('2956', '2021-09-03', '10:55:06 AM', '20210903011', '02959', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('2957', '2021-09-03', '11:01:49 AM', '20210903012', '02960', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '0.00', 'Flat', '550.00', '300.00', '0.00', '250.00', '300.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('2958', '2021-09-03', '11:06:08 AM', '20210903013', '02961', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '50.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('2959', '2021-09-03', '11:07:27 AM', '20210903014', '02962', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '0.00', 'Flat', '850.00', '300.00', '0.00', '550.00', '300.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('2960', '2021-09-03', '11:09:58 AM', '20210903015', '02963', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '500.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('2961', '2021-09-03', '11:11:55 AM', '20210903016', '02964', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('2962', '2021-09-03', '11:13:08 AM', '20210903017', '02965', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('2963', '2021-09-03', '11:15:09 AM', '20210903018', '02966', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('2964', '2021-09-03', '11:31:52 AM', '20210903019', '02967', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('2965', '2021-09-03', '11:41:20 AM', '20210903020', '02968', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('2966', '2021-09-03', '11:47:27 AM', '20210903021', '02969', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '150.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('2967', '2021-09-03', '11:51:56 AM', '20210903022', '02970', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '250.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('2968', '2021-09-03', '11:53:13 AM', '20210903023', '02971', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '200.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('2969', '2021-09-03', '11:55:44 AM', '20210903024', '02972', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '500.00', '0.00', '700.00', '500.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('2970', '2021-09-03', '11:57:37 AM', '20210903025', '02973', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '350.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('2971', '2021-09-03', '11:58:47 AM', '20210903026', '02974', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '400.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('2972', '2021-09-03', '12:02:25 PM', '20210903027', '02975', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('2973', '2021-09-03', '12:03:22 PM', '20210903028', '02976', 'diagnosis', 'diagnosis', '1150.00', '0', '0.00', '1150.00', '350.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('2974', '2021-09-03', '12:05:53 PM', '20210903029', '02977', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '0.00', 'Flat', '800.00', '0.00', '0.00', '800.00', '0.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('2975', '2021-09-03', '12:06:45 PM', '20210903030', '02978', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '300.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('2976', '2021-09-03', '12:08:13 PM', '20210903031', '02979', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('2977', '2021-09-03', '12:09:27 PM', '20210903032', '02980', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('2978', '2021-09-03', '12:10:27 PM', '20210903033', '02981', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('2979', '2021-09-03', '12:12:23 PM', '20210903034', '02982', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '0.00', 'Flat', '550.00', '0.00', '0.00', '550.00', '0.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('2980', '2021-09-03', '12:16:03 PM', '20210903035', '02983', 'diagnosis', 'diagnosis', '2650.00', '0', '0.00', '2650.00', '250.00', 'Flat', '2400.00', '2400.00', '0.00', '0.00', '2400.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('2981', '2021-09-03', '12:22:37 PM', '20210903036', '02984', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('2982', '2021-09-03', '12:24:27 PM', '20210903037', '02985', 'diagnosis', 'diagnosis', '1800.00', '0', '0.00', '1800.00', '300.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1500.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('2983', '2021-09-03', '12:29:13 PM', '20210903038', '02986', 'diagnosis', 'diagnosis', '1700.00', '0', '0.00', '1700.00', '200.00', 'Flat', '1500.00', '500.00', '0.00', '1000.00', '500.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('2984', '2021-09-03', '12:34:50 PM', '20210903039', '02987', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('2985', '2021-09-03', '12:48:02 PM', '20210903040', '02988', 'diagnosis', 'diagnosis', '1750.00', '0', '0.00', '1750.00', '0.00', 'Flat', '1750.00', '1000.00', '0.00', '750.00', '1000.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('2986', '2021-09-03', '12:53:17 PM', '20210903041', '02989', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '350.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('2987', '2021-09-03', '12:56:36 PM', '20210903042', '02990', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('2988', '2021-09-03', '01:05:26 PM', '20210903043', '02991', 'diagnosis', 'diagnosis', '1750.00', '0', '0.00', '1750.00', '250.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1500.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('2989', '2021-09-03', '01:07:18 PM', '20210903044', '02992', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('2990', '2021-09-03', '01:15:12 PM', '20210903045', '02993', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '100.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('2991', '2021-09-03', '01:16:46 PM', '20210903046', '02994', 'diagnosis', 'diagnosis', '1150.00', '0', '0.00', '1150.00', '150.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('2992', '2021-09-03', '01:18:26 PM', '20210903047', '02995', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('2993', '2021-09-03', '01:20:05 PM', '20210903048', '02996', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '400.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('2994', '2021-09-03', '01:24:44 PM', '20210903049', '02997', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1050.00', '0.00', 'Flat', '1200.00', '1200.00', '150.00', '0.00', '1200.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('2995', '2021-09-03', '01:27:18 PM', '20210903050', '02998', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '200.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('2996', '2021-09-03', '01:30:36 PM', '20210903051', '02999', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '50.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('2997', '2021-09-03', '01:32:06 PM', '20210903052', '03000', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '50.00', 'Flat', '750.00', '750.00', '0.00', '0.00', '750.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('2998', '2021-09-03', '01:33:55 PM', '20210903053', '03001', 'diagnosis', 'diagnosis', '1950.00', '0', '0.00', '1950.00', '0.00', 'Flat', '1950.00', '500.00', '0.00', '1450.00', '500.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('2999', '2021-09-03', '01:35:48 PM', '20210903054', '03002', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('3000', '2021-09-03', '01:36:37 PM', '20210903055', '03003', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('3001', '2021-09-03', '01:40:32 PM', '20210903056', '03004', 'diagnosis', 'diagnosis', '2650.00', '0', '0.00', '2650.00', '0.00', 'Flat', '2650.00', '500.00', '0.00', '2150.00', '500.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('3002', '2021-09-03', '01:42:33 PM', '20210903057', '03005', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('3003', '2021-09-03', '01:44:18 PM', '20210903058', '03006', 'diagnosis', 'diagnosis', '2700.00', '0', '0.00', '2700.00', '0.00', 'Flat', '2700.00', '200.00', '0.00', '2500.00', '200.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('3004', '2021-09-03', '01:58:35 PM', '20210903059', '03007', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('3005', '2021-09-03', '02:00:08 PM', '20210903060', '03008', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1450.00', '550.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('3006', '2021-09-03', '02:10:53 PM', '20210903061', '03009', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '200.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('3007', '2021-09-03', '02:16:44 PM', '20210903062', '03010', 'diagnosis', 'diagnosis', '3000.00', '0', '0.00', '3000.00', '500.00', 'Flat', '2500.00', '2500.00', '0.00', '0.00', '2500.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('3008', '2021-09-03', '02:22:40 PM', '20210903063', '03011', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '200.00', 'Flat', '1100.00', '1100.00', '0.00', '0.00', '1100.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('3009', '2021-09-03', '02:32:45 PM', '20210903064', '03012', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('3010', '2021-09-03', '02:34:25 PM', '20210903065', '03013', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('3011', '2021-09-03', '02:57:22 PM', '20210903066', '03014', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('3012', '2021-09-03', '03:10:16 PM', '20210903067', '03015', 'diagnosis', 'diagnosis', '1250.00', '0', '0.00', '900.00', '250.00', 'Flat', '1000.00', '1000.00', '350.00', '0.00', '1000.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('3013', '2021-09-03', '03:18:58 PM', '20210903068', '03016', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '200.00', 'Flat', '1100.00', '1100.00', '0.00', '0.00', '1000.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('3014', '2021-09-03', '03:29:08 PM', '20210903069', '03017', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '0.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('3015', '2021-09-03', '03:36:29 PM', '20210903070', '03018', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '200.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('3016', '2021-09-03', '03:41:45 PM', '20210903071', '03019', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '150.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('3017', '2021-09-03', '03:47:57 PM', '20210903072', '03020', 'diagnosis', 'diagnosis', '1700.00', '0', '0.00', '1700.00', '0.00', 'Flat', '1700.00', '1000.00', '0.00', '700.00', '1000.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('3018', '2021-09-03', '03:53:00 PM', '20210903073', '03021', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('3019', '2021-09-03', '04:03:48 PM', '20210903074', '03022', 'diagnosis', 'diagnosis', '2950.00', '0', '0.00', '2950.00', '950.00', 'Flat', '2000.00', '2000.00', '0.00', '0.00', '2000.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('3020', '2021-09-03', '04:05:02 PM', '20210903075', '03023', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '300.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('3021', '2021-09-03', '04:06:45 PM', '20210903076', '03024', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '100.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('3022', '2021-09-03', '04:07:50 PM', '20210903077', '03025', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('3023', '2021-09-03', '04:11:21 PM', '20210903078', '03026', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '0.00', 'Flat', '550.00', '300.00', '0.00', '250.00', '300.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('3024', '2021-09-03', '04:17:06 PM', '20210903079', '03027', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '50.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('3025', '2021-09-03', '04:18:07 PM', '20210903080', '03028', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('3026', '2021-09-03', '04:19:19 PM', '20210903081', '03029', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '150.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('3027', '2021-09-03', '04:23:03 PM', '20210903082', '03030', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '250.00', 'Flat', '800.00', '700.00', '0.00', '100.00', '700.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('3028', '2021-09-03', '04:25:10 PM', '20210903083', '03031', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('3029', '2021-09-03', '04:26:49 PM', '20210903084', '03032', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '300.00', 'Flat', '1000.00', '900.00', '0.00', '100.00', '900.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('3030', '2021-09-03', '04:35:46 PM', '20210903085', '03033', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '200.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('3031', '2021-09-03', '04:37:04 PM', '20210903086', '03034', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('3032', '2021-09-03', '04:39:04 PM', '20210903087', '03035', 'diagnosis', 'diagnosis', '1950.00', '0', '0.00', '1950.00', '450.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1500.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('3033', '2021-09-03', '04:45:25 PM', '20210903088', '03036', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '100.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('3034', '2021-09-03', '04:48:10 PM', '20210903089', '03037', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '0.00', 'Flat', '1000.00', '500.00', '0.00', '500.00', '500.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('3035', '2021-09-03', '04:51:51 PM', '20210903090', '03038', 'diagnosis', 'diagnosis', '450.00', '0', '0.00', '450.00', '100.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('3036', '2021-09-03', '04:53:48 PM', '20210903091', '03039', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '0.00', 'Flat', '900.00', '400.00', '0.00', '500.00', '400.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('3037', '2021-09-03', '05:05:18 PM', '20210903092', '03040', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '200.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('3038', '2021-09-03', '05:10:38 PM', '20210903093', '03041', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '250.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('3039', '2021-09-03', '05:14:21 PM', '20210903094', '03042', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '200.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('3040', '2021-09-03', '05:18:47 PM', '20210903095', '03043', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('3041', '2021-09-03', '05:36:26 PM', '20210903096', '03044', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '400.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-03', 'pending', '', '15', '', 'diagnosis', '2021-09-03 08:00 PM'), 
('3042', '2021-09-04', '10:13:12 AM', '20210904001', '03045', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '150.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3043', '2021-09-04', '10:28:05 AM', '20210904002', '03046', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3044', '2021-09-04', '10:35:49 AM', '20210904003', '03047', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3045', '2021-09-04', '10:38:43 AM', '20210904004', '03048', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '100.00', '0.00', '300.00', '100.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3046', '2021-09-04', '10:49:44 AM', '20210904005', '03049', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3047', '2021-09-04', '11:10:27 AM', '20210904006', '03050', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '350.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3048', '2021-09-04', '11:15:10 AM', '20210904007', '03051', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '300.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3049', '2021-09-04', '11:19:39 AM', '20210904008', '03052', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3050', '2021-09-04', '11:23:41 AM', '20210904009', '03053', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3051', '2021-09-04', '11:42:53 AM', '20210904010', '03054', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3052', '2021-09-04', '11:46:02 AM', '20210904011', '03055', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3053', '2021-09-04', '11:50:23 AM', '20210904012', '03056', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3054', '2021-09-04', '11:53:46 AM', '20210904013', '03057', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3055', '2021-09-04', '11:56:01 AM', '20210904014', '03058', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3056', '2021-09-04', '11:57:55 AM', '20210904015', '03059', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3057', '2021-09-04', '12:00:05 PM', '20210904016', '03060', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '200.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3058', '2021-09-04', '12:03:13 PM', '20210904017', '03061', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3059', '2021-09-04', '12:04:39 PM', '20210904018', '03062', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3060', '2021-09-04', '12:08:37 PM', '20210904019', '03063', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3061', '2021-09-04', '12:11:24 PM', '20210904020', '03064', 'diagnosis', 'diagnosis', '2250.00', '0', '0.00', '2250.00', '1250.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3062', '2021-09-04', '12:15:03 PM', '20210904021', '03065', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '200.00', 'Flat', '1100.00', '1100.00', '0.00', '0.00', '1100.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3063', '2021-09-04', '12:23:11 PM', '20210904022', '03066', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '100.00', 'Flat', '1400.00', '1400.00', '0.00', '0.00', '1400.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3064', '2021-09-04', '12:25:45 PM', '20210904023', '03067', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '100.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3065', '2021-09-04', '12:34:37 PM', '20210904024', '03068', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3066', '2021-09-04', '12:35:59 PM', '20210904025', '03069', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '100.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3067', '2021-09-04', '12:42:11 PM', '20210904026', '03070', 'diagnosis', 'diagnosis', '1250.00', '0', '0.00', '1250.00', '250.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3068', '2021-09-04', '12:45:40 PM', '20210904027', '03071', 'diagnosis', 'diagnosis', '1550.00', '0', '0.00', '1550.00', '550.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3069', '2021-09-04', '12:45:41 PM', '20210904028', '03072', 'diagnosis', 'diagnosis', '1550.00', '0', '0.00', '1550.00', '550.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3070', '2021-09-04', '12:47:25 PM', '20210904029', '03073', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '0.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1500.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3071', '2021-09-04', '12:50:09 PM', '20210904030', '03074', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '300.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3072', '2021-09-04', '12:53:39 PM', '20210904031', '03075', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '0.00', '150.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3073', '2021-09-04', '12:54:22 PM', '20210904032', '03076', 'diagnosis', 'diagnosis', '2100.00', '0', '0.00', '2100.00', '400.00', 'Flat', '1700.00', '1400.00', '0.00', '300.00', '1400.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3074', '2021-09-04', '01:02:57 PM', '20210904033', '03077', 'diagnosis', 'diagnosis', '1400.00', '0', '0.00', '900.00', '0.00', 'Flat', '1400.00', '0.00', '500.00', '1400.00', '0.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3075', '2021-09-04', '01:04:16 PM', '20210904034', '03078', 'diagnosis', 'diagnosis', '1700.00', '0', '0.00', '1300.00', '0.00', 'Flat', '1700.00', '0.00', '400.00', '1700.00', '0.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3076', '2021-09-04', '01:09:34 PM', '20210904035', '03079', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '300.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3077', '2021-09-04', '01:11:47 PM', '20210904036', '03080', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1300.00', '0.00', 'Flat', '1500.00', '500.00', '200.00', '1000.00', '500.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3078', '2021-09-04', '01:14:03 PM', '20210904037', '03081', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3079', '2021-09-04', '01:20:35 PM', '20210904038', '03082', 'diagnosis', 'diagnosis', '1700.00', '0', '0.00', '1700.00', '300.00', 'Flat', '1400.00', '1400.00', '0.00', '0.00', '1400.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3080', '2021-09-04', '01:29:59 PM', '20210904039', '03083', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '50.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3081', '2021-09-04', '01:35:28 PM', '20210904040', '03084', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '200.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3082', '2021-09-04', '01:40:42 PM', '20210904041', '03085', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '150.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3083', '2021-09-04', '01:43:06 PM', '20210904042', '03086', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3084', '2021-09-04', '01:53:22 PM', '20210904043', '03087', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '900.00', '0.00', 'Flat', '1000.00', '1000.00', '100.00', '0.00', '1000.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3085', '2021-09-04', '02:00:34 PM', '20210904044', '03088', 'diagnosis', 'diagnosis', '600.00', '0', '0.00', '600.00', '300.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3086', '2021-09-04', '02:08:12 PM', '20210904045', '03089', 'diagnosis', 'diagnosis', '1900.00', '0', '0.00', '1900.00', '1100.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3087', '2021-09-04', '02:11:43 PM', '20210904046', '03090', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '200.00', 'Flat', '600.00', '500.00', '0.00', '100.00', '500.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3088', '2021-09-04', '02:13:49 PM', '20210904047', '03091', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '150.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3089', '2021-09-04', '02:21:15 PM', '20210904048', '03092', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '100.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3090', '2021-09-04', '02:25:40 PM', '20210904049', '03093', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '150.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3091', '2021-09-04', '02:30:56 PM', '20210904050', '03094', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '200.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3092', '2021-09-04', '02:34:08 PM', '20210904051', '03095', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '0.00', 'Flat', '800.00', '500.00', '0.00', '300.00', '500.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3093', '2021-09-04', '03:18:52 PM', '20210904052', '03096', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3094', '2021-09-04', '03:21:26 PM', '20210904053', '03097', 'diagnosis', 'diagnosis', '1550.00', '0', '0.00', '1550.00', '350.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3095', '2021-09-04', '03:33:10 PM', '20210904054', '03098', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '650.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3098', '2021-09-04', '03:40:54 PM', '20210904055', '03101', 'diagnosis', 'diagnosis', '1750.00', '0', '0.00', '1750.00', '550.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3099', '2021-09-04', '03:43:38 PM', '20210904056', '03102', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3100', '2021-09-04', '03:50:52 PM', '20210904057', '03103', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3101', '2021-09-04', '03:57:32 PM', '20210904058', '03104', 'diagnosis', 'diagnosis', '1800.00', '0', '0.00', '1800.00', '300.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1500.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3102', '2021-09-04', '04:03:28 PM', '20210904059', '03105', 'diagnosis', 'diagnosis', '1600.00', '0', '0.00', '1600.00', '600.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3103', '2021-09-04', '04:06:50 PM', '20210904060', '03106', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '0.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3104', '2021-09-04', '04:08:57 PM', '20210904061', '03107', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3105', '2021-09-04', '04:10:07 PM', '20210904062', '03108', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '0.00', 'Flat', '550.00', '0.00', '0.00', '550.00', '0.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3106', '2021-09-04', '04:10:56 PM', '20210904063', '03109', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '0.00', 'Flat', '650.00', '0.00', '0.00', '650.00', '0.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3107', '2021-09-04', '04:12:13 PM', '20210904064', '03110', 'diagnosis', 'diagnosis', '200.00', '0', '0.00', '200.00', '50.00', 'Flat', '150.00', '150.00', '0.00', '0.00', '150.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3108', '2021-09-04', '04:22:25 PM', '20210904065', '03111', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '200.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3109', '2021-09-04', '04:22:35 PM', '20210904066', '03112', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3110', '2021-09-04', '04:27:53 PM', '20210904067', '03113', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '0.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3111', '2021-09-04', '04:29:47 PM', '20210904068', '03114', 'diagnosis', 'diagnosis', '2200.00', '0', '0.00', '2200.00', '0.00', 'Flat', '2200.00', '1500.00', '0.00', '700.00', '1500.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3112', '2021-09-04', '04:33:25 PM', '20210904069', '03115', 'diagnosis', 'diagnosis', '4350.00', '0', '0.00', '4350.00', '850.00', 'Flat', '3500.00', '1500.00', '0.00', '2000.00', '1500.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3113', '2021-09-04', '04:43:39 PM', '20210904070', '03116', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '0.00', 'Flat', '1300.00', '500.00', '0.00', '800.00', '500.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3114', '2021-09-04', '04:51:16 PM', '20210904071', '03117', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '300.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3115', '2021-09-04', '04:51:50 PM', '20210904072', '03118', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3116', '2021-09-04', '04:56:49 PM', '20210904073', '03119', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3117', '2021-09-04', '05:19:37 PM', '20210904074', '03120', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3118', '2021-09-04', '05:26:34 PM', '20210904075', '03121', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '50.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3119', '2021-09-04', '05:30:57 PM', '20210904076', '03122', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3120', '2021-09-04', '06:37:57 PM', '20210904077', '03123', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-04', 'pending', '', '15', '', 'diagnosis', '2021-09-04 08:00 PM'), 
('3121', '2021-09-05', '10:14:10 AM', '20210905001', '03124', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3122', '2021-09-05', '10:22:20 AM', '20210905002', '03125', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '350.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3123', '2021-09-05', '10:23:23 AM', '20210905003', '03126', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3124', '2021-09-05', '10:36:09 AM', '20210905004', '03127', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3125', '2021-09-05', '10:48:51 AM', '20210905005', '03128', 'diagnosis', 'diagnosis', '600.00', '0', '0.00', '600.00', '200.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3126', '2021-09-05', '10:56:00 AM', '20210905006', '03129', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3127', '2021-09-05', '11:06:43 AM', '20210905007', '03130', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3128', '2021-09-05', '11:15:10 AM', '20210905008', '03131', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3129', '2021-09-05', '11:18:25 AM', '20210905009', '03132', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3130', '2021-09-05', '11:22:12 AM', '20210905010', '03133', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '100.00', 'Flat', '450.00', '450.00', '0.00', '0.00', '450.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3131', '2021-09-05', '11:27:07 AM', '20210905011', '03134', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3132', '2021-09-05', '11:56:34 AM', '20210905012', '03135', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '200.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3133', '2021-09-05', '11:57:51 AM', '20210905013', '03136', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3134', '2021-09-05', '11:59:40 AM', '20210905014', '03137', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '150.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3135', '2021-09-05', '12:03:19 PM', '20210905015', '03138', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3136', '2021-09-05', '12:11:53 PM', '20210905016', '03139', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3137', '2021-09-05', '12:13:36 PM', '20210905017', '03140', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3138', '2021-09-05', '12:24:55 PM', '20210905018', '03141', 'diagnosis', 'diagnosis', '2300.00', '0', '0.00', '2300.00', '2300.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3139', '2021-09-05', '12:33:00 PM', '20210905019', '03142', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '150.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3140', '2021-09-05', '12:37:24 PM', '20210905020', '03143', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '0.00', 'Flat', '1500.00', '0.00', '0.00', '1500.00', '0.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3141', '2021-09-05', '12:38:11 PM', '20210905021', '03144', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '0.00', 'Flat', '650.00', '0.00', '0.00', '650.00', '0.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3142', '2021-09-05', '12:39:26 PM', '20210905022', '03145', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3143', '2021-09-05', '12:42:07 PM', '20210905023', '03146', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '300.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3144', '2021-09-05', '12:43:56 PM', '20210905024', '03147', 'diagnosis', 'diagnosis', '1650.00', '0', '0.00', '1650.00', '450.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3145', '2021-09-05', '12:45:15 PM', '20210905025', '03148', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '300.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3146', '2021-09-05', '12:46:37 PM', '20210905026', '03149', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '250.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3147', '2021-09-05', '12:47:43 PM', '20210905027', '03150', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3148', '2021-09-05', '12:49:01 PM', '20210905028', '03151', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '300.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3149', '2021-09-05', '12:50:35 PM', '20210905029', '03152', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '350.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3150', '2021-09-05', '12:55:08 PM', '20210905030', '03153', 'diagnosis', 'diagnosis', '2150.00', '0', '0.00', '2150.00', '650.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1500.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3151', '2021-09-05', '12:58:07 PM', '20210905031', '03154', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '550.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3152', '2021-09-05', '12:59:17 PM', '20210905032', '03155', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '250.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3153', '2021-09-05', '01:01:33 PM', '20210905033', '03156', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '350.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3154', '2021-09-05', '01:02:47 PM', '20210905034', '03157', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '100.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3155', '2021-09-05', '01:03:46 PM', '20210905035', '03158', 'diagnosis', 'diagnosis', '1550.00', '0', '0.00', '1550.00', '550.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3156', '2021-09-05', '01:05:56 PM', '20210905036', '03159', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '150.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3157', '2021-09-05', '01:08:22 PM', '20210905037', '03160', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '500.00', '0.00', '700.00', '500.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3158', '2021-09-05', '01:09:17 PM', '20210905038', '03161', 'diagnosis', 'diagnosis', '1550.00', '0', '0.00', '1550.00', '350.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3159', '2021-09-05', '01:10:41 PM', '20210905039', '03162', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3160', '2021-09-05', '01:11:47 PM', '20210905040', '03163', 'diagnosis', 'diagnosis', '1250.00', '0', '0.00', '1250.00', '450.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3161', '2021-09-05', '01:12:33 PM', '20210905041', '03164', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3162', '2021-09-05', '01:13:31 PM', '20210905042', '03165', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3163', '2021-09-05', '01:15:51 PM', '20210905043', '03166', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '400.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3164', '2021-09-05', '01:17:01 PM', '20210905044', '03167', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '200.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3165', '2021-09-05', '01:19:08 PM', '20210905045', '03168', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '600.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3166', '2021-09-05', '01:20:10 PM', '20210905046', '03169', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '0.00', 'Flat', '900.00', '0.00', '0.00', '900.00', '0.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3167', '2021-09-05', '01:21:58 PM', '20210905047', '03170', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3168', '2021-09-05', '01:33:40 PM', '20210905048', '03171', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '500.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3169', '2021-09-05', '01:39:00 PM', '20210905049', '03172', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '600.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3170', '2021-09-05', '01:40:58 PM', '20210905050', '03173', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3171', '2021-09-05', '01:48:59 PM', '20210905051', '03174', 'diagnosis', 'diagnosis', '1100.00', '0', '0.00', '1100.00', '400.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3172', '2021-09-05', '02:05:10 PM', '20210905052', '03175', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '200.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3173', '2021-09-05', '02:16:33 PM', '20210905053', '03176', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3174', '2021-09-05', '03:01:48 PM', '20210905054', '03177', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '90.00', 'Flat', '60.00', '60.00', '0.00', '0.00', '60.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3175', '2021-09-05', '03:11:58 PM', '20210905055', '03178', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1450.00', '450.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3176', '2021-09-05', '03:28:42 PM', '20210905056', '03179', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '150.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3177', '2021-09-05', '03:34:49 PM', '20210905057', '03180', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '350.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3178', '2021-09-05', '03:39:42 PM', '20210905058', '03181', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '350.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3179', '2021-09-05', '03:44:12 PM', '20210905059', '03182', 'diagnosis', 'diagnosis', '2550.00', '0', '0.00', '2550.00', '550.00', 'Flat', '2000.00', '2000.00', '0.00', '0.00', '2000.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3180', '2021-09-05', '03:47:47 PM', '20210905060', '03183', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '0.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3181', '2021-09-05', '03:50:17 PM', '20210905061', '03184', 'diagnosis', 'diagnosis', '2600.00', '0', '0.00', '2600.00', '1000.00', 'Flat', '1600.00', '1600.00', '0.00', '0.00', '1600.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3182', '2021-09-05', '03:52:39 PM', '20210905062', '03185', 'diagnosis', 'diagnosis', '2000.00', '0', '0.00', '2000.00', '0.00', 'Flat', '2000.00', '500.00', '0.00', '1500.00', '500.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3183', '2021-09-05', '04:06:00 PM', '20210905063', '03186', 'diagnosis', 'diagnosis', '1650.00', '0', '0.00', '1650.00', '0.00', 'Flat', '1650.00', '500.00', '0.00', '1150.00', '500.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3184', '2021-09-05', '04:08:00 PM', '20210905064', '03187', 'diagnosis', 'diagnosis', '1250.00', '0', '0.00', '1250.00', '0.00', 'Flat', '1250.00', '0.00', '0.00', '1250.00', '0.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3185', '2021-09-05', '04:10:26 PM', '20210905065', '03188', 'diagnosis', 'diagnosis', '1600.00', '0', '0.00', '1600.00', '800.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3186', '2021-09-05', '04:14:08 PM', '20210905066', '03189', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '400.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3187', '2021-09-05', '04:15:48 PM', '20210905067', '03190', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '400.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3188', '2021-09-05', '04:17:43 PM', '20210905068', '03191', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '400.00', 'Flat', '1100.00', '500.00', '0.00', '600.00', '500.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3189', '2021-09-05', '04:19:02 PM', '20210905069', '03192', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '500.00', 'Flat', '700.00', '400.00', '0.00', '300.00', '400.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3190', '2021-09-05', '04:23:16 PM', '20210905070', '03193', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '200.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3191', '2021-09-05', '04:23:55 PM', '20210905071', '03194', 'diagnosis', 'diagnosis', '1400.00', '0', '0.00', '1400.00', '400.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3192', '2021-09-05', '04:26:58 PM', '20210905072', '03195', 'diagnosis', 'diagnosis', '2300.00', '0', '0.00', '2300.00', '0.00', 'Flat', '2300.00', '500.00', '0.00', '1800.00', '500.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3193', '2021-09-05', '04:34:02 PM', '20210905073', '03196', 'diagnosis', 'diagnosis', '2450.00', '0', '0.00', '2450.00', '0.00', 'Flat', '2450.00', '0.00', '0.00', '2450.00', '0.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3194', '2021-09-05', '04:34:40 PM', '20210905074', '03197', 'diagnosis', 'diagnosis', '600.00', '0', '0.00', '600.00', '200.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3195', '2021-09-05', '04:37:15 PM', '20210905075', '03198', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '150.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3196', '2021-09-05', '04:38:31 PM', '20210905076', '03199', 'diagnosis', 'diagnosis', '1850.00', '0', '0.00', '1850.00', '350.00', 'Flat', '1500.00', '900.00', '0.00', '600.00', '900.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3197', '2021-09-05', '04:47:20 PM', '20210905077', '03200', 'diagnosis', 'diagnosis', '600.00', '0', '0.00', '600.00', '100.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3198', '2021-09-05', '04:55:24 PM', '20210905078', '03201', 'diagnosis', 'diagnosis', '600.00', '0', '0.00', '600.00', '200.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3199', '2021-09-05', '04:59:56 PM', '20210905079', '03202', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3200', '2021-09-05', '05:06:52 PM', '20210905080', '03203', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3201', '2021-09-05', '05:22:58 PM', '20210905081', '03204', 'diagnosis', 'diagnosis', '3100.00', '0', '0.00', '3100.00', '600.00', 'Flat', '2500.00', '1500.00', '0.00', '1000.00', '1500.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3202', '2021-09-05', '05:26:52 PM', '20210905082', '03205', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3203', '2021-09-05', '05:33:34 PM', '20210905083', '03206', 'diagnosis', 'diagnosis', '1800.00', '0', '0.00', '1800.00', '0.00', 'Flat', '1800.00', '1000.00', '0.00', '800.00', '1000.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3204', '2021-09-05', '05:34:33 PM', '20210905084', '03207', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '0.00', 'Flat', '800.00', '0.00', '0.00', '800.00', '0.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3205', '2021-09-05', '05:43:30 PM', '20210905085', '03208', 'diagnosis', 'diagnosis', '1700.00', '0', '0.00', '1700.00', '300.00', 'Flat', '1400.00', '1400.00', '0.00', '0.00', '1400.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3206', '2021-09-05', '05:46:15 PM', '20210905086', '03209', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '150.00', 'Flat', '150.00', '150.00', '0.00', '0.00', '150.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3207', '2021-09-05', '05:57:38 PM', '20210905087', '03210', 'diagnosis', 'diagnosis', '1950.00', '0', '0.00', '1950.00', '350.00', 'Flat', '1600.00', '1600.00', '0.00', '0.00', '1600.00', '2021-09-05', 'pending', '', '15', 'Dr.Tara mia', 'diagnosis', '2021-09-05 08:00 PM'), 
('3208', '2021-09-05', '05:59:55 PM', '20210905088', '03211', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '850.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3209', '2021-09-05', '06:05:06 PM', '20210905089', '03212', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3210', '2021-09-05', '06:06:53 PM', '20210905090', '03213', 'diagnosis', 'diagnosis', '350.00', '0', '0.00', '350.00', '50.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3211', '2021-09-05', '06:12:14 PM', '20210905091', '03214', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '0.00', 'Flat', '650.00', '0.00', '0.00', '650.00', '0.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3212', '2021-09-05', '06:16:45 PM', '20210905092', '03215', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3213', '2021-09-05', '06:42:15 PM', '20210905093', '03216', 'diagnosis', 'diagnosis', '2650.00', '0', '0.00', '2650.00', '750.00', 'Flat', '1900.00', '1500.00', '0.00', '400.00', '1500.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3214', '2021-09-05', '06:45:05 PM', '20210905094', '03217', 'diagnosis', 'diagnosis', '1750.00', '0', '0.00', '1750.00', '950.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3215', '2021-09-05', '06:57:07 PM', '20210905095', '03218', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '0.00', 'Flat', '300.00', '0.00', '0.00', '300.00', '0.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3216', '2021-09-05', '06:59:31 PM', '20210905096', '03219', 'diagnosis', 'diagnosis', '600.00', '0', '0.00', '600.00', '0.00', 'Flat', '600.00', '0.00', '0.00', '600.00', '0.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3217', '2021-09-05', '07:11:46 PM', '20210905097', '03220', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3218', '2021-09-05', '08:12:27 PM', '20210905098', '03221', 'diagnosis', 'diagnosis', '350.00', '0', '0.00', '350.00', '50.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-05', 'pending', '', '15', '', 'diagnosis', '2021-09-05 08:00 PM'), 
('3219', '2021-09-06', '10:55:57 AM', '20210906001', '03222', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3220', '2021-09-06', '10:56:48 AM', '20210906002', '03223', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3221', '2021-09-06', '11:02:19 AM', '20210906003', '03224', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3222', '2021-09-06', '11:10:52 AM', '20210906004', '03225', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3223', '2021-09-06', '11:13:47 AM', '20210906005', '03226', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3224', '2021-09-06', '11:14:42 AM', '20210906006', '03227', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3225', '2021-09-06', '11:27:43 AM', '20210906007', '03228', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3226', '2021-09-06', '11:35:44 AM', '20210906008', '03229', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '0.00', '0.00', '400.00', '0.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3227', '2021-09-06', '11:38:26 AM', '20210906009', '03230', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3228', '2021-09-06', '11:40:34 AM', '20210906010', '03231', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3229', '2021-09-06', '11:42:48 AM', '20210906011', '03232', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3230', '2021-09-06', '11:45:51 AM', '20210906012', '03233', 'diagnosis', 'diagnosis', '2950.00', '0', '0.00', '2950.00', '0.00', 'Flat', '2950.00', '0.00', '0.00', '2950.00', '0.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3231', '2021-09-06', '12:01:09 PM', '20210906013', '03234', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3232', '2021-09-06', '12:05:58 PM', '20210906014', '03235', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '0.00', 'Flat', '700.00', '0.00', '0.00', '700.00', '0.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3233', '2021-09-06', '12:10:25 PM', '20210906015', '03236', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3234', '2021-09-06', '12:15:01 PM', '20210906016', '03237', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '250.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3235', '2021-09-06', '12:16:30 PM', '20210906017', '03238', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '400.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3236', '2021-09-06', '12:17:41 PM', '20210906018', '03239', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '500.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3237', '2021-09-06', '12:18:58 PM', '20210906019', '03240', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '450.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3238', '2021-09-06', '12:21:00 PM', '20210906020', '03241', 'diagnosis', 'diagnosis', '2450.00', '0', '0.00', '2450.00', '0.00', 'Flat', '2450.00', '500.00', '0.00', '1950.00', '500.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3239', '2021-09-06', '12:22:33 PM', '20210906021', '03242', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '400.00', 'Flat', '250.00', '100.00', '0.00', '150.00', '100.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3240', '2021-09-06', '12:29:26 PM', '20210906022', '03243', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3241', '2021-09-06', '12:32:14 PM', '20210906023', '03244', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3242', '2021-09-06', '12:41:34 PM', '20210906024', '03245', 'diagnosis', 'diagnosis', '1900.00', '0', '0.00', '1900.00', '400.00', 'Flat', '1500.00', '1000.00', '0.00', '500.00', '1000.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3243', '2021-09-06', '12:42:31 PM', '20210906025', '03246', 'diagnosis', 'diagnosis', '350.00', '0', '0.00', '350.00', '150.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3244', '2021-09-06', '12:43:49 PM', '20210906026', '03247', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3245', '2021-09-06', '12:54:17 PM', '20210906027', '03248', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3246', '2021-09-06', '12:56:32 PM', '20210906028', '03249', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '600.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3247', '2021-09-06', '12:58:06 PM', '20210906029', '03250', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3248', '2021-09-06', '01:00:29 PM', '20210906030', '03251', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3249', '2021-09-06', '01:03:19 PM', '20210906031', '03252', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '30.00', 'Flat', '120.00', '120.00', '0.00', '0.00', '120.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3250', '2021-09-06', '01:04:36 PM', '20210906032', '03253', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '400.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3251', '2021-09-06', '01:05:56 PM', '20210906033', '03254', 'diagnosis', 'diagnosis', '1100.00', '0', '0.00', '1100.00', '500.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3252', '2021-09-06', '01:07:43 PM', '20210906034', '03255', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '30.00', 'Flat', '120.00', '120.00', '0.00', '0.00', '120.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3253', '2021-09-06', '01:09:15 PM', '20210906035', '03256', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '30.00', 'Flat', '120.00', '120.00', '0.00', '0.00', '120.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3254', '2021-09-06', '01:13:07 PM', '20210906036', '03257', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '30.00', 'Flat', '120.00', '120.00', '0.00', '0.00', '120.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3255', '2021-09-06', '01:14:34 PM', '20210906037', '03258', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '30.00', 'Flat', '120.00', '120.00', '0.00', '0.00', '120.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3256', '2021-09-06', '01:15:53 PM', '20210906038', '03259', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3257', '2021-09-06', '01:18:24 PM', '20210906039', '03260', 'diagnosis', 'diagnosis', '1100.00', '0', '0.00', '1100.00', '200.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3258', '2021-09-06', '01:22:30 PM', '20210906040', '03261', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3259', '2021-09-06', '01:42:07 PM', '20210906041', '03262', 'diagnosis', 'diagnosis', '250.00', '0', '0.00', '250.00', '50.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3260', '2021-09-06', '02:24:34 PM', '20210906042', '03263', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3261', '2021-09-06', '02:31:22 PM', '20210906043', '03264', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3262', '2021-09-06', '02:57:55 PM', '20210906044', '03265', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '0.00', 'Flat', '1350.00', '500.00', '0.00', '850.00', '500.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3263', '2021-09-06', '03:18:07 PM', '20210906045', '03266', 'diagnosis', 'diagnosis', '1600.00', '0', '0.00', '1600.00', '300.00', 'Flat', '1300.00', '1300.00', '0.00', '0.00', '1300.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3264', '2021-09-06', '03:26:34 PM', '20210906046', '03267', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '150.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3265', '2021-09-06', '03:43:39 PM', '20210906047', '03268', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3266', '2021-09-06', '03:48:16 PM', '20210906048', '03269', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3267', '2021-09-06', '04:02:33 PM', '20210906049', '03270', 'diagnosis', 'diagnosis', '1700.00', '0', '0.00', '1700.00', '500.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3268', '2021-09-06', '04:08:59 PM', '20210906050', '03271', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '400.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3269', '2021-09-06', '04:10:35 PM', '20210906051', '03272', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '700.00', 'Flat', '800.00', '300.00', '0.00', '500.00', '300.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3270', '2021-09-06', '04:14:34 PM', '20210906052', '03273', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3271', '2021-09-06', '04:17:31 PM', '20210906053', '03274', 'diagnosis', 'diagnosis', '1800.00', '0', '0.00', '1800.00', '400.00', 'Flat', '1400.00', '1400.00', '0.00', '0.00', '1400.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3272', '2021-09-06', '04:19:18 PM', '20210906054', '03275', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '300.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3273', '2021-09-06', '04:28:04 PM', '20210906055', '03276', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '0.00', '0.00', '400.00', '0.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3274', '2021-09-06', '04:32:51 PM', '20210906056', '03277', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3275', '2021-09-06', '04:36:14 PM', '20210906057', '03278', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '300.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3276', '2021-09-06', '04:44:41 PM', '20210906058', '03279', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1450.00', '500.00', 'Flat', '950.00', '950.00', '0.00', '0.00', '950.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3277', '2021-09-06', '04:52:00 PM', '20210906059', '03280', 'diagnosis', 'diagnosis', '750.00', '0', '0.00', '750.00', '0.00', 'Flat', '750.00', '0.00', '0.00', '750.00', '0.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3278', '2021-09-06', '04:54:58 PM', '20210906060', '03281', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '330.00', 'Flat', '670.00', '670.00', '0.00', '0.00', '670.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3279', '2021-09-06', '05:09:55 PM', '20210906061', '03282', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3280', '2021-09-06', '05:29:00 PM', '20210906062', '03283', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3281', '2021-09-06', '05:39:16 PM', '20210906063', '03284', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '100.00', '0.00', '300.00', '100.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3282', '2021-09-06', '05:39:33 PM', '20210906064', '03285', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3283', '2021-09-06', '06:14:07 PM', '20210906065', '03286', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3284', '2021-09-06', '07:04:48 PM', '20210906066', '03287', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3285', '2021-09-06', '07:05:37 PM', '20210906067', '03288', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-09-06', 'pending', '', '15', '', 'diagnosis', '2021-09-06 08:00 PM'), 
('3286', '2021-09-07', '10:12:18 AM', '20210907001', '03289', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3287', '2021-09-07', '10:21:58 AM', '20210907002', '03290', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3288', '2021-09-07', '10:46:54 AM', '20210907003', '03291', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3289', '2021-09-07', '11:16:53 AM', '20210907004', '03292', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3290', '2021-09-07', '11:22:26 AM', '20210907005', '03293', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '200.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3291', '2021-09-07', '11:25:25 AM', '20210907006', '03294', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '150.00', 'Flat', '150.00', '150.00', '0.00', '0.00', '150.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3292', '2021-09-07', '11:31:10 AM', '20210907007', '03295', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3293', '2021-09-07', '11:35:38 AM', '20210907008', '03296', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '150.00', 'Flat', '550.00', '550.00', '0.00', '0.00', '550.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3294', '2021-09-07', '11:46:25 AM', '20210907009', '03297', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '450.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3295', '2021-09-07', '11:47:24 AM', '20210907010', '03298', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '300.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3296', '2021-09-07', '11:49:46 AM', '20210907011', '03299', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3297', '2021-09-07', '11:52:39 AM', '20210907012', '03300', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3298', '2021-09-07', '11:55:32 AM', '20210907013', '03301', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '250.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3299', '2021-09-07', '11:58:18 AM', '20210907014', '03302', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '450.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3300', '2021-09-07', '12:09:30 PM', '20210907015', '03303', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3301', '2021-09-07', '12:11:56 PM', '20210907016', '03304', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3302', '2021-09-07', '12:15:03 PM', '20210907017', '03305', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '700.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3303', '2021-09-07', '12:18:35 PM', '20210907018', '03306', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3304', '2021-09-07', '12:23:21 PM', '20210907019', '03307', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '300.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3305', '2021-09-07', '12:24:57 PM', '20210907020', '03308', 'diagnosis', 'diagnosis', '1400.00', '0', '0.00', '1400.00', '600.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3306', '2021-09-07', '12:29:41 PM', '20210907021', '03309', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '150.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3307', '2021-09-07', '12:34:48 PM', '20210907022', '03310', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '300.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3308', '2021-09-07', '12:37:40 PM', '20210907023', '03311', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '50.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3309', '2021-09-07', '12:41:23 PM', '20210907024', '03312', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '550.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3310', '2021-09-07', '12:42:31 PM', '20210907025', '03313', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3311', '2021-09-07', '12:45:04 PM', '20210907026', '03314', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '250.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3312', '2021-09-07', '01:00:20 PM', '20210907027', '03315', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3313', '2021-09-07', '01:02:01 PM', '20210907028', '03316', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3314', '2021-09-07', '01:21:51 PM', '20210907029', '03317', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3315', '2021-09-07', '01:52:35 PM', '20210907030', '03318', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3316', '2021-09-07', '01:53:47 PM', '20210907031', '03319', 'diagnosis', 'diagnosis', '1250.00', '0', '0.00', '1250.00', '0.00', 'Flat', '1250.00', '200.00', '0.00', '1050.00', '200.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3317', '2021-09-07', '01:59:00 PM', '20210907032', '03320', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3318', '2021-09-07', '02:00:24 PM', '20210907033', '03321', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '600.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3319', '2021-09-07', '02:20:20 PM', '20210907034', '03322', 'diagnosis', 'diagnosis', '1550.00', '0', '0.00', '1550.00', '650.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3320', '2021-09-07', '03:01:11 PM', '20210907035', '03323', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3321', '2021-09-07', '03:04:30 PM', '20210907036', '03324', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1250.00', '200.00', 'Flat', '1100.00', '1100.00', '50.00', '0.00', '1100.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3322', '2021-09-07', '03:10:53 PM', '20210907037', '03325', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3323', '2021-09-07', '03:11:56 PM', '20210907038', '03326', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3324', '2021-09-07', '03:29:19 PM', '20210907039', '03327', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3325', '2021-09-07', '03:31:56 PM', '20210907040', '03328', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3326', '2021-09-07', '03:37:11 PM', '20210907041', '03329', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3327', '2021-09-07', '03:41:56 PM', '20210907042', '03330', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '0.00', 'Flat', '300.00', '0.00', '0.00', '300.00', '0.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3328', '2021-09-07', '03:52:12 PM', '20210907043', '03331', 'diagnosis', 'diagnosis', '2000.00', '0', '0.00', '2000.00', '1200.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3329', '2021-09-07', '03:54:42 PM', '20210907044', '03332', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3330', '2021-09-07', '03:56:14 PM', '20210907045', '03333', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3331', '2021-09-07', '03:57:15 PM', '20210907046', '03334', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '700.00', 'Flat', '500.00', '0.00', '0.00', '500.00', '0.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3332', '2021-09-07', '03:58:35 PM', '20210907047', '03335', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '300.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3333', '2021-09-07', '04:04:08 PM', '20210907048', '03336', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3334', '2021-09-07', '04:06:25 PM', '20210907049', '03337', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '300.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3335', '2021-09-07', '04:10:19 PM', '20210907050', '03338', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3336', '2021-09-07', '04:14:05 PM', '20210907051', '03339', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '300.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3337', '2021-09-07', '04:15:32 PM', '20210907052', '03340', 'diagnosis', 'diagnosis', '2800.00', '0', '0.00', '2800.00', '800.00', 'Flat', '2000.00', '2000.00', '0.00', '0.00', '2000.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3338', '2021-09-07', '04:17:02 PM', '20210907053', '03341', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3339', '2021-09-07', '04:18:49 PM', '20210907054', '03342', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '400.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3340', '2021-09-07', '04:22:06 PM', '20210907055', '03343', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3341', '2021-09-07', '04:25:33 PM', '20210907056', '03344', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3342', '2021-09-07', '04:26:24 PM', '20210907057', '03345', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3343', '2021-09-07', '04:31:38 PM', '20210907058', '03346', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3344', '2021-09-07', '04:35:14 PM', '20210907059', '03347', 'diagnosis', 'diagnosis', '2050.00', '0', '0.00', '1850.00', '650.00', 'Flat', '1400.00', '1400.00', '200.00', '0.00', '1200.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3345', '2021-09-07', '04:37:19 PM', '20210907060', '03348', 'diagnosis', 'diagnosis', '1650.00', '0', '0.00', '1650.00', '650.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3346', '2021-09-07', '04:38:39 PM', '20210907061', '03349', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3347', '2021-09-07', '04:39:29 PM', '20210907062', '03350', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3348', '2021-09-07', '04:45:52 PM', '20210907063', '03351', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3349', '2021-09-07', '04:52:53 PM', '20210907064', '03352', 'diagnosis', 'diagnosis', '2350.00', '0', '0.00', '2350.00', '850.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1500.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3350', '2021-09-07', '04:54:52 PM', '20210907065', '03353', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3351', '2021-09-07', '04:56:13 PM', '20210907066', '03354', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '0.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3352', '2021-09-07', '04:58:09 PM', '20210907067', '03355', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '100.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3353', '2021-09-07', '05:04:52 PM', '20210907068', '03356', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '200.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3354', '2021-09-07', '05:08:20 PM', '20210907069', '03357', 'diagnosis', 'diagnosis', '2900.00', '0', '0.00', '2900.00', '1400.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1000.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3355', '2021-09-07', '05:30:48 PM', '20210907070', '03358', 'diagnosis', 'diagnosis', '1250.00', '0', '0.00', '1250.00', '250.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3356', '2021-09-07', '05:32:13 PM', '20210907071', '03359', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3357', '2021-09-07', '05:33:00 PM', '20210907072', '03360', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3358', '2021-09-07', '05:36:36 PM', '20210907073', '03361', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3359', '2021-09-07', '06:01:36 PM', '20210907074', '03362', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '500.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3360', '2021-09-07', '06:22:05 PM', '20210907075', '03363', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '0.00', 'Flat', '1050.00', '500.00', '0.00', '550.00', '500.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3361', '2021-09-07', '06:28:22 PM', '20210907076', '03364', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3362', '2021-09-07', '06:29:01 PM', '20210907077', '03365', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3363', '2021-09-07', '06:37:40 PM', '20210907078', '03366', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3364', '2021-09-07', '06:54:45 PM', '20210907079', '03367', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-09-07', 'pending', '', '15', '', 'diagnosis', '2021-09-07 08:00 PM'), 
('3365', '2021-09-08', '10:15:33 AM', '20210908001', '03368', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '200.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3366', '2021-09-08', '10:33:53 AM', '20210908002', '03369', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3367', '2021-09-08', '10:54:07 AM', '20210908003', '03370', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3368', '2021-09-08', '10:55:17 AM', '20210908004', '03371', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3369', '2021-09-08', '10:56:42 AM', '20210908005', '03372', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '200.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3370', '2021-09-08', '11:11:09 AM', '20210908006', '03373', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '200.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3371', '2021-09-08', '11:18:25 AM', '20210908007', '03374', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '200.00', 'Flat', '1000.00', '700.00', '0.00', '300.00', '700.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3372', '2021-09-08', '11:21:56 AM', '20210908008', '03375', 'diagnosis', 'diagnosis', '1850.00', '0', '0.00', '1850.00', '600.00', 'Flat', '1250.00', '1250.00', '0.00', '0.00', '1250.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3373', '2021-09-08', '11:36:55 AM', '20210908009', '03376', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '75.00', 'Flat', '75.00', '75.00', '0.00', '0.00', '75.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3374', '2021-09-08', '11:38:17 AM', '20210908010', '03377', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '75.00', 'Flat', '75.00', '75.00', '0.00', '0.00', '75.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3375', '2021-09-08', '11:46:13 AM', '20210908011', '03378', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '250.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3376', '2021-09-08', '11:50:17 AM', '20210908012', '03379', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '250.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3377', '2021-09-08', '11:54:15 AM', '20210908013', '03380', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '150.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3378', '2021-09-08', '11:58:07 AM', '20210908014', '03381', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3379', '2021-09-08', '12:04:58 PM', '20210908015', '03382', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3380', '2021-09-08', '12:11:22 PM', '20210908016', '03383', 'diagnosis', 'diagnosis', '2500.00', '0', '0.00', '2500.00', '0.00', 'Flat', '2500.00', '500.00', '0.00', '2000.00', '500.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3381', '2021-09-08', '12:23:23 PM', '20210908017', '03384', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3382', '2021-09-08', '12:24:54 PM', '20210908018', '03385', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3383', '2021-09-08', '12:29:21 PM', '20210908019', '03386', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3384', '2021-09-08', '12:39:18 PM', '20210908020', '03387', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '0.00', 'Flat', '650.00', '0.00', '0.00', '650.00', '0.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3385', '2021-09-08', '01:10:54 PM', '20210908021', '03388', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3386', '2021-09-08', '01:12:11 PM', '20210908022', '03389', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3387', '2021-09-08', '01:16:33 PM', '20210908023', '03390', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3388', '2021-09-08', '01:27:54 PM', '20210908024', '03391', 'diagnosis', 'diagnosis', '2750.00', '0', '0.00', '2350.00', '450.00', 'Flat', '2300.00', '2300.00', '400.00', '0.00', '2300.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3389', '2021-09-08', '01:50:13 PM', '20210908025', '03392', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3390', '2021-09-08', '01:52:43 PM', '20210908026', '03393', 'diagnosis', 'diagnosis', '1100.00', '0', '0.00', '1100.00', '300.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3391', '2021-09-08', '01:54:04 PM', '20210908027', '03394', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '250.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3392', '2021-09-08', '01:56:30 PM', '20210908028', '03395', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3393', '2021-09-08', '02:01:00 PM', '20210908029', '03396', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '300.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3394', '2021-09-08', '02:02:47 PM', '20210908030', '03397', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '300.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3395', '2021-09-08', '02:08:50 PM', '20210908031', '03398', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '200.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3396', '2021-09-08', '02:47:43 PM', '20210908032', '03399', 'diagnosis', 'diagnosis', '500.00', '0', '0.00', '500.00', '0.00', 'Flat', '500.00', '0.00', '0.00', '500.00', '0.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3397', '2021-09-08', '02:54:35 PM', '20210908033', '03400', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3398', '2021-09-08', '03:00:08 PM', '20210908034', '03401', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '450.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3399', '2021-09-08', '03:03:55 PM', '20210908035', '03402', 'diagnosis', 'diagnosis', '1850.00', '0', '0.00', '1850.00', '350.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1500.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3400', '2021-09-08', '03:18:35 PM', '20210908036', '03403', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3401', '2021-09-08', '03:38:18 PM', '20210908037', '03404', 'diagnosis', 'diagnosis', '2100.00', '0', '0.00', '2100.00', '0.00', 'Flat', '2100.00', '1000.00', '0.00', '1100.00', '1000.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3402', '2021-09-08', '03:46:26 PM', '20210908038', '03405', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '0.00', 'Flat', '650.00', '0.00', '0.00', '650.00', '0.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3403', '2021-09-08', '03:49:01 PM', '20210908039', '03406', 'diagnosis', 'diagnosis', '1550.00', '0', '0.00', '1550.00', '750.00', 'Flat', '800.00', '0.00', '0.00', '800.00', '0.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3404', '2021-09-08', '03:56:28 PM', '20210908040', '03407', 'diagnosis', 'diagnosis', '1700.00', '0', '0.00', '1700.00', '400.00', 'Flat', '1300.00', '1300.00', '0.00', '0.00', '1300.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3405', '2021-09-08', '04:02:14 PM', '20210908041', '03408', 'diagnosis', 'diagnosis', '1950.00', '0', '0.00', '1950.00', '850.00', 'Flat', '1100.00', '1100.00', '0.00', '0.00', '1100.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3406', '2021-09-08', '04:07:31 PM', '20210908042', '03409', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3407', '2021-09-08', '04:08:41 PM', '20210908043', '03410', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3408', '2021-09-08', '04:10:05 PM', '20210908044', '03411', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3409', '2021-09-08', '04:11:54 PM', '20210908045', '03412', 'diagnosis', 'diagnosis', '1600.00', '0', '0.00', '1600.00', '300.00', 'Flat', '1300.00', '1300.00', '0.00', '0.00', '1300.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3410', '2021-09-08', '04:19:49 PM', '20210908046', '03413', 'diagnosis', 'diagnosis', '1800.00', '0', '0.00', '1800.00', '0.00', 'Flat', '1800.00', '500.00', '0.00', '1300.00', '500.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3411', '2021-09-08', '04:27:27 PM', '20210908047', '03414', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3412', '2021-09-08', '04:30:21 PM', '20210908048', '03415', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '250.00', 'Flat', '1100.00', '1100.00', '0.00', '0.00', '1100.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3413', '2021-09-08', '04:36:30 PM', '20210908049', '03416', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '0.00', '150.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3414', '2021-09-08', '04:38:08 PM', '20210908050', '03417', 'diagnosis', 'diagnosis', '1850.00', '0', '0.00', '1850.00', '0.00', 'Flat', '1850.00', '0.00', '0.00', '1850.00', '0.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3415', '2021-09-08', '04:41:44 PM', '20210908051', '03418', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '400.00', 'Flat', '1100.00', '1100.00', '0.00', '0.00', '1100.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3416', '2021-09-08', '04:46:03 PM', '20210908052', '03419', 'diagnosis', 'diagnosis', '1600.00', '0', '0.00', '1600.00', '300.00', 'Flat', '1300.00', '1300.00', '0.00', '0.00', '1300.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3417', '2021-09-08', '04:51:44 PM', '20210908053', '03420', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3418', '2021-09-08', '04:59:08 PM', '20210908054', '03421', 'diagnosis', 'diagnosis', '1550.00', '0', '0.00', '1550.00', '350.00', 'Flat', '1200.00', '1000.00', '0.00', '200.00', '1000.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3419', '2021-09-08', '05:10:46 PM', '20210908055', '03422', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '400.00', 'Flat', '1100.00', '1100.00', '0.00', '0.00', '1100.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3420', '2021-09-08', '05:19:56 PM', '20210908056', '03423', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1450.00', '550.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3421', '2021-09-08', '05:21:48 PM', '20210908057', '03424', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3422', '2021-09-08', '05:28:40 PM', '20210908058', '03425', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '0.00', 'Flat', '850.00', '500.00', '0.00', '350.00', '500.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3423', '2021-09-08', '05:33:26 PM', '20210908059', '03426', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3424', '2021-09-08', '05:43:37 PM', '20210908060', '03427', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '300.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3425', '2021-09-08', '05:47:28 PM', '20210908061', '03428', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1450.00', '350.00', 'Flat', '1100.00', '1100.00', '0.00', '0.00', '1100.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3426', '2021-09-08', '05:53:06 PM', '20210908062', '03429', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3427', '2021-09-08', '06:21:54 PM', '20210908063', '03430', 'diagnosis', 'diagnosis', '2100.00', '0', '0.00', '2100.00', '500.00', 'Flat', '1600.00', '1600.00', '0.00', '0.00', '1600.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3428', '2021-09-08', '06:32:00 PM', '20210908064', '03431', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1450.00', '50.00', 'Flat', '1400.00', '1400.00', '0.00', '0.00', '1400.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3429', '2021-09-09', '10:08:22 AM', '20210909001', '03432', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '200.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3430', '2021-09-09', '10:15:14 AM', '20210909002', '03433', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3431', '2021-09-09', '10:19:47 AM', '20210909003', '03434', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3432', '2021-09-09', '10:39:25 AM', '20210909004', '03435', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '75.00', 'Flat', '75.00', '75.00', '0.00', '0.00', '75.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3433', '2021-09-09', '10:41:44 AM', '20210909005', '03436', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '75.00', 'Flat', '75.00', '75.00', '0.00', '0.00', '75.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3434', '2021-09-09', '10:45:33 AM', '20210909006', '03437', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '400.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3435', '2021-09-09', '10:59:10 AM', '20210909007', '03438', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3436', '2021-09-09', '11:00:41 AM', '20210909008', '03439', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3437', '2021-09-09', '11:05:01 AM', '20210909009', '03440', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3438', '2021-09-09', '11:09:41 AM', '20210909010', '03441', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3439', '2021-09-09', '11:12:12 AM', '20210909011', '03442', 'diagnosis', 'diagnosis', '1100.00', '0', '0.00', '1100.00', '600.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3440', '2021-09-09', '11:20:10 AM', '20210909012', '03443', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '500.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3441', '2021-09-09', '11:22:17 AM', '20210909013', '03444', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '150.00', '100.00', 'Flat', '200.00', '200.00', '150.00', '0.00', '200.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3442', '2021-09-09', '11:23:41 AM', '20210909014', '03445', 'diagnosis', 'diagnosis', '750.00', '0', '0.00', '750.00', '150.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3443', '2021-09-09', '11:27:17 AM', '20210909015', '03446', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3444', '2021-09-09', '11:34:33 AM', '20210909016', '03447', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3445', '2021-09-09', '11:35:30 AM', '20210909017', '03448', 'diagnosis', 'diagnosis', '600.00', '0', '0.00', '600.00', '0.00', 'Flat', '600.00', '0.00', '0.00', '600.00', '0.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3446', '2021-09-09', '11:37:01 AM', '20210909018', '03449', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '0.00', 'Flat', '700.00', '100.00', '0.00', '600.00', '100.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3447', '2021-09-09', '11:48:59 AM', '20210909019', '03450', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '300.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3448', '2021-09-09', '11:49:59 AM', '20210909020', '03451', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '0.00', 'Flat', '550.00', '0.00', '0.00', '550.00', '0.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3449', '2021-09-09', '12:03:25 PM', '20210909021', '03452', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '50.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3450', '2021-09-09', '12:09:18 PM', '20210909022', '03453', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '200.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3451', '2021-09-09', '12:10:54 PM', '20210909023', '03454', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '350.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3452', '2021-09-09', '12:12:46 PM', '20210909024', '03455', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3453', '2021-09-09', '12:13:37 PM', '20210909025', '03456', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3454', '2021-09-09', '12:15:02 PM', '20210909026', '03457', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '0.00', 'Flat', '650.00', '0.00', '0.00', '650.00', '0.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3455', '2021-09-09', '12:26:42 PM', '20210909027', '03458', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3456', '2021-09-09', '12:27:47 PM', '20210909028', '03459', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3457', '2021-09-09', '12:29:38 PM', '20210909029', '03460', 'diagnosis', 'diagnosis', '2100.00', '0', '0.00', '2100.00', '0.00', 'Flat', '2100.00', '1500.00', '0.00', '600.00', '1500.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3458', '2021-09-09', '12:33:15 PM', '20210909030', '03461', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '0.00', 'Flat', '850.00', '400.00', '0.00', '450.00', '400.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3459', '2021-09-09', '12:37:21 PM', '20210909031', '03462', 'diagnosis', 'diagnosis', '2500.00', '0', '0.00', '2500.00', '0.00', 'Flat', '2500.00', '2500.00', '0.00', '0.00', '2500.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3460', '2021-09-09', '12:38:39 PM', '20210909032', '03463', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '150.00', '100.00', 'Flat', '200.00', '200.00', '150.00', '0.00', '200.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3461', '2021-09-09', '12:44:25 PM', '20210909033', '03464', 'diagnosis', 'diagnosis', '1950.00', '0', '0.00', '1950.00', '750.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3462', '2021-09-09', '12:45:46 PM', '20210909034', '03465', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3463', '2021-09-09', '01:04:53 PM', '20210909035', '03466', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '0.00', '150.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3464', '2021-09-09', '01:31:09 PM', '20210909036', '03467', 'diagnosis', 'diagnosis', '2100.00', '0', '0.00', '2100.00', '600.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1500.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3465', '2021-09-09', '01:34:36 PM', '20210909037', '03468', 'diagnosis', 'diagnosis', '1900.00', '0', '0.00', '1900.00', '0.00', 'Flat', '1900.00', '1900.00', '0.00', '0.00', '1900.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3466', '2021-09-09', '01:36:36 PM', '20210909038', '03469', 'diagnosis', 'diagnosis', '1400.00', '0', '0.00', '1400.00', '700.00', 'Flat', '700.00', '0.00', '0.00', '700.00', '0.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3467', '2021-09-09', '01:38:51 PM', '20210909039', '03470', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3468', '2021-09-09', '01:42:37 PM', '20210909040', '03471', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3469', '2021-09-09', '01:55:10 PM', '20210909041', '03472', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1450.00', '0.00', 'Flat', '1450.00', '0.00', '0.00', '1450.00', '0.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3470', '2021-09-09', '02:05:41 PM', '20210909042', '03473', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '0.00', 'Flat', '550.00', '0.00', '0.00', '550.00', '0.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3471', '2021-09-09', '02:09:43 PM', '20210909043', '03474', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3472', '2021-09-09', '02:44:25 PM', '20210909044', '03475', 'diagnosis', 'diagnosis', '1800.00', '0', '0.00', '1800.00', '1800.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3473', '2021-09-09', '03:00:14 PM', '20210909045', '03476', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3474', '2021-09-09', '03:02:02 PM', '20210909046', '03477', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3475', '2021-09-09', '03:17:28 PM', '20210909047', '03478', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3476', '2021-09-09', '03:42:56 PM', '20210909048', '03479', 'diagnosis', 'diagnosis', '1150.00', '0', '0.00', '1150.00', '150.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3477', '2021-09-09', '03:53:30 PM', '20210909049', '03480', 'diagnosis', 'diagnosis', '1800.00', '0', '0.00', '1800.00', '600.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3478', '2021-09-09', '03:55:56 PM', '20210909050', '03481', 'diagnosis', 'diagnosis', '1150.00', '0', '0.00', '1150.00', '1150.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3479', '2021-09-09', '03:57:33 PM', '20210909051', '03482', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3480', '2021-09-09', '04:00:53 PM', '20210909052', '03483', 'diagnosis', 'diagnosis', '2450.00', '0', '0.00', '2450.00', '0.00', 'Flat', '2450.00', '500.00', '0.00', '1950.00', '500.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3481', '2021-09-09', '04:16:28 PM', '20210909053', '03484', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '500.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3482', '2021-09-09', '04:23:00 PM', '20210909054', '03485', 'diagnosis', 'diagnosis', '1400.00', '0', '0.00', '1400.00', '400.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3483', '2021-09-09', '04:37:13 PM', '20210909055', '03486', 'diagnosis', 'diagnosis', '1750.00', '0', '0.00', '1750.00', '550.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3484', '2021-09-09', '04:41:17 PM', '20210909056', '03487', 'diagnosis', 'diagnosis', '2150.00', '0', '0.00', '2150.00', '650.00', 'Flat', '1500.00', '100.00', '0.00', '1400.00', '100.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3485', '2021-09-09', '04:45:28 PM', '20210909057', '03488', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '0.00', '0.00', '400.00', '0.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3486', '2021-09-09', '04:48:02 PM', '20210909058', '03489', 'diagnosis', 'diagnosis', '600.00', '0', '0.00', '600.00', '100.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3487', '2021-09-09', '05:05:34 PM', '20210909059', '03490', 'diagnosis', 'diagnosis', '2150.00', '0', '0.00', '2150.00', '0.00', 'Flat', '2150.00', '500.00', '0.00', '1650.00', '500.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3488', '2021-09-09', '05:09:58 PM', '20210909060', '03491', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '150.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3489', '2021-09-09', '05:32:34 PM', '20210909061', '03492', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3490', '2021-09-09', '05:37:20 PM', '20210909062', '03493', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '500.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3491', '2021-09-09', '05:40:44 PM', '20210909063', '03494', 'diagnosis', 'diagnosis', '1600.00', '0', '0.00', '1600.00', '800.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3492', '2021-09-09', '05:44:54 PM', '20210909064', '03495', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3493', '2021-09-09', '05:48:20 PM', '20210909065', '03496', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3494', '2021-09-09', '06:00:12 PM', '20210909066', '03497', 'diagnosis', 'diagnosis', '2350.00', '0', '0.00', '2350.00', '0.00', 'Flat', '2350.00', '1400.00', '0.00', '950.00', '1400.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3495', '2021-09-09', '06:16:17 PM', '20210909067', '03498', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '200.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3496', '2021-09-09', '06:35:34 PM', '20210909068', '03499', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-09', 'pending', '', '15', '', 'diagnosis', '2021-09-09 08:00 PM'), 
('3497', '2021-09-10', '10:28:38 AM', '20210910001', '03500', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3498', '2021-09-10', '10:31:01 AM', '20210910002', '03501', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3499', '2021-09-10', '10:46:50 AM', '20210910003', '03502', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3500', '2021-09-10', '11:01:02 AM', '20210910004', '03503', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '150.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3501', '2021-09-10', '11:07:47 AM', '20210910005', '03504', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '90.00', 'Flat', '60.00', '60.00', '0.00', '0.00', '60.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3502', '2021-09-10', '11:20:20 AM', '20210910006', '03505', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '50.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3503', '2021-09-10', '11:22:18 AM', '20210910007', '03506', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3504', '2021-09-10', '11:24:12 AM', '20210910008', '03507', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3505', '2021-09-10', '11:28:22 AM', '20210910009', '03508', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3506', '2021-09-10', '11:30:24 AM', '20210910010', '03509', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '400.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3507', '2021-09-10', '11:34:18 AM', '20210910011', '03510', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3508', '2021-09-10', '11:38:48 AM', '20210910012', '03511', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '0.00', 'Flat', '1300.00', '800.00', '0.00', '500.00', '800.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3509', '2021-09-10', '11:40:04 AM', '20210910013', '03512', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '300.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3510', '2021-09-10', '11:42:14 AM', '20210910014', '03513', 'diagnosis', 'diagnosis', '3050.00', '0', '0.00', '3050.00', '550.00', 'Flat', '2500.00', '2500.00', '0.00', '0.00', '2500.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3511', '2021-09-10', '11:45:13 AM', '20210910015', '03514', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3512', '2021-09-10', '11:47:09 AM', '20210910016', '03515', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3513', '2021-09-10', '11:48:12 AM', '20210910017', '03516', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3514', '2021-09-10', '11:49:54 AM', '20210910018', '03517', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '500.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3515', '2021-09-10', '11:50:40 AM', '20210910019', '03518', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '500.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3516', '2021-09-10', '11:51:22 AM', '20210910020', '03519', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '500.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3517', '2021-09-10', '11:54:27 AM', '20210910021', '03520', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3518', '2021-09-10', '11:55:16 AM', '20210910022', '03521', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '500.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3519', '2021-09-10', '11:57:34 AM', '20210910023', '03522', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3520', '2021-09-10', '11:58:26 AM', '20210910024', '03523', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '400.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3521', '2021-09-10', '12:03:42 PM', '20210910025', '03524', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3522', '2021-09-10', '12:05:06 PM', '20210910026', '03525', 'diagnosis', 'diagnosis', '1700.00', '0', '0.00', '1700.00', '100.00', 'Flat', '1600.00', '1600.00', '0.00', '0.00', '1600.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3523', '2021-09-10', '12:19:02 PM', '20210910027', '03526', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '300.00', 'Flat', '1000.00', '800.00', '0.00', '200.00', '800.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3524', '2021-09-10', '12:22:32 PM', '20210910028', '03527', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3525', '2021-09-10', '12:36:56 PM', '20210910029', '03528', 'diagnosis', 'diagnosis', '2200.00', '0', '0.00', '1900.00', '400.00', 'Flat', '1800.00', '1800.00', '300.00', '0.00', '1800.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3526', '2021-09-10', '12:41:02 PM', '20210910030', '03529', 'diagnosis', 'diagnosis', '2250.00', '0', '0.00', '2250.00', '1250.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3527', '2021-09-10', '12:43:22 PM', '20210910031', '03530', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3528', '2021-09-10', '12:47:39 PM', '20210910032', '03531', 'diagnosis', 'diagnosis', '2650.00', '0', '0.00', '2650.00', '0.00', 'Flat', '2650.00', '500.00', '0.00', '2150.00', '500.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3529', '2021-09-10', '01:00:49 PM', '20210910033', '03532', 'diagnosis', 'diagnosis', '3050.00', '0', '0.00', '3050.00', '1050.00', 'Flat', '2000.00', '1500.00', '0.00', '500.00', '1500.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3530', '2021-09-10', '01:04:17 PM', '20210910034', '03533', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3531', '2021-09-10', '01:06:13 PM', '20210910035', '03534', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '200.00', '0.00', '200.00', '200.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3532', '2021-09-10', '01:09:06 PM', '20210910036', '03535', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '250.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3533', '2021-09-10', '01:10:07 PM', '20210910037', '03536', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '500.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3534', '2021-09-10', '01:12:09 PM', '20210910038', '03537', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '200.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-09-10', 'pending', '', '15', 'niramo', 'diagnosis', '2021-09-10 08:00 PM'), 
('3535', '2021-09-10', '01:13:46 PM', '20210910039', '03538', 'diagnosis', 'diagnosis', '1400.00', '0', '0.00', '1400.00', '400.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3536', '2021-09-10', '01:14:54 PM', '20210910040', '03539', 'diagnosis', 'diagnosis', '1550.00', '0', '0.00', '1550.00', '550.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3537', '2021-09-10', '01:16:17 PM', '20210910041', '03540', 'diagnosis', 'diagnosis', '1550.00', '0', '0.00', '1550.00', '550.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3538', '2021-09-10', '01:17:40 PM', '20210910042', '03541', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '150.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3539', '2021-09-10', '01:18:52 PM', '20210910043', '03542', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '400.00', 'Flat', '1100.00', '1100.00', '0.00', '0.00', '1100.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3540', '2021-09-10', '01:19:59 PM', '20210910044', '03543', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '400.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3541', '2021-09-10', '01:21:13 PM', '20210910045', '03544', 'diagnosis', 'diagnosis', '1900.00', '0', '0.00', '1900.00', '500.00', 'Flat', '1400.00', '1400.00', '0.00', '0.00', '1400.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3542', '2021-09-10', '01:22:35 PM', '20210910046', '03545', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '0.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3543', '2021-09-10', '01:24:02 PM', '20210910047', '03546', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '350.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3544', '2021-09-10', '01:25:34 PM', '20210910048', '03547', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3545', '2021-09-10', '01:26:35 PM', '20210910049', '03548', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '200.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3546', '2021-09-10', '01:27:41 PM', '20210910050', '03549', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3547', '2021-09-10', '01:29:20 PM', '20210910051', '03550', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '50.00', 'Flat', '850.00', '850.00', '0.00', '0.00', '850.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3548', '2021-09-10', '01:42:22 PM', '20210910052', '03551', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '300.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3549', '2021-09-10', '01:45:50 PM', '20210910053', '03552', 'diagnosis', 'diagnosis', '1900.00', '0', '0.00', '1900.00', '400.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1500.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3550', '2021-09-10', '01:48:21 PM', '20210910054', '03553', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '0.00', 'Flat', '900.00', '500.00', '0.00', '400.00', '500.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3551', '2021-09-10', '01:49:57 PM', '20210910055', '03554', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '0.00', '0.00', '400.00', '0.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3552', '2021-09-10', '01:57:24 PM', '20210910056', '03555', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '0.00', 'Flat', '900.00', '0.00', '0.00', '900.00', '0.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3553', '2021-09-10', '02:00:26 PM', '20210910057', '03556', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '0.00', '0.00', '400.00', '0.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3554', '2021-09-10', '02:05:58 PM', '20210910058', '03557', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3555', '2021-09-10', '02:10:27 PM', '20210910059', '03558', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '400.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3556', '2021-09-10', '02:12:31 PM', '20210910060', '03559', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '100.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3557', '2021-09-10', '02:14:42 PM', '20210910061', '03560', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3558', '2021-09-10', '02:24:54 PM', '20210910062', '03561', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '200.00', 'Flat', '1100.00', '1100.00', '0.00', '0.00', '1100.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3559', '2021-09-10', '02:33:59 PM', '20210910063', '03562', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '100.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3560', '2021-09-10', '02:46:23 PM', '20210910064', '03563', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '100.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3561', '2021-09-10', '02:52:45 PM', '20210910065', '03564', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '0.00', 'Flat', '900.00', '200.00', '0.00', '700.00', '200.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3562', '2021-09-10', '02:54:49 PM', '20210910066', '03565', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '150.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3563', '2021-09-10', '03:14:50 PM', '20210910067', '03566', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '200.00', 'Flat', '1100.00', '1100.00', '0.00', '0.00', '1100.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3564', '2021-09-10', '03:43:49 PM', '20210910068', '03567', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '100.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3565', '2021-09-10', '03:46:10 PM', '20210910069', '03568', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '450.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-10-04 08:00 PM'), 
('3566', '2021-09-10', '03:50:30 PM', '20210910070', '03569', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3567', '2021-09-10', '03:53:28 PM', '20210910071', '03570', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '150.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3568', '2021-09-10', '03:54:43 PM', '20210910072', '03571', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3569', '2021-09-10', '03:57:24 PM', '20210910073', '03572', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '200.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3570', '2021-09-10', '03:59:16 PM', '20210910074', '03573', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '300.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3571', '2021-09-10', '04:04:21 PM', '20210910075', '03574', 'diagnosis', 'diagnosis', '1850.00', '0', '0.00', '1850.00', '350.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1500.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3572', '2021-09-10', '04:05:40 PM', '20210910076', '03575', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3573', '2021-09-10', '04:07:53 PM', '20210910077', '03576', 'diagnosis', 'diagnosis', '1800.00', '0', '0.00', '1800.00', '800.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3574', '2021-09-10', '04:09:59 PM', '20210910078', '03577', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '150.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3575', '2021-09-10', '04:15:23 PM', '20210910079', '03578', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '300.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3576', '2021-09-10', '04:17:11 PM', '20210910080', '03579', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3577', '2021-09-10', '04:20:38 PM', '20210910081', '03580', 'diagnosis', 'diagnosis', '1150.00', '0', '0.00', '1150.00', '150.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3578', '2021-09-10', '04:23:57 PM', '20210910082', '03581', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3579', '2021-09-10', '04:27:44 PM', '20210910083', '03582', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3580', '2021-09-10', '04:30:56 PM', '20210910084', '03583', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3581', '2021-09-10', '04:32:50 PM', '20210910085', '03584', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '300.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3582', '2021-09-10', '04:34:47 PM', '20210910086', '03585', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '100.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3583', '2021-09-10', '04:43:17 PM', '20210910087', '03586', 'diagnosis', 'diagnosis', '2050.00', '0', '0.00', '2050.00', '250.00', 'Flat', '1800.00', '1500.00', '0.00', '300.00', '1500.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3584', '2021-09-10', '04:51:29 PM', '20210910088', '03587', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '100.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3585', '2021-09-10', '04:54:11 PM', '20210910089', '03588', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3586', '2021-09-10', '04:57:46 PM', '20210910090', '03589', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3587', '2021-09-10', '04:58:13 PM', '20210910091', '03590', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '150.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3588', '2021-09-10', '05:01:09 PM', '20210910092', '03591', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '200.00', 'Flat', '1100.00', '1100.00', '0.00', '0.00', '1100.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3589', '2021-09-10', '05:02:58 PM', '20210910093', '03592', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3590', '2021-09-10', '05:04:59 PM', '20210910094', '03593', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '100.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3591', '2021-09-10', '05:07:24 PM', '20210910095', '03594', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '500.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3592', '2021-09-10', '05:09:45 PM', '20210910096', '03595', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '400.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3593', '2021-09-10', '05:11:49 PM', '20210910097', '03596', 'diagnosis', 'diagnosis', '1100.00', '0', '0.00', '1100.00', '300.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3594', '2021-09-10', '05:13:59 PM', '20210910098', '03597', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '0.00', 'Flat', '900.00', '0.00', '0.00', '900.00', '0.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3595', '2021-09-10', '05:16:41 PM', '20210910099', '03598', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '800.00', '0.00', 'Flat', '1000.00', '0.00', '200.00', '1000.00', '0.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3596', '2021-09-10', '05:18:21 PM', '20210910100', '03599', 'diagnosis', 'diagnosis', '1900.00', '0', '0.00', '1900.00', '300.00', 'Flat', '1600.00', '1600.00', '0.00', '0.00', '1600.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3597', '2021-09-10', '05:20:45 PM', '20210910101', '03600', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '500.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3598', '2021-09-10', '05:23:11 PM', '20210910102', '03601', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '100.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3599', '2021-09-10', '05:27:22 PM', '20210910103', '03602', 'diagnosis', 'diagnosis', '1250.00', '0', '0.00', '1250.00', '650.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3600', '2021-09-10', '05:32:08 PM', '20210910104', '03603', 'diagnosis', 'diagnosis', '2200.00', '0', '0.00', '2200.00', '0.00', 'Flat', '2200.00', '340.00', '0.00', '1860.00', '340.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3601', '2021-09-10', '05:35:26 PM', '20210910105', '03604', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3602', '2021-09-10', '05:36:01 PM', '20210910106', '03605', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '100.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3603', '2021-09-10', '05:36:34 PM', '20210910107', '03606', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '100.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3604', '2021-09-10', '05:40:45 PM', '20210910108', '03607', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3605', '2021-09-10', '05:42:25 PM', '20210910109', '03608', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '50.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3606', '2021-09-10', '05:50:13 PM', '20210910110', '03609', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '400.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3607', '2021-09-10', '05:59:11 PM', '20210910111', '03610', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '300.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-08', 'pending', '', '15', '', 'diagnosis', '2021-09-08 08:00 PM'), 
('3608', '2021-09-10', '06:18:43 PM', '20210910112', '03611', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '100.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3609', '2021-09-10', '06:21:50 PM', '20210910113', '03612', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '0.00', 'Flat', '800.00', '500.00', '0.00', '300.00', '500.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3610', '2021-09-10', '07:13:59 PM', '20210910114', '03613', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '150.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-09-10', 'pending', '', '15', '', 'diagnosis', '2021-09-10 08:00 PM'), 
('3611', '2021-09-11', '10:30:09 AM', '20210911001', '03614', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '0.00', '150.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3612', '2021-09-11', '10:34:21 AM', '20210911002', '03615', 'diagnosis', 'diagnosis', '1150.00', '0', '0.00', '1150.00', '150.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3613', '2021-09-11', '10:43:19 AM', '20210911003', '03616', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3614', '2021-09-11', '11:14:06 AM', '20210911004', '03617', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '200.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3615', '2021-09-11', '11:15:13 AM', '20210911005', '03618', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3616', '2021-09-11', '11:20:41 AM', '20210911006', '03619', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3617', '2021-09-11', '11:24:43 AM', '20210911007', '03620', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3618', '2021-09-11', '11:27:54 AM', '20210911008', '03621', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3619', '2021-09-11', '11:29:42 AM', '20210911009', '03622', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '200.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3620', '2021-09-11', '11:36:43 AM', '20210911010', '03623', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '700.00', 'Flat', '600.00', '400.00', '0.00', '200.00', '400.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3621', '2021-09-11', '11:38:24 AM', '20210911011', '03624', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '0.00', 'Flat', '800.00', '0.00', '0.00', '800.00', '0.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3622', '2021-09-11', '11:40:47 AM', '20210911012', '03625', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '350.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3623', '2021-09-11', '11:44:39 AM', '20210911013', '03626', 'diagnosis', 'diagnosis', '1400.00', '0', '0.00', '1400.00', '0.00', 'Flat', '1400.00', '500.00', '0.00', '900.00', '500.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3624', '2021-09-11', '11:45:58 AM', '20210911014', '03627', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '500.00', '0.00', '700.00', '500.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3625', '2021-09-11', '11:50:59 AM', '20210911015', '03628', 'diagnosis', 'diagnosis', '200.00', '0', '0.00', '200.00', '100.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3626', '2021-09-11', '12:00:59 PM', '20210911016', '03629', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '50.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3627', '2021-09-11', '12:04:12 PM', '20210911017', '03630', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '200.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3628', '2021-09-11', '12:06:20 PM', '20210911018', '03631', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '50.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3629', '2021-09-11', '12:10:09 PM', '20210911019', '03632', 'diagnosis', 'diagnosis', '1950.00', '0', '0.00', '1950.00', '0.00', 'Flat', '1950.00', '1500.00', '0.00', '450.00', '1500.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3630', '2021-09-11', '12:12:26 PM', '20210911020', '03633', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '200.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3631', '2021-09-11', '12:14:28 PM', '20210911021', '03634', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3632', '2021-09-11', '12:19:05 PM', '20210911022', '03635', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3633', '2021-09-11', '12:24:51 PM', '20210911023', '03636', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3634', '2021-09-11', '12:34:05 PM', '20210911024', '03637', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3635', '2021-09-11', '12:36:05 PM', '20210911025', '03638', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '300.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3636', '2021-09-11', '12:40:16 PM', '20210911026', '03639', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '0.00', 'Flat', '650.00', '0.00', '0.00', '650.00', '0.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3637', '2021-09-11', '12:45:33 PM', '20210911027', '03640', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3638', '2021-09-11', '12:47:38 PM', '20210911028', '03641', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3639', '2021-09-11', '12:48:38 PM', '20210911029', '03642', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3640', '2021-09-11', '12:50:59 PM', '20210911030', '03643', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '300.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3641', '2021-09-11', '12:52:38 PM', '20210911031', '03644', 'diagnosis', 'diagnosis', '1700.00', '0', '0.00', '1700.00', '500.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3642', '2021-09-11', '12:54:52 PM', '20210911032', '03645', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '50.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3643', '2021-09-11', '12:56:20 PM', '20210911033', '03646', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '300.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3644', '2021-09-11', '01:02:19 PM', '20210911034', '03647', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3645', '2021-09-11', '01:13:21 PM', '20210911035', '03648', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3646', '2021-09-11', '01:16:41 PM', '20210911036', '03649', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '500.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3647', '2021-09-11', '01:19:50 PM', '20210911037', '03650', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3648', '2021-09-11', '01:21:22 PM', '20210911038', '03651', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3649', '2021-09-11', '01:22:19 PM', '20210911039', '03652', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3650', '2021-09-11', '01:33:15 PM', '20210911040', '03653', 'diagnosis', 'diagnosis', '2300.00', '0', '0.00', '2300.00', '0.00', 'Flat', '2300.00', '1000.00', '0.00', '1300.00', '1000.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3651', '2021-09-11', '01:39:43 PM', '20210911041', '03654', 'diagnosis', 'diagnosis', '1700.00', '0', '0.00', '1700.00', '0.00', 'Flat', '1700.00', '500.00', '0.00', '1200.00', '500.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3652', '2021-09-11', '02:03:21 PM', '20210911042', '03655', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '400.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3653', '2021-09-11', '02:14:40 PM', '20210911043', '03656', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '100.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3654', '2021-09-11', '02:15:54 PM', '20210911044', '03657', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3655', '2021-09-11', '02:19:09 PM', '20210911045', '03658', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '200.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3656', '2021-09-11', '02:26:17 PM', '20210911046', '03659', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '0.00', 'Flat', '700.00', '0.00', '0.00', '700.00', '0.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3657', '2021-09-11', '02:39:14 PM', '20210911047', '03660', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '100.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3658', '2021-09-11', '02:52:43 PM', '20210911048', '03661', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3659', '2021-09-11', '02:56:23 PM', '20210911049', '03662', 'diagnosis', 'diagnosis', '1550.00', '0', '0.00', '1550.00', '350.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3660', '2021-09-11', '02:58:06 PM', '20210911050', '03663', 'diagnosis', 'diagnosis', '1250.00', '0', '0.00', '1250.00', '650.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3661', '2021-09-11', '03:21:09 PM', '20210911051', '03664', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '0.00', 'Flat', '550.00', '550.00', '0.00', '0.00', '550.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3662', '2021-09-11', '03:27:13 PM', '20210911052', '03665', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '300.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3663', '2021-09-11', '03:43:41 PM', '20210911053', '03666', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '150.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3664', '2021-09-11', '03:45:02 PM', '20210911054', '03667', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '0.00', 'Flat', '950.00', '0.00', '0.00', '950.00', '0.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3665', '2021-09-11', '03:47:37 PM', '20210911055', '03668', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '0.00', 'Flat', '800.00', '0.00', '0.00', '800.00', '0.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3666', '2021-09-11', '03:50:35 PM', '20210911056', '03669', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3667', '2021-09-11', '03:51:58 PM', '20210911057', '03670', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3668', '2021-09-11', '03:56:31 PM', '20210911058', '03671', 'diagnosis', 'diagnosis', '1250.00', '0', '0.00', '1250.00', '250.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3669', '2021-09-11', '03:58:09 PM', '20210911059', '03672', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '100.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3670', '2021-09-11', '04:06:29 PM', '20210911060', '03673', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3671', '2021-09-11', '04:09:20 PM', '20210911061', '03674', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3672', '2021-09-11', '04:11:56 PM', '20210911062', '03675', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '200.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3673', '2021-09-11', '04:14:13 PM', '20210911063', '03676', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '400.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3674', '2021-09-11', '04:16:04 PM', '20210911064', '03677', 'diagnosis', 'diagnosis', '1250.00', '0', '0.00', '1250.00', '450.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3675', '2021-09-11', '04:17:24 PM', '20210911065', '03678', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '0.00', '0.00', '400.00', '0.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3676', '2021-09-11', '04:19:14 PM', '20210911066', '03679', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '250.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3677', '2021-09-11', '04:20:26 PM', '20210911067', '03680', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3678', '2021-09-11', '04:21:46 PM', '20210911068', '03681', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '100.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3679', '2021-09-11', '04:24:34 PM', '20210911069', '03682', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3680', '2021-09-11', '04:27:24 PM', '20210911070', '03683', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '300.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3681', '2021-09-11', '04:37:53 PM', '20210911071', '03684', 'diagnosis', 'diagnosis', '1700.00', '0', '0.00', '1700.00', '200.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1500.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3682', '2021-09-11', '04:37:53 PM', '20210911071', '03684', 'diagnosis', 'diagnosis', '1700.00', '0', '0.00', '1700.00', '200.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1500.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3683', '2021-09-11', '04:44:28 PM', '20210911072', '03686', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3684', '2021-09-11', '04:46:27 PM', '20210911073', '03687', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '0.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3685', '2021-09-11', '04:50:33 PM', '20210911074', '03688', 'diagnosis', 'diagnosis', '2250.00', '0', '0.00', '2250.00', '0.00', 'Flat', '2250.00', '700.00', '0.00', '1550.00', '700.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3686', '2021-09-11', '04:59:48 PM', '20210911075', '03689', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1450.00', '550.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3687', '2021-09-11', '05:01:11 PM', '20210911076', '03690', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '250.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3688', '2021-09-11', '05:23:35 PM', '20210911077', '03691', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '250.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3689', '2021-09-11', '05:24:54 PM', '20210911078', '03692', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '350.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3690', '2021-09-11', '05:52:01 PM', '20210911079', '03693', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3691', '2021-09-11', '05:56:05 PM', '20210911080', '03694', 'diagnosis', 'diagnosis', '1700.00', '0', '0.00', '1700.00', '1700.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3692', '2021-09-11', '06:15:05 PM', '20210911081', '03695', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '300.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-11', 'pending', '', '15', '', 'diagnosis', '2021-09-11 08:00 PM'), 
('3693', '2021-09-12', '10:04:44 AM', '20210912001', '03696', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '200.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3694', '2021-09-12', '10:05:20 AM', '20210912002', '03697', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3695', '2021-09-12', '10:06:09 AM', '20210912003', '03698', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3696', '2021-09-12', '10:09:42 AM', '20210912004', '03699', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '500.00', '0.00', '700.00', '500.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3697', '2021-09-12', '10:49:14 AM', '20210912005', '03700', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3698', '2021-09-12', '10:53:28 AM', '20210912006', '03701', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '300.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3699', '2021-09-12', '11:05:20 AM', '20210912007', '03702', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3700', '2021-09-12', '11:08:28 AM', '20210912008', '03703', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3701', '2021-09-12', '11:09:48 AM', '20210912009', '03704', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3702', '2021-09-12', '11:19:58 AM', '20210912010', '03705', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3703', '2021-09-12', '11:24:44 AM', '20210912011', '03706', 'diagnosis', 'diagnosis', '350.00', '0', '0.00', '350.00', '50.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3704', '2021-09-12', '11:37:18 AM', '20210912012', '03707', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3705', '2021-09-12', '11:40:21 AM', '20210912013', '03708', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '70.00', 'Flat', '80.00', '80.00', '0.00', '0.00', '80.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3706', '2021-09-12', '11:44:05 AM', '20210912014', '03709', 'diagnosis', 'diagnosis', '1850.00', '0', '0.00', '1850.00', '250.00', 'Flat', '1600.00', '1600.00', '0.00', '0.00', '1600.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3707', '2021-09-12', '11:46:54 AM', '20210912015', '03710', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3708', '2021-09-12', '11:56:50 AM', '20210912016', '03711', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3709', '2021-09-12', '11:59:55 AM', '20210912017', '03712', 'diagnosis', 'diagnosis', '1250.00', '0', '0.00', '1250.00', '350.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3710', '2021-09-12', '12:15:26 PM', '20210912018', '03713', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3711', '2021-09-12', '12:28:02 PM', '20210912019', '03714', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '250.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3712', '2021-09-12', '12:32:54 PM', '20210912020', '03715', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3713', '2021-09-12', '12:36:13 PM', '20210912021', '03716', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '0.00', '0.00', '400.00', '0.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3714', '2021-09-12', '12:44:02 PM', '20210912022', '03717', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3715', '2021-09-12', '12:45:39 PM', '20210912023', '03718', 'diagnosis', 'diagnosis', '1250.00', '0', '0.00', '1250.00', '450.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3716', '2021-09-12', '12:47:55 PM', '20210912024', '03719', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3717', '2021-09-12', '01:08:51 PM', '20210912025', '03720', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3718', '2021-09-12', '01:19:14 PM', '20210912026', '03721', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3719', '2021-09-12', '01:26:45 PM', '20210912027', '03722', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3720', '2021-09-12', '01:54:36 PM', '20210912028', '03723', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3721', '2021-09-12', '02:03:11 PM', '20210912029', '03724', 'diagnosis', 'diagnosis', '0.00', '0', '0.00', '0.00', '0.00', '0', '0.00', '0.00', '0.00', '0.00', '0.00', '0000-00-00', 'pending', '', '15', '0', 'diagnosis', '0'), 
('3722', '2021-09-12', '02:04:55 PM', '20210912030', '03725', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3723', '2021-09-12', '02:11:17 PM', '20210912031', '03726', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3724', '2021-09-12', '02:40:44 PM', '20210912032', '03727', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '350.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3725', '2021-09-12', '02:43:17 PM', '20210912033', '03728', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '0.00', 'Flat', '800.00', '0.00', '0.00', '800.00', '0.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3726', '2021-09-12', '03:08:22 PM', '20210912034', '03729', 'diagnosis', 'diagnosis', '350.00', '0', '0.00', '350.00', '250.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3727', '2021-09-12', '03:15:03 PM', '20210912035', '03730', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3728', '2021-09-12', '03:22:06 PM', '20210912036', '03731', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3729', '2021-09-12', '03:36:21 PM', '20210912037', '03732', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3730', '2021-09-12', '03:45:27 PM', '20210912038', '03733', 'diagnosis', 'diagnosis', '2850.00', '0', '0.00', '2850.00', '0.00', 'Flat', '2850.00', '500.00', '0.00', '2350.00', '500.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3731', '2021-09-12', '03:46:47 PM', '20210912039', '03734', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '0.00', 'Flat', '950.00', '0.00', '0.00', '950.00', '0.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3732', '2021-09-12', '03:53:14 PM', '20210912040', '03735', 'diagnosis', 'diagnosis', '1550.00', '0', '0.00', '1550.00', '50.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1500.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3733', '2021-09-12', '03:55:48 PM', '20210912041', '03736', 'diagnosis', 'diagnosis', '2950.00', '0', '0.00', '2950.00', '750.00', 'Flat', '2200.00', '2200.00', '0.00', '0.00', '2200.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3734', '2021-09-12', '03:58:56 PM', '20210912042', '03737', 'diagnosis', 'diagnosis', '2500.00', '0', '0.00', '2500.00', '400.00', 'Flat', '2100.00', '2100.00', '0.00', '0.00', '2100.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3735', '2021-09-12', '04:03:39 PM', '20210912043', '03738', 'diagnosis', 'diagnosis', '600.00', '0', '0.00', '600.00', '100.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3736', '2021-09-12', '04:05:07 PM', '20210912044', '03739', 'diagnosis', 'diagnosis', '2600.00', '0', '0.00', '2600.00', '600.00', 'Flat', '2000.00', '2000.00', '0.00', '0.00', '2000.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3737', '2021-09-12', '04:06:46 PM', '20210912045', '03740', 'diagnosis', 'diagnosis', '1650.00', '0', '0.00', '1650.00', '350.00', 'Flat', '1300.00', '1300.00', '0.00', '0.00', '1300.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3738', '2021-09-12', '04:17:18 PM', '20210912046', '03741', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1450.00', '0.00', 'Flat', '1450.00', '0.00', '0.00', '1450.00', '0.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3739', '2021-09-12', '04:19:03 PM', '20210912047', '03742', 'diagnosis', 'diagnosis', '1250.00', '0', '0.00', '1250.00', '750.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3740', '2021-09-12', '04:19:58 PM', '20210912048', '03743', 'diagnosis', 'diagnosis', '600.00', '0', '0.00', '600.00', '0.00', 'Flat', '600.00', '0.00', '0.00', '600.00', '0.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3741', '2021-09-12', '04:23:18 PM', '20210912049', '03744', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3742', '2021-09-12', '04:29:38 PM', '20210912050', '03745', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1450.00', '450.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3743', '2021-09-12', '04:34:48 PM', '20210912051', '03746', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3744', '2021-09-12', '04:38:22 PM', '20210912052', '03747', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3745', '2021-09-12', '04:40:03 PM', '20210912053', '03748', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3746', '2021-09-12', '04:46:07 PM', '20210912054', '03749', 'diagnosis', 'diagnosis', '1800.00', '0', '0.00', '1800.00', '1000.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3747', '2021-09-12', '04:47:36 PM', '20210912055', '03750', 'diagnosis', 'diagnosis', '750.00', '0', '0.00', '750.00', '450.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3748', '2021-09-12', '04:49:08 PM', '20210912056', '03751', 'diagnosis', 'diagnosis', '750.00', '0', '0.00', '650.00', '400.00', 'Flat', '350.00', '350.00', '100.00', '0.00', '250.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3749', '2021-09-12', '04:50:55 PM', '20210912057', '03752', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '650.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3750', '2021-09-12', '04:55:09 PM', '20210912058', '03753', 'diagnosis', 'diagnosis', '1100.00', '0', '0.00', '800.00', '100.00', 'Flat', '1000.00', '1000.00', '300.00', '0.00', '700.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3751', '2021-09-12', '05:05:36 PM', '20210912059', '03754', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3752', '2021-09-12', '05:07:38 PM', '20210912060', '03755', 'diagnosis', 'diagnosis', '1750.00', '0', '0.00', '1750.00', '350.00', 'Flat', '1400.00', '1400.00', '0.00', '0.00', '1400.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3753', '2021-09-12', '05:09:07 PM', '20210912061', '03756', 'diagnosis', 'diagnosis', '350.00', '0', '0.00', '350.00', '50.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3754', '2021-09-12', '05:10:55 PM', '20210912062', '03757', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3755', '2021-09-12', '05:14:02 PM', '20210912063', '03758', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3756', '2021-09-12', '05:16:19 PM', '20210912064', '03759', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '600.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3757', '2021-09-12', '05:17:49 PM', '20210912065', '03760', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '50.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3758', '2021-09-12', '05:22:45 PM', '20210912066', '03761', 'diagnosis', 'diagnosis', '2150.00', '0', '0.00', '2150.00', '450.00', 'Flat', '1700.00', '1700.00', '0.00', '0.00', '1700.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3759', '2021-09-12', '05:23:18 PM', '20210912067', '03762', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3760', '2021-09-12', '05:25:13 PM', '20210912068', '03763', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3761', '2021-09-12', '05:37:17 PM', '20210912069', '03764', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '150.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3762', '2021-09-12', '05:38:26 PM', '20210912070', '03765', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '200.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3763', '2021-09-12', '05:43:58 PM', '20210912071', '03766', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3764', '2021-09-12', '05:48:57 PM', '20210912072', '03767', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '200.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3765', '2021-09-12', '05:51:24 PM', '20210912073', '03768', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '0.00', 'Flat', '800.00', '0.00', '0.00', '800.00', '0.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3766', '2021-09-12', '06:00:25 PM', '20210912074', '03769', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3767', '2021-09-12', '06:05:56 PM', '20210912075', '03770', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3768', '2021-09-12', '06:09:09 PM', '20210912076', '03771', 'diagnosis', 'diagnosis', '2050.00', '0', '0.00', '2050.00', '0.00', 'Flat', '2050.00', '0.00', '0.00', '2050.00', '0.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3769', '2021-09-12', '06:10:45 PM', '20210912077', '03772', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3770', '2021-09-12', '06:13:48 PM', '20210912078', '03773', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3771', '2021-09-12', '06:35:50 PM', '20210912079', '03774', 'diagnosis', 'diagnosis', '0.00', '0', '0.00', '0.00', '0.00', '0', '0.00', '0.00', '0.00', '0.00', '0.00', '0000-00-00', 'pending', '', '15', '0', 'diagnosis', '0'), 
('3772', '2021-09-12', '06:36:59 PM', '20210912080', '03775', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3774', '2021-09-12', '07:01:37 PM', '20210912081', '03777', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '400.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3775', '2021-09-12', '07:02:53 PM', '20210912082', '03778', 'diagnosis', 'diagnosis', '0.00', '0', '0.00', '0.00', '0.00', '0', '0.00', '0.00', '0.00', '0.00', '0.00', '0000-00-00', 'pending', '', '15', '0', 'diagnosis', '0'), 
('3776', '2021-09-12', '07:42:15 PM', '20210912083', '03779', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '300.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-12', 'pending', '', '15', '', 'diagnosis', '2021-09-12 08:00 PM'), 
('3777', '2021-09-13', '10:33:40 AM', '20210913001', '03780', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3778', '2021-09-13', '10:37:31 AM', '20210913002', '03781', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3779', '2021-09-13', '10:45:12 AM', '20210913003', '03782', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '350.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3780', '2021-09-13', '10:52:40 AM', '20210913004', '03783', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '100.00', 'Flat', '450.00', '450.00', '0.00', '0.00', '450.00', '2021-09-13', 'pending', '', '15', 'Ferdoshi Begum FW V', 'diagnosis', '2021-09-13 08:00 PM'), 
('3781', '2021-09-13', '10:54:06 AM', '20210913005', '03784', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3782', '2021-09-13', '10:57:50 AM', '20210913006', '03785', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3783', '2021-09-13', '10:58:57 AM', '20210913007', '03786', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '350.00', 'Flat', '700.00', '200.00', '0.00', '500.00', '200.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3784', '2021-09-13', '11:00:12 AM', '20210913008', '03787', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3785', '2021-09-13', '11:02:26 AM', '20210913009', '03788', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '400.00', 'Flat', '950.00', '950.00', '0.00', '0.00', '950.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3786', '2021-09-13', '11:04:00 AM', '20210913010', '03789', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3787', '2021-09-13', '11:06:04 AM', '20210913011', '03790', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3788', '2021-09-13', '11:08:24 AM', '20210913012', '03791', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3789', '2021-09-13', '11:11:07 AM', '20210913013', '03792', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3790', '2021-09-13', '11:12:54 AM', '20210913014', '03793', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3791', '2021-09-13', '11:14:06 AM', '20210913015', '03794', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '0.00', 'Flat', '550.00', '100.00', '0.00', '450.00', '100.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3792', '2021-09-13', '11:26:05 AM', '20210913016', '03795', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '100.00', 'Flat', '450.00', '450.00', '0.00', '0.00', '450.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3793', '2021-09-13', '11:29:27 AM', '20210913017', '03796', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '150.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3794', '2021-09-13', '11:36:26 AM', '20210913018', '03797', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3795', '2021-09-13', '11:39:05 AM', '20210913019', '03798', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3796', '2021-09-13', '11:40:42 AM', '20210913020', '03799', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3797', '2021-09-13', '11:44:23 AM', '20210913021', '03800', 'diagnosis', 'diagnosis', '1250.00', '0', '0.00', '1250.00', '0.00', 'Flat', '1250.00', '500.00', '0.00', '750.00', '500.00', '2021-09-13', 'pending', '', '15', 'Dr Anik Mondol Shovo DMF', 'diagnosis', '2021-09-13 08:00 PM'), 
('3798', '2021-09-13', '11:48:09 AM', '20210913022', '03801', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '0.00', 'Flat', '950.00', '200.00', '0.00', '750.00', '200.00', '2021-09-13', 'pending', '', '15', 'Dr Anik Mondol Shovo DMF', 'diagnosis', '2021-09-13 08:00 PM'), 
('3799', '2021-09-13', '11:49:50 AM', '20210913023', '03802', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3800', '2021-09-13', '12:04:26 PM', '20210913024', '03803', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3801', '2021-09-13', '12:05:51 PM', '20210913025', '03804', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3802', '2021-09-13', '12:08:41 PM', '20210913026', '03805', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '0.00', 'Flat', '550.00', '0.00', '0.00', '550.00', '0.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3803', '2021-09-13', '12:21:40 PM', '20210913027', '03806', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3804', '2021-09-13', '12:28:32 PM', '20210913028', '03807', 'diagnosis', 'diagnosis', '1550.00', '0', '0.00', '1550.00', '650.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3805', '2021-09-13', '12:31:15 PM', '20210913029', '03808', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '200.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3806', '2021-09-13', '12:46:59 PM', '20210913030', '03809', 'diagnosis', 'diagnosis', '1250.00', '0', '0.00', '1250.00', '450.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3807', '2021-09-13', '12:49:10 PM', '20210913031', '03810', 'diagnosis', 'diagnosis', '1700.00', '0', '0.00', '1700.00', '500.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3808', '2021-09-13', '12:54:46 PM', '20210913032', '03811', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '400.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3809', '2021-09-13', '12:56:55 PM', '20210913033', '03812', 'diagnosis', 'diagnosis', '1700.00', '0', '0.00', '1700.00', '900.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3810', '2021-09-13', '12:58:45 PM', '20210913034', '03813', 'diagnosis', 'diagnosis', '1550.00', '0', '0.00', '1550.00', '250.00', 'Flat', '1300.00', '1300.00', '0.00', '0.00', '1300.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3811', '2021-09-13', '12:59:43 PM', '20210913035', '03814', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '0.00', 'Flat', '550.00', '0.00', '0.00', '550.00', '0.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3812', '2021-09-13', '01:02:03 PM', '20210913036', '03815', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3813', '2021-09-13', '01:07:48 PM', '20210913037', '03816', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3814', '2021-09-13', '01:27:48 PM', '20210913038', '03817', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3815', '2021-09-13', '01:41:01 PM', '20210913039', '03818', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '400.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3816', '2021-09-13', '01:49:28 PM', '20210913040', '03819', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3817', '2021-09-13', '01:54:17 PM', '20210913041', '03820', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3818', '2021-09-13', '02:04:26 PM', '20210913042', '03821', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3819', '2021-09-13', '02:05:59 PM', '20210913043', '03822', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3820', '2021-09-13', '02:09:25 PM', '20210913044', '03823', 'diagnosis', 'diagnosis', '1550.00', '0', '0.00', '1550.00', '250.00', 'Flat', '1300.00', '1300.00', '0.00', '0.00', '1300.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3821', '2021-09-13', '02:14:03 PM', '20210913045', '03824', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3822', '2021-09-13', '02:38:11 PM', '20210913046', '03825', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3823', '2021-09-13', '03:04:24 PM', '20210913047', '03826', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3824', '2021-09-13', '03:08:45 PM', '20210913048', '03827', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '300.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3825', '2021-09-13', '03:27:21 PM', '20210913049', '03828', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3826', '2021-09-13', '03:42:51 PM', '20210913050', '03829', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '250.00', 'Flat', '550.00', '550.00', '0.00', '0.00', '550.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3827', '2021-09-13', '03:54:28 PM', '20210913051', '03830', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '300.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3828', '2021-09-13', '04:05:48 PM', '20210913052', '03831', 'diagnosis', 'diagnosis', '1100.00', '0', '0.00', '1100.00', '400.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3829', '2021-09-13', '04:06:29 PM', '20210913053', '03832', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3830', '2021-09-13', '04:07:27 PM', '20210913054', '03833', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3831', '2021-09-13', '04:10:21 PM', '20210913055', '03834', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3832', '2021-09-13', '04:14:31 PM', '20210913056', '03835', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '300.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3833', '2021-09-13', '04:25:01 PM', '20210913057', '03836', 'diagnosis', 'diagnosis', '1100.00', '0', '0.00', '1100.00', '200.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3834', '2021-09-13', '04:26:57 PM', '20210913058', '03837', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '300.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3835', '2021-09-13', '04:28:39 PM', '20210913059', '03838', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '450.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3836', '2021-09-13', '04:35:04 PM', '20210913060', '03839', 'diagnosis', 'diagnosis', '1150.00', '0', '0.00', '1150.00', '50.00', 'Flat', '1100.00', '1100.00', '0.00', '0.00', '1100.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3837', '2021-09-13', '04:37:33 PM', '20210913061', '03840', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1450.00', '250.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3838', '2021-09-13', '04:39:18 PM', '20210913062', '03841', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '300.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3839', '2021-09-13', '04:40:46 PM', '20210913063', '03842', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '700.00', '0.00', 'Flat', '800.00', '800.00', '100.00', '0.00', '800.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3840', '2021-09-13', '04:45:38 PM', '20210913064', '03843', 'diagnosis', 'diagnosis', '1150.00', '0', '0.00', '1150.00', '850.00', 'Flat', '300.00', '200.00', '0.00', '100.00', '200.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3841', '2021-09-13', '04:53:01 PM', '20210913065', '03844', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3842', '2021-09-13', '04:56:47 PM', '20210913066', '03845', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '300.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3843', '2021-09-13', '04:59:13 PM', '20210913067', '03846', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3844', '2021-09-13', '05:01:25 PM', '20210913068', '03847', 'diagnosis', 'diagnosis', '1750.00', '0', '0.00', '1750.00', '750.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3845', '2021-09-13', '05:07:35 PM', '20210913069', '03848', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '550.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3846', '2021-09-13', '05:08:31 PM', '20210913070', '03849', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3847', '2021-09-13', '05:18:53 PM', '20210913071', '03850', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3848', '2021-09-13', '05:29:10 PM', '20210913072', '03851', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '500.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3849', '2021-09-13', '06:43:12 PM', '20210913073', '03852', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '250.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-13', 'pending', '', '15', '', 'diagnosis', '2021-09-13 08:00 PM'), 
('3850', '2021-09-14', '10:30:52 AM', '20210914001', '03853', 'diagnosis', 'diagnosis', '0.00', '0', '0.00', '0.00', '0.00', '0', '0.00', '0.00', '0.00', '0.00', '0.00', '0000-00-00', 'pending', '', '15', '0', 'diagnosis', '0'), 
('3851', '2021-09-14', '10:31:50 AM', '20210914002', '03854', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '0.00', '0.00', '400.00', '0.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3852', '2021-09-14', '10:56:00 AM', '20210914003', '03855', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3853', '2021-09-14', '10:57:51 AM', '20210914004', '03856', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '100.00', 'Flat', '450.00', '450.00', '0.00', '0.00', '450.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3854', '2021-09-14', '11:06:24 AM', '20210914005', '03857', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '150.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3855', '2021-09-14', '11:07:12 AM', '20210914006', '03858', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '350.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3856', '2021-09-14', '11:15:52 AM', '20210914007', '03859', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '350.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3857', '2021-09-14', '11:16:47 AM', '20210914008', '03860', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3858', '2021-09-14', '11:20:07 AM', '20210914009', '03861', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3859', '2021-09-14', '11:21:47 AM', '20210914010', '03862', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '250.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3860', '2021-09-14', '11:26:56 AM', '20210914011', '03863', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '250.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3861', '2021-09-14', '11:27:51 AM', '20210914012', '03864', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3862', '2021-09-14', '11:28:42 AM', '20210914013', '03865', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3863', '2021-09-14', '11:29:59 AM', '20210914014', '03866', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '250.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3864', '2021-09-14', '11:31:50 AM', '20210914015', '03867', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3865', '2021-09-14', '11:34:52 AM', '20210914016', '03868', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3866', '2021-09-14', '11:36:39 AM', '20210914017', '03869', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '300.00', 'Flat', '250.00', '200.00', '0.00', '50.00', '200.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3867', '2021-09-14', '11:46:17 AM', '20210914018', '03870', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3868', '2021-09-14', '11:50:25 AM', '20210914019', '03871', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3869', '2021-09-14', '12:02:24 PM', '20210914020', '03872', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '600.00', '0.00', '600.00', '600.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3870', '2021-09-14', '12:17:05 PM', '20210914021', '03873', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3871', '2021-09-14', '12:24:17 PM', '20210914022', '03874', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '400.00', 'Flat', '950.00', '950.00', '0.00', '0.00', '950.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3872', '2021-09-14', '12:36:05 PM', '20210914023', '03875', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '250.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3873', '2021-09-14', '12:40:06 PM', '20210914024', '03876', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3874', '2021-09-14', '12:41:34 PM', '20210914025', '03877', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '700.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3875', '2021-09-14', '12:44:09 PM', '20210914026', '03878', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '200.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3876', '2021-09-14', '12:45:21 PM', '20210914027', '03879', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3877', '2021-09-14', '12:46:20 PM', '20210914028', '03880', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3878', '2021-09-14', '12:48:29 PM', '20210914029', '03881', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3879', '2021-09-14', '12:51:03 PM', '20210914030', '03882', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '350.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3880', '2021-09-14', '12:52:34 PM', '20210914031', '03883', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3881', '2021-09-14', '12:55:47 PM', '20210914032', '03884', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '150.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3882', '2021-09-14', '12:57:28 PM', '20210914033', '03885', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '0.00', 'Flat', '800.00', '0.00', '0.00', '800.00', '0.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3883', '2021-09-14', '12:59:32 PM', '20210914034', '03886', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3884', '2021-09-14', '01:50:04 PM', '20210914035', '03887', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3885', '2021-09-14', '01:56:37 PM', '20210914036', '03888', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '300.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3886', '2021-09-14', '02:04:40 PM', '20210914037', '03889', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3887', '2021-09-14', '02:16:31 PM', '20210914038', '03890', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3888', '2021-09-14', '02:18:17 PM', '20210914039', '03891', 'diagnosis', 'diagnosis', '450.00', '0', '0.00', '450.00', '0.00', 'Flat', '450.00', '0.00', '0.00', '450.00', '0.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3889', '2021-09-14', '02:27:28 PM', '20210914040', '03892', 'diagnosis', 'diagnosis', '0.00', '0', '0.00', '0.00', '0.00', '0', '0.00', '0.00', '0.00', '0.00', '0.00', '0000-00-00', 'pending', '', '15', '0', 'diagnosis', '0'), 
('3890', '2021-09-14', '02:29:10 PM', '20210914041', '03893', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3891', '2021-09-14', '02:51:21 PM', '20210914042', '03894', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '0.00', '150.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3892', '2021-09-14', '03:09:27 PM', '20210914043', '03895', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '950.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '0.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3893', '2021-09-14', '03:10:02 PM', '20210914044', '03896', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3894', '2021-09-14', '03:10:21 PM', '20210914045', '03897', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '950.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '0.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3895', '2021-09-14', '03:21:49 PM', '20210914046', '03898', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3896', '2021-09-14', '03:24:00 PM', '20210914047', '03899', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '950.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '0.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3897', '2021-09-14', '03:29:30 PM', '20210914048', '03900', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '950.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '0.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3898', '2021-09-14', '03:32:22 PM', '20210914049', '03901', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '200.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3899', '2021-09-14', '03:44:38 PM', '20210914050', '03902', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '950.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '0.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3900', '2021-09-14', '03:56:09 PM', '20210914051', '03903', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3901', '2021-09-14', '03:58:29 PM', '20210914052', '03904', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '950.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '0.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3902', '2021-09-14', '03:59:39 PM', '20210914053', '03905', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '950.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '0.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3903', '2021-09-14', '04:01:59 PM', '20210914054', '03906', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '950.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '0.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3904', '2021-09-14', '04:04:44 PM', '20210914055', '03907', 'diagnosis', 'diagnosis', '2150.00', '0', '0.00', '2150.00', '1050.00', 'Flat', '1100.00', '1100.00', '0.00', '0.00', '1100.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3905', '2021-09-14', '04:05:28 PM', '20210914056', '03908', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3906', '2021-09-14', '04:06:43 PM', '20210914057', '03909', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '950.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '0.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3907', '2021-09-14', '04:12:32 PM', '20210914058', '03910', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '950.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '0.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3908', '2021-09-14', '04:13:21 PM', '20210914059', '03911', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '300.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3909', '2021-09-14', '04:16:01 PM', '20210914060', '03912', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '300.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3910', '2021-09-14', '04:17:36 PM', '20210914061', '03913', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '150.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3911', '2021-09-14', '04:19:15 PM', '20210914062', '03914', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '600.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3912', '2021-09-14', '04:21:17 PM', '20210914063', '03915', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '950.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '0.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3913', '2021-09-14', '04:26:34 PM', '20210914064', '03916', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '950.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '0.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3914', '2021-09-14', '04:28:28 PM', '20210914065', '03917', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '150.00', '0.00', '0.00', '150.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3915', '2021-09-14', '04:33:03 PM', '20210914066', '03918', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '0.00', 'Flat', '1300.00', '0.00', '0.00', '1300.00', '0.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3916', '2021-09-14', '04:39:25 PM', '20210914067', '03919', 'diagnosis', 'diagnosis', '1600.00', '0', '0.00', '1600.00', '100.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1500.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3917', '2021-09-14', '04:43:05 PM', '20210914068', '03920', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '700.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3918', '2021-09-14', '04:43:46 PM', '20210914069', '03921', 'diagnosis', 'diagnosis', '450.00', '0', '0.00', '450.00', '250.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3919', '2021-09-14', '04:47:30 PM', '20210914070', '03922', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '450.00', 'Flat', '550.00', '550.00', '0.00', '0.00', '550.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3920', '2021-09-14', '04:51:16 PM', '20210914071', '03923', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '300.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3921', '2021-09-14', '04:52:16 PM', '20210914072', '03924', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3922', '2021-09-14', '04:54:08 PM', '20210914073', '03925', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3923', '2021-09-14', '05:00:41 PM', '20210914074', '03926', 'diagnosis', 'diagnosis', '2400.00', '0', '0.00', '2400.00', '400.00', 'Flat', '2000.00', '1000.00', '0.00', '1000.00', '500.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3924', '2021-09-14', '05:02:45 PM', '20210914075', '03927', 'diagnosis', 'diagnosis', '2650.00', '0', '0.00', '2650.00', '650.00', 'Flat', '2000.00', '2000.00', '0.00', '0.00', '2000.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3925', '2021-09-14', '05:10:09 PM', '20210914076', '03928', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3926', '2021-09-14', '05:11:37 PM', '20210914077', '03929', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '200.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3927', '2021-09-14', '05:13:12 PM', '20210914078', '03930', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '950.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '0.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3928', '2021-09-14', '05:15:42 PM', '20210914079', '03931', 'diagnosis', 'diagnosis', '2150.00', '0', '0.00', '2150.00', '150.00', 'Flat', '2000.00', '2000.00', '0.00', '0.00', '2000.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3929', '2021-09-14', '05:18:20 PM', '20210914080', '03932', 'diagnosis', 'diagnosis', '2000.00', '0', '0.00', '2000.00', '500.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1500.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3930', '2021-09-14', '05:20:26 PM', '20210914081', '03933', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '600.00', '0.00', '600.00', '600.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3931', '2021-09-14', '05:35:20 PM', '20210914082', '03934', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3932', '2021-09-14', '05:39:26 PM', '20210914083', '03935', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '950.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '0.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3933', '2021-09-14', '05:52:08 PM', '20210914084', '03936', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '950.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '0.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3934', '2021-09-14', '06:06:19 PM', '20210914085', '03937', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '950.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '0.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3935', '2021-09-14', '06:09:47 PM', '20210914086', '03938', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3936', '2021-09-14', '06:10:52 PM', '20210914087', '03939', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3937', '2021-09-14', '06:11:58 PM', '20210914088', '03940', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-09-14', 'pending', '', '15', '', 'diagnosis', '2021-09-14 08:00 PM'), 
('3938', '2021-09-15', '09:50:53 AM', '20210915001', '03941', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '450.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3939', '2021-09-15', '09:53:01 AM', '20210915002', '03942', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3940', '2021-09-15', '10:00:39 AM', '20210915003', '03943', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3941', '2021-09-15', '10:09:40 AM', '20210915004', '03944', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '200.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3942', '2021-09-15', '11:04:08 AM', '20210915005', '03945', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '250.00', 'Flat', '1100.00', '1100.00', '0.00', '0.00', '1100.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3943', '2021-09-15', '11:05:55 AM', '20210915006', '03946', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '0.00', 'Flat', '650.00', '0.00', '0.00', '650.00', '0.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3944', '2021-09-15', '11:07:16 AM', '20210915007', '03947', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '700.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3945', '2021-09-15', '11:08:12 AM', '20210915008', '03948', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3946', '2021-09-15', '11:09:15 AM', '20210915009', '03949', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '110.00', 'Flat', '40.00', '40.00', '0.00', '0.00', '40.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3947', '2021-09-15', '11:10:55 AM', '20210915010', '03950', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3948', '2021-09-15', '11:17:21 AM', '20210915011', '03951', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3949', '2021-09-15', '11:19:35 AM', '20210915012', '03952', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3950', '2021-09-15', '11:28:53 AM', '20210915013', '03953', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '250.00', 'Flat', '550.00', '550.00', '0.00', '0.00', '550.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3951', '2021-09-15', '11:34:18 AM', '20210915014', '03954', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3952', '2021-09-15', '11:42:42 AM', '20210915015', '03955', 'diagnosis', 'diagnosis', '2050.00', '0', '0.00', '1550.00', '0.00', 'Flat', '2050.00', '1000.00', '500.00', '1050.00', '1000.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3953', '2021-09-15', '11:44:02 AM', '20210915016', '03956', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3954', '2021-09-15', '11:44:52 AM', '20210915017', '03957', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3955', '2021-09-15', '11:46:24 AM', '20210915018', '03958', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3956', '2021-09-15', '11:47:47 AM', '20210915019', '03959', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '0.00', 'Flat', '1000.00', '0.00', '0.00', '1000.00', '0.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3957', '2021-09-15', '11:48:35 AM', '20210915020', '03960', 'diagnosis', 'diagnosis', '2050.00', '0', '0.00', '2050.00', '0.00', 'Flat', '2050.00', '0.00', '0.00', '2050.00', '0.00', '2021-09-15', 'pending', '', '15', 'Dr Mustafizur Rahman Shajahan P C D H', 'diagnosis', '2021-09-15 08:00 PM'), 
('3958', '2021-09-15', '11:52:26 AM', '20210915021', '03961', 'diagnosis', 'diagnosis', '450.00', '0', '0.00', '450.00', '450.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3959', '2021-09-15', '11:54:18 AM', '20210915022', '03962', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '500.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3960', '2021-09-15', '11:56:48 AM', '20210915023', '03963', 'diagnosis', 'diagnosis', '1150.00', '0', '0.00', '950.00', '250.00', 'Flat', '900.00', '900.00', '200.00', '0.00', '900.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3961', '2021-09-15', '11:58:22 AM', '20210915024', '03964', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '150.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3962', '2021-09-15', '11:59:04 AM', '20210915025', '03965', 'diagnosis', 'diagnosis', '1150.00', '0', '0.00', '950.00', '650.00', 'Flat', '500.00', '500.00', '200.00', '0.00', '500.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3963', '2021-09-15', '12:00:56 PM', '20210915026', '03966', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '0.00', 'Flat', '1350.00', '0.00', '0.00', '1350.00', '0.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3964', '2021-09-15', '12:02:49 PM', '20210915027', '03967', 'diagnosis', 'diagnosis', '2150.00', '0', '0.00', '2150.00', '0.00', 'Flat', '2150.00', '1000.00', '0.00', '1150.00', '1000.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3965', '2021-09-15', '12:05:41 PM', '20210915028', '03968', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3966', '2021-09-15', '12:07:14 PM', '20210915029', '03969', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '0.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-15', 'pending', '', '15', 'Dr Mustafizur Rahman Shajahan P C D H', 'diagnosis', '2021-09-15 08:00 PM'), 
('3967', '2021-09-15', '12:09:18 PM', '20210915030', '03970', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3968', '2021-09-15', '12:11:02 PM', '20210915031', '03971', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '300.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '500.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3969', '2021-09-15', '12:12:27 PM', '20210915032', '03972', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '400.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3970', '2021-09-15', '12:14:25 PM', '20210915033', '03973', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '250.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3971', '2021-09-15', '12:16:36 PM', '20210915034', '03974', 'diagnosis', 'diagnosis', '2450.00', '0', '0.00', '2450.00', '550.00', 'Flat', '1900.00', '1900.00', '0.00', '0.00', '1900.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3972', '2021-09-15', '12:20:26 PM', '20210915035', '03975', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '650.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3973', '2021-09-15', '12:47:34 PM', '20210915036', '03976', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '0.00', 'Flat', '550.00', '0.00', '0.00', '550.00', '0.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3974', '2021-09-15', '12:55:36 PM', '20210915037', '03977', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '150.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3975', '2021-09-15', '01:25:50 PM', '20210915038', '03978', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '0.00', 'Flat', '550.00', '0.00', '0.00', '550.00', '0.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3976', '2021-09-15', '01:29:14 PM', '20210915039', '03979', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '50.00', 'Flat', '1300.00', '1300.00', '0.00', '0.00', '1300.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3977', '2021-09-15', '01:32:05 PM', '20210915040', '03980', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3978', '2021-09-15', '01:38:01 PM', '20210915041', '03981', 'diagnosis', 'diagnosis', '1900.00', '0', '0.00', '1900.00', '700.00', 'Flat', '1200.00', '1000.00', '0.00', '200.00', '1000.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3979', '2021-09-15', '01:54:47 PM', '20210915042', '03982', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3980', '2021-09-15', '02:00:54 PM', '20210915043', '03983', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3981', '2021-09-15', '02:12:28 PM', '20210915044', '03984', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '150.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3982', '2021-09-15', '03:24:02 PM', '20210915045', '03985', 'diagnosis', 'diagnosis', '2000.00', '0', '0.00', '2000.00', '500.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1500.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3983', '2021-09-15', '03:29:49 PM', '20210915046', '03986', 'diagnosis', 'diagnosis', '2350.00', '0', '0.00', '2350.00', '0.00', 'Flat', '2350.00', '500.00', '0.00', '1850.00', '500.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3984', '2021-09-15', '03:41:15 PM', '20210915047', '03987', 'diagnosis', 'diagnosis', '1950.00', '0', '0.00', '1950.00', '150.00', 'Flat', '1800.00', '1800.00', '0.00', '0.00', '1800.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3985', '2021-09-15', '03:46:12 PM', '20210915048', '03988', 'diagnosis', 'diagnosis', '1900.00', '0', '0.00', '1900.00', '600.00', 'Flat', '1300.00', '1300.00', '0.00', '0.00', '1300.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3986', '2021-09-15', '03:55:46 PM', '20210915049', '03989', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '650.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3987', '2021-09-15', '03:59:32 PM', '20210915050', '03990', 'diagnosis', 'diagnosis', '1900.00', '0', '0.00', '1900.00', '500.00', 'Flat', '1400.00', '1400.00', '0.00', '0.00', '1400.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3988', '2021-09-15', '04:03:49 PM', '20210915051', '03991', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3989', '2021-09-15', '04:06:43 PM', '20210915052', '03992', 'diagnosis', 'diagnosis', '2200.00', '0', '0.00', '2200.00', '500.00', 'Flat', '1700.00', '1700.00', '0.00', '0.00', '1700.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3990', '2021-09-15', '04:10:26 PM', '20210915053', '03993', 'diagnosis', 'diagnosis', '1950.00', '0', '0.00', '1950.00', '650.00', 'Flat', '1300.00', '1300.00', '0.00', '0.00', '1300.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3991', '2021-09-15', '04:14:26 PM', '20210915054', '03994', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3992', '2021-09-15', '04:17:00 PM', '20210915055', '03995', 'diagnosis', 'diagnosis', '2150.00', '0', '0.00', '2150.00', '450.00', 'Flat', '1700.00', '1700.00', '0.00', '0.00', '1700.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3993', '2021-09-15', '04:20:34 PM', '20210915056', '03996', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '350.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3994', '2021-09-15', '04:31:54 PM', '20210915057', '03997', 'diagnosis', 'diagnosis', '2250.00', '0', '0.00', '2250.00', '0.00', 'Flat', '2250.00', '0.00', '0.00', '2250.00', '0.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3995', '2021-09-15', '04:35:19 PM', '20210915058', '03998', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '100.00', 'Flat', '450.00', '450.00', '0.00', '0.00', '450.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3996', '2021-09-15', '04:36:44 PM', '20210915059', '03999', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '900.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3997', '2021-09-15', '04:37:45 PM', '20210915060', '04000', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '0.00', 'Flat', '900.00', '300.00', '0.00', '600.00', '300.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3998', '2021-09-15', '04:50:43 PM', '20210915061', '04001', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1450.00', '0.00', 'Flat', '1450.00', '0.00', '0.00', '1450.00', '0.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('3999', '2021-09-15', '04:58:54 PM', '20210915062', '04002', 'diagnosis', 'diagnosis', '600.00', '0', '0.00', '600.00', '300.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('4000', '2021-09-15', '04:59:45 PM', '20210915063', '04003', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1450.00', '550.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('4001', '2021-09-15', '05:00:35 PM', '20210915064', '04004', 'diagnosis', 'diagnosis', '1850.00', '0', '0.00', '1850.00', '550.00', 'Flat', '1300.00', '1300.00', '0.00', '0.00', '1300.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('4002', '2021-09-15', '05:04:35 PM', '20210915065', '04005', 'diagnosis', 'diagnosis', '1800.00', '0', '0.00', '1800.00', '600.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('4003', '2021-09-15', '05:11:20 PM', '20210915066', '04006', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('4004', '2021-09-15', '05:21:00 PM', '20210915067', '04007', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('4005', '2021-09-15', '05:40:29 PM', '20210915068', '04008', 'diagnosis', 'diagnosis', '1650.00', '0', '0.00', '1650.00', '450.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('4006', '2021-09-15', '05:45:13 PM', '20210915069', '04009', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('4007', '2021-09-15', '05:46:39 PM', '20210915070', '04010', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('4008', '2021-09-15', '05:59:54 PM', '20210915071', '04011', 'diagnosis', 'diagnosis', '1550.00', '0', '0.00', '1550.00', '750.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('4009', '2021-09-15', '06:12:52 PM', '20210915072', '04012', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '400.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-09-15', 'pending', '', '15', '', 'diagnosis', '2021-09-15 08:00 PM'), 
('4010', '2021-09-16', '01:49:31 PM', '20210916001', '04013', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '200.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-16', 'pending', '', '15', '', 'diagnosis', '2021-09-16 08:00 PM'), 
('4011', '2021-09-16', '01:50:18 PM', '20210916002', '04014', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-16', 'pending', '', '15', '', 'diagnosis', '2021-09-16 08:00 PM'), 
('4012', '2021-09-16', '01:58:17 PM', '20210916003', '04015', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '0.00', 'Flat', '800.00', '0.00', '0.00', '800.00', '0.00', '2021-09-16', 'pending', '', '15', '', 'diagnosis', '2021-09-16 08:00 PM'), 
('4013', '2021-09-16', '02:01:04 PM', '20210916004', '04016', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-16', 'pending', '', '15', '', 'diagnosis', '2021-09-16 08:00 PM'), 
('4014', '2021-09-16', '02:01:26 PM', '20210916005', '04017', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-16', 'pending', '', '15', '', 'diagnosis', '2021-09-16 08:00 PM'), 
('4015', '2021-09-16', '02:01:47 PM', '20210916006', '04018', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-09-16', 'pending', '', '15', '', 'diagnosis', '2021-09-16 08:00 PM'), 
('4016', '2021-09-16', '02:02:21 PM', '20210916007', '04019', 'diagnosis', 'diagnosis', '1550.00', '0', '0.00', '1550.00', '150.00', 'Flat', '1400.00', '1400.00', '0.00', '0.00', '1400.00', '2021-09-16', 'pending', '', '15', '', 'diagnosis', '2021-09-16 08:00 PM'), 
('4017', '2021-09-16', '02:02:46 PM', '20210916008', '04020', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '160.00', 'Flat', '240.00', '240.00', '0.00', '0.00', '240.00', '2021-09-16', 'pending', '', '15', '', 'diagnosis', '2021-09-16 08:00 PM'), 
('4018', '2021-09-16', '02:03:21 PM', '20210916009', '04021', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '350.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-09-16', 'pending', '', '15', '', 'diagnosis', '2021-09-16 08:00 PM'), 
('4019', '2021-09-16', '02:03:42 PM', '20210916010', '04022', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-09-16', 'pending', '', '15', '', 'diagnosis', '2021-09-16 08:00 PM'), 
('4020', '2021-09-16', '02:04:05 PM', '20210916011', '04023', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-16', 'pending', '', '15', '', 'diagnosis', '2021-09-16 08:00 PM'), 
('4021', '2021-09-16', '02:13:35 PM', '20210916012', '04024', 'diagnosis', 'diagnosis', '0.00', '0', '0.00', '0.00', '0.00', '0', '0.00', '0.00', '0.00', '0.00', '0.00', '0000-00-00', 'pending', '', '15', '0', 'diagnosis', '0'), 
('4022', '2021-09-16', '02:18:19 PM', '20210916013', '04025', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-16', 'pending', '', '15', '', 'diagnosis', '2021-09-16 08:00 PM'), 
('4023', '2021-09-16', '02:19:07 PM', '20210916014', '04026', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '450.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-16', 'pending', '', '15', '', 'diagnosis', '2021-09-16 08:00 PM'), 
('4024', '2021-09-16', '02:19:43 PM', '20210916015', '04027', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '250.00', 'Flat', '450.00', '450.00', '0.00', '0.00', '450.00', '2021-09-16', 'pending', '', '15', '', 'diagnosis', '2021-09-16 08:00 PM'), 
('4025', '2021-09-16', '02:20:03 PM', '20210916016', '04028', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-16', 'pending', '', '15', '', 'diagnosis', '2021-09-16 08:00 PM'), 
('4026', '2021-09-16', '02:20:21 PM', '20210916017', '04029', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '450.00', '0.00', '-50.00', '450.00', '2021-09-16', 'pending', '', '15', '', 'diagnosis', '2021-09-16 08:00 PM'), 
('4027', '2021-09-16', '02:20:59 PM', '20210916018', '04030', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-16', 'pending', '', '15', '', 'diagnosis', '2021-09-16 08:00 PM'), 
('4028', '2021-09-16', '02:21:22 PM', '20210916019', '04031', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '250.00', 'Flat', '450.00', '450.00', '0.00', '0.00', '450.00', '2021-09-16', 'pending', '', '15', '', 'diagnosis', '2021-09-16 08:00 PM'), 
('4029', '2021-09-16', '02:21:44 PM', '20210916020', '04032', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-16', 'pending', '', '15', '', 'diagnosis', '2021-09-16 08:00 PM'), 
('4030', '2021-09-16', '02:22:08 PM', '20210916021', '04033', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-16', 'pending', '', '15', '', 'diagnosis', '2021-09-16 08:00 PM'), 
('4031', '2021-09-16', '02:22:36 PM', '20210916022', '04034', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1450.00', '750.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-16', 'pending', '', '15', '', 'diagnosis', '2021-09-16 08:00 PM'), 
('4032', '2021-09-16', '02:23:00 PM', '20210916023', '04035', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '250.00', 'Flat', '450.00', '450.00', '0.00', '0.00', '450.00', '2021-09-16', 'pending', '', '15', '', 'diagnosis', '2021-09-16 08:00 PM'), 
('4033', '2021-09-16', '02:23:18 PM', '20210916024', '04036', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '0.00', 'Flat', '550.00', '200.00', '0.00', '350.00', '200.00', '2021-09-16', 'pending', '', '15', '', 'diagnosis', '2021-09-16 08:00 PM'), 
('4034', '2021-09-16', '02:23:41 PM', '20210916025', '04037', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-16', 'pending', '', '15', '', 'diagnosis', '2021-09-16 08:00 PM'), 
('4035', '2021-09-16', '02:24:55 PM', '20210916026', '04038', 'diagnosis', 'diagnosis', '1250.00', '0', '0.00', '1250.00', '250.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-16', 'pending', '', '15', '', 'diagnosis', '2021-09-16 08:00 PM'), 
('4036', '2021-09-16', '02:37:38 PM', '20210916027', '04039', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '200.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-16', 'pending', '', '15', '', 'diagnosis', '2021-09-16 08:00 PM'), 
('4037', '2021-09-16', '02:49:02 PM', '20210916028', '04040', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '150.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-16', 'pending', '', '15', '', 'diagnosis', '2021-09-16 08:00 PM'), 
('4038', '2021-09-16', '03:01:44 PM', '20210916029', '04041', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-16', 'pending', '', '15', '', 'diagnosis', '2021-09-16 08:00 PM'), 
('4039', '2021-09-16', '03:15:21 PM', '20210916030', '04042', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '50.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-16', 'pending', '', '15', '', 'diagnosis', '2021-09-16 08:00 PM'), 
('4040', '2021-09-16', '03:39:51 PM', '20210916031', '04043', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '650.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-09-16', 'pending', '', '15', '', 'diagnosis', '2021-09-16 08:00 PM'), 
('4041', '2021-09-16', '03:47:05 PM', '20210916032', '04044', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '150.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-09-16', 'pending', '', '15', '', 'diagnosis', '2021-09-16 08:00 PM'), 
('4042', '2021-09-16', '03:59:48 PM', '20210916033', '04045', 'diagnosis', 'diagnosis', '1850.00', '0', '0.00', '1850.00', '250.00', 'Flat', '1600.00', '1600.00', '0.00', '0.00', '1600.00', '2021-09-16', 'pending', '', '15', '', 'diagnosis', '2021-09-16 08:00 PM'), 
('4043', '2021-09-16', '04:00:46 PM', '20210916034', '04046', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '300.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-09-16', 'pending', '', '15', '', 'diagnosis', '2021-09-16 08:00 PM'), 
('4044', '2021-09-16', '04:07:50 PM', '20210916035', '04047', 'diagnosis', 'diagnosis', '450.00', '0', '0.00', '450.00', '50.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-16', 'pending', '', '15', '', 'diagnosis', '2021-09-16 08:00 PM'), 
('4045', '2021-09-16', '04:14:04 PM', '20210916036', '04048', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-09-16', 'pending', '', '15', '', 'diagnosis', '2021-09-16 08:00 PM'), 
('4046', '2021-09-16', '04:16:23 PM', '20210916037', '04049', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '200.00', '0.00', '200.00', '200.00', '2021-09-16', 'pending', '', '15', '', 'diagnosis', '2021-09-16 08:00 PM'), 
('4047', '2021-09-16', '04:22:49 PM', '20210916038', '04050', 'diagnosis', 'diagnosis', '450.00', '0', '0.00', '450.00', '450.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-09-16', 'pending', '', '15', '', 'diagnosis', '2021-09-16 08:00 PM'), 
('4048', '2021-09-16', '04:30:47 PM', '20210916039', '04051', 'diagnosis', 'diagnosis', '2850.00', '0', '0.00', '2850.00', '1350.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1500.00', '2021-09-16', 'pending', '', '15', '', 'diagnosis', '2021-09-16 08:00 PM'), 
('4049', '2021-09-16', '04:32:44 PM', '20210916040', '04052', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '400.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-09-16', 'pending', '', '15', '', 'diagnosis', '2021-09-16 08:00 PM'), 
('4050', '2021-09-16', '04:43:39 PM', '20210916041', '04053', 'diagnosis', 'diagnosis', '450.00', '0', '0.00', '450.00', '150.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-16', 'pending', '', '15', '', 'diagnosis', '2021-09-16 08:00 PM'), 
('4051', '2021-09-16', '04:46:30 PM', '20210916042', '04054', 'diagnosis', 'diagnosis', '1750.00', '0', '0.00', '1750.00', '250.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1500.00', '2021-09-16', 'pending', '', '15', '', 'diagnosis', '2021-09-16 08:00 PM'), 
('4052', '2021-09-16', '04:49:06 PM', '20210916043', '04055', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-16', 'pending', '', '15', '', 'diagnosis', '2021-09-16 08:00 PM'), 
('4053', '2021-09-16', '04:56:52 PM', '20210916044', '04056', 'diagnosis', 'diagnosis', '2200.00', '0', '0.00', '2200.00', '800.00', 'Flat', '1400.00', '1400.00', '0.00', '0.00', '1400.00', '2021-09-16', 'pending', '', '15', '', 'diagnosis', '2021-09-16 08:00 PM'), 
('4054', '2021-09-16', '05:21:21 PM', '20210916045', '04057', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-16', 'pending', '', '15', '', 'diagnosis', '2021-09-16 08:00 PM'), 
('4055', '2021-09-16', '05:32:44 PM', '20210916046', '04058', 'diagnosis', 'diagnosis', '1550.00', '0', '0.00', '1550.00', '450.00', 'Flat', '1100.00', '1100.00', '0.00', '0.00', '1100.00', '2021-09-16', 'pending', '', '15', '', 'diagnosis', '2021-09-16 08:00 PM'), 
('4056', '2021-09-16', '05:42:37 PM', '20210916047', '04059', 'diagnosis', 'diagnosis', '3800.00', '0', '0.00', '3000.00', '1800.00', 'Flat', '2000.00', '2200.00', '800.00', '-200.00', '2000.00', '2021-09-16', 'pending', '', '15', '', 'diagnosis', '2021-09-16 08:00 PM'), 
('4057', '2021-09-16', '05:56:38 PM', '20210916048', '04060', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-16', 'pending', '', '15', '', 'diagnosis', '2021-09-16 08:00 PM'), 
('4058', '2021-09-17', '10:04:51 AM', '20210917001', '04061', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4059', '2021-09-17', '10:44:02 AM', '20210917002', '04062', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4060', '2021-09-17', '11:14:38 AM', '20210917003', '04063', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4061', '2021-09-17', '11:19:54 AM', '20210917004', '04064', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4062', '2021-09-17', '11:24:17 AM', '20210917005', '04065', 'diagnosis', 'diagnosis', '2450.00', '0', '0.00', '2450.00', '550.00', 'Flat', '1900.00', '1900.00', '0.00', '0.00', '1900.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4063', '2021-09-17', '11:26:16 AM', '20210917006', '04066', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '300.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4064', '2021-09-17', '11:31:15 AM', '20210917007', '04067', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '500.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4065', '2021-09-17', '11:32:21 AM', '20210917008', '04068', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '0.00', 'Flat', '550.00', '550.00', '0.00', '0.00', '550.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4066', '2021-09-17', '11:33:42 AM', '20210917009', '04069', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '800.00', '300.00', 'Flat', '1000.00', '1000.00', '500.00', '0.00', '500.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4067', '2021-09-17', '11:36:10 AM', '20210917010', '04070', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4068', '2021-09-17', '11:38:00 AM', '20210917011', '04071', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4069', '2021-09-17', '11:39:32 AM', '20210917012', '04072', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '300.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4070', '2021-09-17', '11:41:47 AM', '20210917013', '04073', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '350.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4071', '2021-09-17', '11:42:58 AM', '20210917014', '04074', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '0.00', 'Flat', '1300.00', '300.00', '0.00', '1000.00', '300.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4072', '2021-09-17', '11:45:38 AM', '20210917015', '04075', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4073', '2021-09-17', '11:47:02 AM', '20210917016', '04076', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '50.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4074', '2021-09-17', '11:56:09 AM', '20210917017', '04077', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '200.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '400.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4075', '2021-09-17', '12:15:46 PM', '20210917018', '04078', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '50.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4076', '2021-09-17', '12:25:08 PM', '20210917019', '04079', 'diagnosis', 'diagnosis', '1550.00', '0', '0.00', '1550.00', '350.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4077', '2021-09-17', '12:29:30 PM', '20210917020', '04080', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4078', '2021-09-17', '12:30:26 PM', '20210917021', '04081', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4079', '2021-09-17', '12:34:24 PM', '20210917022', '04082', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '150.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4080', '2021-09-17', '12:38:32 PM', '20210917023', '04083', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '0.00', 'Flat', '550.00', '550.00', '0.00', '0.00', '550.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4081', '2021-09-17', '12:43:07 PM', '20210917024', '04084', 'diagnosis', 'diagnosis', '1750.00', '0', '0.00', '1750.00', '0.00', 'Flat', '1750.00', '800.00', '0.00', '950.00', '800.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4082', '2021-09-17', '12:47:08 PM', '20210917025', '04085', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4083', '2021-09-17', '12:49:13 PM', '20210917026', '04086', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4084', '2021-09-17', '12:53:36 PM', '20210917027', '04087', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4085', '2021-09-17', '12:54:55 PM', '20210917028', '04088', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4086', '2021-09-17', '12:57:29 PM', '20210917029', '04089', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4087', '2021-09-17', '12:58:27 PM', '20210917030', '04090', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4088', '2021-09-17', '01:00:18 PM', '20210917031', '04091', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '50.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4089', '2021-09-17', '01:01:26 PM', '20210917032', '04092', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '150.00', 'Flat', '700.00', '200.00', '0.00', '500.00', '0.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4090', '2021-09-17', '01:04:35 PM', '20210917033', '04093', 'diagnosis', 'diagnosis', '1750.00', '0', '0.00', '1750.00', '0.00', 'Flat', '1750.00', '1000.00', '0.00', '750.00', '1000.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4091', '2021-09-17', '01:06:02 PM', '20210917034', '04094', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '350.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4092', '2021-09-17', '01:13:34 PM', '20210917035', '04095', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '100.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4093', '2021-09-17', '01:19:16 PM', '20210917036', '04096', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '100.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4094', '2021-09-17', '01:24:38 PM', '20210917037', '04097', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4095', '2021-09-17', '01:46:18 PM', '20210917038', '04098', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1450.00', '450.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4096', '2021-09-17', '02:15:13 PM', '20210917039', '04099', 'diagnosis', 'diagnosis', '1700.00', '0', '0.00', '1700.00', '0.00', 'Flat', '1700.00', '0.00', '0.00', '1700.00', '0.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4097', '2021-09-17', '02:37:48 PM', '20210917040', '04100', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '200.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4098', '2021-09-17', '02:45:43 PM', '20210917041', '04101', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4099', '2021-09-17', '02:46:09 PM', '20210917042', '04102', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '400.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4100', '2021-09-17', '02:50:09 PM', '20210917043', '04103', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '100.00', 'Flat', '850.00', '850.00', '0.00', '0.00', '850.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4101', '2021-09-17', '02:57:24 PM', '20210917044', '04104', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4102', '2021-09-17', '03:08:10 PM', '20210917045', '04105', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '0.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4103', '2021-09-17', '03:11:05 PM', '20210917046', '04106', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '100.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4104', '2021-09-17', '03:13:16 PM', '20210917047', '04107', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4105', '2021-09-17', '03:16:33 PM', '20210917048', '04108', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '0.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4106', '2021-09-17', '03:18:07 PM', '20210917049', '04109', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4107', '2021-09-17', '03:21:49 PM', '20210917050', '04110', 'diagnosis', 'diagnosis', '2350.00', '0', '0.00', '2350.00', '0.00', 'Flat', '2350.00', '1000.00', '0.00', '1350.00', '1000.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4108', '2021-09-17', '03:24:16 PM', '20210917051', '04111', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '300.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4109', '2021-09-17', '03:30:03 PM', '20210917052', '04112', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '0.00', 'Flat', '800.00', '0.00', '0.00', '800.00', '0.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4110', '2021-09-17', '03:33:42 PM', '20210917053', '04113', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '200.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4111', '2021-09-17', '03:34:54 PM', '20210917054', '04114', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4112', '2021-09-17', '03:37:09 PM', '20210917055', '04115', 'diagnosis', 'diagnosis', '1600.00', '0', '0.00', '1600.00', '400.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4113', '2021-09-17', '03:38:40 PM', '20210917056', '04116', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4114', '2021-09-17', '03:40:48 PM', '20210917057', '04117', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '100.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4115', '2021-09-17', '03:41:44 PM', '20210917058', '04118', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4116', '2021-09-17', '03:43:23 PM', '20210917059', '04119', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4117', '2021-09-17', '03:45:06 PM', '20210917060', '04120', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4118', '2021-09-17', '03:50:04 PM', '20210917061', '04121', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '150.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4119', '2021-09-17', '04:18:55 PM', '20210917062', '04122', 'diagnosis', 'diagnosis', '1600.00', '0', '0.00', '1600.00', '400.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4120', '2021-09-17', '04:20:06 PM', '20210917063', '04123', 'diagnosis', 'diagnosis', '2150.00', '0', '0.00', '2150.00', '150.00', 'Flat', '2000.00', '2000.00', '0.00', '0.00', '2000.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4121', '2021-09-17', '04:20:48 PM', '20210917064', '04124', 'diagnosis', 'diagnosis', '3000.00', '0', '0.00', '3000.00', '700.00', 'Flat', '2300.00', '2300.00', '0.00', '0.00', '2300.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4122', '2021-09-17', '04:21:24 PM', '20210917065', '04125', 'diagnosis', 'diagnosis', '1900.00', '0', '0.00', '1900.00', '0.00', 'Flat', '1900.00', '800.00', '0.00', '1100.00', '800.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4123', '2021-09-17', '04:22:17 PM', '20210917066', '04126', 'diagnosis', 'diagnosis', '2000.00', '0', '0.00', '2000.00', '500.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1500.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4124', '2021-09-17', '04:22:32 PM', '20210917067', '04127', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4125', '2021-09-17', '04:23:01 PM', '20210917068', '04128', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '200.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4126', '2021-09-17', '04:23:55 PM', '20210917069', '04129', 'diagnosis', 'diagnosis', '2150.00', '0', '0.00', '2150.00', '650.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1500.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4127', '2021-09-17', '04:25:14 PM', '20210917070', '04130', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '50.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4128', '2021-09-17', '04:25:26 PM', '20210917071', '04131', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '150.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4129', '2021-09-17', '04:25:56 PM', '20210917072', '04132', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '300.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4130', '2021-09-17', '04:26:22 PM', '20210917073', '04133', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '0.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4131', '2021-09-17', '04:26:49 PM', '20210917074', '04134', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '200.00', 'Flat', '1100.00', '1100.00', '0.00', '0.00', '1100.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4132', '2021-09-17', '04:27:15 PM', '20210917075', '04135', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '0.00', 'Flat', '1200.00', '0.00', '0.00', '1200.00', '0.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4133', '2021-09-17', '04:27:56 PM', '20210917076', '04136', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '150.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4134', '2021-09-17', '04:28:43 PM', '20210917077', '04137', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4135', '2021-09-17', '04:29:12 PM', '20210917078', '04138', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4136', '2021-09-17', '04:34:27 PM', '20210917079', '04139', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4137', '2021-09-17', '04:36:57 PM', '20210917080', '04140', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '300.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4138', '2021-09-17', '04:57:10 PM', '20210917081', '04141', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '100.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4139', '2021-09-17', '05:06:55 PM', '20210917082', '04142', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '250.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4140', '2021-09-17', '05:09:57 PM', '20210917083', '04143', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4141', '2021-09-17', '05:20:08 PM', '20210917084', '04144', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '0.00', 'Flat', '900.00', '500.00', '0.00', '400.00', '500.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4142', '2021-09-17', '05:38:38 PM', '20210917085', '04145', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4143', '2021-09-17', '05:46:56 PM', '20210917086', '04146', 'diagnosis', 'diagnosis', '2400.00', '0', '0.00', '2400.00', '400.00', 'Flat', '2000.00', '1500.00', '0.00', '500.00', '1500.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4144', '2021-09-17', '05:58:18 PM', '20210917087', '04147', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4145', '2021-09-17', '06:01:17 PM', '20210917088', '04148', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4146', '2021-09-17', '06:18:25 PM', '20210917089', '04149', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '300.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4147', '2021-09-17', '06:31:33 PM', '20210917090', '04150', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4148', '2021-09-17', '06:34:27 PM', '20210917091', '04151', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '0.00', '0.00', '400.00', '0.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4149', '2021-09-17', '06:55:03 PM', '20210917092', '04152', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-17', 'pending', '', '15', '', 'diagnosis', '2021-09-17 08:00 PM'), 
('4150', '2021-09-18', '09:51:38 AM', '20210918001', '04153', 'diagnosis', 'diagnosis', '300.00', '0', '0.00', '300.00', '0.00', 'Flat', '300.00', '0.00', '0.00', '300.00', '0.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4151', '2021-09-18', '09:54:40 AM', '20210918002', '04154', 'diagnosis', 'diagnosis', '450.00', '0', '0.00', '400.00', '0.00', 'Flat', '450.00', '450.00', '50.00', '0.00', '450.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4152', '2021-09-18', '10:10:39 AM', '20210918003', '04155', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4153', '2021-09-18', '10:12:14 AM', '20210918004', '04156', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4154', '2021-09-18', '10:13:43 AM', '20210918005', '04157', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4155', '2021-09-18', '10:20:57 AM', '20210918006', '04158', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4156', '2021-09-18', '10:22:26 AM', '20210918007', '04159', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4157', '2021-09-18', '10:33:26 AM', '20210918008', '04160', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '100.00', 'Flat', '450.00', '450.00', '0.00', '0.00', '450.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4158', '2021-09-18', '10:44:50 AM', '20210918009', '04161', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4159', '2021-09-18', '10:45:49 AM', '20210918010', '04162', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4160', '2021-09-18', '11:00:10 AM', '20210918011', '04163', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4161', '2021-09-18', '11:03:11 AM', '20210918012', '04164', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4162', '2021-09-18', '11:03:49 AM', '20210918013', '04165', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4163', '2021-09-18', '11:34:08 AM', '20210918014', '04166', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4164', '2021-09-18', '11:34:57 AM', '20210918015', '04167', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4165', '2021-09-18', '11:35:36 AM', '20210918016', '04168', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4166', '2021-09-18', '11:36:58 AM', '20210918017', '04169', 'diagnosis', 'diagnosis', '1700.00', '0', '0.00', '1700.00', '500.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4167', '2021-09-18', '11:38:07 AM', '20210918018', '04170', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '0.00', 'Flat', '950.00', '200.00', '0.00', '750.00', '200.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4168', '2021-09-18', '11:39:27 AM', '20210918019', '04171', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '600.00', 'Flat', '450.00', '450.00', '0.00', '0.00', '450.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4169', '2021-09-18', '11:40:28 AM', '20210918020', '04172', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '200.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4170', '2021-09-18', '11:41:33 AM', '20210918021', '04173', 'diagnosis', 'diagnosis', '1700.00', '0', '0.00', '1700.00', '500.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4171', '2021-09-18', '11:42:42 AM', '20210918022', '04174', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '300.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4172', '2021-09-18', '11:43:35 AM', '20210918023', '04175', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '200.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4173', '2021-09-18', '11:45:19 AM', '20210918024', '04176', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4174', '2021-09-18', '11:47:05 AM', '20210918025', '04177', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1450.00', '250.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4175', '2021-09-18', '11:48:25 AM', '20210918026', '04178', 'diagnosis', 'diagnosis', '450.00', '0', '0.00', '450.00', '50.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4176', '2021-09-18', '11:49:33 AM', '20210918027', '04179', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4177', '2021-09-18', '11:51:42 AM', '20210918028', '04180', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '550.00', 'Flat', '800.00', '500.00', '0.00', '300.00', '500.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4178', '2021-09-18', '11:54:59 AM', '20210918029', '04181', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4179', '2021-09-18', '11:55:19 AM', '20210918030', '04182', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '250.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4180', '2021-09-18', '11:57:22 AM', '20210918031', '04183', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '600.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4181', '2021-09-18', '11:58:21 AM', '20210918032', '04184', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '200.00', 'Flat', '750.00', '750.00', '0.00', '0.00', '750.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4182', '2021-09-18', '11:59:19 AM', '20210918033', '04185', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4183', '2021-09-18', '12:03:56 PM', '20210918034', '04186', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '250.00', 'Flat', '1100.00', '1100.00', '0.00', '0.00', '1100.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4184', '2021-09-18', '12:16:13 PM', '20210918035', '04187', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '200.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4185', '2021-09-18', '12:44:34 PM', '20210918036', '04188', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4186', '2021-09-18', '12:49:40 PM', '20210918037', '04189', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '150.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4187', '2021-09-18', '12:58:44 PM', '20210918038', '04190', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4188', '2021-09-18', '12:59:48 PM', '20210918039', '04191', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4189', '2021-09-18', '01:00:53 PM', '20210918040', '04192', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4190', '2021-09-18', '01:02:47 PM', '20210918041', '04193', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4191', '2021-09-18', '01:03:35 PM', '20210918042', '04194', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4192', '2021-09-18', '01:07:23 PM', '20210918043', '04195', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '300.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4193', '2021-09-18', '01:08:37 PM', '20210918044', '04196', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4194', '2021-09-18', '01:13:51 PM', '20210918045', '04197', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4195', '2021-09-18', '01:29:40 PM', '20210918046', '04198', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '350.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4196', '2021-09-18', '01:32:57 PM', '20210918047', '04199', 'diagnosis', 'diagnosis', '1500.00', '0', '0.00', '1500.00', '300.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4197', '2021-09-18', '01:34:47 PM', '20210918048', '04200', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4198', '2021-09-18', '01:37:07 PM', '20210918049', '04201', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '250.00', 'Flat', '650.00', '650.00', '0.00', '0.00', '650.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4199', '2021-09-18', '01:44:02 PM', '20210918050', '04202', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '250.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4200', '2021-09-18', '01:45:34 PM', '20210918051', '04203', 'diagnosis', 'diagnosis', '1050.00', '0', '0.00', '1050.00', '250.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4201', '2021-09-18', '01:47:19 PM', '20210918052', '04204', 'diagnosis', 'diagnosis', '1950.00', '0', '0.00', '1950.00', '250.00', 'Flat', '1700.00', '400.00', '0.00', '1300.00', '400.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4202', '2021-09-18', '01:51:35 PM', '20210918053', '04205', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '350.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4203', '2021-09-18', '01:56:37 PM', '20210918054', '04206', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '350.00', '0.00', '50.00', '350.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4204', '2021-09-18', '01:59:21 PM', '20210918055', '04207', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '300.00', 'Flat', '250.00', '250.00', '0.00', '0.00', '250.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4205', '2021-09-18', '02:03:55 PM', '20210918056', '04208', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '200.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4206', '2021-09-18', '02:09:56 PM', '20210918057', '04209', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '300.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4207', '2021-09-18', '02:10:48 PM', '20210918058', '04210', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4208', '2021-09-18', '02:14:50 PM', '20210918059', '04211', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '250.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4209', '2021-09-18', '02:19:13 PM', '20210918060', '04212', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4210', '2021-09-18', '02:25:57 PM', '20210918061', '04213', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '50.00', 'Flat', '800.00', '500.00', '0.00', '300.00', '500.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4211', '2021-09-18', '02:28:46 PM', '20210918062', '04214', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '100.00', 'Flat', '850.00', '850.00', '0.00', '0.00', '850.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4212', '2021-09-18', '02:35:06 PM', '20210918063', '04215', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '200.00', 'Flat', '200.00', '200.00', '0.00', '0.00', '200.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4213', '2021-09-18', '02:41:27 PM', '20210918064', '04216', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4214', '2021-09-18', '02:45:00 PM', '20210918065', '04217', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '200.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4215', '2021-09-18', '02:47:59 PM', '20210918066', '04218', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4216', '2021-09-18', '02:59:42 PM', '20210918067', '04219', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '100.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4217', '2021-09-18', '03:01:00 PM', '20210918068', '04220', 'diagnosis', 'diagnosis', '600.00', '0', '0.00', '600.00', '0.00', 'Flat', '600.00', '0.00', '0.00', '600.00', '0.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4218', '2021-09-18', '03:08:53 PM', '20210918069', '04221', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '100.00', 'Flat', '450.00', '450.00', '0.00', '0.00', '450.00', '2021-09-18', 'pending', '', '19', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4219', '2021-09-18', '03:39:00 PM', '20210918070', '04222', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '100.00', 'Flat', '450.00', '450.00', '0.00', '0.00', '450.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4220', '2021-09-18', '03:47:15 PM', '20210918071', '04223', 'diagnosis', 'diagnosis', '650.00', '0', '0.00', '650.00', '0.00', 'Flat', '650.00', '100.00', '0.00', '550.00', '100.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4221', '2021-09-18', '03:48:05 PM', '20210918072', '04224', 'diagnosis', 'diagnosis', '2950.00', '0', '0.00', '2950.00', '950.00', 'Flat', '2000.00', '2000.00', '0.00', '0.00', '2000.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4222', '2021-09-18', '03:49:54 PM', '20210918073', '04225', 'diagnosis', 'diagnosis', '450.00', '0', '0.00', '450.00', '450.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4223', '2021-09-18', '03:53:42 PM', '20210918074', '04226', 'diagnosis', 'diagnosis', '1100.00', '0', '0.00', '1100.00', '100.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4224', '2021-09-18', '03:55:26 PM', '20210918075', '04227', 'diagnosis', 'diagnosis', '1450.00', '0', '0.00', '1450.00', '350.00', 'Flat', '1100.00', '1100.00', '0.00', '0.00', '1100.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4225', '2021-09-18', '03:58:12 PM', '20210918076', '04228', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4226', '2021-09-18', '04:02:07 PM', '20210918077', '04229', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4227', '2021-09-18', '04:04:03 PM', '20210918078', '04230', 'diagnosis', 'diagnosis', '1700.00', '0', '0.00', '1700.00', '500.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4228', '2021-09-18', '04:08:01 PM', '20210918079', '04231', 'diagnosis', 'diagnosis', '1850.00', '0', '0.00', '1850.00', '250.00', 'Flat', '1600.00', '1600.00', '0.00', '0.00', '1600.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4229', '2021-09-18', '04:20:52 PM', '20210918080', '04232', 'diagnosis', 'diagnosis', '1100.00', '0', '0.00', '1100.00', '300.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4230', '2021-09-18', '04:23:21 PM', '20210918081', '04233', 'diagnosis', 'diagnosis', '1700.00', '0', '0.00', '1700.00', '700.00', 'Flat', '1000.00', '800.00', '0.00', '200.00', '500.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4231', '2021-09-18', '04:25:41 PM', '20210918082', '04234', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4232', '2021-09-18', '04:28:17 PM', '20210918083', '04235', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '200.00', 'Flat', '1100.00', '1100.00', '0.00', '0.00', '1100.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4233', '2021-09-18', '04:30:14 PM', '20210918084', '04236', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4234', '2021-09-18', '04:30:36 PM', '20210918085', '04237', 'diagnosis', 'diagnosis', '1550.00', '0', '0.00', '1550.00', '350.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4235', '2021-09-18', '04:34:03 PM', '20210918086', '04238', 'diagnosis', 'diagnosis', '1800.00', '0', '0.00', '1800.00', '600.00', 'Flat', '1200.00', '1200.00', '0.00', '0.00', '1200.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4236', '2021-09-18', '04:34:15 PM', '20210918087', '04239', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '0.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4237', '2021-09-18', '04:35:41 PM', '20210918088', '04240', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4238', '2021-09-18', '04:37:06 PM', '20210918089', '04241', 'diagnosis', 'diagnosis', '1700.00', '0', '0.00', '1700.00', '200.00', 'Flat', '1500.00', '1500.00', '0.00', '0.00', '1500.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4239', '2021-09-18', '04:42:50 PM', '20210918090', '04242', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '200.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4240', '2021-09-18', '04:50:15 PM', '20210918091', '04243', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '200.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4241', '2021-09-18', '04:55:36 PM', '20210918092', '04244', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '0.00', 'Flat', '900.00', '900.00', '0.00', '0.00', '900.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4242', '2021-09-18', '04:59:03 PM', '20210918093', '04245', 'diagnosis', 'diagnosis', '1300.00', '0', '0.00', '1300.00', '600.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4243', '2021-09-18', '05:00:38 PM', '20210918094', '04246', 'diagnosis', 'diagnosis', '900.00', '0', '0.00', '900.00', '100.00', 'Flat', '800.00', '800.00', '0.00', '0.00', '800.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4244', '2021-09-18', '05:12:10 PM', '20210918095', '04247', 'diagnosis', 'diagnosis', '850.00', '0', '0.00', '850.00', '350.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4245', '2021-09-18', '05:15:35 PM', '20210918096', '04248', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '100.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4246', '2021-09-18', '05:16:40 PM', '20210918097', '04249', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '50.00', 'Flat', '100.00', '100.00', '0.00', '0.00', '100.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4247', '2021-09-18', '05:22:28 PM', '20210918098', '04250', 'diagnosis', 'diagnosis', '1900.00', '0', '0.00', '1900.00', '900.00', 'Flat', '1000.00', '1000.00', '0.00', '0.00', '1000.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4248', '2021-09-18', '05:24:20 PM', '20210918099', '04251', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '400.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4249', '2021-09-18', '05:25:47 PM', '20210918100', '04252', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-18', 'pending', '', '15', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4250', '2021-09-18', '05:58:29 PM', '20210918101', '04253', 'diagnosis', 'diagnosis', '1900.00', '0', '0.00', '1900.00', '500.00', 'Flat', '1400.00', '1400.00', '0.00', '0.00', '1400.00', '2021-09-18', 'pending', '', '19', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4251', '2021-09-18', '06:54:22 PM', '20210918102', '04254', 'diagnosis', 'diagnosis', '450.00', '0', '0.00', '450.00', '0.00', 'Flat', '450.00', '0.00', '0.00', '450.00', '0.00', '2021-09-18', 'pending', '', '10', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4252', '2021-09-18', '07:01:47 PM', '20210918103', '04255', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '100.00', 'Flat', '300.00', '300.00', '0.00', '0.00', '300.00', '2021-09-18', 'pending', '', '10', '', 'diagnosis', '2021-09-18 08:00 PM'), 
('4253', '2021-09-19', '10:11:54 AM', '20210919001', '04256', 'diagnosis', 'diagnosis', '1850.00', '0', '0.00', '1850.00', '450.00', 'Flat', '1400.00', '1000.00', '0.00', '400.00', '1000.00', '2021-09-19', 'pending', '', '10', '', 'diagnosis', '2021-09-19 08:00 PM'), 
('4254', '2021-09-19', '10:17:00 AM', '20210919002', '04257', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '0.00', 'Flat', '150.00', '0.00', '0.00', '150.00', '0.00', '2021-09-19', 'pending', '', '10', '', 'diagnosis', '2021-09-19 08:00 PM'), 
('4255', '2021-09-19', '10:19:58 AM', '20210919003', '04258', 'diagnosis', 'diagnosis', '400.00', '0', '0.00', '400.00', '50.00', 'Flat', '350.00', '350.00', '0.00', '0.00', '350.00', '2021-09-19', 'pending', '', '10', '', 'diagnosis', '2021-09-19 08:00 PM'), 
('4256', '2021-09-19', '10:23:08 AM', '20210919004', '04259', 'diagnosis', 'diagnosis', '800.00', '0', '0.00', '800.00', '300.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-19', 'pending', '', '10', 'Dr.Md Shakawat Husen', 'diagnosis', '2021-09-19 08:00 PM'), 
('4257', '2021-09-19', '10:37:59 AM', '20210919005', '04260', 'diagnosis', 'diagnosis', '1250.00', '0', '0.00', '1250.00', '150.00', 'Flat', '1100.00', '1100.00', '0.00', '0.00', '1100.00', '2021-09-19', 'pending', '', '10', '', 'diagnosis', '2021-09-19 08:00 PM'), 
('4258', '2021-09-19', '10:39:14 AM', '20210919006', '04261', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '0.00', 'Flat', '950.00', '0.00', '0.00', '950.00', '0.00', '2021-09-19', 'pending', '', '10', '', 'diagnosis', '2021-09-19 08:00 PM'), 
('4259', '2021-09-19', '10:40:21 AM', '20210919007', '04262', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-19', 'pending', '', '10', '', 'diagnosis', '2021-09-19 08:00 PM'), 
('4260', '2021-09-19', '10:41:47 AM', '20210919008', '04263', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '250.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-19', 'pending', '', '10', '', 'diagnosis', '2021-09-19 08:00 PM'), 
('4261', '2021-09-19', '10:47:19 AM', '20210919009', '04264', 'diagnosis', 'diagnosis', '1200.00', '0', '0.00', '1200.00', '600.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-09-19', 'pending', '', '10', '', 'diagnosis', '2021-09-19 08:00 PM'), 
('4262', '2021-09-19', '10:48:32 AM', '20210919010', '04265', 'diagnosis', 'diagnosis', '950.00', '0', '0.00', '950.00', '350.00', 'Flat', '600.00', '600.00', '0.00', '0.00', '600.00', '2021-09-19', 'pending', '', '10', '', 'diagnosis', '2021-09-19 08:00 PM'), 
('4263', '2021-09-19', '10:51:25 AM', '20210919011', '04266', 'diagnosis', 'diagnosis', '1350.00', '0', '0.00', '1350.00', '250.00', 'Flat', '1100.00', '1100.00', '0.00', '0.00', '1100.00', '2021-09-19', 'pending', '', '10', '', 'diagnosis', '2021-09-19 08:00 PM'), 
('4264', '2021-09-19', '10:53:55 AM', '20210919012', '04267', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-19', 'pending', '', '10', '', 'diagnosis', '2021-09-19 08:00 PM'), 
('4265', '2021-09-19', '10:56:10 AM', '20210919013', '04268', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '150.00', 'Flat', '0.00', '0.00', '0.00', '0.00', '0.00', '2021-09-19', 'pending', '', '10', '', 'diagnosis', '2021-09-19 08:00 PM'), 
('4266', '2021-09-19', '11:10:28 AM', '20210919014', '04269', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-19', 'pending', '', '10', '', 'diagnosis', '2021-09-19 08:00 PM'), 
('4267', '2021-09-19', '11:13:10 AM', '20210919015', '04270', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-09-19', 'pending', '', '10', '', 'diagnosis', '2021-09-19 08:00 PM'), 
('4268', '2021-09-19', '11:14:16 AM', '20210919016', '04271', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-19', 'pending', '', '10', '', 'diagnosis', '2021-09-19 08:00 PM'), 
('4269', '2021-09-19', '11:18:16 AM', '20210919017', '04272', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-19', 'pending', '', '10', '', 'diagnosis', '2021-09-19 08:00 PM'), 
('4270', '2021-09-19', '11:19:19 AM', '20210919018', '04273', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-19', 'pending', '', '10', '', 'diagnosis', '2021-09-19 08:00 PM'), 
('4271', '2021-09-19', '11:25:12 AM', '20210919019', '04274', 'diagnosis', 'diagnosis', '150.00', '0', '0.00', '150.00', '100.00', 'Flat', '50.00', '50.00', '0.00', '0.00', '50.00', '2021-09-19', 'pending', '', '10', '', 'diagnosis', '2021-09-19 08:00 PM'), 
('4272', '2021-09-19', '11:29:20 AM', '20210919020', '04275', 'diagnosis', 'diagnosis', '550.00', '0', '0.00', '550.00', '150.00', 'Flat', '400.00', '400.00', '0.00', '0.00', '400.00', '2021-09-19', 'pending', '', '10', '', 'diagnosis', '2021-09-19 08:00 PM'), 
('4273', '2021-09-19', '11:30:01 AM', '20210919021', '04276', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '200.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-19', 'pending', '', '10', '', 'diagnosis', '2021-09-19 08:00 PM'), 
('4274', '2021-09-19', '11:31:40 AM', '20210919022', '04277', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '200.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-19', 'pending', '', '10', '', 'diagnosis', '2021-09-19 08:00 PM'), 
('4275', '2021-09-19', '11:32:47 AM', '20210919023', '04278', 'diagnosis', 'diagnosis', '1000.00', '0', '0.00', '1000.00', '300.00', 'Flat', '700.00', '700.00', '0.00', '0.00', '700.00', '2021-09-19', 'pending', '', '10', '', 'diagnosis', '2021-09-19 08:00 PM'), 
('4276', '2021-09-19', '11:34:45 AM', '20210919024', '04279', 'diagnosis', 'diagnosis', '700.00', '0', '0.00', '700.00', '200.00', 'Flat', '500.00', '500.00', '0.00', '0.00', '500.00', '2021-09-19', 'pending', '', '10', '', 'diagnosis', '2021-09-19 08:00 PM'), 
('4277', '2021-09-19', '11:37:01 AM', '20210919025', '04280', 'diagnosis', 'diagnosis', '2050.00', '0', '0.00', '2050.00', '350.00', 'Flat', '1700.00', '1700.00', '0.00', '0.00', '1700.00', '2021-09-19', 'pending', '', '10', '', 'diagnosis', '2021-09-19 08:00 PM');  



 



 



 



 



 



 



 



 



 



 



 



INSERT INTO `cost_field` ( `id`, `code`, `cost_field`, `trash`) VALUES 
('1', '0001', 'Hospital Cost', '0'), 
('2', '0002', 'eletracity ', '0'), 
('3', '0003', 'Doctor Cost', '0');  



 



 



 



INSERT INTO `designations` ( `id`, `created_at`, `designation_name`, `trash`) VALUES 
('1', '2020-11-19', 'Managing Director', '0'), 
('2', '2020-11-07', 'Manager', '1'), 
('3', '2020-11-08', 'Labourer', '1'), 
('4', '2020-11-16', 'operator', '1'), 
('5', '2020-11-19', 'Laboratory Technician ', '0'), 
('6', '2020-11-19', 'Nurse', '0'), 
('7', '2020-11-19', 'O.T. Specialist ', '0'), 
('8', '2020-11-19', 'Nurse Maid', '0'), 
('9', '2020-11-19', 'Night Guard ', '0'), 
('10', '2021-06-24', 'Receptionist', '0');  



INSERT INTO `diagnosis` ( `id`, `date`, `delivery`, `pid`, `name`, `group_id`, `test_id`, `gender`, `reference_name`, `refereed_doctor`, `group`, `room`, `result`, `alt_doctor_id`, `alt_doctor_fee`, `remarks`, `amount`, `cost`, `bill`, `user_id`, `status`) VALUES 
('4228', '2021-08-10', '0000-00-00', '12761', '', '141', '805', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1108', '15', 'pending'), 
('4229', '2021-08-10', '0000-00-00', '12761', '', '141', '810', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1108', '15', 'pending'), 
('4230', '2021-08-10', '0000-00-00', '27939', '', '141', '898', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1109', '15', 'pending'), 
('4231', '2021-08-10', '0000-00-00', '27939', '', '141', '805', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1109', '15', 'pending'), 
('4232', '2021-08-10', '0000-00-00', '27939', '', '141', '804', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1109', '15', 'pending'), 
('4233', '2021-08-10', '0000-00-00', '27939', '', '141', '800', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1109', '15', 'pending'), 
('4234', '2021-08-10', '0000-00-00', '51442', '', '141', '805', '', '112', '49', '', '', '', '0', '0.00', '', '0.00', '0.00', '1110', '15', 'pending'), 
('4235', '2021-08-10', '0000-00-00', '23381', '', '141', '790', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1111', '15', 'pending'), 
('4236', '2021-08-10', '0000-00-00', '73086', '', '135', '822', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1112', '15', 'pending'), 
('4237', '2021-08-10', '0000-00-00', '80864', '', '141', '805', '', '112', '49', '', '', '', '0', '0.00', '', '0.00', '0.00', '1113', '15', 'pending'), 
('4238', '2021-08-10', '0000-00-00', '80864', '', '141', '810', '', '112', '49', '', '', '', '0', '0.00', '', '0.00', '0.00', '1113', '15', 'pending'), 
('4239', '2021-08-10', '0000-00-00', '80864', '', '135', '822', '', '112', '49', '', '', '', '0', '0.00', '', '0.00', '0.00', '1113', '15', 'pending'), 
('4240', '2021-08-10', '0000-00-00', '39375', '', '141', '805', '', '112', '49', '', '', '', '0', '0.00', '', '0.00', '0.00', '1114', '15', 'pending'), 
('4241', '2021-08-10', '0000-00-00', '55727', '', '141', '805', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1115', '15', 'pending'), 
('4242', '2021-08-10', '0000-00-00', '14027', '', '135', '822', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1116', '15', 'pending'), 
('4243', '2021-08-10', '0000-00-00', '98622', '', '141', '790', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1117', '15', 'pending'), 
('4244', '2021-08-10', '0000-00-00', '98622', '', '141', '805', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1117', '15', 'pending'), 
('4245', '2021-08-10', '0000-00-00', '98622', '', '141', '810', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1117', '15', 'pending'), 
('4246', '2021-08-10', '0000-00-00', '98622', '', '139', '880', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1117', '15', 'pending'), 
('4247', '2021-08-10', '0000-00-00', '89487', '', '141', '790', '', '112', '47', '', '', '', '0', '0.00', '', '0.00', '0.00', '1118', '15', 'pending'), 
('4248', '2021-08-10', '0000-00-00', '89487', '', '141', '793', '', '112', '47', '', '', '', '0', '0.00', '', '0.00', '0.00', '1118', '15', 'pending'), 
('4249', '2021-08-10', '0000-00-00', '89487', '', '141', '801', '', '112', '47', '', '', '', '0', '0.00', '', '0.00', '0.00', '1118', '15', 'pending'), 
('4250', '2021-08-10', '0000-00-00', '89487', '', '141', '799', '', '112', '47', '', '', '', '0', '0.00', '', '0.00', '0.00', '1118', '15', 'pending'), 
('4251', '2021-08-10', '0000-00-00', '89487', '', '139', '887', '', '112', '47', '', '', '', '0', '0.00', '', '0.00', '0.00', '1118', '15', 'pending'), 
('4252', '2021-08-10', '0000-00-00', '89487', '', '138', '854', '', '112', '47', '', '', '', '0', '0.00', '', '0.00', '0.00', '1118', '15', 'pending'), 
('4253', '2021-08-11', '0000-00-00', '72160', '', '141', '807', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1119', '15', 'pending'), 
('4256', '2021-08-11', '0000-00-00', '83705', '', '141', '899', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1122', '15', 'pending'), 
('4257', '2021-08-11', '0000-00-00', '14836', '', '141', '899', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1123', '15', 'pending'), 
('4258', '2021-08-11', '0000-00-00', '51413', '', '143', '902', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1124', '15', 'pending'), 
('4260', '2021-08-11', '0000-00-00', '12007', '', '139', '880', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1126', '15', 'pending'), 
('4261', '2021-08-11', '0000-00-00', '33490', '', '139', '880', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1127', '15', 'pending'), 
('4262', '2021-08-11', '0000-00-00', '85397', '', '139', '882', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1128', '15', 'pending'), 
('4263', '2021-08-11', '0000-00-00', '47245', '', '141', '811', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1129', '15', 'pending'), 
('4264', '2021-08-11', '0000-00-00', '47245', '', '141', '805', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1129', '15', 'pending'), 
('4266', '2021-08-11', '0000-00-00', '56857', '', '141', '807', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1131', '15', 'pending'), 
('4268', '2021-08-11', '0000-00-00', '47331', '', '139', '880', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1133', '15', 'pending'), 
('4269', '2021-08-11', '0000-00-00', '47331', '', '141', '804', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1133', '15', 'pending'), 
('4271', '2021-08-11', '0000-00-00', '51117', '', '139', '880', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1135', '15', 'pending'), 
('4272', '2021-08-11', '0000-00-00', '75723', '', '138', '840', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1136', '15', 'pending'), 
('4273', '2021-08-11', '0000-00-00', '78898', '', '139', '883', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1137', '15', 'pending'), 
('4274', '2021-08-11', '0000-00-00', '78898', '', '138', '827', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1137', '15', 'pending'), 
('4275', '2021-08-11', '0000-00-00', '78898', '', '141', '790', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1137', '15', 'pending'), 
('4276', '2021-08-11', '0000-00-00', '78898', '', '135', '822', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1137', '15', 'pending'), 
('4277', '2021-08-11', '0000-00-00', '01140', '', '139', '882', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1138', '15', 'pending'), 
('4278', '2021-08-11', '0000-00-00', '01140', '', '140', '876', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1138', '15', 'pending'), 
('4279', '2021-08-11', '0000-00-00', '01140', '', '141', '805', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1138', '15', 'pending'), 
('4280', '2021-08-11', '0000-00-00', '01140', '', '135', '822', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1138', '15', 'pending'), 
('4281', '2021-08-11', '0000-00-00', '01142', '', '139', '880', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1139', '15', 'pending'), 
('4282', '2021-08-11', '0000-00-00', '01142', '', '141', '804', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1139', '15', 'pending'), 
('4283', '2021-08-11', '0000-00-00', '01143', '', '138', '866', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1140', '15', 'pending'), 
('4285', '2021-08-11', '0000-00-00', '01145', '', '139', '880', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1142', '15', 'pending'), 
('4288', '2021-08-11', '0000-00-00', '01148', '', '139', '882', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1145', '15', 'pending'), 
('4289', '2021-08-11', '0000-00-00', '01148', '', '138', '853', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1145', '15', 'pending'), 
('4290', '2021-08-11', '0000-00-00', '01149', '', '135', '822', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1146', '15', 'pending'), 
('4291', '2021-08-11', '0000-00-00', '01149', '', '141', '805', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1146', '15', 'pending'), 
('4292', '2021-08-11', '0000-00-00', '01149', '', '139', '883', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1146', '15', 'pending'), 
('4293', '2021-08-11', '0000-00-00', '01149', '', '141', '790', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1146', '15', 'pending'), 
('4294', '2021-08-11', '0000-00-00', '01150', '', '141', '792', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1147', '15', 'pending'), 
('4295', '2021-08-11', '0000-00-00', '01150', '', '139', '882', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1147', '15', 'pending'), 
('4296', '2021-08-11', '0000-00-00', '01151', '', '139', '880', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1148', '15', 'pending'), 
('4297', '2021-08-11', '0000-00-00', '01152', '', '141', '791', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1149', '15', 'pending'), 
('4298', '2021-08-11', '0000-00-00', '01152', '', '139', '882', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1149', '15', 'pending'), 
('4299', '2021-08-11', '0000-00-00', '01153', '', '139', '882', '', '112', '54', '', '', '', '0', '0.00', '', '0.00', '0.00', '1150', '15', 'pending'), 
('4300', '2021-08-11', '0000-00-00', '01154', '', '139', '882', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1151', '15', 'pending'), 
('4301', '2021-08-11', '0000-00-00', '01154', '', '138', '828', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1151', '15', 'pending'), 
('4302', '2021-08-11', '0000-00-00', '01154', '', '141', '790', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1151', '15', 'pending'), 
('4303', '2021-08-11', '0000-00-00', '01154', '', '141', '797', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1151', '15', 'pending'), 
('4304', '2021-08-11', '0000-00-00', '01154', '', '141', '805', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1151', '15', 'pending'), 
('4305', '2021-08-11', '0000-00-00', '01154', '', '135', '822', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1151', '15', 'pending'), 
('4306', '2021-08-11', '0000-00-00', '01155', '', '139', '882', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1152', '15', 'pending'), 
('4307', '2021-08-11', '0000-00-00', '01156', '', '139', '881', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1153', '15', 'pending'), 
('4308', '2021-08-11', '0000-00-00', '01157', '', '139', '880', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1154', '15', 'pending'), 
('4309', '2021-08-11', '0000-00-00', '01158', '', '139', '880', '', '112', '54', '', '', '', '0', '0.00', '', '0.00', '0.00', '1155', '15', 'pending'), 
('4310', '2021-08-11', '0000-00-00', '01159', '', '139', '882', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1156', '15', 'pending'), 
('4311', '2021-08-11', '0000-00-00', '01160', '', '139', '880', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1157', '15', 'pending'), 
('4312', '2021-08-11', '0000-00-00', '01161', '', '141', '807', '', '112', '54', '', '', '', '0', '0.00', '', '0.00', '0.00', '1158', '15', 'pending'), 
('4314', '2021-08-11', '0000-00-00', '01163', '', '141', '807', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1160', '15', 'pending'), 
('4315', '2021-08-11', '0000-00-00', '01164', '', '140', '876', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1161', '15', 'pending'), 
('4316', '2021-08-11', '0000-00-00', '01165', '', '140', '876', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1162', '15', 'pending'), 
('4317', '2021-08-11', '0000-00-00', '01166', '', '141', '898', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1163', '15', 'pending'), 
('4318', '2021-08-11', '0000-00-00', '01166', '', '141', '800', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1163', '15', 'pending'), 
('4319', '2021-08-11', '0000-00-00', '01166', '', '141', '804', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1163', '15', 'pending'), 
('4320', '2021-08-11', '0000-00-00', '01166', '', '141', '805', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1163', '15', 'pending'), 
('4321', '2021-08-11', '0000-00-00', '01166', '', '139', '880', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1163', '15', 'pending'), 
('4322', '2021-08-11', '0000-00-00', '01167', '', '139', '880', '', '112', '0', '', '', '', '0', '0.00', '', '0.00', '0.00', '1164', '15', 'pending'), 
('4323', '2021-08-11', '0000-00-00', '01168', '', '141', '791', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1165', '15', 'pending'), 
('4324', '2021-08-11', '0000-00-00', '01168', '', '141', '804', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1165', '15', 'pending'), 
('4325', '2021-08-11', '0000-00-00', '01168', '', '138', '843', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1165', '15', 'pending'), 
('4326', '2021-08-11', '0000-00-00', '01169', '', '139', '880', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1166', '15', 'pending'), 
('4327', '2021-08-11', '0000-00-00', '01169', '', '135', '822', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1166', '15', 'pending'), 
('4328', '2021-08-11', '0000-00-00', '01170', '', '141', '805', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1167', '15', 'pending'), 
('4329', '2021-08-11', '0000-00-00', '01170', '', '135', '822', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1167', '15', 'pending'), 
('4330', '2021-08-11', '0000-00-00', '01171', '', '141', '898', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1168', '15', 'pending'), 
('4331', '2021-08-11', '0000-00-00', '01171', '', '141', '805', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1168', '15', 'pending'), 
('4332', '2021-08-11', '0000-00-00', '01171', '', '135', '822', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1168', '15', 'pending'), 
('4333', '2021-08-11', '0000-00-00', '01171', '', '139', '884', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1168', '15', 'pending'), 
('4334', '2021-08-11', '0000-00-00', '01172', '', '141', '790', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1169', '15', 'pending'), 
('4335', '2021-08-11', '0000-00-00', '01172', '', '141', '805', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1169', '15', 'pending'), 
('4336', '2021-08-11', '0000-00-00', '01172', '', '141', '810', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1169', '15', 'pending'), 
('4337', '2021-08-11', '0000-00-00', '01172', '', '135', '822', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1169', '15', 'pending'), 
('4338', '2021-08-11', '0000-00-00', '01172', '', '140', '876', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1169', '15', 'pending'), 
('4339', '2021-08-11', '0000-00-00', '01172', '', '138', '843', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1169', '15', 'pending'), 
('4340', '2021-08-11', '0000-00-00', '01173', '', '141', '790', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1170', '15', 'pending'), 
('4341', '2021-08-11', '0000-00-00', '01173', '', '141', '805', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1170', '15', 'pending'), 
('4342', '2021-08-11', '0000-00-00', '01173', '', '135', '822', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1170', '15', 'pending'), 
('4343', '2021-08-11', '0000-00-00', '01173', '', '138', '828', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1170', '15', 'pending'), 
('4344', '2021-08-11', '0000-00-00', '01173', '', '140', '876', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1170', '15', 'pending'), 
('4345', '2021-08-11', '0000-00-00', '01173', '', '141', '818', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1170', '15', 'pending'), 
('4346', '2021-08-11', '0000-00-00', '01174', '', '138', '827', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1171', '15', 'pending'), 
('4347', '2021-08-11', '0000-00-00', '01174', '', '141', '790', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1171', '15', 'pending'), 
('4348', '2021-08-11', '0000-00-00', '01174', '', '141', '797', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1171', '15', 'pending'), 
('4349', '2021-08-11', '0000-00-00', '01175', '', '141', '898', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1172', '15', 'pending'), 
('4350', '2021-08-11', '0000-00-00', '01175', '', '141', '805', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1172', '15', 'pending'), 
('4351', '2021-08-11', '0000-00-00', '01175', '', '141', '810', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1172', '15', 'pending'), 
('4352', '2021-08-11', '0000-00-00', '01175', '', '135', '822', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1172', '15', 'pending'), 
('4353', '2021-08-11', '0000-00-00', '01175', '', '139', '882', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1172', '15', 'pending'), 
('4354', '2021-08-11', '0000-00-00', '01175', '', '138', '855', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1172', '15', 'pending'), 
('4355', '2021-08-11', '0000-00-00', '01176', '', '141', '898', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1173', '15', 'pending'), 
('4356', '2021-08-11', '0000-00-00', '01176', '', '141', '800', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1173', '15', 'pending'), 
('4357', '2021-08-11', '0000-00-00', '01176', '', '141', '805', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1173', '15', 'pending'), 
('4358', '2021-08-11', '0000-00-00', '01176', '', '135', '822', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1173', '15', 'pending'), 
('4359', '2021-08-11', '0000-00-00', '01177', '', '139', '882', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1174', '15', 'pending'), 
('4360', '2021-08-11', '0000-00-00', '01177', '', '140', '876', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1174', '15', 'pending'), 
('4361', '2021-08-11', '0000-00-00', '01177', '', '135', '822', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1174', '15', 'pending'), 
('4362', '2021-08-11', '0000-00-00', '01177', '', '141', '805', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1174', '15', 'pending'), 
('4363', '2021-08-11', '0000-00-00', '01177', '', '141', '810', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1174', '15', 'pending'), 
('4364', '2021-08-11', '0000-00-00', '01178', '', '141', '898', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1175', '15', 'pending'), 
('4365', '2021-08-11', '0000-00-00', '01178', '', '141', '800', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1175', '15', 'pending'), 
('4366', '2021-08-11', '0000-00-00', '01178', '', '139', '880', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1175', '15', 'pending'), 
('4367', '2021-08-11', '0000-00-00', '01178', '', '141', '805', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1175', '15', 'pending'), 
('4368', '2021-08-11', '0000-00-00', '01179', '', '139', '882', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1176', '15', 'pending'), 
('4369', '2021-08-11', '0000-00-00', '01179', '', '135', '822', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1176', '15', 'pending'), 
('4370', '2021-08-11', '0000-00-00', '01179', '', '141', '810', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1176', '15', 'pending'), 
('4371', '2021-08-11', '0000-00-00', '01180', '', '139', '880', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1177', '15', 'pending'), 
('4372', '2021-08-11', '0000-00-00', '01181', '', '138', '869', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1178', '15', 'pending'), 
('4373', '2021-08-11', '0000-00-00', '01182', '', '138', '827', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1179', '15', 'pending'), 
('4374', '2021-08-11', '0000-00-00', '01182', '', '141', '790', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1179', '15', 'pending'), 
('4375', '2021-08-11', '0000-00-00', '01182', '', '141', '811', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1179', '15', 'pending'), 
('4376', '2021-08-11', '0000-00-00', '01182', '', '141', '810', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1179', '15', 'pending'), 
('4377', '2021-08-11', '0000-00-00', '01182', '', '141', '818', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1179', '15', 'pending'), 
('4378', '2021-08-11', '0000-00-00', '01182', '', '135', '822', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1179', '15', 'pending'), 
('4379', '2021-08-11', '0000-00-00', '01183', '', '141', '805', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1180', '15', 'pending'), 
('4380', '2021-08-11', '0000-00-00', '01183', '', '138', '843', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1180', '15', 'pending'), 
('4381', '2021-08-11', '0000-00-00', '01184', '', '141', '898', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1181', '15', 'pending'), 
('4382', '2021-08-11', '0000-00-00', '01184', '', '139', '884', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1181', '15', 'pending'), 
('4383', '2021-08-11', '0000-00-00', '01185', '', '141', '791', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1182', '15', 'pending'), 
('4384', '2021-08-11', '0000-00-00', '01185', '', '135', '822', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1182', '15', 'pending'), 
('4385', '2021-08-11', '0000-00-00', '01185', '', '141', '805', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1182', '15', 'pending'), 
('4386', '2021-08-11', '0000-00-00', '01186', '', '141', '804', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1183', '15', 'pending'), 
('4387', '2021-08-11', '0000-00-00', '01186', '', '135', '822', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1183', '15', 'pending'), 
('4388', '2021-08-11', '0000-00-00', '01186', '', '141', '805', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1183', '15', 'pending'), 
('4389', '2021-08-11', '0000-00-00', '01186', '', '137', '879', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1183', '15', 'pending'), 
('4390', '2021-08-11', '0000-00-00', '01187', '', '141', '805', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1184', '15', 'pending'), 
('4391', '2021-08-11', '0000-00-00', '01188', '', '141', '792', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1185', '15', 'pending'), 
('4392', '2021-08-11', '0000-00-00', '01188', '', '141', '811', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1185', '15', 'pending'), 
('4393', '2021-08-11', '0000-00-00', '01188', '', '141', '810', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1185', '15', 'pending'), 
('4394', '2021-08-11', '0000-00-00', '01188', '', '141', '818', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1185', '15', 'pending'), 
('4395', '2021-08-11', '0000-00-00', '01188', '', '135', '822', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1185', '15', 'pending'), 
('4396', '2021-08-11', '0000-00-00', '01188', '', '139', '882', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1185', '15', 'pending'), 
('4397', '2021-08-11', '0000-00-00', '01188', '', '138', '828', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1185', '15', 'pending'), 
('4398', '2021-08-11', '0000-00-00', '01189', '', '138', '854', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1186', '15', 'pending'), 
('4399', '2021-08-11', '0000-00-00', '01189', '', '139', '882', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1186', '15', 'pending'), 
('4400', '2021-08-11', '0000-00-00', '01189', '', '135', '822', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1186', '15', 'pending'), 
('4401', '2021-08-11', '0000-00-00', '01190', '', '139', '882', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1187', '15', 'pending'), 
('4402', '2021-08-11', '0000-00-00', '01191', '', '141', '805', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1188', '15', 'pending'), 
('4403', '2021-08-11', '0000-00-00', '01192', '', '141', '807', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1189', '15', 'pending'), 
('4404', '2021-08-11', '0000-00-00', '01193', '', '144', '903', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1190', '15', 'pending'), 
('4405', '2021-08-11', '0000-00-00', '01193', '', '139', '882', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1190', '15', 'pending'), 
('4406', '2021-08-11', '0000-00-00', '01193', '', '135', '822', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1190', '15', 'pending'), 
('4407', '2021-08-11', '0000-00-00', '01194', '', '139', '882', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1191', '15', 'pending'), 
('4408', '2021-08-11', '0000-00-00', '01194', '', '144', '903', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1191', '15', 'pending'), 
('4409', '2021-08-11', '0000-00-00', '01194', '', '141', '805', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1191', '15', 'pending'), 
('4410', '2021-08-11', '0000-00-00', '01194', '', '141', '810', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1191', '15', 'pending'), 
('4411', '2021-08-11', '0000-00-00', '01194', '', '135', '822', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1191', '15', 'pending'), 
('4412', '2021-08-11', '0000-00-00', '01195', '', '139', '882', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1192', '15', 'pending'), 
('4413', '2021-08-11', '0000-00-00', '01195', '', '135', '822', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1192', '15', 'pending'), 
('4414', '2021-08-11', '0000-00-00', '01196', '', '139', '880', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1193', '15', 'pending'), 
('4415', '2021-08-11', '0000-00-00', '01197', '', '141', '805', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1194', '15', 'pending'), 
('4416', '2021-08-11', '0000-00-00', '01197', '', '140', '876', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1194', '15', 'pending'), 
('4417', '2021-08-11', '0000-00-00', '01198', '', '141', '810', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1195', '15', 'pending'), 
('4418', '2021-08-11', '0000-00-00', '01199', '', '141', '792', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1196', '15', 'pending'), 
('4419', '2021-08-11', '0000-00-00', '01199', '', '141', '797', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1196', '15', 'pending'), 
('4420', '2021-08-11', '0000-00-00', '01199', '', '135', '822', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1196', '15', 'pending'), 
('4421', '2021-08-11', '0000-00-00', '01199', '', '139', '882', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1196', '15', 'pending'), 
('4422', '2021-08-11', '0000-00-00', '01200', '', '141', '805', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1197', '15', 'pending'), 
('4423', '2021-08-11', '0000-00-00', '01200', '', '140', '876', '', '112', '46', '', '', '', '0', '0.00', '', '0.00', '0.00', '1197', '15', 'pending'), 
('4424', '2021-08-12', '0000-00-00', '01201', '', '139', '880', '', '112', '54', '', '', '', '0', '0.00', '', '0.00', '0.00', '1198', '15', 'pending'), 
('4425', '2021-08-12', '0000-00-00', '01202', '', '138', '839', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1199', '15', 'pending'), 
('4426', '2021-08-12', '0000-00-00', '01203', '', '139', '880', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1200', '15', 'pending'), 
('4427', '2021-08-12', '0000-00-00', '01204', '', '138', '839', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1201', '15', 'pending'), 
('4428', '2021-08-12', '0000-00-00', '01205', '', '138', '838', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1202', '15', 'pending'), 
('4429', '2021-08-12', '0000-00-00', '01206', '', '135', '822', '', '112', '58', '', '', '', '0', '0.00', '', '0.00', '0.00', '1203', '15', 'pending'), 
('4430', '2021-08-12', '0000-00-00', '01206', '', '139', '880', '', '112', '58', '', '', '', '0', '0.00', '', '0.00', '0.00', '1203', '15', 'pending'), 
('4431', '2021-08-12', '0000-00-00', '01207', '', '141', '805', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1204', '15', 'pending'), 
('4432', '2021-08-12', '0000-00-00', '01208', '', '139', '880', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1205', '15', 'pending'), 
('4433', '2021-08-12', '0000-00-00', '01209', '', '139', '880', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1206', '15', 'pending'), 
('4434', '2021-08-12', '0000-00-00', '01210', '', '139', '880', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1207', '15', 'pending'), 
('4435', '2021-08-12', '0000-00-00', '01211', '', '141', '790', '', '112', '50', '', '', '', '0', '0.00', '', '0.00', '0.00', '1208', '15', 'pending'), 
('4436', '2021-08-12', '0000-00-00', '01211', '', '141', '795', '', '112', '50', '', '', '', '0', '0.00', '', '0.00', '0.00', '1208', '15', 'pending'), 
('4437', '2021-08-12', '0000-00-00', '01211', '', '141', '818', '', '112', '50', '', '', '', '0', '0.00', '', '0.00', '0.00', '1208', '15', 'pending'), 
('4438', '2021-08-12', '0000-00-00', '01211', '', '135', '822', '', '112', '50', '', '', '', '0', '0.00', '', '0.00', '0.00', '1208', '15', 'pending'), 
('4439', '2021-08-12', '0000-00-00', '01211', '', '138', '855', '', '112', '50', '', '', '', '0', '0.00', '', '0.00', '0.00', '1208', '15', 'pending'), 
('4440', '2021-08-12', '0000-00-00', '01212', '', '139', '880', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1209', '15', 'pending'), 
('4441', '2021-08-12', '0000-00-00', '01213', '', '141', '790', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1210', '15', 'pending'), 
('4442', '2021-08-12', '0000-00-00', '01213', '', '141', '797', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1210', '15', 'pending'), 
('4443', '2021-08-12', '0000-00-00', '01213', '', '141', '805', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1210', '15', 'pending'), 
('4444', '2021-08-12', '0000-00-00', '01213', '', '135', '822', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1210', '15', 'pending'), 
('4445', '2021-08-12', '0000-00-00', '01213', '', '138', '843', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1210', '15', 'pending'), 
('4446', '2021-08-12', '0000-00-00', '01213', '', '139', '882', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1210', '15', 'pending'), 
('4447', '2021-08-12', '0000-00-00', '01214', '', '139', '880', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1211', '15', 'pending'), 
('4448', '2021-08-12', '0000-00-00', '01215', '', '139', '882', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1212', '15', 'pending'), 
('4449', '2021-08-12', '0000-00-00', '01216', '', '141', '790', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1213', '15', 'pending'), 
('4450', '2021-08-12', '0000-00-00', '01216', '', '141', '797', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1213', '15', 'pending'), 
('4451', '2021-08-12', '0000-00-00', '01216', '', '139', '882', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1213', '15', 'pending'), 
('4452', '2021-08-12', '0000-00-00', '01217', '', '139', '887', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1214', '15', 'pending'), 
('4453', '2021-08-12', '0000-00-00', '01218', '', '141', '805', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1215', '15', 'pending'), 
('4454', '2021-08-12', '0000-00-00', '01218', '', '135', '822', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1215', '15', 'pending'), 
('4455', '2021-08-12', '0000-00-00', '01218', '', '139', '882', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1215', '15', 'pending'), 
('4456', '2021-08-12', '0000-00-00', '01219', '', '139', '882', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1216', '15', 'pending'), 
('4457', '2021-08-12', '0000-00-00', '01220', '', '141', '804', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1217', '15', 'pending'), 
('4458', '2021-08-12', '0000-00-00', '01220', '', '139', '881', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1217', '15', 'pending'), 
('4459', '2021-08-12', '0000-00-00', '01221', '', '141', '790', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1218', '15', 'pending'), 
('4460', '2021-08-12', '0000-00-00', '01221', '', '141', '797', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1218', '15', 'pending'), 
('4461', '2021-08-12', '0000-00-00', '01221', '', '135', '822', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1218', '15', 'pending'), 
('4462', '2021-08-12', '0000-00-00', '01221', '', '139', '882', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1218', '15', 'pending'), 
('4463', '2021-08-12', '0000-00-00', '01222', '', '141', '792', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1219', '15', 'pending'), 
('4464', '2021-08-12', '0000-00-00', '01222', '', '141', '805', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1219', '15', 'pending'), 
('4465', '2021-08-12', '0000-00-00', '01222', '', '141', '811', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1219', '15', 'pending'), 
('4466', '2021-08-12', '0000-00-00', '01222', '', '135', '822', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1219', '15', 'pending'), 
('4467', '2021-08-12', '0000-00-00', '01222', '', '139', '882', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1219', '15', 'pending'), 
('4468', '2021-08-12', '0000-00-00', '01222', '', '138', '828', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1219', '15', 'pending'), 
('4469', '2021-08-12', '0000-00-00', '01223', '', '139', '880', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1220', '15', 'pending'), 
('4470', '2021-08-12', '0000-00-00', '01224', '', '141', '805', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1221', '15', 'pending'), 
('4471', '2021-08-12', '0000-00-00', '01224', '', '135', '822', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1221', '15', 'pending'), 
('4472', '2021-08-12', '0000-00-00', '01224', '', '139', '882', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1221', '15', 'pending'), 
('4473', '2021-08-12', '0000-00-00', '01224', '', '138', '853', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1221', '15', 'pending'), 
('4474', '2021-08-12', '0000-00-00', '01225', '', '141', '805', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1222', '15', 'pending'), 
('4475', '2021-08-12', '0000-00-00', '01225', '', '135', '822', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1222', '15', 'pending'), 
('4476', '2021-08-12', '0000-00-00', '01225', '', '139', '882', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1222', '15', 'pending'), 
('4477', '2021-08-12', '0000-00-00', '01225', '', '140', '876', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1222', '15', 'pending'), 
('4478', '2021-08-12', '0000-00-00', '01226', '', '135', '822', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1223', '15', 'pending'), 
('4479', '2021-08-12', '0000-00-00', '01226', '', '139', '894', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1223', '15', 'pending'), 
('4480', '2021-08-12', '0000-00-00', '01227', '', '135', '822', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1224', '15', 'pending'), 
('4481', '2021-08-12', '0000-00-00', '01227', '', '139', '894', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1224', '15', 'pending'), 
('4482', '2021-08-12', '0000-00-00', '01228', '', '138', '867', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1225', '15', 'pending'), 
('4483', '2021-08-12', '0000-00-00', '01229', '', '141', '792', '', '112', '58', '', '', '', '0', '0.00', '', '0.00', '0.00', '1226', '15', 'pending'), 
('4484', '2021-08-12', '0000-00-00', '01229', '', '141', '797', '', '112', '58', '', '', '', '0', '0.00', '', '0.00', '0.00', '1226', '15', 'pending'), 
('4485', '2021-08-12', '0000-00-00', '01229', '', '141', '804', '', '112', '58', '', '', '', '0', '0.00', '', '0.00', '0.00', '1226', '15', 'pending'), 
('4486', '2021-08-12', '0000-00-00', '01229', '', '139', '880', '', '112', '58', '', '', '', '0', '0.00', '', '0.00', '0.00', '1226', '15', 'pending'), 
('4487', '2021-08-12', '0000-00-00', '01230', '', '141', '790', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1227', '15', 'pending'), 
('4488', '2021-08-12', '0000-00-00', '01230', '', '141', '797', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1227', '15', 'pending'), 
('4489', '2021-08-12', '0000-00-00', '01230', '', '141', '811', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1227', '15', 'pending'), 
('4490', '2021-08-12', '0000-00-00', '01230', '', '139', '882', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1227', '15', 'pending'), 
('4491', '2021-08-12', '0000-00-00', '01231', '', '139', '882', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1228', '15', 'pending'), 
('4492', '2021-08-12', '0000-00-00', '01232', '', '135', '822', '', '112', '58', '', '', '', '0', '0.00', '', '0.00', '0.00', '1229', '15', 'pending'), 
('4493', '2021-08-12', '0000-00-00', '01232', '', '139', '880', '', '112', '58', '', '', '', '0', '0.00', '', '0.00', '0.00', '1229', '15', 'pending'), 
('4494', '2021-08-12', '0000-00-00', '01233', '', '139', '880', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1230', '15', 'pending'), 
('4495', '2021-08-12', '0000-00-00', '01234', '', '135', '822', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1231', '15', 'pending'), 
('4496', '2021-08-12', '0000-00-00', '01234', '', '139', '882', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1231', '15', 'pending'), 
('4497', '2021-08-12', '0000-00-00', '01235', '', '139', '882', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1232', '15', 'pending'), 
('4498', '2021-08-12', '0000-00-00', '01236', '', '141', '805', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1233', '15', 'pending'), 
('4499', '2021-08-12', '0000-00-00', '01236', '', '139', '882', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1233', '15', 'pending'), 
('4500', '2021-08-12', '0000-00-00', '01237', '', '135', '822', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1234', '15', 'pending'), 
('4501', '2021-08-12', '0000-00-00', '01237', '', '139', '884', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1234', '15', 'pending'), 
('4502', '2021-08-12', '0000-00-00', '01238', '', '142', '823', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1235', '15', 'pending'), 
('4503', '2021-08-12', '0000-00-00', '01239', '', '142', '823', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1236', '15', 'pending'), 
('4504', '2021-08-12', '0000-00-00', '01240', '', '139', '880', '', '112', '54', '', '', '', '0', '0.00', '', '0.00', '0.00', '1237', '15', 'pending'), 
('4505', '2021-08-12', '0000-00-00', '01241', '', '142', '823', '', '112', '67', '', '', '', '0', '0.00', '', '0.00', '0.00', '1238', '15', 'pending'), 
('4506', '2021-08-12', '0000-00-00', '01241', '', '139', '880', '', '112', '67', '', '', '', '0', '0.00', '', '0.00', '0.00', '1238', '15', 'pending'), 
('4507', '2021-08-12', '0000-00-00', '01242', '', '139', '882', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1239', '15', 'pending'), 
('4508', '2021-08-12', '0000-00-00', '01243', '', '141', '792', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1240', '15', 'pending'), 
('4509', '2021-08-12', '0000-00-00', '01243', '', '139', '882', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1240', '15', 'pending'), 
('4510', '2021-08-12', '0000-00-00', '01244', '', '135', '822', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1241', '15', 'pending'), 
('4511', '2021-08-12', '0000-00-00', '01244', '', '139', '882', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1241', '15', 'pending'), 
('4512', '2021-08-12', '0000-00-00', '01245', '', '141', '790', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1242', '15', 'pending'), 
('4513', '2021-08-12', '0000-00-00', '01245', '', '141', '797', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1242', '15', 'pending'), 
('4514', '2021-08-12', '0000-00-00', '01245', '', '139', '882', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1242', '15', 'pending'), 
('4515', '2021-08-12', '0000-00-00', '01246', '', '141', '805', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1243', '15', 'pending'), 
('4516', '2021-08-12', '0000-00-00', '01246', '', '135', '822', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1243', '15', 'pending'), 
('4517', '2021-08-12', '0000-00-00', '01246', '', '139', '883', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1243', '15', 'pending'), 
('4518', '2021-08-12', '0000-00-00', '01247', '', '141', '792', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1244', '15', 'pending'), 
('4519', '2021-08-12', '0000-00-00', '01247', '', '139', '882', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1244', '15', 'pending'), 
('4520', '2021-08-12', '0000-00-00', '01248', '', '139', '882', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1245', '15', 'pending'), 
('4521', '2021-08-12', '0000-00-00', '01249', '', '138', '875', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1246', '15', 'pending'), 
('4522', '2021-08-12', '0000-00-00', '01250', '', '139', '880', '', '112', '54', '', '', '', '0', '0.00', '', '0.00', '0.00', '1247', '15', 'pending'), 
('4523', '2021-08-12', '0000-00-00', '01251', '', '139', '880', '', '112', '54', '', '', '', '0', '0.00', '', '0.00', '0.00', '1248', '15', 'pending'), 
('4524', '2021-08-12', '0000-00-00', '01252', '', '141', '898', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1249', '15', 'pending'), 
('4525', '2021-08-12', '0000-00-00', '01252', '', '141', '805', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1249', '15', 'pending'), 
('4526', '2021-08-12', '0000-00-00', '01252', '', '135', '822', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1249', '15', 'pending'), 
('4527', '2021-08-12', '0000-00-00', '01252', '', '139', '880', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1249', '15', 'pending'), 
('4528', '2021-08-12', '0000-00-00', '01253', '', '139', '880', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1250', '15', 'pending'), 
('4529', '2021-08-12', '0000-00-00', '01254', '', '132', '824', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1251', '15', 'pending'), 
('4530', '2021-08-12', '0000-00-00', '01255', '', '141', '898', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1252', '15', 'pending'), 
('4531', '2021-08-12', '0000-00-00', '01255', '', '141', '800', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1252', '15', 'pending'), 
('4532', '2021-08-12', '0000-00-00', '01255', '', '141', '804', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1252', '15', 'pending'), 
('4533', '2021-08-12', '0000-00-00', '01255', '', '141', '805', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1252', '15', 'pending'), 
('4534', '2021-08-12', '0000-00-00', '01255', '', '135', '822', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1252', '15', 'pending'), 
('4535', '2021-08-12', '0000-00-00', '01255', '', '139', '880', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1252', '15', 'pending'), 
('4536', '2021-08-12', '0000-00-00', '01256', '', '135', '822', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1253', '15', 'pending'), 
('4537', '2021-08-12', '0000-00-00', '01256', '', '139', '884', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1253', '15', 'pending'), 
('4538', '2021-08-12', '0000-00-00', '01257', '', '141', '805', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1254', '15', 'pending'), 
('4539', '2021-08-12', '0000-00-00', '01257', '', '141', '898', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1254', '15', 'pending'), 
('4540', '2021-08-12', '0000-00-00', '01257', '', '138', '857', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1254', '15', 'pending'), 
('4541', '2021-08-12', '0000-00-00', '01258', '', '141', '804', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1255', '15', 'pending'), 
('4542', '2021-08-12', '0000-00-00', '01259', '', '141', '805', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1256', '15', 'pending'), 
('4543', '2021-08-12', '0000-00-00', '01259', '', '141', '804', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1256', '15', 'pending'), 
('4544', '2021-08-12', '0000-00-00', '01259', '', '139', '880', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1256', '15', 'pending'), 
('4545', '2021-08-12', '0000-00-00', '01260', '', '141', '800', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1257', '15', 'pending'), 
('4546', '2021-08-12', '0000-00-00', '01260', '', '141', '804', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1257', '15', 'pending'), 
('4547', '2021-08-12', '0000-00-00', '01260', '', '141', '805', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1257', '15', 'pending'), 
('4548', '2021-08-12', '0000-00-00', '01260', '', '135', '822', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1257', '15', 'pending'), 
('4549', '2021-08-12', '0000-00-00', '01260', '', '141', '898', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1257', '15', 'pending'), 
('4550', '2021-08-12', '0000-00-00', '01260', '', '139', '880', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1257', '15', 'pending'), 
('4551', '2021-08-12', '0000-00-00', '01261', '', '141', '792', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1258', '15', 'pending'), 
('4552', '2021-08-12', '0000-00-00', '01261', '', '141', '898', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1258', '15', 'pending'), 
('4553', '2021-08-12', '0000-00-00', '01261', '', '141', '798', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1258', '15', 'pending'), 
('4554', '2021-08-12', '0000-00-00', '01261', '', '135', '822', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1258', '15', 'pending'), 
('4555', '2021-08-12', '0000-00-00', '01261', '', '139', '884', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1258', '15', 'pending'), 
('4556', '2021-08-12', '0000-00-00', '01262', '', '141', '805', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1259', '15', 'pending'), 
('4557', '2021-08-12', '0000-00-00', '01262', '', '135', '822', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1259', '15', 'pending'), 
('4558', '2021-08-12', '0000-00-00', '01262', '', '141', '898', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1259', '15', 'pending'), 
('4559', '2021-08-12', '0000-00-00', '01262', '', '139', '880', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1259', '15', 'pending'), 
('4560', '2021-08-12', '0000-00-00', '01263', '', '141', '898', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1260', '15', 'pending'), 
('4561', '2021-08-12', '0000-00-00', '01263', '', '141', '800', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1260', '15', 'pending'), 
('4562', '2021-08-12', '0000-00-00', '01263', '', '141', '804', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1260', '15', 'pending'), 
('4563', '2021-08-12', '0000-00-00', '01263', '', '141', '805', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1260', '15', 'pending'), 
('4564', '2021-08-12', '0000-00-00', '01263', '', '135', '822', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1260', '15', 'pending'), 
('4565', '2021-08-12', '0000-00-00', '01263', '', '139', '880', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1260', '15', 'pending'), 
('4566', '2021-08-12', '0000-00-00', '01264', '', '135', '822', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1261', '15', 'pending'), 
('4567', '2021-08-12', '0000-00-00', '01264', '', '139', '880', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1261', '15', 'pending'), 
('4568', '2021-08-12', '0000-00-00', '01265', '', '141', '898', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1262', '15', 'pending'), 
('4569', '2021-08-12', '0000-00-00', '01265', '', '141', '800', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1262', '15', 'pending'), 
('4570', '2021-08-12', '0000-00-00', '01265', '', '141', '805', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1262', '15', 'pending'), 
('4571', '2021-08-12', '0000-00-00', '01265', '', '139', '880', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1262', '15', 'pending'), 
('4572', '2021-08-12', '0000-00-00', '01266', '', '141', '804', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1263', '15', 'pending'), 
('4573', '2021-08-12', '0000-00-00', '01267', '', '141', '898', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1264', '15', 'pending'), 
('4574', '2021-08-12', '0000-00-00', '01267', '', '141', '805', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1264', '15', 'pending'), 
('4575', '2021-08-12', '0000-00-00', '01267', '', '139', '880', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1264', '15', 'pending'), 
('4576', '2021-08-12', '0000-00-00', '01268', '', '141', '791', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1265', '15', 'pending'), 
('4577', '2021-08-12', '0000-00-00', '01268', '', '141', '804', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1265', '15', 'pending'), 
('4578', '2021-08-12', '0000-00-00', '01268', '', '135', '822', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1265', '15', 'pending'), 
('4579', '2021-08-12', '0000-00-00', '01269', '', '141', '807', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1266', '15', 'pending'), 
('4580', '2021-08-12', '0000-00-00', '01270', '', '139', '882', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1267', '15', 'pending'), 
('4581', '2021-08-12', '0000-00-00', '01270', '', '141', '792', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1267', '15', 'pending'), 
('4582', '2021-08-12', '0000-00-00', '01270', '', '141', '797', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1267', '15', 'pending'), 
('4583', '2021-08-12', '0000-00-00', '01271', '', '141', '792', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1268', '15', 'pending'), 
('4584', '2021-08-12', '0000-00-00', '01271', '', '139', '882', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1268', '15', 'pending'), 
('4585', '2021-08-12', '0000-00-00', '01272', '', '141', '790', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1269', '15', 'pending'), 
('4586', '2021-08-12', '0000-00-00', '01272', '', '141', '804', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1269', '15', 'pending'), 
('4587', '2021-08-12', '0000-00-00', '01272', '', '141', '805', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1269', '15', 'pending'), 
('4588', '2021-08-12', '0000-00-00', '01272', '', '135', '822', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1269', '15', 'pending'), 
('4589', '2021-08-12', '0000-00-00', '01272', '', '139', '884', '', '112', '48', '', '', '', '0', '0.00', '', '0.00', '0.00', '1269', '15', 'pending'), 
('4590', '2021-08-12', '0000-00-00', '01273', '', '139', '880', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1270', '15', 'pending'), 
('4591', '2021-08-12', '0000-00-00', '01274', '', '139', '882', '', '112', '54', '', '', '', '0', '0.00', '', '0.00', '0.00', '1271', '15', 'pending'), 
('4592', '2021-08-13', '0000-00-00', '01275', '', '139', '880', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1272', '15', 'pending'), 
('4593', '2021-08-13', '0000-00-00', '01276', '', '138', '859', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1273', '15', 'pending'), 
('4594', '2021-08-13', '0000-00-00', '01277', '', '139', '880', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1274', '15', 'pending'), 
('4595', '2021-08-13', '0000-00-00', '01278', '', '139', '882', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1275', '15', 'pending'), 
('4596', '2021-08-13', '0000-00-00', '01279', '', '139', '882', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1276', '15', 'pending'), 
('4597', '2021-08-13', '0000-00-00', '01280', '', '139', '880', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1277', '15', 'pending'), 
('4598', '2021-08-13', '0000-00-00', '01281', '', '138', '854', '', '112', '51', '', '', '', '0', '0.00', '', '0.00', '0.00', '1278', '15', 'pending'), 
('4599', '2021-08-13', '0000-00-00', '01282', '', '141', '791', '', '112', '47', '', '', '', '0', '0.00', '', '0.00', '0.00', '1279', '15', 'pending'), 
('4600', '2021-08-13', '0000-00-00', '01282', '', '138', '843', '', '112', '47', '', '', '', '0', '0.00', '', '0.00', '0.00', '1279', '15', 'pending'), 
('4601', '2021-08-13', '0000-00-00', '01282', '', '141', '805', '', '112', '47', '', '', '', '0', '0.00', '', '0.00', '0.00', '1279', '15', 'pending'), 
('4602', '2021-08-13', '0000-00-00', '01283', '', '138', '843', '', '112', '47', '', '', '', '0', '0.00', '', '0.00', '0.00', '1280', '15', 'pending'), 
('4603', '2021-08-13', '0000-00-00', '01284', '', '139', '880', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1281', '15', 'pending'), 
('4604', '2021-08-13', '0000-00-00', '01285', '', '141', '807', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1282', '15', 'pending'), 
('4605', '2021-08-13', '0000-00-00', '01286', '', '139', '880', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1283', '15', 'pending'), 
('4606', '2021-08-13', '0000-00-00', '01287', '', '139', '880', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1284', '15', 'pending'), 
('4607', '2021-08-13', '0000-00-00', '01288', '', '141', '791', '', '112', '47', '', '', '', '0', '0.00', '', '0.00', '0.00', '1285', '15', 'pending'), 
('4608', '2021-08-13', '0000-00-00', '01288', '', '141', '800', '', '112', '47', '', '', '', '0', '0.00', '', '0.00', '0.00', '1285', '15', 'pending'), 
('4609', '2021-08-13', '0000-00-00', '01288', '', '141', '804', '', '112', '47', '', '', '', '0', '0.00', '', '0.00', '0.00', '1285', '15', 'pending'), 
('4610', '2021-08-13', '0000-00-00', '01288', '', '141', '805', '', '112', '47', '', '', '', '0', '0.00', '', '0.00', '0.00', '1285', '15', 'pending'), 
('4611', '2021-08-13', '0000-00-00', '01288', '', '139', '880', '', '112', '47', '', '', '', '0', '0.00', '', '0.00', '0.00', '1285', '15', 'pending'), 
('4612', '2021-08-13', '0000-00-00', '01289', '', '143', '902', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1286', '15', 'pending'), 
('4613', '2021-08-13', '0000-00-00', '01290', '', '141', '791', '', '112', '47', '', '', '', '0', '0.00', '', '0.00', '0.00', '1287', '15', 'pending'), 
('4614', '2021-08-13', '0000-00-00', '01290', '', '141', '805', '', '112', '47', '', '', '', '0', '0.00', '', '0.00', '0.00', '1287', '15', 'pending'), 
('4615', '2021-08-13', '0000-00-00', '01290', '', '138', '904', '', '112', '47', '', '', '', '0', '0.00', '', '0.00', '0.00', '1287', '15', 'pending'), 
('4616', '2021-08-13', '0000-00-00', '01290', '', '141', '810', '', '112', '47', '', '', '', '0', '0.00', '', '0.00', '0.00', '1287', '15', 'pending'), 
('4617', '2021-08-13', '0000-00-00', '01291', '', '141', '791', '', '112', '47', '', '', '', '0', '0.00', '', '0.00', '0.00', '1288', '15', 'pending'), 
('4618', '2021-08-13', '0000-00-00', '01291', '', '141', '793', '', '112', '47', '', '', '', '0', '0.00', '', '0.00', '0.00', '1288', '15', 'pending'), 
('4619', '2021-08-13', '0000-00-00', '01291', '', '141', '796', '', '112', '47', '', '', '', '0', '0.00', '', '0.00', '0.00', '1288', '15', 'pending'), 
('4620', '2021-08-13', '0000-00-00', '01291', '', '141', '800', '', '112', '47', '', '', '', '0', '0.00', '', '0.00', '0.00', '1288', '15', 'pending'), 
('4621', '2021-08-13', '0000-00-00', '01291', '', '141', '804', '', '112', '47', '', '', '', '0', '0.00', '', '0.00', '0.00', '1288', '15', 'pending'), 
('4622', '2021-08-13', '0000-00-00', '01291', '', '141', '805', '', '112', '47', '', '', '', '0', '0.00', '', '0.00', '0.00', '1288', '15', 'pending'), 
('4623', '2021-08-13', '0000-00-00', '01291', '', '141', '810', '', '112', '47', '', '', '', '0', '0.00', '', '0.00', '0.00', '1288', '15', 'pending'), 
('4624', '2021-08-13', '0000-00-00', '01291', '', '138', '827', '', '112', '47', '', '', '', '0', '0.00', '', '0.00', '0.00', '1288', '15', 'pending'), 
('4625', '2021-08-13', '0000-00-00', '01291', '', '138', '843', '', '112', '47', '', '', '', '0', '0.00', '', '0.00', '0.00', '1288', '15', 'pending'), 
('4626', '2021-08-13', '0000-00-00', '01291', '', '140', '876', '', '112', '47', '', '', '', '0', '0.00', '', '0.00', '0.00', '1288', '15', 'pending'), 
('4627', '2021-08-13', '0000-00-00', '01292', '', '139', '882', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1289', '15', 'pending'), 
('4628', '2021-08-13', '0000-00-00', '01293', '', '135', '822', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1290', '15', 'pending'), 
('4629', '2021-08-13', '0000-00-00', '01294', '', '138', '839', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1291', '15', 'pending'), 
('4630', '2021-08-13', '0000-00-00', '01295', '', '139', '881', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1292', '15', 'pending'), 
('4631', '2021-08-13', '0000-00-00', '01296', '', '141', '791', '', '112', '47', '', '', '', '0', '0.00', '', '0.00', '0.00', '1293', '15', 'pending'), 
('4632', '2021-08-13', '0000-00-00', '01296', '', '141', '805', '', '112', '47', '', '', '', '0', '0.00', '', '0.00', '0.00', '1293', '15', 'pending'), 
('4633', '2021-08-13', '0000-00-00', '01296', '', '138', '904', '', '112', '47', '', '', '', '0', '0.00', '', '0.00', '0.00', '1293', '15', 'pending'), 
('4634', '2021-08-13', '0000-00-00', '01297', '', '139', '882', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1294', '15', 'pending'), 
('4635', '2021-08-13', '0000-00-00', '01298', '', '141', '790', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1295', '15', 'pending'), 
('4636', '2021-08-13', '0000-00-00', '01298', '', '141', '805', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1295', '15', 'pending'), 
('4637', '2021-08-13', '0000-00-00', '01298', '', '141', '811', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1295', '15', 'pending'), 
('4638', '2021-08-13', '0000-00-00', '01298', '', '135', '822', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1295', '15', 'pending'), 
('4639', '2021-08-13', '0000-00-00', '01298', '', '139', '883', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1295', '15', 'pending'), 
('4640', '2021-08-13', '0000-00-00', '01299', '', '138', '843', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1296', '15', 'pending'), 
('4641', '2021-08-13', '0000-00-00', '01300', '', '138', '836', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1297', '15', 'pending'), 
('4642', '2021-08-13', '0000-00-00', '01301', '', '141', '805', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1298', '15', 'pending'), 
('4643', '2021-08-13', '0000-00-00', '01301', '', '139', '882', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1298', '15', 'pending'), 
('4644', '2021-08-13', '0000-00-00', '01301', '', '138', '867', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1298', '15', 'pending'), 
('4645', '2021-08-13', '0000-00-00', '01302', '', '141', '808', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1299', '15', 'pending'), 
('4646', '2021-08-13', '0000-00-00', '01303', '', '141', '791', '', '112', '47', '', '', '', '0', '0.00', '', '0.00', '0.00', '1300', '15', 'pending'), 
('4647', '2021-08-13', '0000-00-00', '01303', '', '141', '796', '', '112', '47', '', '', '', '0', '0.00', '', '0.00', '0.00', '1300', '15', 'pending'), 
('4648', '2021-08-13', '0000-00-00', '01303', '', '141', '804', '', '112', '47', '', '', '', '0', '0.00', '', '0.00', '0.00', '1300', '15', 'pending'), 
('4649', '2021-08-13', '0000-00-00', '01303', '', '141', '805', '', '112', '47', '', '', '', '0', '0.00', '', '0.00', '0.00', '1300', '15', 'pending'), 
('4650', '2021-08-13', '0000-00-00', '01304', '', '141', '898', '', '112', '58', '', '', '', '0', '0.00', '', '0.00', '0.00', '1301', '15', 'pending'), 
('4651', '2021-08-13', '0000-00-00', '01304', '', '141', '804', '', '112', '58', '', '', '', '0', '0.00', '', '0.00', '0.00', '1301', '15', 'pending'), 
('4652', '2021-08-13', '0000-00-00', '01304', '', '141', '805', '', '112', '58', '', '', '', '0', '0.00', '', '0.00', '0.00', '1301', '15', 'pending'), 
('4653', '2021-08-13', '0000-00-00', '01304', '', '139', '880', '', '112', '58', '', '', '', '0', '0.00', '', '0.00', '0.00', '1301', '15', 'pending'), 
('4654', '2021-08-13', '0000-00-00', '01305', '', '138', '904', '', '112', '47', '', '', '', '0', '0.00', '', '0.00', '0.00', '1302', '15', 'pending'), 
('4656', '2021-08-13', '0000-00-00', '01307', '', '141', '804', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1304', '15', 'pending'), 
('4657', '2021-08-13', '0000-00-00', '01307', '', '141', '898', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1304', '15', 'pending'), 
('4658', '2021-08-13', '0000-00-00', '01307', '', '139', '880', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1304', '15', 'pending'), 
('4659', '2021-08-13', '0000-00-00', '01308', '', '143', '902', '', '112', '45', '', '', '', '0', '0.00', '', '0.00', '0.00', '1305', '15', 'pending'), 
('4660', '2021-08-13', '0000-00-00', '01309', '', '138', '874', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1306', '15', 'pending'), 
('4661', '2021-08-13', '0000-00-00', '01310', '', '141', '791', '', '112', '47', '', '', '', '0', '0.00', '', '0.00', '0.00', '1307', '15', 'pending'), 
('4662', '2021-08-13', '0000-00-00', '01310', '', '141', '804', '', '112', '47', '', '', '', '0', '0.00', '', '0.00', '0.00', '1307', '15', 'pending'), 
('4663', '2021-08-13', '0000-00-00', '01310', '', '141', '805', '', '112', '47', '', '', '', '0', '0.00', '', '0.00', '0.00', '1307', '15', 'pending'), 
('4664', '2021-08-13', '0000-00-00', '01310', '', '138', '843', '', '112', '47', '', '', '', '0', '0.00', '', '0.00', '0.00', '1307', '15', 'pending'), 
('4665', '2021-08-13', '0000-00-00', '01311', '', '139', '882', '', '112', '', '', '', '', '0', '0.00', '', '0.00', '0.00', '1308', '15', 'pending'), 
('4666', '2021-08-13', '0000-00-00', '01312', '', '138', '846', '', '112', '47', '', '', '', '0', '0.00', '', '0.00', '0.00', '1309', '15', 'pending'), 
('4667', '2021-08-13', '0000-00-00', '01313', '', '139', '880', '', '112', '55', '', '', '', '0', '0.00', '', '0.00', '0.00', '1310',